/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.util.Enumeration;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometry_Menu;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PgPointSet_Menu
extends PgGeometry_Menu {
    public static final int MTHD_PRINT_CENTER = 0;
    public static final int MTHD_PRINT_BNDBOX = 1;
    public static final int MTHD_REMOVE_VECTOR_FIELDS = 2;
    public static final int MTHD_MOVE_TO_ORIGIN = 3;
    public static final int MTHD_PROJECT_TO_SPHERE = 4;
    public static final int MTHD_FLIP_ORIENTATION = 5;
    public static final int MTHD_SHOW_VECTOR_ARROWS = 6;
    public static final int MTHD_MARK_VERTICES = 7;
    public static final int MTHD_UNMARK_VERTICES = 8;
    public static final int MTHD_REMOVE_MARKED_VERTICES = 9;
    public static final int MTHD_SHOW_MARKED_VERTICES = 10;
    public static final int MTHD_SHOW_TITLE = 11;
    public static final int MTHD_SHOW_VERTEX_LABELS = 12;
    public static final int MTHD_ENABLE_DEFAULT_LABEL = 13;
    public static final int MTHD_SHOW_GLOBAL_VERTEX_COLOR = 14;
    public static final int MTHD_VERTEX_COLOR_FROM_VECTOR = 15;
    public static final int MTHD_VERTEX_COLOR_FROM_XYZ = 16;
    public static final int MTHD_VERTEX_COLOR_FROM_Z = 17;
    public static final int MTHD_VERTEX_COLOR_FROM_Z_HUE = 18;
    public static final int MTHD_SHOW_VERTEX_NORMAL_ARROW = 19;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_XY = 20;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_XZ = 21;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_YZ = 22;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_CYL = 23;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_SPH = 24;
    public static final int MTHD_ADD_TEXTURE = 25;
    public static final int MTHD_REMOVE_TEXTURE = 26;
    public static final int MTHD_INCREMENT_DIMENSION = 27;
    public static final int MTHD_DECREMENT_DIMENSION = 28;
    public static final int MTHD_SHOW_VERTEX_TEXTURE = 29;
    public static final int MTHD_MARK_ALL_VERTICES = 30;
    public static final int MTHD_UNMARK_ALL_VERTICES = 31;
    public static final int MTHD_REMOVE_VERTEX_NORMALS = 32;
    public static final String[] m_pointSetMethod = new String[]{PsConfig.getMessage("PrintCenter"), PsConfig.getMessage("PrintBndBox"), PsConfig.getMessage("RemoveAllVectorFields"), PsConfig.getMessage("MoveToOrigin"), PsConfig.getMessage("ProjectToSphere1"), PsConfig.getMessage("FlipOrientation"), PsConfig.getMessage("ShowVectorArrows"), PsConfig.getMessage("MarkVertices"), PsConfig.getMessage("UnmarkVertices"), PsConfig.getMessage("RemoveMarkedVertices"), PsConfig.getMessage("ShowMarkedVertices"), PsConfig.getMessage("ShowTitle"), PsConfig.getMessage("ShowVertexLabels"), PsConfig.getMessage("EnableDefaultLabel"), PsConfig.getMessage("ShowGlobalVertexColor"), PsConfig.getMessage("MakeVertexColorFromVector"), PsConfig.getMessage("MakeVertexColorFromXYZ"), PsConfig.getMessage("MakeVertexColorFromZ"), PsConfig.getMessage("MakeVertexColorFromZHue"), PsConfig.getMessage("ShowVertexNormalArrow"), PsConfig.getMessage("MakeVertexTextureFromXY"), PsConfig.getMessage("MakeVertexTextureFromXZ"), PsConfig.getMessage("MakeVertexTextureFromYZ"), PsConfig.getMessage("MakeVertexTextureFromCylinder"), PsConfig.getMessage("MakeVertexTextureFromSphere"), PsConfig.getMessage("AddTexture"), PsConfig.getMessage("RemoveTexture"), PsConfig.getMessage("IncrementDimension"), PsConfig.getMessage("DecrementDimension"), PsConfig.getMessage("ShowVertexTexture"), PsConfig.getMessage("MarkAllVertices"), PsConfig.getMessage("UnmarkAllVertices"), PsConfig.getMessage("RemoveVertexNormals")};
    protected PgPointSet m_pointSet;

    public boolean applyMethod(String aMethod) {
        if (super.applyMethod(aMethod)) {
            return true;
        }
        PsDebug.notify("trying method = " + aMethod);
        int found = PsMethodMenu.getIndexOfMethod(m_pointSetMethod, aMethod);
        switch (found) {
            case 0: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName() + "\n\tCenter: ");
                PdVector center = this.m_pointSet.getCenter();
                if (center == null) {
                    PsDebug.message("\t missing center");
                    return true;
                }
                PsDebug.message(center.toShortString());
                return true;
            }
            case 1: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName() + "\n\tBounding Box: ");
                PdVector[] bndBox = this.m_pointSet.getBounds();
                if (bndBox == null) {
                    PsDebug.message("\t missing bounding box");
                    return true;
                }
                PsDebug.message(bndBox[0].toShortString());
                PsDebug.message(bndBox[1].toShortString());
                return true;
            }
            case 11: {
                this.m_pointSet.showTitle(!this.m_pointSet.isShowingTitle());
                break;
            }
            case 13: {
                this.m_pointSet.setDefaultLabelEnabled(!this.m_pointSet.isDefaultLabelEnabled());
                break;
            }
            case 12: {
                this.m_pointSet.showVertexLabels(!this.m_pointSet.isShowingVertexLabels());
                break;
            }
            case 10: {
                this.m_pointSet.showTaggedVertices(!this.m_pointSet.isShowingTaggedVertices());
                break;
            }
            case 19: {
                this.m_pointSet.showVertexNormalArrow(!this.m_pointSet.isShowingVertexNormalArrow());
                return true;
            }
            case 6: {
                this.m_pointSet.showVectorArrows(!this.m_pointSet.isShowingVectorArrows());
                return true;
            }
            case 29: {
                this.m_pointSet.showVertexTexture(!this.m_pointSet.isShowingVertexTexture());
                return true;
            }
            case 7: {
                Enumeration dispSet = this.m_pointSet.getDisplays();
                while (dispSet != null && dispSet.hasMoreElements()) {
                    PvDisplayIf disp = (PvDisplayIf)dispSet.nextElement();
                    disp.setMajorMode(9);
                }
                break;
            }
            case 30: {
                int nov = this.m_pointSet.getNumVertices();
                int i = 0;
                while (i < nov) {
                    this.m_pointSet.getVertex(i).setTag(1);
                    ++i;
                }
                break;
            }
            case 8: {
                Enumeration dispSet = this.m_pointSet.getDisplays();
                while (dispSet != null && dispSet.hasMoreElements()) {
                    PvDisplayIf disp = (PvDisplayIf)dispSet.nextElement();
                    disp.setMajorMode(11);
                }
                break;
            }
            case 31: {
                int nn = this.m_pointSet.getNumVertices();
                int i = 0;
                while (i < nn) {
                    this.m_pointSet.getVertex(i).clearTag(1);
                    ++i;
                }
                break;
            }
            case 9: {
                PdVector[] vertex = this.m_pointSet.getVertices();
                int i = this.m_pointSet.getNumVertices() - 1;
                while (i >= 0) {
                    if (vertex[i].hasTag(1)) {
                        vertex[i].setTag(2);
                    }
                    --i;
                }
                this.m_pointSet.removeMarkedVertices();
                break;
            }
            case 32: {
                this.m_pointSet.showVertexNormals(false);
                this.m_pointSet.setVertexNormals(null);
                break;
            }
            case 2: {
                this.m_pointSet.removeAllVectorFields();
                break;
            }
            case 26: {
                if (this.m_pointSet.getTexture() == null) {
                    return true;
                }
                this.m_pointSet.setTexture(null);
                this.m_pointSet.setVertexTextures(null);
                this.m_pointSet.showVertexTexture(false);
                return true;
            }
            case 14: {
                this.m_pointSet.showVertexColors(!this.m_pointSet.isShowingVertexColors());
                break;
            }
            case 16: {
                this.m_pointSet.makeVertexColorsFromXYZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 17: {
                this.m_pointSet.makeVertexColorsFromZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 18: {
                this.m_pointSet.makeVertexColorsFromZHue();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (item == null) break;
                item.setState(false);
                break;
            }
            case 15: {
                boolean bCheck = this.m_pointSet.makeColorFromVectorLength();
                if (!bCheck) break;
                this.m_pointSet.showVertices(true);
                this.m_pointSet.showVertexColors(bCheck);
                break;
            }
            case 20: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(0, 1);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 21: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(0, 2);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 22: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(1, 2);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 23: {
                this.assureTexture();
                PdVector axis = new PdVector(this.m_pointSet.getDimOfVertices());
                axis.setEntry(this.m_pointSet.getDimOfVertices() - 1, 1.0);
                this.m_pointSet.makeVertexTextureFromCylinder(this.m_pointSet.getCenterOfBndBox(), axis);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 24: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromSphere(this.m_pointSet.getCenterOfBndBox());
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 27: {
                this.m_pointSet.setDimOfVertices(this.m_pointSet.getDimOfVertices() + 1);
                break;
            }
            case 28: {
                this.m_pointSet.setDimOfVertices(this.m_pointSet.getDimOfVertices() - 1);
                break;
            }
            case 3: {
                PdVector origin = new PdVector(this.m_pointSet.getDimOfVertices());
                this.m_pointSet.setCenterOfBndBox(origin);
                break;
            }
            case 4: {
                this.m_pointSet.projectToSphere(this.m_pointSet.getCenter(), 1.0);
                break;
            }
            case 5: {
                this.m_pointSet.flipOrientation();
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.warning("method string = " + aMethod + " does not match a constant");
                return false;
            }
        }
        return true;
    }

    public boolean update(Object event) {
        CheckboxMenuItem item;
        if (event == null || event != this.m_pointSet) {
            return false;
        }
        String msgShow = PsConfig.getMessage("Show");
        if (this.hasMenu(msgShow)) {
            item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[11]);
            if (item != null && item.getState() != this.m_pointSet.isShowingTitle()) {
                item.setState(this.m_pointSet.isShowingTitle());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[13])) != null && item.getState() != this.m_pointSet.isDefaultLabelEnabled()) {
                item.setState(this.m_pointSet.isDefaultLabelEnabled());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[12])) != null && item.getState() != this.m_pointSet.isShowingVertexLabels()) {
                item.setState(this.m_pointSet.isShowingVertexLabels());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[10])) != null && item.getState() != this.m_pointSet.isShowingTaggedVertices()) {
                item.setState(this.m_pointSet.isShowingTaggedVertices());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[19])) != null && item.getState() != this.m_pointSet.isShowingVertexNormalArrow()) {
                item.setState(this.m_pointSet.isShowingVertexNormalArrow());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[6])) != null && item.getState() != this.m_pointSet.isShowingVectorArrow()) {
                item.setState(this.m_pointSet.isShowingVectorArrow());
            }
            if ((item = (CheckboxMenuItem)this.getMenuItem(msgShow, m_pointSetMethod[29])) != null && item.getState() != this.m_pointSet.isShowingVertexTexture()) {
                item.setState(this.m_pointSet.isShowingVertexTexture());
            }
        }
        if (this.hasMenu(PsConfig.getMessage("Color")) && (item = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14])) != null) {
            if (item.isEnabled() != this.m_pointSet.hasVertexColors()) {
                item.setEnabled(this.m_pointSet.hasVertexColors());
            }
            if (item.getState() != !this.m_pointSet.isShowingVertexColors()) {
                item.setState(!this.m_pointSet.isShowingVertexColors());
            }
        }
        return super.update(event);
    }

    public void init(PsObject anObject) {
        super.init(anObject);
        this.m_pointSet = (PgPointSet)anObject;
        String msgInfo = PsConfig.getMessage("Info");
        this.addMenu(msgInfo);
        this.addMenuItem(msgInfo, m_pointSetMethod[0]);
        this.addMenuItem(msgInfo, m_pointSetMethod[1]);
        String msgShow = PsConfig.getMessage("Show");
        this.addMenu(msgShow);
        this.addMenuItem(msgShow, m_pointSetMethod[11], this.m_pointSet.isShowingTitle());
        this.addMenuItem(msgShow, m_pointSetMethod[13], this.m_pointSet.isDefaultLabelEnabled());
        this.getMenu(msgShow).addSeparator();
        this.addMenuItem(msgShow, m_pointSetMethod[12], this.m_pointSet.isShowingVertexLabels());
        this.addMenuItem(msgShow, m_pointSetMethod[10], this.m_pointSet.isShowingTaggedVertices());
        this.addMenuItem(msgShow, m_pointSetMethod[19], this.m_pointSet.isShowingVertexNormalArrow());
        this.getMenu(msgShow).addSeparator();
        this.addMenuItem(msgShow, m_pointSetMethod[6], this.m_pointSet.isShowingVectorArrow());
        String msgMark = PsConfig.getMessage("Mark");
        this.addMenu(msgMark);
        this.addMenuItem(msgMark, m_pointSetMethod[7]);
        this.addMenuItem(msgMark, m_pointSetMethod[30]);
        this.addMenuItem(msgMark, m_pointSetMethod[8]);
        this.addMenuItem(msgMark, m_pointSetMethod[31]);
        String msgDelete = PsConfig.getMessage("Delete");
        this.addMenu(msgDelete);
        this.addMenuItem(msgDelete, m_pointSetMethod[9]);
        this.addMenuItem(msgDelete, m_pointSetMethod[32]);
        this.addMenuItem(msgDelete, m_pointSetMethod[2]);
        this.addMenuItem(msgDelete, m_pointSetMethod[26]);
        String msgColor = PsConfig.getMessage("Color");
        this.addMenu(msgColor);
        CheckboxMenuItem item = this.addMenuItem(msgColor, m_pointSetMethod[14], !this.m_pointSet.isShowingVertexColors());
        if (!this.m_pointSet.hasVertexColors()) {
            item.setEnabled(false);
        }
        this.getMenu(msgColor).addSeparator();
        this.addMenuItem(msgColor, m_pointSetMethod[16]);
        this.addMenuItem(msgColor, m_pointSetMethod[17]);
        this.addMenuItem(msgColor, m_pointSetMethod[18]);
        this.addMenuItem(msgColor, m_pointSetMethod[15]);
        String msgTexture = PsConfig.getMessage("Texture");
        this.addMenu(msgTexture);
        this.addMenuItem(msgTexture, m_pointSetMethod[20]);
        this.addMenuItem(msgTexture, m_pointSetMethod[21]);
        this.addMenuItem(msgTexture, m_pointSetMethod[22]);
        this.addMenuItem(msgTexture, m_pointSetMethod[23]);
        this.addMenuItem(msgTexture, m_pointSetMethod[24]);
        String msgModeling = PsConfig.getMessage("Modeling");
        this.addMenu(msgModeling);
        this.addMenuItem(msgModeling, m_pointSetMethod[27]);
        this.addMenuItem(msgModeling, m_pointSetMethod[28]);
        this.addMenuItem(msgModeling, m_pointSetMethod[3]);
        this.addMenuItem(msgModeling, m_pointSetMethod[4]);
        this.addMenuItem(msgModeling, m_pointSetMethod[5]);
    }

    private boolean assureTexture() {
        if (this.m_pointSet.getTexture() != null) {
            return true;
        }
        PgTexture tex = new PgTexture();
        tex.setImageName(PsConfig.getCodeBase() + "images/JavaViewLogo.gif");
        Image img = tex.loadImage(null);
        if (img == null) {
            PsDebug.warning("loading default texture failed, use texture panel.");
        }
        this.m_pointSet.setTexture(tex);
        return true;
    }
}

