/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import jv.geom.PgElementSet;
import jv.loader.PgLoaderIf;
import jv.loader.PgMacroPatch;
import jv.loader.PvDisplayOption;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgBdLoader
implements PgLoaderIf {
    protected String m_task;
    protected int m_startFrame;
    protected int m_endFrame;
    protected int m_numIntegerParms;
    protected int m_numDoubleParms;
    protected int m_numPatches;
    protected int m_numVertices;
    protected PdVector[] m_vertex;
    protected PiVector[] m_vertexType;
    protected PgMacroPatch[] m_patch;

    protected boolean parse(BufferedReader bufReader) {
        if (bufReader == null) {
            PsDebug.warning("missing argumnt");
            return false;
        }
        StreamTokenizer st = new StreamTokenizer(bufReader);
        st.whitespaceChars(59, 59);
        st.eolIsSignificant(true);
        st.commentChar(35);
        try {
            int k;
            if (this.nextToken(st) != -3) {
                PsDebug.warning("failed reading m_task");
                return false;
            }
            this.m_task = new String(st.sval);
            if (this.nextToken(st) != -2) {
                PsDebug.warning("failed reading m_startFrame");
                return false;
            }
            this.m_startFrame = (int)st.nval;
            if (this.nextToken(st) != -2) {
                PsDebug.warning("failed reading m_endFrame");
                return false;
            }
            this.m_endFrame = (int)st.nval;
            if (this.nextToken(st) != -2) {
                PsDebug.warning("failed reading m_numIntegerParms");
                return false;
            }
            this.m_numIntegerParms = (int)st.nval;
            if (this.nextToken(st) != -2) {
                PsDebug.warning("failed reading m_numDoubleParms");
                return false;
            }
            this.m_numDoubleParms = (int)st.nval;
            if (this.nextToken(st) != -2) {
                PsDebug.warning("failed reading numPatches");
                return false;
            }
            this.m_numPatches = (int)st.nval;
            this.m_patch = new PgMacroPatch[this.m_numPatches];
            if (this.nextToken(st) != -2) {
                PsDebug.warning("Number expected");
                return false;
            }
            this.m_numVertices = (int)st.nval;
            this.m_vertexType = new PiVector[this.m_numVertices];
            this.m_vertex = new PdVector[this.m_numVertices];
            int i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexType[i] = new PiVector(3);
                this.m_vertex[i] = new PdVector(3);
                k = 0;
                while (k < 3) {
                    if (this.nextToken(st) != -2) {
                        PsDebug.warning("failed reading m_vertexType[" + i + "].m_data[" + k + "]");
                        return false;
                    }
                    this.m_vertexType[i].m_data[k] = (int)st.nval;
                    ++k;
                }
                k = 0;
                while (k < 3) {
                    if (this.nextToken(st) != -2) {
                        PsDebug.warning("failed reading m_vertex[" + i + "].m_data[" + k + "]");
                        return false;
                    }
                    this.m_vertex[i].m_data[k] = st.nval;
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < this.m_numPatches) {
                int length;
                int shapeInt;
                String shapeString;
                this.m_patch[i] = new PgMacroPatch(3);
                this.m_patch[i].setVertexType(this.m_vertexType);
                this.m_patch[i].setVertex(this.m_vertex);
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading orientation in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].setOrientation((int)st.nval);
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading bndType in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].setBndType((int)st.nval);
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading patchLength in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].setNumVertices((int)st.nval);
                int patchLength = this.m_patch[i].getNumVertices();
                int j = 0;
                while (j < patchLength) {
                    if (this.nextToken(st) != -2) {
                        PsDebug.warning("error reading element[" + j + "] in patch[" + i + "]");
                        return false;
                    }
                    this.m_patch[i].m_element.m_data[j] = (int)st.nval;
                    ++j;
                }
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading numULines in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].m_numULines = (int)st.nval;
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading numVLines in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].m_numVLines = (int)st.nval;
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading numUSubs in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].m_numUSubs = (int)st.nval;
                if (this.nextToken(st) != -2) {
                    PsDebug.warning("error reading numVSubs in patch[" + i + "]");
                    return false;
                }
                this.m_patch[i].m_numVSubs = (int)st.nval;
                if (this.m_patch[i].getBndType() == 1) {
                    j = 0;
                    while (j < patchLength) {
                        if (this.nextToken(st) != -2) {
                            PsDebug.warning("error reading bndShape[" + j + "][0] in patch[" + i + "]");
                            return false;
                        }
                        shapeString = Integer.toString((int)st.nval);
                        shapeInt = Integer.parseInt(shapeString, 8);
                        shapeString = Integer.toBinaryString(shapeInt);
                        length = shapeString.length();
                        k = 0;
                        while (k < length) {
                            if (shapeString.charAt(length - 1 - k) == '1') {
                                this.m_patch[i].m_bndShapeBits[j].set(k);
                            } else {
                                this.m_patch[i].m_bndShapeBits[j].clear(k);
                            }
                            ++k;
                        }
                        if (this.nextToken(st) != -2) {
                            PsDebug.warning("error reading bndShape[" + j + "][" + 0 + "] in patch[" + i + "]");
                            return false;
                        }
                        this.m_patch[i].m_bndShape[j].m_data[0] = (int)st.nval;
                        if (!this.m_patch[i].m_bndShapeBits[j].get(7) || this.m_patch[i].m_bndShapeBits[j].get(7) && this.m_patch[i].m_bndShapeBits[j].get(5)) {
                            k = 1;
                            while (k < 3) {
                                if (this.nextToken(st) != -2) {
                                    PsDebug.warning("error reading bndShape[" + j + "][" + k + "] in patch[" + i + "]");
                                    return false;
                                }
                                this.m_patch[i].m_bndShape[j].m_data[k] = (int)st.nval;
                                ++k;
                            }
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < patchLength) {
                        shapeString = Integer.toString(220);
                        shapeInt = Integer.parseInt(shapeString, 8);
                        shapeString = Integer.toBinaryString(shapeInt);
                        length = shapeString.length();
                        k = 0;
                        while (k < length) {
                            if (shapeString.charAt(length - 1 - k) == '1') {
                                this.m_patch[i].m_bndShapeBits[j].set(k);
                            } else {
                                this.m_patch[i].m_bndShapeBits[j].clear(k);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            PsDebug.warning("Exception thrown = " + e.toString() + "\n\tparsing broke abnormally in line=" + st.lineno() + ",\n\treading st.sval=" + st.sval + ",\n\tst.ttype=" + st.ttype);
            return false;
        }
        PsDebug.notify("... finished");
        return true;
    }

    public PgElementSet[] readElementSet(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        boolean check = this.parse(in);
        if (!check) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        PgElementSet elemSet = new PgElementSet(3);
        int k = 0;
        while (k < this.getNumPatches()) {
            PgMacroPatch aPatch = this.getPatch(k);
            PgElementSet trianTmp = new PgElementSet(3);
            trianTmp = aPatch.buildElementSet(trianTmp);
            if (this.getNumPatches() == 1) {
                return new PgElementSet[]{trianTmp};
            }
            elemSet.merge(trianTmp);
            ++k;
        }
        elemSet.close();
        return new PgElementSet[]{elemSet};
    }

    private int nextToken(StreamTokenizer st) throws IOException {
        block6: while (true) {
            switch (st.nextToken()) {
                case 10: {
                    continue block6;
                }
                case -3: {
                    return -3;
                }
                case -2: {
                    return -2;
                }
                case -1: {
                    return -1;
                }
            }
            PsDebug.warning("token not identified");
        }
    }

    public PgJvxSrc[] read(BufferedReader in) {
        PgElementSet[] elemSet = this.readElementSet(in);
        if (elemSet == null) {
            PsDebug.warning("error during parsing.");
            return null;
        }
        PgJvxSrc[] geomArr = new PgJvxSrc[elemSet.length];
        int i = 0;
        while (i < elemSet.length) {
            geomArr[i] = elemSet[i].getJvx();
            ++i;
        }
        return geomArr;
    }

    public PgMacroPatch getPatch(int anInd) {
        if (this.m_patch == null) {
            PsDebug.warning("m_Patch==null");
            return null;
        }
        if (anInd < 0 || this.m_patch.length <= anInd) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_patch[anInd];
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public void setAnimation(boolean flag) {
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        PsDebug.error("method not implemented yet.");
        return false;
    }

    public int getNumPatches() {
        return this.m_numPatches;
    }

    public boolean isAnimation() {
        return false;
    }
}

