/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgVectorField
extends PgGeometry {
    protected PgPointSet m_basePoints;
    protected PgElementSet m_surface;
    public static final int VERTEX_BASED = 0;
    public static final int ELEMENT_BASED = 1;
    protected int m_basedOn;
    protected int m_dimOfVectors;
    protected int m_numVectors;
    protected int m_maxNumVectors;
    protected PdVector[] m_vector;
    protected Color[] m_vectorColor;
    protected boolean m_bShowVectorArrow;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors = false;
    protected int m_index = -1;
    private static /* synthetic */ Class class$jv$geom$PgVectorField;

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public void setBasedOn(int basedOn) {
        if (this.m_basedOn == basedOn) {
            return;
        }
        this.m_basedOn = basedOn;
        if (this.m_surface != null) {
            if (this.m_basedOn == 1) {
                this.setNumVectors(this.m_surface.getNumElements());
            } else {
                this.setNumVectors(this.m_surface.getNumVertices());
            }
        }
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double size) {
        this.m_globalVectorSize.setValue(size);
    }

    public boolean merge(PgGeometryIf aField) {
        if (!super.merge(aField)) {
            return false;
        }
        if (!(aField instanceof PgVectorField)) {
            return false;
        }
        PgVectorField vf = (PgVectorField)aField;
        int oldNov = this.m_numVectors;
        int newNov = this.m_numVectors + vf.m_numVectors;
        this.setNumVectors(newNov);
        PdVector.copy(this.m_vector, oldNov, vf.m_vector, 0, vf.m_numVectors);
        if (vf.m_vectorColor != null) {
            this.assureVectorColors();
            PdColor.copy(this.m_vectorColor, oldNov, vf.m_vectorColor, 0, vf.m_numVectors);
        }
        return true;
    }

    public boolean computeGradient(PgElementSet domain, PgPointSet image) {
        int nov;
        if (domain == null || image == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_dim != domain.getDimOfVertices()) {
            PsDebug.warning("domain and vf have different dimension.");
            return false;
        }
        if (domain.getDimOfElements() != 3) {
            PgElementSet.triangulate(domain);
        }
        if ((nov = domain.getNumVertices()) != image.getNumVertices()) {
            PsDebug.warning("domain and image have different number of vertices.");
            return false;
        }
        int noe = domain.getNumElements();
        this.setBasedOn(1);
        this.setGeometry(domain);
        this.setNumVectors(noe);
        PiVector[] element = domain.getElements();
        PdVector[] vertex = domain.getVertices();
        double[] ctg = new double[3];
        PdVector[] edge = PdVector.realloc(null, 3, this.m_dim);
        PdVector[] gradFi = PdVector.realloc(null, 3, this.m_dim);
        int i = 0;
        while (i < noe) {
            int[] elem = element[i].m_data;
            double area = domain.getAreaOfElement(i);
            PuVectorGeom.ctg(ctg, vertex[elem[0]], vertex[elem[1]], vertex[elem[2]]);
            int k = 0;
            while (k < 3) {
                edge[k].sub(vertex[elem[(k + 2) % 3]], vertex[elem[(k + 1) % 3]]);
                ++k;
            }
            k = 0;
            while (k < 3) {
                gradFi[k].blend(ctg[(k + 1) % 3], edge[(k + 1) % 3], -ctg[(k + 2) % 3], edge[(k + 2) % 3]);
                gradFi[k].multScalar(1.0 / (2.0 * area));
                ++k;
            }
            this.m_vector[i].setConstant(0.0);
            k = 0;
            while (k < 3) {
                gradFi[k].multScalar(image.m_vertex[elem[k]].m_data[0]);
                this.m_vector[i].add(gradFi[k]);
                ++k;
            }
            ++i;
        }
        return true;
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double length) {
        this.m_globalVectorLength.setValue(length);
    }

    public PdVector[] getVertices() {
        if (this.m_basePoints != null) {
            return this.m_basePoints.getVertices();
        }
        PsDebug.warning("missing base points.");
        return null;
    }

    protected void project(int elemInd) {
        if (this.m_dim < 3) {
            return;
        }
        PdVector dir = this.m_vector[elemInd];
        double eps = 1.0E-10;
        PiVector[] elem = this.m_surface.getElements();
        PdVector[] vertex = this.m_surface.getVertices();
        PdVector[] vert = new PdVector[3];
        int i = 0;
        while (i < 3) {
            vert[i] = new PdVector(this.m_dim);
            ++i;
        }
        int j = 0;
        while (j < 3) {
            vert[j].setSize(vertex[elem[elemInd].m_data[j]].getSize());
            vert[j].copy(vertex[elem[elemInd].m_data[j]]);
            ++j;
        }
        vert[1].sub(vert[0]);
        vert[2].sub(vert[0]);
        PdVector n = new PdVector(this.m_dim);
        int j2 = 0;
        while (j2 < this.m_dim) {
            n.m_data[j2] = 0.0;
            ++j2;
        }
        if (this.m_dim == 3) {
            n = PdVector.crossNew(vert[1], vert[2]);
            double absval = n.length();
            if (absval < eps) {
                PsDebug.warning("elements degenerated in element set");
                return;
            }
            n.multScalar(1.0 / absval);
            double s = PdVector.dot(n, dir);
            n.multScalar(-s);
            n.add(dir);
        }
        dir.copy(n);
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(event);
        }
        if (event == this.m_surface) {
            this.setGeometry(this.m_surface);
            return super.update(null);
        }
        if (event == this.m_basePoints) {
            this.setGeometry(this.m_basePoints);
            return super.update(null);
        }
        if (event == this.m_globalVectorSize) {
            PsDebug.notify("called with event=m_globalVectorSize");
            return super.update(this);
        }
        if (event == this.m_globalVectorLength) {
            PsDebug.notify("called with event=m_globalVectorLength");
            return super.update(this);
        }
        if (event == this.m_globalVectorColor) {
            PsDebug.notify("called with event=m_globalVectorColor");
            return super.update(this);
        }
        return super.update(event);
    }

    public void makeTangent() {
        if (this.m_basedOn == 0) {
            PsDebug.warning("vector field is vertex based");
            return;
        }
        int i = 0;
        while (i < this.m_numVectors) {
            this.project(i);
            ++i;
        }
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
    }

    public void assureVectorColors() {
        if (this.m_vectorColor == null || this.m_vectorColor.length != this.m_maxNumVectors) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_maxNumVectors);
        }
    }

    public Color[] getVectorColors() {
        return this.m_vectorColor;
    }

    public void setVectorColors(Color[] colorList) {
        if (colorList == null) {
            this.m_vectorColor = null;
            return;
        }
        if (colorList.length < this.m_numVectors) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVectorColors();
        PdColor.copy(this.m_vectorColor, 0, colorList, 0, this.m_numVectors);
    }

    public int getNumVectors() {
        return this.m_numVectors;
    }

    public void setNumVectors(int aNumVectors) {
        if (aNumVectors > this.m_maxNumVectors) {
            this.setMaxNumVectors(aNumVectors);
        }
        this.m_numVectors = aNumVectors;
    }

    public Object clone() {
        PgVectorField clone = (PgVectorField)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_basePoints = null;
        clone.m_surface = null;
        clone.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        clone.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        clone.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        clone.m_globalVectorSize.setParent(clone);
        clone.m_globalVectorLength.setParent(clone);
        clone.m_globalVectorColor.setParent(clone);
        if (this.m_vector != null) {
            clone.m_vector = (PdVector[])P_Vector.clone(this.m_vector);
        }
        if (this.m_vectorColor != null) {
            clone.m_vectorColor = (Color[])this.m_vectorColor.clone();
        }
        return clone;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgVectorField ***********\n");
        strBuf.append("\t m_numVectors = " + this.m_numVectors + "\n");
        strBuf.append("\t ******* m_vector *******\n");
        if (this.m_vector != null && this.m_numVectors > 0) {
            int i = 0;
            while (i < this.m_numVectors) {
                strBuf.append("\t [" + i + "] = " + this.m_vector[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_vector = null");
        }
        return strBuf.toString();
    }

    public PgVectorField(int aVectorDim) {
        this(aVectorDim, 0);
    }

    public PgVectorField(int aVectorDim, int basedOn) {
        super(aVectorDim);
        this.setTag(4);
        this.m_dimOfVectors = aVectorDim;
        this.m_basedOn = basedOn;
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage("globalVectorColor"), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage("globalVectorLength"), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage("globalVectorSize"), this);
        if (this.getClass() == (class$jv$geom$PgVectorField != null ? class$jv$geom$PgVectorField : (class$jv$geom$PgVectorField = PgVectorField.class$("jv.geom.PgVectorField")))) {
            this.init();
        }
    }

    public void paint(PvGeometryIf dc) {
        dc.setNumVectors(this.m_index, this.m_numVectors, this.m_dimOfVectors);
        dc.setVectors(this.m_index, this.m_vector);
        dc.setVectorElementBased(this.m_index, this.m_basedOn == 1);
        dc.showVectorField(this.m_index, this.isVisible());
        dc.showVectorArrows(this.m_index, this.m_bShowVectorArrow);
        dc.showVectorColors(this.m_index, this.m_bShowVectorColors);
        dc.setGlobalVectorColor(this.m_index, this.m_globalVectorColor.getColor());
        dc.setGlobalVectorLength(this.m_index, this.m_globalVectorLength.getValue());
        dc.setGlobalVectorSize(this.m_index, this.m_globalVectorSize.getValue());
    }

    public void clearTagVector(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vector[anIndex].clearTag(aTag);
    }

    public PdVector getVector(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vector[anIndex];
    }

    public boolean setVector(int anIndex, PdVector aVector) {
        if (anIndex < 0 || anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vector[anIndex].copy(aVector);
        return true;
    }

    public void setVector(int anIndex, double x, double y) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(anIndex + 1);
        }
        this.m_vector[anIndex].set(x, y);
    }

    public void setVector(int anIndex, double x, double y, double z) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(anIndex + 1);
        }
        this.m_vector[anIndex].set(x, y, z);
    }

    public boolean blend(double s, PgVectorField a, double t, PgVectorField b) {
        int i;
        if (a == null || b == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (Math.abs(s) < 1.0E-10) {
            s = 0.0;
        }
        if (Math.abs(t) < 1.0E-10) {
            t = 0.0;
        }
        this.m_dim = a.m_dim;
        if (a.m_numVectors == 0) {
            PsDebug.warning("empty first argument");
            return false;
        }
        if (a.m_numVectors != b.m_numVectors) {
            PsDebug.warning("wrong second argument");
            return false;
        }
        this.setVisible(a.isVisible());
        this.m_globalVectorColor.blend(s, a.m_globalVectorColor, t, b.m_globalVectorColor);
        this.m_globalVectorSize.blend(s, a.m_globalVectorSize, t, b.m_globalVectorSize);
        this.m_globalVectorLength.blend(s, a.m_globalVectorLength, t, b.m_globalVectorLength);
        this.setNumVectors(a.m_numVectors);
        if (a.m_vector != null && b.m_vector != null) {
            i = 0;
            while (i < this.m_numVectors) {
                this.m_vector[i].blend(s, a.m_vector[i], t, b.m_vector[i]);
                ++i;
            }
        }
        if (a.m_vectorColor != null && b.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_numVectors);
            i = 0;
            while (i < this.m_numVectors) {
                this.m_vectorColor[i] = PdColor.blend(s, a.m_vectorColor[i], t, b.m_vectorColor[i]);
                ++i;
            }
        }
        return true;
    }

    public void setTagVector(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vector[anIndex].setTag(aTag);
    }

    public boolean removeVector(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numVectors - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        this.m_vector[anIndex].setTag(2);
        return true;
    }

    public void setGeometry(PgPointSet geom) {
        this.m_basePoints = geom;
        int newNumVectors = geom.getNumVertices();
        int newDim = geom.getDimOfVertices();
        if (geom instanceof PgElementSet) {
            this.m_surface = (PgElementSet)geom;
            if (this.m_basedOn == 1) {
                newNumVectors = this.m_surface.getNumElements();
            }
        }
        if (newNumVectors != this.m_numVectors) {
            this.setDimOfVertices(newDim);
            this.setNumVectors(newNumVectors);
        }
    }

    public void copy(PgGeometry aGeom) {
        super.copy(aGeom);
        if (!(aGeom instanceof PgVectorField)) {
            return;
        }
        PgVectorField vec = (PgVectorField)aGeom;
        this.m_basePoints = vec.m_basePoints;
        this.m_surface = vec.m_surface;
        this.m_basedOn = vec.m_basedOn;
        this.m_dimOfVectors = vec.m_dimOfVectors;
        this.m_numVectors = vec.m_numVectors;
        this.m_maxNumVectors = vec.m_maxNumVectors;
        this.m_vector = vec.m_vector != null ? PdVector.copyNew(vec.m_vector) : null;
        if (vec.m_vectorColor != null) {
            this.m_vectorColor = new Color[vec.m_vectorColor.length];
            PdColor.copy(this.m_vectorColor, 0, vec.m_vectorColor, 0, vec.m_vectorColor.length);
        } else {
            this.m_vectorColor = null;
        }
        this.m_bShowVectorArrow = vec.m_bShowVectorArrow;
        this.m_globalVectorColor.copy(vec.m_globalVectorColor);
        this.m_globalVectorLength.copy(vec.m_globalVectorLength);
        this.m_globalVectorSize.copy(vec.m_globalVectorSize);
        this.m_bShowVectorColors = vec.m_bShowVectorColors;
    }

    protected void setIndex(int ind) {
        this.m_index = ind;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public PdVector[] getVectors() {
        return this.m_vector;
    }

    public void init() {
        super.init();
        this.m_numVectors = 0;
        this.m_maxNumVectors = 0;
        this.m_vector = null;
        this.m_vectorColor = null;
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_globalVectorLength.setDefValue(2.0);
        this.m_globalVectorLength.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.init();
    }

    public boolean setVectors(PdVector[] aVectorList) {
        if (aVectorList == null || aVectorList.length == 0 || aVectorList.length < this.m_numVectors) {
            PsDebug.warning("void length of argument vector array");
            return false;
        }
        int dimSav = aVectorList[0].getSize();
        int i = 0;
        while (i < this.m_numVectors) {
            int dim = aVectorList[i].getSize();
            this.m_vector[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        this.m_dimOfVectors = dimSav;
        PdVector.copy(this.m_vector, 0, aVectorList, 0, this.m_numVectors);
        return true;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    protected int getMaxNumVectors() {
        return this.m_maxNumVectors;
    }

    protected void setMaxNumVectors(int aNumVectors) {
        if (this.m_maxNumVectors == aNumVectors) {
            return;
        }
        this.m_vector = PdVector.realloc(this.m_vector, aNumVectors, this.m_dimOfVectors);
        if (this.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, aNumVectors);
        }
        this.m_maxNumVectors = aNumVectors;
        if (this.m_maxNumVectors < this.m_numVectors) {
            this.m_numVectors = this.m_maxNumVectors;
        }
    }
}

