/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.viewer.PvControlMenu;
import jv.viewer.PvViewer;

final class PvControl
extends PsMainFrame
implements ActionListener {
    private static final int NUM_PANELS = 7;
    private static final int PROJECT_ARR = 0;
    private static final int INFO_ARR = 1;
    private static final int MATERIAL_ARR = 2;
    private static final int TEXTURE_ARR = 3;
    private static final int CONFIG_ARR = 4;
    private static final int CAMERA_ARR = 5;
    private static final int DISPLAY_ARR = 6;
    protected static final String[] m_panelName = new String[]{"Project", "Info", "Material", "Texture", "Config", "Camera", "Display"};
    protected Panel[] m_oldPanel = new Panel[7];
    protected boolean[] m_bPanelOutside = new boolean[7];
    protected CardLayout m_crd;
    protected Panel m_inspector;
    protected int m_currentPanel_Id;
    protected Panel m_currentPanel;
    private boolean m_firstShowing;
    protected PvControlMenu m_menuBar;
    protected PvViewer m_viewer;
    protected PjProject m_project;
    protected PgGeometryIf m_geometry;
    protected PvDisplayIf m_display;

    protected void setProject(PjProject aProject) {
        if (aProject == null) {
            this.enableMenu(21, false);
            this.m_project = null;
            return;
        }
        if (this.m_project == aProject) {
            return;
        }
        this.enableMenu(21, true);
        this.m_project = aProject;
        this.m_currentPanel_Id = 0;
        if (this.isShowing()) {
            this.addInspectorPanel(this.m_currentPanel_Id, this.m_project.getInfoPanel());
            this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
        }
        this.enableMenu(40, this.m_project.hasAnimation());
    }

    protected PvDisplayIf getDisplay() {
        return this.m_display;
    }

    protected void setDisplay(PvDisplayIf aDisplay) {
        if (this.m_display == aDisplay) {
            return;
        }
        this.m_display = aDisplay;
        this.removeInspectorPanel(6);
        if (this.isShowing() && this.m_currentPanel_Id == 6) {
            this.showPanel(17);
        }
        this.removeInspectorPanel(5);
        if (this.isShowing() && this.m_currentPanel_Id == 5) {
            this.showPanel(16);
        }
    }

    private void addInspectorPanel(int panelPos, Panel aPanel) {
        if (aPanel == null) {
            return;
        }
        if (this.m_oldPanel[panelPos] == aPanel) {
            PsDebug.notify("***************trying to add same panel*************");
            return;
        }
        if (this.m_oldPanel[panelPos] != null) {
            this.m_inspector.remove(this.m_oldPanel[panelPos]);
            this.m_oldPanel[panelPos] = aPanel;
        } else {
            this.m_oldPanel[panelPos] = aPanel;
        }
        this.m_inspector.add(m_panelName[panelPos], aPanel);
        this.m_inspector.validate();
    }

    public PvControl(PvViewer aViewer) {
        super(PsConfig.getProgram() + " v" + PsConfig.getVersion() + " - " + PsConfig.getMessage("Control"), (String[])null);
        this.m_viewer = aViewer;
        this.addKeyListener(this.m_viewer);
        this.m_firstShowing = true;
        this.m_currentPanel_Id = 0;
        this.init();
    }

    public void setVisible(boolean flag) {
        if (!flag || !this.m_firstShowing) {
            super.setVisible(flag);
            return;
        }
        this.m_firstShowing = false;
        PsDebug.notify("panel = " + m_panelName[this.m_currentPanel_Id]);
        this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
        if (this.m_currentPanel == null || this.m_bPanelOutside[this.m_currentPanel_Id]) {
            int i = 1;
            while (i <= 7) {
                this.enablePanel(PvViewer.getPanelId(m_panelName[this.m_currentPanel_Id]), false);
                this.m_currentPanel_Id = (this.m_currentPanel_Id + i) % 7;
                this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
                if (this.m_currentPanel != null && !this.m_bPanelOutside[this.m_currentPanel_Id]) break;
                ++i;
            }
            if (this.m_currentPanel == null) {
                PsDebug.error("missing panel = " + m_panelName[this.m_currentPanel_Id], this);
                return;
            }
        }
        if (this.m_geometry != null) {
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.addInspectorPanel(this.m_currentPanel_Id, this.m_currentPanel);
        this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
        this.pack();
        this.setLocation(this.m_viewer.m_controlSize[0], this.m_viewer.m_controlSize[1]);
        ((Component)this).setSize(this.m_viewer.m_controlSize[2], this.m_viewer.m_controlSize[3]);
        super.setVisible(true);
    }

    private Panel assurePanelAtPosition(int panelPos) {
        PsPanel panel = null;
        if (this.m_oldPanel[panelPos] != null) {
            return this.m_oldPanel[panelPos];
        }
        switch (panelPos) {
            case 0: {
                if (this.m_project == null) {
                    return null;
                }
                panel = this.m_project.getInfoPanel();
                break;
            }
            case 1: {
                if (this.m_geometry == null) {
                    return null;
                }
                panel = this.m_geometry.assureInspector("Info", "_IP");
                break;
            }
            case 2: {
                if (this.m_geometry == null) {
                    return null;
                }
                panel = this.m_geometry.assureInspector("Material", "_MP");
                break;
            }
            case 3: {
                if (this.m_geometry == null) {
                    return null;
                }
                panel = this.m_geometry.assureInspector("Texture", "_TP");
                break;
            }
            case 4: {
                if (this.m_geometry == null) {
                    return null;
                }
                panel = this.m_geometry.assureInspector("Control", "_CP");
                break;
            }
            case 5: {
                if (this.m_display == null) {
                    return null;
                }
                panel = this.m_display.getCameraPanel();
                break;
            }
            case 6: {
                if (this.m_display == null) {
                    return null;
                }
                panel = this.m_display.getInfoPanel();
                break;
            }
            default: {
                PsDebug.warning("index of panel = " + panelPos + " not found");
                return null;
            }
        }
        if (panel == null) {
            return null;
        }
        return panel;
    }

    protected void removeProject(PjProject aProject) {
        if (aProject == null) {
            return;
        }
        if (this.m_project != aProject) {
            PsDebug.warning("project = " + aProject.getName() + " not registered");
            return;
        }
        this.removeInspectorPanel(1);
        this.removeInspectorPanel(2);
        this.removeInspectorPanel(3);
        this.removeInspectorPanel(4);
        this.removeInspectorPanel(0);
        this.m_oldPanel[1] = null;
        this.m_oldPanel[2] = null;
        this.m_oldPanel[3] = null;
        this.m_oldPanel[4] = null;
        this.m_oldPanel[0] = null;
        if (this.m_menuBar != null && this.m_menuBar.m_mMethod != null) {
            this.m_menuBar.m_mMethod.removeAll();
        }
        this.m_project = null;
        this.m_geometry = null;
    }

    private void setLanguage(String lang) {
        PsConfig.setLanguage(lang);
        this.m_menuBar = new PvControlMenu(this);
        if (this.m_geometry != null) {
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.setMenuBar(this.m_menuBar);
        if (this.hasInspectorPanel(0)) {
            this.removeInspectorPanel(0);
        }
        if (this.hasInspectorPanel(1)) {
            this.removeInspectorPanel(1);
        }
        if (this.hasInspectorPanel(2)) {
            this.removeInspectorPanel(2);
        }
        if (this.hasInspectorPanel(3)) {
            this.removeInspectorPanel(3);
        }
        if (this.hasInspectorPanel(4)) {
            this.removeInspectorPanel(4);
        }
        if (this.hasInspectorPanel(5)) {
            this.removeInspectorPanel(5);
        }
        if (this.hasInspectorPanel(6)) {
            this.removeInspectorPanel(6);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.m_currentPanel_Id == 0) {
            this.showPanel(10);
        } else if (this.m_currentPanel_Id == 1) {
            this.showPanel(12);
        } else if (this.m_currentPanel_Id == 2) {
            this.showPanel(13);
        } else if (this.m_currentPanel_Id == 3) {
            this.showPanel(14);
        } else if (this.m_currentPanel_Id == 4) {
            this.showPanel(15);
        } else if (this.m_currentPanel_Id == 5) {
            this.showPanel(16);
        } else if (this.m_currentPanel_Id == 6) {
            this.showPanel(17);
        }
    }

    public boolean update(Object event) {
        if (this.m_viewer != null) {
            return this.m_viewer.update(this);
        }
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        String arg = event.getActionCommand();
        Object source = event.getSource();
        if (this.m_menuBar == null) {
            return;
        }
        if (source == this.m_menuBar.m_mFile_New_Project) {
            this.m_viewer.showDialog(27);
        } else if (source == this.m_menuBar.m_mFile_New_Geometry) {
            this.m_viewer.showDialog(29);
        } else if (source == this.m_menuBar.m_mFile_New_Display) {
            this.m_viewer.newDisplay();
        } else if (source == this.m_menuBar.m_mFile_Add_Project) {
            this.m_viewer.showDialog(28);
        } else if (source == this.m_menuBar.m_mFile_Add_Geometry) {
            this.m_viewer.showDialog(30);
        } else if (source == this.m_menuBar.m_mFile_Import_VGP) {
            this.m_viewer.showDialog(31);
        } else if (source == this.m_menuBar.m_mFile_Import_DISK) {
            this.m_viewer.showDialog(32);
        } else if (source == this.m_menuBar.m_mFile_Import_Deserialize) {
            this.m_viewer.deserialize();
        } else if (source == this.m_menuBar.m_mFile_Export_BYU) {
            this.m_viewer.showDialog(33);
        } else if (source == this.m_menuBar.m_mFile_Export_FE) {
            this.m_viewer.showDialog(34);
        } else if (source == this.m_menuBar.m_mFile_Export_JVX) {
            this.m_viewer.showDialog(35);
        } else if (source == this.m_menuBar.m_mFile_Export_JVX_SMALL) {
            this.m_viewer.showDialog(351);
        } else if (source == this.m_menuBar.m_mFile_Export_MGS) {
            this.m_viewer.showDialog(36);
        } else if (source == this.m_menuBar.m_mFile_Export_MPL) {
            this.m_viewer.showDialog(37);
        } else if (source == this.m_menuBar.m_mFile_Export_OBJ) {
            this.m_viewer.showDialog(38);
        } else if (source == this.m_menuBar.m_mFile_Export_OFF) {
            this.m_viewer.showDialog(39);
        } else if (source == this.m_menuBar.m_mFile_Export_VRML) {
            this.m_viewer.showDialog(40);
        } else if (source == this.m_menuBar.m_mFile_Export_GIF) {
            this.m_viewer.showDialog(41);
        } else if (source == this.m_menuBar.m_mFile_Export_GIF_ANIM) {
            this.m_viewer.showDialog(42);
        } else if (source == this.m_menuBar.m_mFile_Export_PPM) {
            this.m_viewer.showDialog(43);
        } else if (source == this.m_menuBar.m_mFile_Export_PPM_ANIM) {
            this.m_viewer.showDialog(44);
        } else if (source == this.m_menuBar.m_mFile_Export_Serialize_Applet || source == this.m_menuBar.m_mFile_Export_Serialize_Display || source == this.m_menuBar.m_mFile_Export_Serialize_Geometry || source == this.m_menuBar.m_mFile_Export_Serialize_Project) {
            this.m_viewer.serialize(arg);
        } else if (source == this.m_menuBar.m_mFILE_PRINT_EPS) {
            this.m_viewer.showDialog(46);
        } else if (source == this.m_menuBar.m_mFILE_PRINT_PS) {
            this.m_viewer.showDialog(47);
        } else if (source == this.m_menuBar.m_mFile_Export_JVD) {
            this.m_viewer.showDialog(48);
        } else if (source == this.m_menuBar.m_mFile_Submit) {
            this.m_viewer.submit();
        } else if (source == this.m_menuBar.m_mFile_Close) {
            this.setVisible(false);
        } else if (source == this.m_menuBar.m_mFile_Exit) {
            this.m_viewer.destroy();
        } else if (source == this.m_menuBar.m_mInspector_Project) {
            this.showPanel(10);
        } else if (source == this.m_menuBar.m_mInspector_Object_Info) {
            this.showPanel(12);
        } else if (source == this.m_menuBar.m_mInspector_Object_Material) {
            this.showPanel(13);
        } else if (source == this.m_menuBar.m_mInspector_Object_Texture) {
            this.showPanel(14);
        } else if (source == this.m_menuBar.m_mInspector_Object_Config) {
            this.showPanel(15);
        } else if (source == this.m_menuBar.m_mInspector_Camera) {
            this.showPanel(16);
        } else if (source == this.m_menuBar.m_mInspector_Display) {
            this.showPanel(17);
        } else if (source == this.m_menuBar.m_mWindow_Animation) {
            this.m_viewer.showDialog(23);
        } else if (source == this.m_menuBar.m_mWindow_Console) {
            this.m_viewer.showDialog(25);
        } else if (source == this.m_menuBar.m_mHelp_Garbage) {
            Runtime rt = Runtime.getRuntime();
            PsDebug.message("free memory (before gc) = " + String.valueOf(rt.freeMemory()));
            System.gc();
            PsDebug.message("free memory (after gc)  = " + String.valueOf(rt.freeMemory()));
        } else if (source == this.m_menuBar.m_mWindow_Network) {
            PsDebug.warning("network viewer not implemented yet.");
        } else if (source == this.m_menuBar.m_mHelp_Rsrc) {
            this.m_viewer.showDialog(20);
        } else if (source == this.m_menuBar.m_mHelp_About) {
            this.m_viewer.showDialog(21);
        } else if (source == this.m_menuBar.m_mHelp_Applet) {
            this.m_viewer.showDialog(22);
        } else if (source == this.m_menuBar.m_mHelp_Language_English) {
            this.setLanguage("en");
        } else if (source == this.m_menuBar.m_mHelp_Language_German) {
            this.setLanguage("de");
        } else if (source == this.m_menuBar.m_mHelp_Language_French) {
            this.setLanguage("fr");
        } else if (source == this.m_menuBar.m_mHelp_Language_Portuguese) {
            this.setLanguage("pt");
        } else if (source == this.m_menuBar.m_mHelp_Viewer) {
            this.m_viewer.showDialog(26);
        } else if (source == this.m_menuBar.m_mHelp_Fonts) {
            if (!PsConfig.isApplication()) {
                try {
                    URL fonts = new URL(PsConfig.getCodeBase() + "jars/systemFonts.html");
                    fonts.openConnection();
                    fonts.openStream();
                    PsConfig.getApplet().getAppletContext().showDocument(fonts, "SystemFonts");
                }
                catch (MalformedURLException exc) {
                    PsDebug.warning("MalformedURLException when accessing HTML font page.");
                }
                catch (IOException exc) {
                    PsDebug.warning("IOException, no connection to HTML font page.");
                }
            } else {
                Component sf = (Component)PsUtil.newInstance("jvx.thirdParty.fonts.SystemFonts");
                if (sf == null) {
                    PsDebug.warning("could not create font canvas.\n\t Probably, class is not contained in current archive.");
                    return;
                }
                PsDialog dialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage("fontExample"), true);
                dialog.setLayout(new BorderLayout());
                ((Component)dialog).setSize(400, 700);
                dialog.add("Center", sf);
                dialog.add("South", dialog.getBottomButtons(2));
                ((Component)dialog).setVisible(true);
            }
        } else if (source == this.m_menuBar.m_mHelp_SystemProp) {
            PsDialog dialog = new PsDialog(PsConfig.getFrame(), "System Properties and Applet Parameters", true);
            ScrollPane pane = new ScrollPane();
            Panel panel = new Panel();
            ((Component)panel).setFont(PsConfig.getFont(1));
            panel.setLayout(new BorderLayout());
            Hashtable prop = PsConfig.getProperties();
            Panel pLeft = new Panel();
            pLeft.setLayout(new GridLayout(prop.size(), 1));
            Panel pRight = new Panel();
            pRight.setLayout(new GridLayout(prop.size(), 1));
            Enumeration keys = prop.keys();
            while (keys.hasMoreElements()) {
                String propKey = (String)keys.nextElement();
                TextField tVal = propKey.equals("line.separator") ? new TextField("\\n\n") : new TextField(String.valueOf(prop.get(propKey)) + "\n");
                pLeft.add(new Label(propKey));
                pRight.add(tVal);
            }
            panel.add("North", new Label("Note, property values are currently not editable."));
            panel.add("West", pLeft);
            panel.add("Center", pRight);
            pane.add(panel);
            dialog.setLayout(new BorderLayout());
            dialog.add("Center", pane);
            dialog.add("South", dialog.getBottomButtons(2));
            ((Component)dialog).setSize(500, 600);
            ((Component)dialog).setVisible(true);
        } else {
            PsDebug.notify("arg=" + arg.toString());
        }
    }

    protected Panel releasePanel(int aPanel) {
        Panel panel = this.assurePanelAtPosition(PvControl.getPanelPosition(aPanel));
        if (panel == null) {
            return null;
        }
        this.enablePanel(aPanel, true);
        this.m_bPanelOutside[PvControl.getPanelPosition((int)aPanel)] = false;
        return panel;
    }

    protected void setGeometry(PgGeometryIf geom) {
        if (geom == null) {
            this.enableMenu(22, false);
            this.removeInspectorPanel(1);
            this.removeInspectorPanel(2);
            this.removeInspectorPanel(3);
            this.removeInspectorPanel(4);
            if (this.isShowing()) {
                if (this.m_currentPanel_Id == 1 || this.m_currentPanel_Id == 2 || this.m_currentPanel_Id == 3 || this.m_currentPanel_Id == 4) {
                    this.showPanel(16);
                }
                if (this.m_menuBar.m_mMethod != null) {
                    this.m_menuBar.m_mMethod.removeAll();
                }
            }
            this.m_geometry = null;
            return;
        }
        if (this.m_geometry == geom) {
            return;
        }
        this.enableMenu(22, true);
        this.m_geometry = geom;
        if (this.m_menuBar.m_mMethod != null) {
            this.m_menuBar.m_mMethod.removeAll();
            this.m_geometry.fillMethodMenu(this.m_menuBar.m_mMethod);
        }
        this.removeInspectorPanel(1);
        this.removeInspectorPanel(2);
        this.removeInspectorPanel(3);
        this.removeInspectorPanel(4);
        this.enableMenu(223, this.m_geometry.isConfigurable(7));
        this.enableMenu(220, this.m_geometry.isConfigurable(4));
        this.enableMenu(221, this.m_geometry.isConfigurable(5));
        this.enableMenu(222, this.m_geometry.isConfigurable(6));
        if (this.isShowing()) {
            boolean success = false;
            if (this.m_currentPanel_Id == 1) {
                success = this.showPanel(12);
            } else if (this.m_currentPanel_Id == 2) {
                success = this.showPanel(13);
            } else if (this.m_currentPanel_Id == 3) {
                success = this.showPanel(14);
            } else if (this.m_currentPanel_Id == 4) {
                success = this.showPanel(15);
            } else if (this.m_project != null && this.m_currentPanel_Id == 0) {
                success = this.showPanel(10);
            } else if (this.m_display != null && this.m_currentPanel_Id == 5) {
                success = this.showPanel(16);
            } else if (this.m_display != null && this.m_currentPanel_Id == 6) {
                success = this.showPanel(17);
            } else {
                PsDebug.warning("missing panel[" + this.m_currentPanel_Id + "] in geom = " + geom.getName());
            }
            if (!success) {
                boolean bl = this.showPanel(16);
            }
        }
    }

    protected void enableMenu(int menuId, boolean cond) {
        if (this.m_menuBar != null) {
            this.m_menuBar.enableMenu(menuId, cond);
        }
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
        int i = 0;
        while (i < 7) {
            this.m_bPanelOutside[i] = false;
            ++i;
        }
        this.m_inspector = new Panel();
        this.m_inspector.addKeyListener(this.m_viewer);
        this.add("Center", this.m_inspector);
        this.m_crd = new CardLayout();
        this.m_inspector.setLayout(this.m_crd);
        this.m_menuBar = new PvControlMenu(this);
        this.setMenuBar(this.m_menuBar);
    }

    public Panel getPanel(int aPanel) {
        Panel panel = this.assurePanelAtPosition(PvControl.getPanelPosition(aPanel));
        if (panel == null) {
            return null;
        }
        this.enablePanel(aPanel, false);
        this.m_bPanelOutside[PvControl.getPanelPosition((int)aPanel)] = true;
        return panel;
    }

    protected boolean enablePanel(int aPanel, boolean cond) {
        switch (aPanel) {
            case 10: {
                this.enableMenu(21, cond);
                break;
            }
            case 12: {
                this.enableMenu(220, cond);
                break;
            }
            case 13: {
                this.enableMenu(221, cond);
                break;
            }
            case 14: {
                this.enableMenu(222, cond);
                break;
            }
            case 15: {
                this.enableMenu(223, cond);
                break;
            }
            case 16: {
                this.enableMenu(23, cond);
                break;
            }
            case 17: {
                this.enableMenu(24, cond);
                break;
            }
            default: {
                PsDebug.notify("panel not found = " + aPanel);
                return false;
            }
        }
        return true;
    }

    public boolean showPanel(int panelId) {
        if (this.m_bPanelOutside[PvControl.getPanelPosition(panelId)]) {
            return false;
        }
        this.m_currentPanel_Id = PvControl.getPanelPosition(panelId);
        if (this.isShowing()) {
            this.m_currentPanel = this.assurePanelAtPosition(this.m_currentPanel_Id);
            if (this.m_currentPanel == null) {
                return false;
            }
            boolean isParent = true;
            Container prevParent = this.m_currentPanel.getParent();
            if (this.m_currentPanel.isShowing() && this.m_inspector != prevParent) {
                isParent = false;
                this.enablePanel(panelId, true);
                PsDebug.warning("Requested panel is not associated to control window", this.m_currentPanel);
            }
            this.addInspectorPanel(this.m_currentPanel_Id, this.m_currentPanel);
            this.m_crd.show(this.m_inspector, m_panelName[this.m_currentPanel_Id]);
            if (!isParent) {
                ((Component)prevParent).validate();
            }
            ((PsPanel)this.m_currentPanel).update(((PsPanel)this.m_currentPanel).getFather());
        }
        return true;
    }

    private void removeInspectorPanel(int panelPos) {
        if (this.m_oldPanel[panelPos] == null) {
            return;
        }
        this.m_inspector.remove(this.m_oldPanel[panelPos]);
        this.m_oldPanel[panelPos] = null;
    }

    private boolean hasInspectorPanel(int panelPos) {
        return this.m_oldPanel[panelPos] != null;
    }

    private static int getPanelPosition(int panelId) {
        if (panelId == 10) {
            return 0;
        }
        if (panelId == 12) {
            return 1;
        }
        if (panelId == 13) {
            return 2;
        }
        if (panelId == 14) {
            return 3;
        }
        if (panelId == 15) {
            return 4;
        }
        if (panelId == 16) {
            return 5;
        }
        if (panelId == 17) {
            return 6;
        }
        PsDebug.notify("panel not found = " + panelId);
        return -1;
    }
}

