/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.util.Dictionary;
import java.util.Enumeration;
import jv.thirdParty.acmeEncoders.IntHashtableEntry;
import jv.thirdParty.acmeEncoders.IntHashtableEnumerator;

public class IntHashtable
extends Dictionary
implements Cloneable {
    private IntHashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public synchronized Object get(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object get(Object okey) {
        if (!(okey instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer ikey = (Integer)okey;
        int key = ikey;
        return this.get(key);
    }

    public synchronized Object put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new IntHashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object put(Object okey, Object value) {
        if (!(okey instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer ikey = (Integer)okey;
        int key = ikey;
        return this.put(key, value);
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new IntHashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public synchronized Enumeration elements() {
        return new IntHashtableEnumerator(this.table, false);
    }

    public int size() {
        return this.count;
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Enumeration keys() {
        return new IntHashtableEnumerator(this.table, true);
    }

    public synchronized void clear() {
        IntHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntHashtableEntry[] newTable = new IntHashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IntHashtableEntry old = oldTable[i];
            while (old != null) {
                IntHashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable t = (IntHashtable)super.clone();
            t.table = new IntHashtableEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                IntHashtableEntry intHashtableEntry = t.table[i] = this.table[i] != null ? (IntHashtableEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized Object remove(int key) {
        IntHashtableEntry[] tab = this.table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        IntHashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                this.count += -1;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object remove(Object okey) {
        if (!(okey instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer ikey = (Integer)okey;
        int key = ikey;
        return this.remove(key);
    }
}

