/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsObject;

public class PsAnimation
extends PsObject
implements Runnable {
    public static final int FORWARD = 0;
    public static final int REWIND = 1;
    public static final int FAST_FORWARD = 2;
    public static final int FAST_REWIND = 3;
    public static final int ONE_WAY = 0;
    public static final int LOOP = 1;
    public static final int BACK_FORTH = 2;
    protected Vector m_dynamicList;
    protected double m_globalTime;
    protected PuDouble m_currentTime;
    protected int m_speed;
    private double m_timeIncr;
    private long m_sleepInterval;
    protected int m_repeat;
    protected boolean m_syncFlag = true;
    protected boolean m_enableKeys = false;
    protected int[] m_position = new int[]{100, 100, 400, 250};
    protected transient PsDialog m_animDialog;
    protected transient Thread m_thread;
    private static /* synthetic */ Class class$jv$anim$PsAnimation;

    public void stop() {
        if (this.m_thread != null) {
            PsDebug.notify("Animation stopped");
            this.m_thread = null;
        } else {
            PsDebug.notify("Animation is not running");
        }
    }

    public void setTimeInterval(double aMin, double aMax, double aLineIncr, double aPageIncr) {
        this.m_currentTime.setBounds(aMin, aMax, aLineIncr, aPageIncr);
    }

    public void setTimeInterval(double aMin, double aMax) {
        this.m_currentTime.setBounds(aMin, aMax);
    }

    public PsAnimation() {
        this.setTag(4);
        this.m_currentTime = new PuDouble(PsConfig.getMessage("currentTime"), this);
        this.m_currentTime.setDefBounds(0.0, 100.0, 1.0, 5.0);
        this.m_currentTime.setDefValue(0.0);
        if (this.getClass() == (class$jv$anim$PsAnimation != null ? class$jv$anim$PsAnimation : (class$jv$anim$PsAnimation = PsAnimation.class$("jv.anim.PsAnimation")))) {
            this.init();
        }
    }

    public void setRepeat(int repeat) {
        this.m_repeat = repeat;
    }

    public double getTimeStepIncr() {
        return this.m_currentTime.getLineIncr();
    }

    public double getMinTime() {
        return this.m_currentTime.getMin();
    }

    public double getTime() {
        return this.m_currentTime.getValue();
    }

    public void setTime(double newTime) {
        if (newTime == this.m_currentTime.getValue()) {
            return;
        }
        this.m_globalTime = newTime;
        if (!this.m_syncFlag) {
            return;
        }
        boolean success = this.setTime(new PsTimeEvent(this.m_globalTime));
        if (success) {
            this.m_currentTime.setValue(this.m_globalTime);
        }
    }

    protected boolean setTime(PsTimeEvent timeEvent) {
        PsDebug.notify("time = " + timeEvent.getTime());
        if (this.m_dynamicList == null) {
            return true;
        }
        Enumeration e = this.m_dynamicList.elements();
        while (e.hasMoreElements()) {
            PsTimeListenerIf dynamic = (PsTimeListenerIf)e.nextElement();
            dynamic.setTime(timeEvent);
        }
        return true;
    }

    public double getMaxTime() {
        return this.m_currentTime.getMax();
    }

    public boolean update(Object event) {
        if (event == this.m_currentTime) {
            double newTime;
            this.m_globalTime = newTime = this.m_currentTime.getValue();
            return this.setTime(new PsTimeEvent(this.m_globalTime));
        }
        if (event == this.m_animDialog) {
            return true;
        }
        return super.update(event);
    }

    public long getSleepInterval() {
        return this.m_sleepInterval;
    }

    public void setSleepInterval(long newInterval) {
        this.m_sleepInterval = newInterval;
    }

    public double getTimePageIncr() {
        return this.m_currentTime.getPageIncr();
    }

    public void start() {
        this.start(0);
    }

    public void start(int speed) {
        this.setSpeed(speed);
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Animation");
            this.m_thread.start();
            PsDebug.notify("Animation started");
        } else {
            PsDebug.notify("Animation is running");
        }
    }

    public boolean hasTimeListener(PsTimeListenerIf listener) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.contains(listener);
    }

    public boolean removeTimeListener(PsTimeListenerIf listener) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.removeElement(listener);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void setPosition(int[] position) {
        if (position == null || position.length < 4) {
            PsDebug.warning("missing or incomplete position");
            return;
        }
        int i = 0;
        while (i < 4) {
            this.m_position[i] = position[i];
            ++i;
        }
        if (this.m_animDialog != null) {
            this.m_animDialog.setLocation(this.m_position[0], this.m_position[1]);
            ((Component)this.m_animDialog).setSize(this.m_position[2], this.m_position[3]);
        }
    }

    public void synchronize(boolean flag) {
        if (this.m_syncFlag == flag) {
            return;
        }
        this.m_syncFlag = flag;
        if (this.m_syncFlag) {
            this.setTime(this.m_globalTime);
        }
    }

    public boolean addTimeListener(PsTimeListenerIf listener) {
        if (this.m_dynamicList == null) {
            this.m_dynamicList = new Vector();
        } else if (this.hasTimeListener(listener)) {
            PsDebug.warning("name = " + listener.getName() + " of listener already used.");
            return false;
        }
        this.m_dynamicList.addElement(listener);
        listener.setAnimation(this);
        return true;
    }

    public void enableKeys(boolean flag) {
        if (this.m_enableKeys == flag) {
            return;
        }
        this.m_enableKeys = flag;
        this.updatePanels(this);
    }

    public void run() {
        while (this.m_thread != null) {
            double newTime = this.m_currentTime.getValue();
            if ((newTime += this.m_timeIncr) > this.m_currentTime.getMax() - 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMax());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    newTime = newTime < this.m_currentTime.getMax() + 1.0E-10 ? this.m_currentTime.getMax() : this.m_currentTime.getMin();
                } else if (this.m_repeat == 2) {
                    newTime = this.m_currentTime.getMax();
                    this.m_timeIncr *= -1.0;
                }
            } else if (newTime < this.m_currentTime.getMin() + 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMin());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    newTime = newTime > this.m_currentTime.getMin() - 1.0E-10 ? this.m_currentTime.getMin() : this.m_currentTime.getMax();
                } else if (this.m_repeat == 2) {
                    newTime = this.m_currentTime.getMin();
                    this.m_timeIncr *= -1.0;
                }
            }
            this.setTime(newTime);
            PsDebug.notify("current time = " + newTime);
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void init() {
        super.init();
        this.m_speed = 0;
        this.m_repeat = 2;
        this.m_syncFlag = true;
        this.m_globalTime = 0.0;
        this.m_sleepInterval = 50L;
        this.m_currentTime.init();
    }

    public PsDialog getAnimationPanel() {
        if (this.m_animDialog != null) {
            return this.m_animDialog;
        }
        this.m_animDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage("AnimationPanel"), false);
        if (this.m_animDialog == null) {
            PsDebug.warning("failed allocating animation dialog.");
            return null;
        }
        this.m_animDialog.add("Center", this.getInfoPanel());
        this.m_animDialog.add("South", this.m_animDialog.getBottomButtons(16));
        this.m_animDialog.pack();
        this.m_animDialog.setLocation(this.m_position[0], this.m_position[1]);
        ((Component)this.m_animDialog).setSize(this.m_position[2], this.m_position[3]);
        this.m_animDialog.setParent(this);
        this.m_animDialog.update(this);
        return this.m_animDialog;
    }

    public void setAnimationPanel(PsDialog panel) {
        this.m_animDialog = panel;
    }

    protected void setSpeed(int speed) {
        this.m_speed = speed;
        switch (this.m_speed) {
            case 0: {
                this.m_timeIncr = this.m_currentTime.getLineIncr();
                break;
            }
            case 1: {
                this.m_timeIncr = -this.m_currentTime.getLineIncr();
                break;
            }
            case 2: {
                this.m_timeIncr = this.m_currentTime.getPageIncr();
                break;
            }
            case 3: {
                this.m_timeIncr = -this.m_currentTime.getPageIncr();
                break;
            }
        }
    }

    public boolean isRunning() {
        return this.m_thread != null;
    }

    public boolean hasAnimationPanel() {
        return this.m_animDialog != null;
    }
}

