/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public final class PuInteger
extends PsObject {
    private int m_defValue = 0;
    private int m_defMinimum = -10;
    private int m_defMaximum = 10;
    private int m_defLineIncr = 1;
    private int m_defPageIncr = 10;
    protected int m_value;
    protected int m_minimum;
    protected int m_maximum;
    protected int m_lineIncr;
    protected int m_pageIncr;
    protected boolean m_enabled = true;

    public void setValue(int aValue) {
        this.setValueFromPanel(aValue, this);
    }

    public int getValue() {
        return this.m_value;
    }

    public int getMin() {
        return this.m_minimum;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public PuInteger(String aName, PsUpdateIf aParent) {
        this.setTag(4);
        this.setTag(7);
        this.setParent(aParent);
        this.setName(aName);
        this.init();
    }

    public int getDefPageIncr() {
        return this.m_defPageIncr;
    }

    public void setDefBounds(int aMin, int aMax, int aLineIncr, int aPageIncr) {
        this.m_defMinimum = aMin;
        this.m_defMaximum = aMax;
        this.m_defLineIncr = aLineIncr;
        this.m_defPageIncr = aPageIncr;
    }

    public void setDefValue(int value) {
        this.m_defValue = value;
    }

    public boolean update(Object anObject) {
        if (anObject == this.m_infoPanel) {
            return super.update(null);
        }
        return super.update(anObject);
    }

    protected void setValueFromPanel(int aValue, Object event) {
        if (aValue < this.m_minimum) {
            aValue = this.m_minimum;
        } else if (this.m_maximum < aValue) {
            aValue = this.m_maximum;
        }
        if (this.m_value == aValue) {
            return;
        }
        this.m_value = aValue;
        this.updatePanels(event);
    }

    public int getDefMinimum() {
        return this.m_defMinimum;
    }

    public int getLineIncr() {
        return this.m_lineIncr;
    }

    public void copy(PuInteger num) {
        super.copy(num);
        this.m_defValue = num.m_defValue;
        this.m_defMinimum = num.m_defMinimum;
        this.m_defMaximum = num.m_defMaximum;
        this.m_defLineIncr = num.m_defLineIncr;
        this.m_defPageIncr = num.m_defPageIncr;
        this.m_value = num.m_value;
        this.m_minimum = num.m_minimum;
        this.m_maximum = num.m_maximum;
        this.m_lineIncr = num.m_lineIncr;
        this.m_pageIncr = num.m_pageIncr;
    }

    public int getMax() {
        return this.m_maximum;
    }

    public int getPageIncr() {
        return this.m_pageIncr;
    }

    public void setBounds(int aMin, int aMax, int aLineIncr, int aPageIncr) {
        this.m_minimum = aMin;
        this.m_maximum = aMax;
        if (aLineIncr >= aMax) {
            aLineIncr = 1;
        }
        this.m_lineIncr = aLineIncr;
        if (aPageIncr >= aMax) {
            aPageIncr = 1;
        }
        this.m_pageIncr = aPageIncr;
        this.setValue(this.m_value);
    }

    public void init() {
        super.init();
        this.setBounds(this.m_defMinimum, this.m_defMaximum, this.m_defLineIncr, this.m_defPageIncr);
        this.setValue(this.m_defValue);
        this.updatePanels(this);
    }

    protected void incrValue(int units) {
        this.m_value += units * this.m_lineIncr;
    }

    public void setBounds(int aMin, int aMax) {
        this.setBounds(aMin, aMax, this.m_defLineIncr, this.m_defPageIncr);
    }

    public int getDefMaximum() {
        return this.m_defMaximum;
    }

    public void setEnabled(boolean flag) {
        PsDebug.notify("setEnabled(" + flag + ")");
        if (this.m_enabled == flag) {
            return;
        }
        this.m_enabled = flag;
        if (this.hasInspector("Info")) {
            this.getInspector("Info").setEnabled(flag);
        }
    }

    public int getDefLineIncr() {
        return this.m_defLineIncr;
    }
}

