/*
 *  $Id$
 */

#include <map>
#include <iostream>
#include <fstream>
#include <sstream>

using namespace std;

void outNumberToScancode(ostream &target, int set, int number, const string &str) {
    static int objcnt=0;
    objcnt++;

    target << "static const int object"<<objcnt<<"[] = { ";

    istringstream is(str);

    int cnt=0;
    do {
        char val[5];
        char dummy; //overread ','

        is.get(val, 5, ',');
        if (is.fail()) break;
        target << "0x00" << val;
        is >> dummy;
        if (is.fail()) break;
        target << ",";
        cnt++;



    } while (!is.eof());

    //for (;cnt<MAX_CHAR_PER_KEY; cnt++) {
    target << ",0xffff";
    //}




    target << "};" << endl;

    target << "keynumberToScancode" << set << "[" << number << "]= object"<<objcnt<<";"<< endl;

}

void generateKeytrans(
  std::string directory, std::string output
)
{
    string xName( directory + string("/xcode_to_keynumber.dat") );
    string kName( directory + string("/keynumber_to_scancode.dat") ); 

    ifstream xToNumber( xName.c_str() );
    ifstream keynumberToScancode( kName.c_str() );
    ofstream target( output.c_str() );

    target
      << "//" << endl
      << "//  This file is automatically generated.  DO NOT EDIT!" << endl
      << "//  See kbdgentables.cpp for details." << endl
      << "//" << endl
      << endl;

    do {
        int xcode;
        int number;
        xToNumber >> xcode >> number;
        if (xToNumber.fail()) break;
        target << "xToNumber[" << xcode << "]="<< number<< ";" << endl;
    }
    while (!xToNumber.eof());

    do {
        int number;
        string mode1;
        string mode2;
        string mode3;

        keynumberToScancode >> number >> mode1>>mode2>>mode3;
        if (keynumberToScancode.fail()) break;

        //unpack the multi char strings "0a,0b,0c" 
        //and add 0x before each hex value
        //unused values are set to 0xffff

        outNumberToScancode(target, 1, number, mode1);
        outNumberToScancode(target, 2, number, mode2);
        outNumberToScancode(target, 3, number, mode3);

    } while (!keynumberToScancode.eof());
    
    cout << "file " << output << " created. Please copy it to include/ui directory in repository!" << endl;
}

int main(
  int    argc,
  char **argv
)
{
    if ( argc != 3 ) {
        cerr << "Incorrect usage; takes a input directory and output file argument" << endl;
        return -1;
    }

    generateKeytrans( string(argv[1]), string(argv[2]) );

}

