////////////////////////////////////////////////////////////////////////////////
/// triBase.js
///
/// DISCLAIMER
///
/// Copyright 2010 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Claudius Weinberger
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////
//
//
//

(function(voc){ 
  // session ------------------
  voc.session = session = {};
  session.rightNames = {  
    '1000': 'RIGHT_TO_MANAGE_ADMIN',
    '1001': 'RIGHT_TO_MANAGE_USER',
    '1002': 'RIGHT_TO_BE_DELETED',
    '1003': 'RIGHT_TO_LOGIN'
  }; 
  session.availableRoles = [];  // will be populated from rightFuncs
  session.rightFuncs = { 
    '1000': function(){
      // whatevers
    }, 
    '1001': function(){
      // FIXME voc.conf.nav.. should not be altered.
      // make a copy or actually alter the dom of teh navi here. 
      voc.addNaviItem('Users', 'userManager'); 
      /*
      voc.conf.navigation.push({
        label: 'Users', 
        controller: 'userManager' 
      }); 
      */
    }, 
    '1002': function(){
    },
    '1003': function(){ 
      $('#loginlink').show().click(function(){
        voc.stack.add(voc.controllers.login); 
      }); 
    }  
  }; 
  session.get = function(cb){ 
    cb = cb || function(){};
    this.initedRights = []; 
    $.ajax({ 
      url: voc.conf.urls.startSession,
      context: this, 
      dataType: 'json', 
      type: 'POST',
      success: function(data){ 
        //{"sid" : "LZHFYRtSbN", "rights" : [1003]}  
        session.sid = data.sid, 
        session.rights = data.rights
        this.init(); 
        cb(); 
      }, 
      error: function(err){ 
        $('.notifier').notifier('notify', 'error', 'Session Fail!');
      }  
    }); 
  }; 
  session.rightIsInited = function(right){ 
    this.initedRights = this.initedRights || []; 
    for(var i=0; i<this.initedRights.length; i++){
      if(this.initedRights[i] === right){
        return true;
      } 
    } 
    return false;
  }, 
  session.init = function(){ 
    // init calls a function for every right the session(user) has.
    // this function needs to be idempotent, so every right that 
    // is inited is stored in this.initedRights 
    // if new rights are aquired and init() is called again the 
    // rights that have already been initialized
    this.initedRights = this.initedRights || []; 
    for(var i=0; i<this.rights.length; i++){
      console.log(this.rights[i]); 
      if(!this.rightIsInited(this.rights[i])){ 
        console.log('init');
        this.rightFuncs[this.rights[i]](); 
        this.initedRights.push(this.rights[i]);
      } 
    } 
  }; 


  // app ---------------------------

  voc.addNaviItem = function(label, controller){ 
      var li = $('<li />').appendTo('#subnavi ul'); ; 
      $('<a />', { 
        href: '#', 
        id:'nav_'+controller, 
        text: label,
        click: function(){
          var ctrl  = controller; 
          voc.highlightNavi('nav_'+ctrl);
          $.cookie('lastcontroller', ctrl); 
          voc.stack.add(voc.controllers[ctrl]); 
        } 
      }).appendTo(li); 
  }; 

  voc.buildNavi = function(){ 
    // build navi and bind controllers to navi items.
    $('#subnavi ul').empty();
    for(var i=0; i<voc.conf.navigation.length; i++){ 
      var nav = voc.conf.navigation[i]; 
      voc.addNaviItem(nav.label, nav.controller); 
    } 
  }; 

})(voc); 


$(document).ready(function(){
  // this is the 'main'
  //
  // start the notifier. this is independent from other controllers and 
  // controllers shouldn't mess with it's dom-node. 
  $('div.notifier').notifier({
    maxLen: voc.conf.notifications.count, 
    notifyDuration : voc.conf.notifications.duration
  }); 
  // the notifier can be opened by pressing crtl+i 
  $(document).keyup(function(e){ 
    if(e.ctrlKey && e.keyCode === 73){ 
      $('div.notifier').notifier('show'); 
    } 
  }); 

  // TODO: activity indicator

  voc.session.get(function(){   
    voc.buildNavi(); 
    // see if there is a cookie holding information about which controller 
    // to execute
    if(voc.controllers[$.cookie('lastcontroller')]){ 
      voc.stack.add(voc.controllers[$.cookie('lastcontroller')]); 
      voc.highlightNavi('nav_'+$.cookie('lastcontroller'));
    } else {  // otherwise execute a default
      voc.stack.add(voc.controllers[voc.conf.defaultController]); 
      voc.highlightNavi('nav_'+voc.conf.defaultController);
    }  
  });
});  


