////////////////////////////////////////////////////////////////////////////////
/// @brief statistics and figures
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_SIMPLEVOC_SIMPLE_VOC_FIGURES_H
#define SIMPLEVOC_SIMPLEVOC_SIMPLE_VOC_FIGURES_H 1

#include <Basics/Common.h>

#include <Basics/RoundRobinFigures.h>

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics numbers
    ////////////////////////////////////////////////////////////////////////////////

    enum stat_e {
      STAT_MC_INVALID = 0,
      STAT_MC_ADD = 1,
      STAT_MC_APPEND = 2,
      STAT_MC_CAS = 3,
      STAT_MC_DECR = 4,
      STAT_MC_DELETE = 5,
      STAT_MC_FLUSH_ALL = 6,
      STAT_MC_GET = 7,
      STAT_MC_GETS = 8,
      STAT_MC_INCR = 9,
      STAT_MC_PGET = 10,
      STAT_MC_PGETS = 11,
      STAT_MC_PREPEND = 12,
      STAT_MC_REPLACE = 13,
      STAT_MC_SET = 14,
      STAT_MC_STAT = 15,
      STAT_MC_VERSION = 16,

      STAT_POSTFIX_INVALID = 17,
      STAT_POSTFIX_GET = 18,
      STAT_POSTFIX_PUT = 19,

      STAT_REST_INVALID = 20,
      STAT_REST_FLUSH = 21,
      STAT_REST_PREFIX = 22,
      STAT_REST_VALUE_GET = 23,
      STAT_REST_VALUE_POST = 24,
      STAT_REST_VALUE_PUT = 25,
      STAT_REST_VALUE_DELETE = 26,
      STAT_REST_VERSION = 27,
      STAT_REST_STATS = 28,

      STAT_END = 29
    };

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics groups
    ////////////////////////////////////////////////////////////////////////////////

    enum group_e {
      GROUP_ALL = 0,

      GROUP_MC = 1,
      GROUP_POSTFIX = 2,
      GROUP_REST = 3,

      GROUP_END = 4
    };

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics names
    ////////////////////////////////////////////////////////////////////////////////

    string StatisticsName (stat_e);

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics group
    ////////////////////////////////////////////////////////////////////////////////

    group_e StatisticsGroup (stat_e);

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief group names
    ////////////////////////////////////////////////////////////////////////////////

    string GroupName (group_e);

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics
    ////////////////////////////////////////////////////////////////////////////////

    struct SimpleVocStatistics {
      RRF_FIGURES(SimpleVocStatistics, size_t(STAT_END), runtimes);
    };

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief figures by the second
    ////////////////////////////////////////////////////////////////////////////////

    extern basics::RoundRobinFigures<1, 61, SimpleVocStatistics> FiguresSecond;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief figures by the minute
    ////////////////////////////////////////////////////////////////////////////////

    extern basics::RoundRobinFigures<60, 61, SimpleVocStatistics> FiguresMinute;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief figures by the hour
    ////////////////////////////////////////////////////////////////////////////////

    extern basics::RoundRobinFigures<60 * 60, 25, SimpleVocStatistics> FiguresHour;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief figures by the day
    ////////////////////////////////////////////////////////////////////////////////

    extern basics::RoundRobinFigures<24 * 60 * 60, 31, SimpleVocStatistics> FiguresDay;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief add new figure
    ////////////////////////////////////////////////////////////////////////////////

    template<typename C>
    void addFigure (size_t statistics, double time) {
      FiguresSecond.addFigure<SimpleVocStatistics::runtimesAccessor>(statistics, time);
      FiguresMinute.addFigure<SimpleVocStatistics::runtimesAccessor>(statistics, time);
      FiguresHour.addFigure<SimpleVocStatistics::runtimesAccessor>(statistics, time);
      FiguresDay.addFigure<SimpleVocStatistics::runtimesAccessor>(statistics, time);
    }
  }
}

#endif

