////////////////////////////////////////////////////////////////////////////////
/// @brief prefix request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Achim Brandt
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_RESTHANDLER_REST_PREFIX_HANDLER_H
#define SIMPLEVOC_RESTHANDLER_REST_PREFIX_HANDLER_H 1

#include "RestHandler/RestDefaultHandler.h"

namespace triagens {
  namespace hpdf {
    class HpdfFilterTree;
  }

  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief prefix request handler
    ////////////////////////////////////////////////////////////////////////////////

    class RestPrefixHandler : public RestDefaultHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creator
        ////////////////////////////////////////////////////////////////////////////////

        static rest::HttpHandler* create(rest::HttpRequest* request, void* model) {
          return new RestPrefixHandler(request, model);
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        RestPrefixHandler(rest::HttpRequest* request, void* model)
          : RestDefaultHandler(request, model, STAT_REST_PREFIX),
            allowEmptyPrefix(false) {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        status_e execute();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief execute the get method
        ////////////////////////////////////////////////////////////////////////////////

        virtual status_e executeGet (hpdf::HpdfFilterTree*, hpdf::DynamicSort::DynamicSortDescription const&);

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief allow an ampty prefix
        ////////////////////////////////////////////////////////////////////////////////

        bool allowEmptyPrefix;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief prefix to use
        ////////////////////////////////////////////////////////////////////////////////

        string prefix;

      private:
        void computePrefix ();
    };
  }
}

#endif
