////////////////////////////////////////////////////////////////////////////////
/// @brief introspective search for debugging
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2011-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_RESTHANDLER_REST_ADMIN_SEARCH_HANDLER_H
#define SIMPLEVOC_RESTHANDLER_REST_ADMIN_SEARCH_HANDLER_H 1

#include "RestHandler/RestPrefixHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief prefix request handler
    ////////////////////////////////////////////////////////////////////////////////

    class RestAdminSearchHandler : public RestPrefixHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creator
        ////////////////////////////////////////////////////////////////////////////////

        static rest::HttpHandler* create(rest::HttpRequest* request, void* model) {
          return new RestAdminSearchHandler(request, model);
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        RestAdminSearchHandler(rest::HttpRequest* request, void* model)
          : RestPrefixHandler(request, model) {
          allowEmptyPrefix = true;
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// execute the get method
        ////////////////////////////////////////////////////////////////////////////////

        virtual status_e executeGet (hpdf::HpdfFilterTree*, hpdf::DynamicSort::DynamicSortDescription const&);
    };
  }
}

#endif
