////////////////////////////////////////////////////////////////////////////////
/// @brief prefix request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Achim Brandt
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "RestAdminSearchHandler.h"

#include <Basics/StringBuffer.h>
#include <Hpdf/HpdfFilterTree.h>

using namespace triagens::basics;
using namespace triagens::rest;
using namespace triagens::hpdf;

namespace triagens {
  namespace simple {

    // -----------------------------------------------------------------------------
    // RestPrefixHandler methods
    // -----------------------------------------------------------------------------

    HttpHandler::status_e RestAdminSearchHandler::executeGet (HpdfFilterTree* tree, DynamicSort::DynamicSortDescription const& sorting) {
      vector<Value> values;

      Value value;
      value.identifier = prefix;

      ResponseType result = model->prefixGetValue(value, tree, sorting, values);

      if (tree != 0) {
        delete tree;
      }

      if (result == OK) {
        bool useKeyFilter;
        string keyFilter = request->value("key", useKeyFilter);
        useKeyFilter &= ! keyFilter.empty();

        bool useValueFilter;
        string valueFilter = request->value("value", useValueFilter);
        useValueFilter &= ! valueFilter.empty();

        response = new rest::HttpResponse(rest::HttpResponse::OK);
        response->body().appendChar('[');

        string sep = "\"";

        for (vector<Value>::iterator i = values.begin();  i != values.end();  ++i) {
          Value& v = *i;

          if (useKeyFilter) {
            if (v.identifier.find(keyFilter) == string::npos) {
              continue;
            }
          }

          if (useValueFilter) {
            if (v.identifier.find(valueFilter) == string::npos) {
              continue;
            }
          }

          response->body().appendText(sep);
          response->body().appendText(StringUtils::escapeUnicode(v.identifier));
          response->body().appendText("\"");

          sep = ",\"";
        }

        response->body().appendChar(']');
        response->setContentType("application/json");
      }
      else {
        generateError("prefix not found");
      }

      return HANDLER_DONE;
    }
  }
}


