////////////////////////////////////////////////////////////////////////////////
/// @brief information about the extended key values
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2011-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_RESTHANDLER_REST_ADMIN_EXTENDED_KEY_VALUES_H
#define SIMPLEVOC_RESTHANDLER_REST_ADMIN_EXTENDED_KEY_VALUES_H 1

#include "RestHandler/RestDefaultHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief information about the extended key values
    ////////////////////////////////////////////////////////////////////////////////

    class RestAdminExtendedKeyValues : public RestDefaultHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creator
        ////////////////////////////////////////////////////////////////////////////////

        static rest::HttpHandler* create(rest::HttpRequest* request, void* model) {
          return new RestAdminExtendedKeyValues(request, model);
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        RestAdminExtendedKeyValues (rest::HttpRequest* request, void* model)
          : RestDefaultHandler(request, model, STAT_REST_STATS) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        status_e execute ();
    };
  }
}

#endif
