////////////////////////////////////////////////////////////////////////////////
/// @brief information about the extended key values
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2011-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "RestAdminExtendedKeyValues.h"

using namespace triagens::basics;
using namespace triagens::rest;
using namespace triagens::hpdf;

namespace triagens {
  namespace simple {

    // -----------------------------------------------------------------------------
    // Handler methods
    // -----------------------------------------------------------------------------

    HttpHandler::status_e RestAdminExtendedKeyValues::execute () {
      if (request->requestType() != HttpRequest::HTTP_REQUEST_GET) {
        generateError("expecting GET or PUT /configuration");
        return HANDLER_DONE;
      }

      VariantArray* result = new VariantArray();

      vector<hpdf::AttributeDescriptor> const& extendedKeyValues = model->getExtendedKeyValues();

      for (vector<hpdf::AttributeDescriptor>::const_iterator i = extendedKeyValues.begin();  i != extendedKeyValues.end();  ++i) {
        hpdf::AttributeDescriptor const& desc = *i;
        string key = desc.name;
        string type = "unknown";

        switch (desc.type) {
          case AT_STRING:
            type = "string";
            break;

          case AT_DATETIME:
            type = "datetime";
            break;

          case AT_DOUBLE:
            type = "double";
            break;

          case AT_INTEGER:
            type = "integer";
            break;

          case AT_BOOLEAN:
            type = "boolean";
            break;
        }

        result->add(key, type);
      }

      generateResult(result, false);
      return HANDLER_DONE;
    }
  }
}
