////////////////////////////////////////////////////////////////////////////////
/// @brief line response
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_LINE_RESPONSE_H
#define TRIAGENS_REST_LINE_RESPONSE_H 1

#include <Basics/Common.h>

#include <Basics/StringBuffer.h>

namespace triagens {
  namespace rest {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief line response
    ///
    /// A line request handler is called to handle a line request. It returns its
    /// answer as line response.
    ////////////////////////////////////////////////////////////////////////////////

    class  LineResponse : boost::noncopyable {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief line response codes
        ////////////////////////////////////////////////////////////////////////////////

        enum LineResponseCode {
          OK,
          ERROR_CODE
        };

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        LineResponse () {
          bodyValue.initialise();
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief deletes a line response
        ///
        /// The descrutor will free the string buffers used. After the line response
        /// is deleted, the string buffers returned by body() become invalid.
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~LineResponse () {
          bodyValue.free();
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the body
        ////////////////////////////////////////////////////////////////////////////////

        basics::StringBuffer& body() {
          return bodyValue;
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief generates the response
        ////////////////////////////////////////////////////////////////////////////////

        virtual void write (basics::StringBuffer*)  = 0;

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the body
        ////////////////////////////////////////////////////////////////////////////////

        basics::StringBuffer bodyValue;
    };
  }
}

#endif
