////////////////////////////////////////////////////////////////////////////////
/// @brief abstract line handler factory
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_LINE_HANDLER_FACTORY_H
#define TRIAGENS_REST_LINE_HANDLER_FACTORY_H 1

#include <Basics/Common.h>

////////////////////////////////////////////////////////////////////////////////
/// @defgroup LineServer Line-Server
////////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace rest {
    class LineRequest;
    class LineResponse;
    class LineHandler;

    ////////////////////////////////////////////////////////////////////////////////
    /// @ingroup LineServer
    /// @brief abstract line handler factory
    ////////////////////////////////////////////////////////////////////////////////

    class LineHandlerFactory : boost::noncopyable {
      public:
        typedef LineHandler GeneralHandler;
        typedef LineRequest GeneralRequest;
        typedef LineResponse GeneralResponse;

        typedef LineHandler* (*create_fptr) (LineRequest*, void*);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new handler factory
        ////////////////////////////////////////////////////////////////////////////////

        LineHandlerFactory () {
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructs a handler factory
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~LineHandlerFactory () {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns header and body size restrictions
        ////////////////////////////////////////////////////////////////////////////////

        virtual pair<size_t, size_t> sizeRestrictions ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creates a new request
        ////////////////////////////////////////////////////////////////////////////////

        virtual LineRequest* createRequest (char const* ptr, size_t length) const = 0;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creates a new handler
        ////////////////////////////////////////////////////////////////////////////////

        virtual LineHandler* createHandler (LineRequest*) const = 0;
    };
  }
}

#endif
