////////////////////////////////////////////////////////////////////////////////
/// @brief http server
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_HTTP_SERVER_H
#define TRIAGENS_REST_HTTP_SERVER_H 1

#include <Basics/Common.h>

namespace triagens {
  namespace rest {
    class Scheduler;
    class Dispatcher;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief http server
    ////////////////////////////////////////////////////////////////////////////////

    class HttpServer : boost::noncopyable {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new http server
        ////////////////////////////////////////////////////////////////////////////////

        static HttpServer* create (Scheduler* scheduler);


      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~HttpServer () {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief checks if to close connection if keep-alive is missing
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool getCloseWithoutKeepAlive () const = 0;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief close connection if keep-alive is missing
        ////////////////////////////////////////////////////////////////////////////////

        virtual void setCloseWithoutKeepAlive (bool value) = 0;
    };
  }
}

#endif

