////////////////////////////////////////////////////////////////////////////////
/// @brief any server
///
/// @file
/// This file contains a server template.
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_ANY_SERVER_H
#define TRIAGENS_REST_ANY_SERVER_H 1

#include <Basics/Common.h>

////////////////////////////////////////////////////////////////////////////////
/// @defgroup AnyServer Any-Server
////////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace rest {
    class ApplicationServer;
    class ApplicationHttpServer;
    class ApplicationHttpsServer;

    ////////////////////////////////////////////////////////////////////////////////
    /// @ingroup RestServer
    /// @brief rest server base
    ////////////////////////////////////////////////////////////////////////////////

    class AnyServer : boost::noncopyable {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        AnyServer ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~AnyServer ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief start the server
        ////////////////////////////////////////////////////////////////////////////////

        int start ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief builds the application server
        ////////////////////////////////////////////////////////////////////////////////

        virtual void buildApplicationServer () = 0;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief prepares the server for startup
        ////////////////////////////////////////////////////////////////////////////////

        virtual void prepareServer () {
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief start the server using the description
        ////////////////////////////////////////////////////////////////////////////////

        virtual int startupServer () = 0;

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief running in daemon mode
        ////////////////////////////////////////////////////////////////////////////////

        bool daemonMode;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief running in supervisor mode
        ////////////////////////////////////////////////////////////////////////////////

        bool supervisorMode;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief pid file
        ////////////////////////////////////////////////////////////////////////////////

        string pidFile;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief working directory
        ////////////////////////////////////////////////////////////////////////////////

        string workingDirectory;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief application server
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationServer* applicationServer;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief application http server
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationHttpServer* applicationHttpServer;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief application https server
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationHttpsServer* applicationHttpsServer;

      private:
        int startupSupervisor ();
        int startupDaemon ();
    };
  }
}

#endif
