////////////////////////////////////////////////////////////////////////////////
/// @brief postfix transformation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_POSTFIXHANDLER_TRANSFORMATION_H
#define SIMPLEVOC_POSTFIXHANDLER_TRANSFORMATION_H 1

#include <Basics/Common.h>

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief postfix transformation
    ////////////////////////////////////////////////////////////////////////////////

    class Transformation {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        explicit
        Transformation (string const& format);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        Transformation (Transformation const&);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~Transformation ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief assignment operator
        ////////////////////////////////////////////////////////////////////////////////

        Transformation& operator= (Transformation const&);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief evaluate value
        ////////////////////////////////////////////////////////////////////////////////

        string evaluate (map<string, string> const&) const;


      private:

        class Part {
          public:
            virtual ~Part () {
            }

            virtual string const& value (map<string, string> const&) const = 0;

            virtual Part* clone () const = 0;
        };


        class Constant : public Part {
          public:
            explicit
            Constant (string const& str)
              : str(str) {
            }

          public:
            string const& value (map<string, string> const&) const {
              return str;
            }

            Part* clone () const {
              return new Constant(str);
            }

          private:
            string const str;
        };



        class Entry : public Part {
          public:
            explicit
            Entry (string const& key)
              : key(key) {
            }

          public:
            string const& value (map<string, string> const& dictionary) const {
              static string empty = "";

              map<string, string>::const_iterator i = dictionary.find(key);

              if (i == dictionary.end()) {
                return empty;
              }
              else {
                return i->second;
              }
            }

            Part* clone () const {
              return new Entry(key);
            }

          private:
            string const key;
        };


      private:
        vector<Part*> parts;
    };

  }
}

#endif
