////////////////////////////////////////////////////////////////////////////////
/// @brief postfix response
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_POSTFIXHANDLER_POSTFIX_RESPONSE_H
#define SIMPLEVOC_POSTFIXHANDLER_POSTFIX_RESPONSE_H 1

#include <Rest/LineResponse.h>

#include <Basics/StringBuffer.h>

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief line response
    ///
    /// A line request handler is called to handle a line request. It returns its
    /// answer as line response.
    ////////////////////////////////////////////////////////////////////////////////

    class  PostfixResponse : public rest::LineResponse {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void write (basics::StringBuffer* output) {
          output->copy(bodyValue);
        }
    };
  }
}

#endif
