////////////////////////////////////////////////////////////////////////////////
/// @brief put request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_POSTFIXHANDLER_POSTFIX_PUT_HANDLER_H
#define SIMPLEVOC_POSTFIXHANDLER_POSTFIX_PUT_HANDLER_H 1

#include "PostfixHandler/PostfixBaseHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief put request handler
    ////////////////////////////////////////////////////////////////////////////////

    class PostfixPutHandler : public PostfixBaseHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        PostfixPutHandler (rest::LineRequest* request, SimpleModel* model)
          : PostfixBaseHandler(request, model, STAT_POSTFIX_PUT) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (PostfixRequest* request, PostfixResponse* response) {
          char const* putKey    = request->getKey();
          char const* putValue  = request->getValue();

          if (putKey == 0) {
            response->body().appendText("500 no key\n", 11);
            return;
          }

          Value value;

          value.identifier = putKey;
          value.data       = string(putValue);
          value.identifier = string(putKey);
          value.expireTime = 0.0;
          value.flags      = 0;

          ResponseType result = model->setValue(value);

          if (result == STORED) {
            response->body().appendText("200 stored\n", 11);
          }
          else {
            response->body().appendText("500 not_stored\n", 15);
          }
        }
    };
  }
}

#endif
