////////////////////////////////////////////////////////////////////////////////
/// @brief postfix line handler factory
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_POSTFIXHANDLER_POSTFIX_HANDLER_FACTORY_H
#define SIMPLEVOC_POSTFIXHANDLER_POSTFIX_HANDLER_FACTORY_H 1

#include <Basics/Common.h>

#include <Rest/LineHandlerFactory.h>

#include "PostfixHandler/Transformation.h"
#include "SimpleVoc/SimpleModel.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief postfix line handler factory
    ////////////////////////////////////////////////////////////////////////////////

    class PostfixHandlerFactory : public rest::LineHandlerFactory {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new handler factory
        ////////////////////////////////////////////////////////////////////////////////

        PostfixHandlerFactory (SimpleModel* model, vector<Transformation> const& transformations)
          : model(model), transformations(transformations) {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        rest::LineRequest* createRequest (char const* ptr, size_t length) const;

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        rest::LineHandler* createHandler (rest::LineRequest*) const;

      private:
        SimpleModel* model;
        vector<Transformation> transformations;
    };
  }
}

#endif
