////////////////////////////////////////////////////////////////////////////////
/// @brief version request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCVERSION_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCVERSION_HANDLER_H 1

#include "MCHandler/MCBodyLessHandler.h"

#include <Basics.h>

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief version request handler
    ////////////////////////////////////////////////////////////////////////////////

    class MCVersionHandler : public MCBodyLessHandler {

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCVersionHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBodyLessHandler(request, model, size_t(STAT_MC_VERSION)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest*, MCResponse* response) {
          response->body().appendText("SimpleVOC version ");
          response->body().appendText(basics::version());
          response->body().appendText("\r\n", 2);
        }
    };
  }
}

#endif
