////////////////////////////////////////////////////////////////////////////////
/// @brief statistics request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCSTAT_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCSTAT_HANDLER_H 1

#include "MCHandler/MCBodyLessHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief statistics request handler
    ////////////////////////////////////////////////////////////////////////////////

    class MCStatHandler : public MCBodyLessHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCStatHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBodyLessHandler(request, model, size_t(STAT_MC_STAT)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest*, MCResponse* response) {
          StatsValues stats;

          ResponseType result = model->statsValue(stats);

          if (result == OK) {
            response->body().appendText("server_up_time: "  + basics::StringUtils::formatDatetime(stats.serverStartup) + "\r\n");
            response->body().appendText("number_keys: "     + basics::StringUtils::itoa(stats.numKeyValue) + "\r\n");
            response->body().appendText("total_data_size: " + basics::StringUtils::itoa(stats.totalDataSize) + "\r\n");
            response->body().appendText("total_key_size: "  + basics::StringUtils::itoa(stats.totalKeySize) + "\r\n");
            response->body().appendText("END\r\n");
          }
          else {
            response->body().appendText("STAT not implemented\r\n");
            response->body().appendText("END\r\n");
          }
        }
    };
  }
}

#endif
