////////////////////////////////////////////////////////////////////////////////
/// @brief decrement request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCDECR_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCDECR_HANDLER_H 1

#include "MCHandler/MCBodyLessHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief decrement request handler
    ////////////////////////////////////////////////////////////////////////////////

    class MCDecrHandler : public MCBodyLessHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCDecrHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBodyLessHandler(request, model, size_t(STAT_MC_DECR)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest* request, MCResponse* response) {
          Value value;

          value.identifier = request->cmdStructure.keys[0].first;
          value.incrDecr   = request->cmdStructure.increment;

          ResponseType result = model->decrValue(value);

          if (request->cmdStructure.noreply) {
            return;
          }

          if (result == OK) {
            response->body().appendInteger(value.incrDecr);
            response->body().appendText("\r\n",2);
            return;
          }

          switch (result) {
            case NOT_FOUND:
              response->body().appendText("NOT_FOUND\r\n",11);
              break;
            case VALUE_LIMIT_EXCEEDED:
              response->body().appendText("VALUE_SIZE_LIMIT\r\n",18);
              break;
            case TOTAL_SIZE_EXCEEDED:
              response->body().appendText("TOTAL_SIZE_LIMIT\r\n",18);
              break;
            case TOTAL_VALUE_SIZE_EXCEEDED:
              response->body().appendText("TOTAL_VALUE_SIZE_LIMIT\r\n",24);
              break;
            default:
              response->body().appendText("NOT_STORED\r\n",12);
              break;
          }
        }
    };
  }
}

#endif
