////////////////////////////////////////////////////////////////////////////////
/// @brief append request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCAPPEND_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCAPPEND_HANDLER_H 1

#include "MCHandler/MCBaseHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief append request handler
    ////////////////////////////////////////////////////////////////////////////////

    class MCAppendHandler : public MCBaseHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCAppendHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBaseHandler(request, model, size_t(STAT_MC_APPEND)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest* request, MCResponse* response) {
          Value value;

          value.identifier = request->cmdStructure.keys[0].first;
          value.data = string(request->cmdStructure.body.c_str(), request->cmdStructure.bytes);

          ResponseType result = model->appendValue(value);

          if (request->cmdStructure.noreply) {
            return;
          }

          if (result == STORED) {
            response->body().appendText("STORED\r\n", 8);
            return;
          }

          switch (result) {
            case VALUE_LIMIT_EXCEEDED:
              response->body().appendText("VALUE_SIZE_LIMIT\r\n", 18);
              break;
            case TOTAL_SIZE_EXCEEDED:
              response->body().appendText("TOTAL_SIZE_LIMIT\r\n", 18);
              break;
            case TOTAL_VALUE_SIZE_EXCEEDED:
              response->body().appendText("TOTAL_VALUE_SIZE_LIMIT\r\n", 24);
              break;
            default:
              response->body().appendText("NOT_STORED\r\n", 12);
              break;
          }

        }
    };
  }
}

#endif
