////////////////////////////////////////////////////////////////////////////////
/// @brief http server implementation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef FYN_HTTPSERVER_HTTP_SERVER_IMPL_H
#define FYN_HTTPSERVER_HTTP_SERVER_IMPL_H 1

#include <Rest/HttpServer.h>

#include "GeneralServer/GeneralServer.h"
#include "HttpServer/HttpCommTask.h"

namespace triagens {
  namespace rest {
    class HttpHandlerFactory;
    class HttpListenTask;
    class HttpRequest;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief http server implementation
    ////////////////////////////////////////////////////////////////////////////////

    class HttpServerImpl : public GeneralServer<HttpServerImpl, HttpHandlerFactory, HttpCommTask>, virtual public HttpServer {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new http server
        ////////////////////////////////////////////////////////////////////////////////

        explicit
        HttpServerImpl (Scheduler* scheduler)
          : GeneralServer<HttpServerImpl, HttpHandlerFactory, HttpCommTask>(scheduler),
            closeWithoutKeepAlive(false) {
        }


      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool getCloseWithoutKeepAlive () const {
          return closeWithoutKeepAlive;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setCloseWithoutKeepAlive (bool value = true) {
          closeWithoutKeepAlive = value;
        }

      private:
        bool closeWithoutKeepAlive;
    };
  }
}

#endif
