////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_HPDF_HPDF_FILTER_TREE_H
#define TRIAGENS_HPDF_HPDF_FILTER_TREE_H 1

#include <Hpdf/Common.h>

namespace triagens {
  namespace hpdf {
    class AttributeDescriptor;
    class HpdfBinaryTreeNode;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief HpdfFilterTree
    ///
    /// The actual filter object which stores the tree structure.  Observe that
    /// the constructor initiates the process of parsing the string and that
    /// this object is created from the query structure (originally) output from
    /// a ".in" file.
    ////////////////////////////////////////////////////////////////////////////////

    class HpdfFilterTree : boost::noncopyable {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        HpdfFilterTree (string const& parseString, AttributeDescriptor* desc);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief Destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~HpdfFilterTree();

      // -----------------------------------------------------------------------------
      // required for speed
      // -----------------------------------------------------------------------------

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief valid filter
        ////////////////////////////////////////////////////////////////////////////////

        bool validFilterTree;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief root node
        ////////////////////////////////////////////////////////////////////////////////

        HpdfBinaryTreeNode* rootNode;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief evaluation node array
        ////////////////////////////////////////////////////////////////////////////////

        HpdfBinaryTreeNode*** evaluationNodeArray;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief node array height
        ////////////////////////////////////////////////////////////////////////////////

        int maxNodeArrayHeight;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief node array width
        ////////////////////////////////////////////////////////////////////////////////

        int maxNodeArrayWidth;

      private:
        string parseString;
    };
  }
}

#endif

