////////////////////////////////////////////////////////////////////////////////
/// @brief program options
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_BASICS_PROGRAM_OPTIONS_H
#define TRIAGENS_BASICS_PROGRAM_OPTIONS_H 1

#include <Basics/Common.h>

#include <Basics/ProgramOptionsDescription.h>

namespace triagens {
  namespace basics {
    struct ProgramOptionsData;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief program options
    ////////////////////////////////////////////////////////////////////////////////

    class ProgramOptions : boost::noncopyable {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        ProgramOptions ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~ProgramOptions ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief parse command line
        ////////////////////////////////////////////////////////////////////////////////

        bool parse (ProgramOptionsDescription const&, int argc, char** argv);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief parse configuration file
        ////////////////////////////////////////////////////////////////////////////////

        bool parse (ProgramOptionsDescription const&, string const& filename);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief checks if option was given
        ////////////////////////////////////////////////////////////////////////////////

        bool has (string const& name);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the string value
        ////////////////////////////////////////////////////////////////////////////////

        string stringValue (string const& name);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the last error
        ////////////////////////////////////////////////////////////////////////////////

        string lastError () {
          return errorMessage;
        }

      private:
        ProgramOptionsData* data;
        string errorMessage;
    };
  }
}

#endif
