////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_BASICS_CONFIGURATION_H
#define TRIAGENS_BASICS_CONFIGURATION_H 1

// -----------------------------------------------------------------------------
// APPLE
// -----------------------------------------------------------------------------

#ifdef __APPLE__

#include <stdint.h>

#define CONFIG_H                        "config.h"
#define ENABLE_SYSLOG                   1
#define HAVE_POSIX_THREADS              1
#undef  HAVE_WIN32_THREADS
#undef  INCLUDE_IO_H
#define INCLUDE_SIGNAL_H                1
#define INCLUDE_SYS_TIME_H              1
#define TC_OVERLOAD_FUNCS_SIZE_T        1

#if __WORDSIZE == 64
#define TC_SIZEOF_SIZE_T                8
#define TC_ALIGNOF_VOIDP                8
#else
#define TC_SIZEOF_SIZE_T                4
#define TC_ALIGNOF_VOIDP                4
#endif

#ifndef SIZE_MAX
#if __WORDSIZE == 64
#define SIZE_MAX                        (18446744073709551615UL)
#else
#define SIZE_MAX                        (4294967295U)
#endif
#endif

#endif

// -----------------------------------------------------------------------------
// cygwin
// -----------------------------------------------------------------------------

#ifdef __CYGWIN__

#include <bits/wordsize.h>

#define CONFIG_H                        "config.h"
#define ENABLE_SYSLOG                   1
#define HAVE_POSIX_THREADS              1
#undef  HAVE_WIN32_THREADS
#define INCLUDE_IO_H                    1
#undef  INCLUDE_SIGNAL_H
#undef  INCLUDE_SYS_TIME_H
#undef  TC_OVERLOAD_FUNCS_SIZE_T

#if __WORDSIZE == 64
#define TC_SIZEOF_SIZE_T                8
#define TC_ALIGNOF_VOIDP                8
#else
#define TC_SIZEOF_SIZE_T                4
#define TC_ALIGNOF_VOIDP                4
#endif

#endif

// -----------------------------------------------------------------------------
// LINUX
// -----------------------------------------------------------------------------

#ifdef __linux__

#include <features.h>

#define CONFIG_H                        "config.h"
#define ENABLE_SYSLOG                   1
#define HAVE_POSIX_THREADS              1
#undef  HAVE_WIN32_THREADS
#undef  INCLUDE_IO_H
#define INCLUDE_SIGNAL_H                1
#define INCLUDE_SYS_TIME_H              1
#undef  TC_OVERLOAD_FUNCS_SIZE_T

#if __WORDSIZE == 64
#define TC_SIZEOF_SIZE_T                8
#define TC_ALIGNOF_VOIDP                8
#else
#define TC_SIZEOF_SIZE_T                4
#define TC_ALIGNOF_VOIDP                4
#endif

#endif

// -----------------------------------------------------------------------------
// WINDOWS
// -----------------------------------------------------------------------------

#if defined(_WIN32) && defined(_MSC_VER)

#define CONFIG_H                        "config-win32.h"
#undef  ENABLE_SYSLOG
#undef  HAVE_POSIX_THREADS
#define HAVE_WIN32_THREADS              1
#define INCLUDE_IO_H                    1
#define INCLUDE_SIGNAL_H                1
#undef  INCLUDE_SYS_TIME_H
#undef  TC_OVERLOAD_FUNCS_SIZE_T

typedef int ssize_t;

#endif

// -----------------------------------------------------------------------------
// POSIX or WINDOWS I/O
// -----------------------------------------------------------------------------

#if defined(_WIN32) && defined(_MSC_VER)

#define O_RDONLY                        _O_RDONLY

#define TR_CLOSE                        _close
#define TR_OPEN                         _open
#define TR_READ                         _read

#else

#define TR_CLOSE                        close
#define TR_OPEN                         open
#define TR_READ                         read

#endif

// -----------------------------------------------------------------------------
// GNU C Compiler
// -----------------------------------------------------------------------------

#ifdef __GNUC__
#define HAVE_GCC_ATTRIBUTE              1
#define HAVE_GCC_BUILTIN                1
#else
#undef HAVE_GCC_ATTRIBUTE
#undef HAVE_GCC_BUILTIN
#endif

// -----------------------------------------------------------------------------
// SIZE_T OVERLOADING
// -----------------------------------------------------------------------------

#if defined(TC_OVERLOAD_FUNCS_SIZE_T)
#if TC_SIZEOF_SIZE_T == 8
#define sizetint_t                      uint64_t
#else
#define sizetint_t                      uint32_t
#endif
#endif

#endif
