////////////////////////////////////////////////////////////////////////////////
/// @brief application simple user and session management feature
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2011-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef BORNHOLM_ADMIN_APPLICATION_ADMIN_SERVER_H
#define BORNHOLM_ADMIN_APPLICATION_ADMIN_SERVER_H 1

#include <Rest/ApplicationFeature.h>

#include <Admin/Right.h>
#include <Rest/AddressPort.h>

namespace triagens {
  namespace rest {
    class ApplicationServer;
    class HttpHandlerFactory;
    class HttpResponse;
    class HttpRequest;
  }

  namespace admin {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief application simple user and session management feature
    ////////////////////////////////////////////////////////////////////////////////

    class ApplicationAdminServer : public rest::ApplicationFeature {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creates a new feature
        ////////////////////////////////////////////////////////////////////////////////

        static ApplicationAdminServer* create (rest::ApplicationServer*);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~ApplicationAdminServer ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief adds the http handlers
        ///
        /// Note that the server does not claim ownership of the factory.
        ////////////////////////////////////////////////////////////////////////////////

        void addHandlers (rest::HttpHandlerFactory*, string const& prefix);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief sets the right of an anonymous session
        ////////////////////////////////////////////////////////////////////////////////

        void setAnonymousRights (vector<right_t> const&);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief allow session and user management
        ////////////////////////////////////////////////////////////////////////////////

        void allowSessionManagement () {
          _allowSessionManagement = true;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief add a log viewer
        ////////////////////////////////////////////////////////////////////////////////

        void allowLogViewer () {
          _allowLogViewer = true;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief allow a webadmin directory
        ////////////////////////////////////////////////////////////////////////////////

        void allowAdminDirectory () {
          _allowAdminDirectory = true;
        }


      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief setups the options
        ////////////////////////////////////////////////////////////////////////////////

        void setupOptions (rest::ApplicationServer::section_e, basics::ProgramOptionsDescription&);

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationAdminServer ();

      private:
        static string optionAdminDirectory;

      private:
        bool _allowSessionManagement;
        bool _allowLogViewer;
        bool _allowAdminDirectory;

        string _adminDirectory;
        void* _pathOptions;
    };
  }
}

#endif
