////////////////////////////////////////////////////////////////////////////////
/// @brief application simple user and session management feature
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2011-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "ApplicationAdminServer.h"

#include <Admin/RestHandlerCreator.h>
#include <Admin/RestAdminLogHandler.h>
#include <Basics/ProgramOptionsDescription.h>
#include <Rest/HttpHandlerFactory.h>
#include <Rest/HttpResponse.h>

#include "HttpServer/PathHandler.h"

#include "SessionManager/Session.h"
#include "SessionManager/SessionHandler.h"


using namespace triagens::basics;
using namespace triagens::rest;

namespace triagens {
  namespace admin {

    // -----------------------------------------------------------------------------
    // static variables
    // -----------------------------------------------------------------------------

    string ApplicationAdminServer::optionAdminDirectory;

    // -----------------------------------------------------------------------------
    // constructors and destructors
    // -----------------------------------------------------------------------------

    ApplicationAdminServer* ApplicationAdminServer::create (ApplicationServer*) {
      return new ApplicationAdminServer();
    }



    ApplicationAdminServer::ApplicationAdminServer ()
      : _allowSessionManagement(false),
        _allowLogViewer(false),
        _allowAdminDirectory(false) {
      _pathOptions = new PathHandler::Options();
    }



    ApplicationAdminServer::~ApplicationAdminServer () {
      delete reinterpret_cast<PathHandler::Options*>(_pathOptions);
    }

    // -----------------------------------------------------------------------------
    // public methods
    // -----------------------------------------------------------------------------

    void ApplicationAdminServer::setupOptions (rest::ApplicationServer::section_e section, basics::ProgramOptionsDescription& description) {
      switch (section) {
        case ApplicationServer::OPTIONS_SERVER:
          if (_allowAdminDirectory) {
            description
              ("server.admin-directory", &optionAdminDirectory, "directory containing the ADMIN front-end")
            ;
          }

          break;

        default:
          break;
      }
    }



    void ApplicationAdminServer::addHandlers (HttpHandlerFactory* factory, string const& prefix) {

      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // add session management
      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if (_allowSessionManagement) {

        factory->addPrefixHandler(prefix + "/session-manager/session", SessionHandler::create, this);
      }

      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // add log viewer
      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if (_allowLogViewer) {
        factory->addHandler("/admin/log", RestHandlerCreator<RestAdminLogHandler>::createNoData, 0);
      }

      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // add a web-admin directory
      // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if (_allowAdminDirectory) {
        if (! optionAdminDirectory.empty()) {
          reinterpret_cast<PathHandler::Options*>(_pathOptions)->path = optionAdminDirectory;
          reinterpret_cast<PathHandler::Options*>(_pathOptions)->contentType = "text/plain";
          reinterpret_cast<PathHandler::Options*>(_pathOptions)->allowSymbolicLink = false;
          reinterpret_cast<PathHandler::Options*>(_pathOptions)->defaultFile = "index.html";

          factory->addPrefixHandler("/admin", RestHandlerCreator<PathHandler>::createData<PathHandler::Options*>, _pathOptions);
        }
      }
    }






    void ApplicationAdminServer::setAnonymousRights (vector<right_t> const& rights) {
      Session::setAnonymousRights(rights);
    }
  }
}
