/* sigh, a signal handling library
 * (C) 2004 Nick Welch
 *
 * Usage of the works is permitted provided that this
 * instrument is retained with the works, so that any entity
 * that uses the works is notified of this instrument.
 *
 * DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *
 * [2004, Fair License; rhid.com/fair]
 */

/* this test does not use sigh at all; it is intended to test the frequency at
 * which normal signals can be received.  it increments a counter each time
 * SIGINT is received, and sets up an alarm to send itself SIGALRM every 3
 * seconds, and when SIGALRM is received, it prints out stats for the last 3
 * seconds and resets the counter.
 *
 * on my 2.8ghz pentium 4, this test reports an average of about 740k signals
 * per 3-second period.
 */

#include <stdio.h>
#include <signal.h>

/* alarm, sleep */
#include <unistd.h>

/* gettimeofday */
#include <time.h>
#include <sys/time.h>

int count;

void increment(int sig) { ++count; }

void status(int sig)
{
    static struct timeval tv;
    gettimeofday(&tv, 0);

    /* due to the interruptions from asynchronous delivery of all of those
     * SIGINTs, this fprintf call will often be interrupted and you won't see
     * it */
    fprintf(stderr, "%d.%d - count: %d\n", tv.tv_sec, tv.tv_usec, count);
    count = 0;

    alarm(3);
}

int main(void)
{
    struct sigaction act;
    act.sa_flags = 0;
    sigemptyset(&act.sa_mask);

    act.sa_handler = increment;
    sigaction(SIGINT, &act, 0);

    act.sa_handler = status;
    sigaction(SIGALRM, &act, 0);

    alarm(3);
    /* main loop */
    for(;;)
    {
        /* this'll get interrupted WAY before one second, but just keep at it.
         * it's the most computationally-non-intensive thing we can do. */
        sleep(1);
    }
}

