/* sigh, a signal handling library
 * (C) 2004 Nick Welch
 *
 * Usage of the works is permitted provided that this
 * instrument is retained with the works, so that any entity
 * that uses the works is notified of this instrument.
 *
 * DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *
 * [2004, Fair License; rhid.com/fair]
 */

/* this test is essentially stress-standard.c "converted" to use sigh.  it
 * tests the frequency at which we can receive signals with sigh_poll().  every
 * three seconds, the SIGALRM pops up and we spit out stats for the last 3
 * seconds, and reset the counter.
 *
 * on my 2.8ghz pentium 4, this test reports an average of about 2.25m signals
 * per 3-second period -- about three times as many as the other test!  using
 * sigh_wait() cuts this about in half (about 1.4m/sec), due to its added
 * complexity (including at least one call to gettimeofday()) -- still about a
 * 50% increase over standard asynchronous signals!
 *
 * and of course, for most uses, none of this really matters.  good to know
 * though. :)
 */

#include <sigh/sigh.h>

#include <stdio.h>
#include <signal.h>

/* alarm */
#include <unistd.h>

/* gettimeofday */
#include <time.h>
#include <sys/time.h>

/* look ma, no global variables! */

int main(void)
{
    int sig;
    int count = 0;
    sigset_t sigs = sigh_make_sigset(SIGINT, SIGALRM, 0);

    sigh_watch(&sigs);

    alarm(3);
    /* main loop */
    for(;;)
    {
        /* sig = sigh_wait(&sigs, 1000); */

        sig = sigh_poll(&sigs);

        if(sig == SIGINT)
            ++count;
        else if(sig == SIGALRM)
        {
            static struct timeval tv;
            gettimeofday(&tv, 0);
            fprintf(stderr, "%d.%d - count: %d\n",
                    tv.tv_sec, tv.tv_usec, count);
            count = 0;
            alarm(3);
        }
    }
}

