/*
 * Copyright (c) 2002-2005 The TenDRA Project <http://www.tendra.org/>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of The TenDRA Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific, prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: non-local.h 1228 2007-05-31 23:40:52Z kate $
 */
/*
    		 Crown Copyright (c) 1997

    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-

        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;

        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;

        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;

        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/

/*
 * non-local.h - Non local name ADT.
 *
 * See the file "non-local.c" for more information.
 */

#ifndef H_NON_LOCAL
#define H_NON_LOCAL

#include "../os-interface.h"
#include "../eds/dalloc.h"
#include "entry.h"
#include "../eds/ostream.h"

typedef struct NonLocalEntryT {
    struct NonLocalEntryT      *next;
    EntryT *			name;
    EntryT *			type;
    EntryT *			initialiser;
} NonLocalEntryT;

typedef struct NonLocalListT {
    NonLocalEntryT *		head;
    NonLocalEntryT *	       *tail;
} NonLocalListT;

extern void		non_local_list_init(NonLocalListT *);
extern NonLocalEntryT *	non_local_list_add(NonLocalListT *, EntryT *, EntryT *);
extern BoolT		non_local_list_is_empty(NonLocalListT *);
extern void		non_local_list_iter_for_table(NonLocalListT *,
						      void(*)(EntryT *, void *),
						      void *);
extern void		non_local_list_destroy(NonLocalListT *);

extern void		write_non_locals(OStreamT *, NonLocalListT *);

extern void		non_local_entry_set_initialiser(NonLocalEntryT *, EntryT *);
extern EntryT *		non_local_entry_get_initialiser(NonLocalEntryT *);
extern EntryT *		non_local_entry_get_type(NonLocalEntryT *);
extern EntryT *		non_local_entry_get_name(NonLocalEntryT *);

#endif /* !defined (H_NON_LOCAL) */
