<?xml version='1.0' encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="common.xsl"/>
	<xsl:import href="sanitize.xsl"/>

	<xsl:param name="project_url"></xsl:param>
	<xsl:param name="project_name"></xsl:param>

	<!--
	Template name	When it is called
	user.header.navigation	Called before standard navigational header.
	header.navigation	The standard navigational header.
	user.header.content	Called after standard navigational header but before any other content.
	user.footer.content	Called after the chunk content but before the standard navigational footer.
	footer.navigation	The standard navigational footer.
	user.footer.navigation	Called after the standard navigational footer.
	-->

	<xsl:template name="user.header.navigation">
		<!--
		<xsl:call-template name="wpheader"/>
		-->
		<div id="header">
			<h1>
				<a id="logo" href="http://ideas.water-powered.com">
					<span>Water-Powered Ideas</span>
				</a>
			</h1>
		</div>

		<div id="crumbs">
			<p>
				<xsl:if test="$project_url != '' and $project_name != ''">
					<a href="{$project_url}">
						<xsl:value-of select="$project_name"/>
					</a> &gt;
				</xsl:if>
				<a>
					<xsl:attribute name="href">
						<xsl:call-template name="href.target">
							<xsl:with-param name="object" 
								select="/*[1]"/>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="/*[1]" 
						mode="object.title.markup"/>
				</a> 
				<xsl:if test=". != /*[1]">
					&gt; <xsl:apply-templates select="." 
						mode="object.title.markup"/>
				</xsl:if>
			</p>
		</div>
	</xsl:template>

	<xsl:template name="user.footer.navigation">
		<div id="footer">
			<p class="copyright">
				Copyright 2005-2007 <a href="http://ideas.water-powered.com">Water-Powered Ideas</a>
				<br/>
				All Rights Reserved. 
			</p>
		</div>
	</xsl:template>

</xsl:stylesheet>
