# $Id: docbook.mk 176 2007-06-02 06:55:38Z kate $
# This Makefile deals with articles written in docbook, and rendering
# those articles to varius formats (namely XHTML and PDF).

# XSLT
DOCBOOK_XSL = 	/usr/local/share/xsl/docbook
XSLT = 			xsltproc --xinclude
XHTMLSTYLE ?=	../doctools/xsl/docbook-chunked.xsl
XHTMLSTYLE_SINGLE ?=	../doctools/xsl/docbook-single.xsl

# PDF via dblatex (so much better than XSL-FO)
# Requires dblatex, http://dblatex.sf.net 
DBLATEX =		/usr/local/bin/dblatex
PDFSTYLE =		simple

XHTMLDIR = 		../xhtml
PDFDIR = 		../pdf
RESOURCES ?= 	../doctools/resources/*.css ../doctools/resources/*.png
CSSFILE ?= 		docs.css	
STYLEOPT=		--stringparam html.stylesheet $(CSSFILE) \
				--stringparam chunker.output.encoding UTF-8 \
				--stringparam chunk.section.depth 0 \
				--stringparam project_url $(PROJECT_URL) \
				--stringparam project_name $(PROJECT_NAME)

all: xhtml xhtml-single

xhtml: $(XHTMLDIR)/$(NAME)/index.html

xhtml-single: $(XHTMLDIR)/$(NAME)-single/index.html

pdf: $(PDFDIR)
	$(DBLATEX) -T $(PDFSTYLE) $(SOURCE) -o $(PDFDIR)/$(NAME).pdf

$(XHTMLDIR)/$(NAME)/index.html: $(SOURCE)
	$(XSLT) $(STYLEOPT) -o $(XHTMLDIR)/$(NAME)/ $(XHTMLSTYLE) $(SOURCE)
	cp -r $(RESOURCES) $(XHTMLDIR)/$(NAME)

$(XHTMLDIR)/$(NAME)-single/index.html: $(SOURCE)
	$(XSLT) $(STYLEOPT) -o $(XHTMLDIR)/$(NAME)-single/index.html $(XHTMLSTYLE_SINGLE) $(SOURCE)
	cp -r $(RESOURCES) $(XHTMLDIR)/$(NAME)-single

$(PDFDIR)/design.fo: $(PDFDIR)
	$(XSLT) -o $(PDFDIR)/$(NAME).fo $(FOSTYLE) $(SOURCE)

$(PDFDIR):
	mkdir -p $(PDFDIR)

$(XHTMLDIR)/$(NAME):
	mkdir -p $(XHTMLDIR)/$(NAME)

$(XHTMLDIR)/$(NAME)-single:
	mkdir -p $(XHTMLDIR)/$(NAME)-single

clean: 
	rm -rf $(XHTMLDIR)/$(NAME)
	rm -rf $(XHTMLDIR)/$(NAME)-single
	rm -rf $(PDFDIR) $(CLEAN_EXTRA)

force:

