<?xml version="1.0"?>

<!-- $Id: tendra-website.xsl 1140 2007-05-21 06:30:18Z kate $ -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version='1.0'>

	<xsl:import href="http://docbook.sourceforge.net/release/website/current/xsl/chunk-tabular.xsl"/>

	<!-- TODO there are still GIF images being generated all over the place! -->
	<xsl:param name="sequential.links">0</xsl:param>
	<xsl:param name="header.hr">0</xsl:param>
	<xsl:param name="footer.hr">0</xsl:param>
	<xsl:param name="footer.hr">0</xsl:param>
	<xsl:param name="feedback.href"></xsl:param>	<!-- TODO link to contact page? -->
	<xsl:param name="feedback.with.ids">0</xsl:param>
	<xsl:param name="feedback.link.text"></xsl:param>
	<xsl:param name="navtocwidth"></xsl:param>
	<xsl:param name="navbodywidth"></xsl:param>
	<xsl:param name="textbgcolor"></xsl:param>
	<xsl:param name="navbgcolor"></xsl:param>
	<xsl:param name="toc.spacer.graphic">0</xsl:param>
	<xsl:param name="toc.pointer.graphic">0</xsl:param>
	<xsl:param name="toc.blank.graphic">0</xsl:param>
	<xsl:param name="table.spacer.image"></xsl:param>
	<xsl:param name="currentpage.marker">0</xsl:param>
	<xsl:param name="banner.before.navigation">1</xsl:param>
	<xsl:param name="nav.graphics">0</xsl:param>
	<xsl:param name="nav.pointer">0</xsl:param>
	<xsl:param name="nav.revisionflag">0</xsl:param>
	<xsl:param name="nav.text.spacer"></xsl:param>
	<xsl:param name="nav.text.current.open"></xsl:param>
	<xsl:param name="nav.text.current.page"></xsl:param>
	<xsl:param name="nav.text.other.page"></xsl:param>
	<xsl:param name="nav.text.other.open"></xsl:param>
	<xsl:param name="nav.text.other.closed"></xsl:param>
	<xsl:param name="toc.expand.depth">2</xsl:param>

	<xsl:template name="body.attributes"/>

	<xsl:template name="allpages.banner">
		<h1 id="banner">
			<xsl:text>The </xsl:text>
			<span class="logo">
				<xsl:text>Ten</xsl:text>
				<span class="smallcaps">
					<xsl:text>DRA</xsl:text>
				</span>
			</span>
			<xsl:text> Project</xsl:text>
		</h1>
	</xsl:template>

	<xsl:template match="title" mode="head.mode">
		<title>
			<xsl:text>TenDRA - </xsl:text>
			<xsl:value-of select="."/>
		</title>
	</xsl:template>

	<xsl:template name="insert.spacers"/>

	<!-- This only differs in omiting the <img/> tags, which are not optional! -->
	<xsl:template match="toc">
		<xsl:param name="pageid" select="@id"/>

		<xsl:variable name="relpath">
			<xsl:call-template name="toc-rel-path">
				<xsl:with-param name="pageid" select="$pageid"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:apply-templates select="tocentry">
			<xsl:with-param name="pageid" select="$pageid"/>
			<xsl:with-param name="relpath" select="$relpath"/>
		</xsl:apply-templates>
	</xsl:template>

	<!-- $rcsdate is in Subversion's $Date$ format, e.g. "$Date: 2007-05-19 17:34:01 +0100 (Sat, 19 May 2007) $" -->
	<xsl:template name="rcsdate.format">
		<xsl:param name="rcsdate" select="./config[@param='rcsdate']/@value"/>
		<xsl:value-of select="substring-before(substring-after($rcsdate, '('), ')')"/>
	</xsl:template>

	<xsl:template match="head/title" mode="title.mode"/>
	<xsl:template name="home.navhead.cell"/>
	<xsl:template name="home.navhead.upperright.cell"/>
	<xsl:template name="home.navhead.separator"/>
</xsl:stylesheet>

