---
title: "How to contribute"
keywords: spherical harmonics software package, spherical harmonic transform, legendre functions, multitaper spectral analysis, fortran, Python, gravity, magnetic field
sidebar: mydoc_sidebar
permalink: how-to-contribute.html
summary: SHTOOLS is an open source project whose success depends upon contributions from people like you. Even if you can not contribute code, you can report issues at GitHub and help us improve the documentation.
toc: true
folder: mydoc
---

## I would like to contribute to the code base

The easiest way to contribute to developing SHTOOLS is by GitHub.

* Start by forking the [SHTOOLS](https://github.com/SHTOOLS/SHTOOLS) repo into your GitHub account.
* Clone this repo on your local computer.
* Commit changes to your personal repo. We work on the `develop` branch, so please base your commits on the most recent commit on this branch.
* When you think that your changes are ready to be incorporated into the main repo, make a pull request, describing what you changed and why. 
* The administrators will verify your work and may ask for changes. After they are happy with your contribution, they will merge your pull request into the main repo.

If you are not comfortable with using `git`, please just contact us by email. We will be happy to help.

## I would like to report a bug, or suggest a change

* If you find a bug, please open an [issue](https://github.com/SHTOOLS/SHTOOLS/issues) on GitHub.
* If you would like to suggest a change, or suggest a new feature that should be implemented in SHTOOLS, please open an [issue](https://github.com/SHTOOLS/SHTOOLS/issues) at the same place. Before doing so, please look at the SHTOOLS [milestones](https://github.com/SHTOOLS/SHTOOLS/milestones) to see if this is already on the development roadmap.

## I would like to fix some typos in the documentation

* The easiest way to improve the documentation is by clicking on the "Edit me" button at the bottom of the page you are reading. This will bring you to the original source file on GitHub where you can make the change by clicking on the "edit this file" button. Just follow the instructions and don't worry, it is impossible to mess anything up.
