---
title: PlmIndex (Fortran)
keywords: spherical harmonics software package, spherical harmonic transform, legendre functions, multitaper spectral analysis, fortran, Python, gravity, magnetic field
sidebar: fortran_sidebar
permalink: plmindex.html
summary:
tags: [fortran]
toc: false
editdoc: fdoc
---

Compute the index of an array corresponding to degree `l` and angular order `m`.

## Usage

`index` = PlmIndex (`l`, `m`)

## Parameters

`index` : function output, integer
:   Index of an array of associated Legendre functions corresponding to degree `l` and angular order `m`.

`l` : input, integer
:   The spherical harmonic degree.

`m` : input, integer
:   The angular order.

## Description

`PlmIndex` will calculate the index of an array of associated Legendre functions corresponding to degree `l` and angular order `m`. The input arrays are generated by routines such as `PlmBar`, `PlmBar_d1`, `PlmSchmidt`, `PlmSchmidt_d1`, `PlmON`, `PlmON_d1`, `PLegendreA`, and `PLegendreA_d1`. The array index is equal to `l*(l+1)/2+m+1`.

## See also

[plmbar](plmbar.html), [plmbar_d1](plmbar_d1.html), [plmschmidt](plmschmidt.html), [plmschmidt_d1](plmschmidt_d1.html), [plmon](plmon.html), [plmon_d1](plmon_d1.html), [`plegendrea`](plegendrea.html), [plegendrea_d1](plegendrea_d1.html)
