---
title: "Global spectral analysis"
keywords: spherical harmonics software package, spherical harmonic transform, legendre functions, multitaper spectral analysis, fortran, Python, gravity, magnetic field
sidebar: fortran_sidebar
permalink: global-spectral-analysis.html
summary: 
toc: true
folder: fortran
---

<style>
table:nth-of-type(n) {
    display:table;
    width:100%;
}
table:nth-of-type(n) th:nth-of-type(2) {
    width:65%;
}
</style>

## Real spectral analysis

| Routine name | Description |
| ------------ | ----------- |
| [SHPowerL](SHPowerL) | Compute the power of a real function for a single spherical harmonic degree. |
| [SHPowerDensityL](shpowerdensityl.html) | Compute the power spectral density of a function for a single spherical harmonic degree. |
| [SHCrossPowerL](shcrosspowerl.html) | Compute the cross-power of two functions for a single spherical harmonic degree. |
| [SHCrossPowerDensityL](shcrosspowerdensityl.html) | Compute the cross-power spectral density of two functions for a single spherical harmonic degree. |
| [SHPowerSpectrum](shpowerspectrum.html) | Compute the power spectrum of a function. |
| [SHPowerSpectrumDensity](shpowerspectrumdensity.html) | Compute the power spectral density of a function. |
| [SHCrossPowerSpectrum](shcrosspowerspectrum.html) | Compute the cross-power spectrum of two functions. |
| [SHCrossPowerSpectrumDensity](shcrosspowerspectrumdensity.html) | Compute the cross-power spectral density of two functions. |
| [SHAdmitCorr](shadmitcorr.html) | Calculate the admittance and correlation spectra of two functions. |
| [SHConfidence](shconfidence.html) | Compute the probability that two sets of spherical harmonic coefficients are correlated at a given degree and for a given correlation coefficient. |

## Complex spectral analysis

| Routine name | Description |
| ------------ | ----------- |
| [SHPowerLC](shpowerlc.html) | Compute the power of a complex function for a single spherical harmonic degree. |
| [SHPowerDensityLC](shpowerdensitylc.html) | Compute the power spectral density of a complex function for a single spherical harmonic degree. |
| [SHCrossPowerLC](shcrosspowerlc.html) | Compute the cross-power of two complex functions for a single spherical harmonic degree. |
| [SHCrossPowerDensityLC](shcrosspowerdensitylc.html) | Compute the cross-power spectral density of two complex functions for a single spherical harmonic degree. |
| [SHPowerSpectrumC](shpowerspectrumc.html) | Compute the power spectrum of a complex function. |
| [SHPowerSpectrumDensityC](shpowerspectrumdensityc.html) | Compute the power spectral density of a complex function. |
| [SHCrossPowerSpectrumC](shcrosspowerspectrumc.html) | Compute the cross-power spectrum of two complex functions. |
| [SHCrossPowerSpectrumDensityC](shcrosspowerspectrumdensityc.html) | Compute the cross-power spectral density of two complex functions. |

