---
title: SHBiasAdmitCorr (Fortran)
keywords: spherical harmonics software package, spherical harmonic transform, legendre functions, multitaper spectral analysis, fortran, Python, gravity, magnetic field
sidebar: fortran_sidebar
permalink: shbiasadmitcorr.html
summary:
tags: [fortran]
toc: false
editdoc: fdoc
---

Calculate the expected multitaper admittance and correlation spectra associated with the input global cross-power spectra of two functions.

## Usage

call SHAdmitCorr (`sgt`, `sgg`, `stt`, `lmax`, `tapers`, `lwin`, `k`, `admit`, `corr`, `mtdef`, `taper_wt`, `exitstatus`)

## Parameters

`sgt` : input, real(dp), dimension (`lmax`+1)
:   The global cross-power spectrum of the functions `G` and `T`.

`sgg` : input, real(dp), dimension (`lmax`+1)
:   The global power spectrum of the function `G`.

`stt` : input, real(dp), dimension (`lmax`+1)
:   The global power spectrum of the function `T`.

`lmax` : input, integer(int32)
:   The maximum spherical harmonic degree to use of the input spectra `sgt`, `sgg`, `stt`.

`tapers` : input, real(dp), dimension (`lwin`+1, `k`)
:   The spherical harmonic coefficients of the spherical cap localizing windows. Each column corresponds to the non-zero coefficients of a single angular order. Since all that is important is the power spectrum of each window, the exact angular order is not important. These are generated by a call to `SHReturnTapers` or `SHReturnTapersM`.

`lwin` : input, integer(int32)
:   The spherical harmonic bandwidth of the localizing windows.

`k` : input, integer(int32)
:   The number of localizing windows to use. Only the first `k` columns of `tapers` will be employed, which corresponds to the `k` best-concentrated localizing windows.

`admit` : output, real(dp), dimension (`lmax`-`lwin`+1) 
:   The biased admittance spectrum obtained using the localized (cross-)power spectra of Sgt and Stt.

`corr` : output, real(dp), dimension (`lmax`-`lwin`+1) 
:   The biased correlation spectrum obtained using the localized (cross-)power spectra of Sgt, Stt, and Sgg.

`mtdef` : optional, input, integer(int32), default = 1
:   1 (default): Calculate the multitaper spectral estimates Sgt, Sgg and Stt first, and then use these to calculate the admittance and correlation functions. 2: Calculate admittance and correlation spectra using each individual taper, and then average these to obtain the multitaper admittance and correlation functions.

`taper_wt` : input, optional, real(dp), dimension (`k`)
:   The weights to apply to each individual windowed spectral estimate. The weights must sum to unity and are obtained from `SHMTVarOpt`.

`exitstatus` : output, optional, integer(int32)
:   If present, instead of executing a STOP when an error is encountered, the variable exitstatus will be returned describing the error. 0 = No errors; 1 = Improper dimensions of input array; 2 = Improper bounds for input variable; 3 = Error allocating memory; 4 = File IO error.

## Description

Given the global cross-power spectra `Sgt`, `Sgg` and `Stt` of two functions `G` and `T`, `SHBiasAdmitCorr` will calculate the expected multitaper admittance and correlation spectra associated with the two global functions. This routine expects as input a matrix containing the spherical harmonic coefficients of the localizing windows, which can be generated by a call to `SHReturnTapers` or `SHReturnTapersM`. Only the `k` best-concentrated localization windows will be employed when calculating the biased cross-power spectra. The maximum calculated degree of the output biased admittance and correlation spectra corresponds to `lmax-lwin`, as it is assumed that the input cross-power spectra beyond `lmax` are unknown, and not zero.

Two manners of calculating the localized admittance and correlation spectra are possible according to the value of the optional parameter `mtdef`. In case 1, the multitaper cross-power spectra of Sgt, Sgg, and Stt are first calculated, and from these, the admittance and correlation spectra are formed. In case 2, the biased admittance and correlation spectra are calculated for each individual taper, and these are then averaged to obtain the biased multitaper admittance and correlation spectra.

The default is to apply equal weights to each individual windowed estimate of the spectrum, but this can be modified when `mtdef` is 1 by specifying the weights in the optional argument `taper_wt`. The weights must sum to unity and can be calculated by `SHMTVarOpt`.

## References

Wieczorek, M. A. and F. J. Simons, Minimum-variance multitaper spectral estimation on the sphere, J. Fourier Anal. Appl., 13, doi:10.1007/s00041-006-6904-1, 665-692, 2007.

Simons, F. J., F. A. Dahlen and M. A. Wieczorek, Spatiospectral concentration on the sphere, SIAM Review, 48, 504-536, doi:10.1137/S0036144504445765, 2006. 

Wieczorek, M. A. and F. J. Simons, Localized spectral analysis on the sphere, 
Geophys. J. Int., 162, 655-675.

## See also

[shbias](shbias.html), [shbiask](shbiask.html), [shreturntapers](shreturntapers.html), [shreturntapersm](shreturntapersm.html), [shmtvaropt](shmtvaropt.html)
