# PlanetsConstants

SHTOOLS Module containing planetary constants.

# Description

`PlanetsConstants` defines several constants that are used in analyzing gravity,
topography, and magnetic field data of the terrestrial planets. All units are SI. Confer with the Python attributes of the constant for exact values and references.

# Constants

## Fundamental Constants

`Grav_constant`
:   Gravitational Constant.

`Pi_constant`
:   Pi.

`Mu0_constant`
:   Magnetic constant.

## Mercury

`R_Mercury`
:   Average radius of Mercury.

`GM_Mercury`
:   Gravitational constant times the mass of the Mercury.

`Mass_Mercury`
:   Mass of Mercury.

`Omega_Orbit_Mercury`
:   Angular rotation rate of Mercury about the Sun.

`Omega_Mercury`
:   Angular rotation rate of Mercury.

`Density_Mercury`
:   Average density of Mercury.

`G0_Mercury`
:   Gravitational acceleration at R_Mercury, not including rotation.

## Venus

`R_Venus`
:   Average radius of Venus.

`GM_Venus`
:   Gravitational constant times the mass of the Venus.

`Mass_Venus`
:   Mass of Venus.

`Omega_Venus`
:   Angular rotation rate of Venus.

`Density_Venus`
:   Average density of Venus.

`G0_Venus`
:   Gravitational acceleration at R_Venus, not including rotation.

## Earth

`GM_EGM2008`
:   Gravitational constant times the mass of the Earth from the EGM2008 model.

`Mass_EGM2008`
:   The mass of the Earth from the EGM2008 model.

`A_WGS84`
:   The semi-major axis of the WGS84 ellipsoid.

`B_WGS84`
:   The semi-minor axis of the WGS84 ellipsoid.

`R3_WGS84`
:   The radius of a sphere of Earth's volume.

`F_WGS84`
:   The flattening of the WGS84 ellipsoid.

`GM_WGS84`
:   The adopted GM of the WGS84 model, which includes the atmosphere.

`Mass_WGS84`
:   The mass of the Earth from the WGS84 model.

`GMA_WGS84`
:   The GM of the atmosphere adopted by the WGS84 model.

`Omega_WGS84`
:   The adopted angular rotation rate of the Earth of the WGS84 model.

`U0_WGS84`
:   The theoretical normal potential associated with the WGS84 model.

## The Moon

`R_Moon`
:   Mean radius of the Moon.

`GM_Moon`
:   Gravitational constant times the mass of the Moon.

`Mass_Moon`
:   Mass of the Moon.

`Density_Moon`
:   Average density of the Moon.

`A_Orbit_Moon`
:   Semi-major axis of the lunar orbit.

`Omega_Moon`
:   Angular rotation rate of the Moon.

`I_Solid_Moon`
:   Average moment of inertia of the solid portion of the Moon.

`Gamma_Moon`
:   Libration parameter of the Moon, (B-A)/C.

`Beta_Moon`
:   Libration parameter of the Moon, (C-A)/B.

`G0_Moon`
:   Mean gravitational acceleration of the Moon at the mean surface radius (R_Moon), not including rotation.

## Mars

`R_Mars`
:   Average radius of Mars.

`GM_Mars`
:   Gravitational constant times the mass of the Mars.

`Mass_Mars`
:   Mass of Mars.

`Density_Mars`
:   Average density of Mars.

`Omega_Mars`
:   Angular rotation rate of Mars.

`F_Mars`
:   Topographic flattening of Mars.

`A_Mars`
:   Semi-major axis radius of Mars.

`B_Mars`
:   Semi-minor axis radius of Mars.

`U0_mars`
:   Reference potential of Mars.

`G0_Mars`
:   Gravitational acceleration of Mars at R_Mars, not including rotation.

