import numpy as _np


@_np.vectorize
def PlmIndex(l, m):
    """
    Compute the index of a array of Legendre functions corresponding to degree
    l and angular order m.

    Usage
    -----
    index = PlmIndex (l, m)

    Returns
    -------
    index : integer, ndarray
        Index of an array of associated Legendre functions corresponding to
        degree l and angular order m.

    Parameters
    ----------
    l : integer, array_like
        The spherical harmonic degree.
    m : integer, array_like
        The angular order.

    Notes
    -----
    PlmIndex will calculate the index of an array of associated Legendre
    functions corresponding to degree l and angular order m. The input arrays
    are generated by routines such as PlmBar, PlmBar_d1, PlmSchmidt,
    PlmSchmidt_d1, PlmON, PlmON_d1, PLegendreA, and PLegendreA_d1. The array
    index in Python is equal to l * (l + 1) / 2 + m.
"""

    return (l * (l + 1)) // 2 + m
