// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2021, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2021, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 * \brief Provides seqan3::type_list and associated metaprogramming utilities.
 */

#include <seqan3/utility/type_list/traits.hpp>
#include <seqan3/utility/type_list/type_list.hpp>

/*!\defgroup type_list Type List
 * \brief Provides seqan3::type_list and metaprogramming utilities for working on type lists.
 * \ingroup utility
 *
 * \details
 *
 * All traits on type lists are defined in the header `<seqan3/utility/type_list/traits.hpp>`.
 *
 */

/*!\namespace seqan3::list_traits
 * \brief Namespace containing traits for working on seqan3::type_list.
 * \ingroup type_list
 */
