// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2021, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2021, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \brief Meta-header for the \link container container submodule \endlink.
 * \author Hannes Hauswedell <hannes.hauswedell AT fu-berlin.de>
 *
 * \defgroup container Container
 * \brief The container submodule contains special SeqAn containers and generic container concepts.
 * \ingroup range
 * \sa https://en.cppreference.com/w/cpp/container
 * \sa range/container/all.hpp
 */

#pragma once

#include <seqan3/alphabet/container/bitpacked_sequence.hpp>
#include <seqan3/alphabet/container/concatenated_sequences.hpp>
#include <seqan3/utility/container/aligned_allocator.hpp>
#include <seqan3/utility/container/concept.hpp>
#include <seqan3/utility/container/small_string.hpp>
#include <seqan3/utility/container/small_vector.hpp>
