---
name: Release Checklist
about: A checklist used internally for the release process.
title: "#.#.# Release"
labels: ''
assignees: ''

---

- [ ] Create a release branch, e.g. `release-[VERSION]`, and enable branch protection in the reposity settings.
- [ ] Create at least one pre-Release s.t. our package maintainers can try out a new release of our library (they will need a complete source-package to do this).
- [ ] Check that the [directory structure](https://github.com/seqan/seqan3/blob/master/doc/setup/quickstart_cmake/index.md) is valid.
- [ ] Check for critical performance regressions (via [this tool](https://github.com/wvandertoorn/cmp_benchmarks)).
- [ ] Check [Nightlies](https://cdash.seqan.de/index.php?project=SeqAn3) for critical build failures. Change nightlies to build on release branch.
- [ ] Check workarounds in `platform.hpp`. Are they still valid or can they be limited to specific compiler versions.
- [ ] Check the [Changelog.md](https://github.com/seqan/seqan3/blob/master/CHANGELOG.md) for completeness (including changed headers).
- [ ] Update the index from cppreference.com so that up-to-date documentation links are generated.
  <details><summary>Click for detailed steps</summary><br>

  Check for [new releases](https://github.com/PeterFeicht/cppreference-doc/releases) and update the link and hash
  in the [code base](https://github.com/seqan/seqan3/blob/77c5e8a1381ed39ae96a6966c008f56dd15152cb/test/documentation/seqan3-doxygen.cmake#L54).

  For the hash do

  ```
  wget -O- <link to html book> | sha256sum
  ```

  </details>
- [ ] Add versioned documentation build on docs.seqan.de.
  <details><summary>Click for detailed steps</summary>

  1. Build the documentation locally or use the artefact generated by the CI

  2. Create a #.#.# directory for the release in `/web/docs.seqan.de/htdocs/seqan/`

  3. Copy everything from the build (`doc_usr/html/*`) into the directory.

  4. Alter the file `/web/docs.seqan.de/htdocs/seqan3.html` with a link to the new documentation build.

  </details>
- [ ] Prepare `seqan3-[VERSION]-{Linux,Source}.tar.xz{,.sha265}`.
  <details><summary>Click for detailed steps</summary><br>

  Make a fresh clone of the repository.
  ```
  mkdir package-build

  git clone https://github.com/seqan/seqan3.git
  cd seqan3

  git checkout release-[VERSION] # version to pack

  git submodule init
  git submodule update

  cd ../package-build

  cmake ../seqan3 # configure

  cpack # builds binary package, e.g. seqan3-[VERSION]-Linux.tar.xz{,.sha265}

  cmake --build . --target package_source # builds source package, e.g. seqan3-[VERSION]-Source.tar.xz{,.sha265}
  ```

  Note: Do not do `git clone --recurse-submodules https://github.com/seqan/seqan3.git` because it will recursively
  pull sub-submodules which we do not want!

  </details>
- [ ] Prepare a release note with notable features, API changes, bugs, and external dependency updates.

---

- [ ] **Tag release on Github and attach `seqan3-[VERSION]-{Linux,Source}.tar.xz{,.sha265}` to the release.**

  <details><summary>Click for detailed steps</summary><br>

  Github is not able to create annotated releases (https://github.com/seqan/product_backlog/issues/159), so we have to manually sign the release.
  Make sure you have set up [signed commits](https://docs.github.com/en/github/authenticating-to-github/signing-commits).
  ```bash
  git checkout release-[VERSION]
  git tag -s [VERSION]
  git push upstream [VERSION]
  ```

  You will need to provide a tag message. We use the first sentences of the release note:

  E.g. (see https://github.com/seqan/seqan3/tags)
  ```
  SeqAn 3.0.2 Release


  Despite all circumstances, we are excited to present a new update of our SeqAn library.
  We present some great new features and also a lot of usability improvements.
  Among others, this release will fully comply with the final C++-20 standard.

  :warning: In this release we harmonised the algorithm configurations for a better user experience.
  This, much like 2020, will break a lot of code. But rest assured that the changes are easy to apply and are worth every bit. :smile:

  You can find a comprehensive list of the changes in our [changelog](https://docs.seqan.de/seqan/3.0.2/about_changelog.html).
  ```

  </details>

---

- [ ] Merge release branch into master.
- [ ] Bump succeeding version number in master. ([include/seqan3/version.hpp](https://github.com/seqan/seqan3/blob/77c5e8a1381ed39ae96a6966c008f56dd15152cb/include/seqan3/version.hpp#L18-L23))
- [ ] Bump latest stable version number of the API-Stability test in master. ([test/api_stability/CMakeLists.txt](https://github.com/seqan/seqan3/blob/77c5e8a1381ed39ae96a6966c008f56dd15152cb/test/api_stability/CMakeLists.txt#L10))
- [ ] Update the SeqAn version [here](https://github.com/OpenMS/usage_plots/blob/master/seqan_versions.txt) to ensure
      that the server in Tübingen, which takes care of the argument parser update notifications, is aware of it
      (@smehringer).
- [ ] Delete release branch (remove branch protection in repository settings first).
- [ ] Change [Nightlies](https://cdash.seqan.de/index.php?project=SeqAn3) back to master branch.
- [ ] Announce release on [twitter](https://twitter.com/seqanlib).
- [ ] Announce release on [website](https://www.seqan.de).
- [ ] Announce release on mailing list `seqan-dev@lists.fu-berlin.de`.
- [ ] Announce release on [public Gitter channel](https://gitter.im/seqan/Lobby).
- [ ] Notify upstream package maintainers
  - [ ] [brew](https://github.com/brewsci/homebrew-bio/tree/develop/Formula/seqan%403.rb) (@rrahn)
  - [ ] [macports](https://github.com/macports/macports-ports/tree/master/science/seqan3/Portfile) (@rrahn)
  - [ ] [bio.tools](https://bio.tools/seqan) (@rrahn)
  - [ ] [conda](https://github.com/bioconda/bioconda-recipes/tree/master/recipes/seqan3) (@eseiler)
  - [ ] [debian](https://tracker.debian.org/pkg/seqan3) (@mr-c)
  - [ ] fedora (@sagitter)
- [ ] Update release template with the current release tasks.
- [ ] Celebrate :tada: :beer:
