/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.Collection;
import slothLib.linearAlgebra.featureVector.BasicVector;
import slothLib.linearAlgebra.featureVector.IDocumentFrequencyVector;
import slothLib.linearAlgebra.featureVector.IVector;

public class DocumentFrequencyVector<T>
extends BasicVector<T>
implements IDocumentFrequencyVector<T> {
    private int _vectorCount;

    @Override
    public int vectorCount() {
        return this._vectorCount;
    }

    public DocumentFrequencyVector(Collection<IVector<T>> vectors) {
        int i = 0;
        for (IVector<T> vector : vectors) {
            this.calculate(vector);
            ++i;
        }
        this._vectorCount = i;
    }

    public DocumentFrequencyVector(IVector<T> ... vectors) {
        int i = 0;
        IVector<T>[] iVectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            IVector<T> vector = iVectorArray[n2];
            this.calculate(vector);
            ++i;
            ++n2;
        }
        this._vectorCount = i;
    }

    private void calculate(IVector<T> v) {
        for (T key : v.keys()) {
            if (v.get(key) == 0.0) continue;
            if (this.containsKey(key)) {
                this.set(key, this.get(key) + 1.0);
                continue;
            }
            this.set(key, 1.0);
        }
    }
}

