#include <assert.h>

#include <aterm2.h>
#include <deprecated.h>
#include "SDFME.h"

/**
 * Converts a string to an ATermList of integers (ASCII values). 
 * \param[in] str An ASCII string
 * \return An ATermList containing the ASCII values of #arg as ATermInts
 */
ATerm SDF_stringToChars(const char *str) {
  int len = strlen(str);
  int i;
  ATermList result = ATempty;

  for (i = len - 1; i >= 0; i--) {
    result = ATinsert(result, (ATerm) ATmakeInt(str[i]));
  }

  return (ATerm) result;
}

/**
 * Converts an ASCII char to an ATermInt. 
 * \param[in] ch an ASCII character
 * \return An ATerm representing the ASCII value of #arg
 */
ATerm SDF_byteToChar(char ch) {
    return (ATerm) ATmakeInt(ch);
}

/**
 * Converts a list of integers (ASCII values) to a C string. 
 * \param[in] arg An ATermList with ATermInts, such as [32,32,10]
 * \return String containing the characters from #arg as characters
 */
char *SDF_charsToString(ATerm arg) {
  ATermList list = (ATermList) arg;
  int len = ATgetLength(list);
  int i;
  char *str;

  str = (char *) malloc(len+1);
  if (str == NULL) {
      return NULL;
  }

  for (i = 0; !ATisEmpty(list); list = ATgetNext(list), i++) {
    str[i] = (char) ATgetInt((ATermInt) ATgetFirst(list));
  }
  str[i] = '\0';

  return str;
}

char SDF_charToByte(ATerm arg) {
    return (char) ATgetInt((ATermInt) arg);
}


typedef struct ATerm _SDF_OptLayout;
typedef struct ATerm _SDF_Layout;
typedef struct ATerm _SDF_LexLayoutList;
typedef struct ATerm _SDF_AFun;
typedef struct ATerm _SDF_ATerm;
typedef struct ATerm _SDF_Annotation;
typedef struct ATerm _SDF_Start;
typedef struct ATerm _SDF_ATermArgs;
typedef struct ATerm _SDF_ATermElems;
typedef struct ATerm _SDF_ATermAnnos;
typedef struct ATerm _SDF_IntCon;
typedef struct ATerm _SDF_OptExp;
typedef struct ATerm _SDF_RealCon;
typedef struct ATerm _SDF_Grammar;
typedef struct ATerm _SDF_Alias;
typedef struct ATerm _SDF_Aliases;
typedef struct ATerm _SDF_AliasList;
typedef struct ATerm _SDF_Symbol;
typedef struct ATerm _SDF_CharRange;
typedef struct ATerm _SDF_CharRanges;
typedef struct ATerm _SDF_OptCharRanges;
typedef struct ATerm _SDF_CharClass;
typedef struct ATerm _SDF_LexNumChar;
typedef struct ATerm _SDF_NumChar;
typedef struct ATerm _SDF_LexShortChar;
typedef struct ATerm _SDF_ShortChar;
typedef struct ATerm _SDF_Character;
typedef struct ATerm _SDF_ATermAttribute;
typedef struct ATerm _SDF_Attribute;
typedef struct ATerm _SDF_Attributes;
typedef struct ATerm _SDF_Production;
typedef struct ATerm _SDF_Productions;
typedef struct ATerm _SDF_AttributeList;
typedef struct ATerm _SDF_ProductionList;
typedef struct ATerm _SDF_Label;
typedef struct ATerm _SDF_LexSingleQuotedStrChar;
typedef struct ATerm _SDF_SingleQuotedStrChar;
typedef struct ATerm _SDF_LexSingleQuotedStrCon;
typedef struct ATerm _SDF_SingleQuotedStrCon;
typedef struct ATerm _SDF_FunctionName;
typedef struct ATerm _SDF_LexSingleQuotedStrCharChars;
typedef struct ATerm _SDF_SymbolArguments;
typedef struct ATerm _SDF_LexModuleWord;
typedef struct ATerm _SDF_ModuleWord;
typedef struct ATerm _SDF_LexModuleId;
typedef struct ATerm _SDF_ModuleId;
typedef struct ATerm _SDF_Definition;
typedef struct ATerm _SDF_Module;
typedef struct ATerm _SDF_Section;
typedef struct ATerm _SDF_Sections;
typedef struct ATerm _SDF_ModuleName;
typedef struct ATerm _SDF_ImpSection;
typedef struct ATerm _SDF_Imports;
typedef struct ATerm _SDF_Import;
typedef struct ATerm _SDF_ModuleList;
typedef struct ATerm _SDF_ImpSectionList;
typedef struct ATerm _SDF_SectionList;
typedef struct ATerm _SDF_ImportList;
typedef struct ATerm _SDF_Associativity;
typedef struct ATerm _SDF_ArgumentIndicator;
typedef struct ATerm _SDF_Group;
typedef struct ATerm _SDF_Priority;
typedef struct ATerm _SDF_Priorities;
typedef struct ATerm _SDF_NatConArguments;
typedef struct ATerm _SDF_GroupList;
typedef struct ATerm _SDF_PriorityList;
typedef struct ATerm _SDF_SymbolTail;
typedef struct ATerm _SDF_SymbolRest;
typedef struct ATerm _SDF_Renamings;
typedef struct ATerm _SDF_Renaming;
typedef struct ATerm _SDF_RenamingList;
typedef struct ATerm _SDF_Lookahead;
typedef struct ATerm _SDF_Lookaheads;
typedef struct ATerm _SDF_Restriction;
typedef struct ATerm _SDF_Restrictions;
typedef struct ATerm _SDF_LookaheadList;
typedef struct ATerm _SDF_RestrictionList;
typedef struct ATerm _SDF_Sort;
typedef struct ATerm _SDF_SDF;
typedef struct ATerm _SDF_LexSort;
typedef struct ATerm _SDF_SymbolParameters;
typedef struct ATerm _SDF_Symbols;
typedef struct ATerm _SDF_SymbolList;
typedef struct ATerm _SDF_LexLayout;
typedef struct ATerm _SDF_LexStrChar;
typedef struct ATerm _SDF_StrChar;
typedef struct ATerm _SDF_LexStrCon;
typedef struct ATerm _SDF_StrCon;
typedef struct ATerm _SDF_LexStrCharChars;
typedef struct ATerm _SDF_LexNatCon;
typedef struct ATerm _SDF_NatCon;
typedef struct ATerm _SDF_LexIdCon;
typedef struct ATerm _SDF_IdCon;

/**
 * Initializes the full API. Forgetting to call this function before using the API will lead to strange behaviour. ATinit() needs to be called before this function.
 */
void SDF_initSDFMEApi(void) {
  init_SDFME_dict();
}

/**
 * Protect a SDF_OptLayout from the ATerm garbage collector. Every SDF_OptLayout that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_OptLayout
 */
void SDF_protectOptLayout(SDF_OptLayout *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_OptLayout from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_OptLayout
 */
void SDF_unprotectOptLayout(SDF_OptLayout *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Layout from the ATerm garbage collector. Every SDF_Layout that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Layout
 */
void SDF_protectLayout(SDF_Layout *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Layout from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Layout
 */
void SDF_unprotectLayout(SDF_Layout *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexLayoutList from the ATerm garbage collector. Every SDF_LexLayoutList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexLayoutList
 */
void SDF_protectLexLayoutList(SDF_LexLayoutList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexLayoutList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexLayoutList
 */
void SDF_unprotectLexLayoutList(SDF_LexLayoutList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_AFun from the ATerm garbage collector. Every SDF_AFun that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_AFun
 */
void SDF_protectAFun(SDF_AFun *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_AFun from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_AFun
 */
void SDF_unprotectAFun(SDF_AFun *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ATerm from the ATerm garbage collector. Every SDF_ATerm that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ATerm
 */
void SDF_protectATerm(SDF_ATerm *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ATerm from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ATerm
 */
void SDF_unprotectATerm(SDF_ATerm *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Annotation from the ATerm garbage collector. Every SDF_Annotation that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Annotation
 */
void SDF_protectAnnotation(SDF_Annotation *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Annotation from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Annotation
 */
void SDF_unprotectAnnotation(SDF_Annotation *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Start from the ATerm garbage collector. Every SDF_Start that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Start
 */
void SDF_protectStart(SDF_Start *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Start from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Start
 */
void SDF_unprotectStart(SDF_Start *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ATermArgs from the ATerm garbage collector. Every SDF_ATermArgs that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ATermArgs
 */
void SDF_protectATermArgs(SDF_ATermArgs *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ATermArgs from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ATermArgs
 */
void SDF_unprotectATermArgs(SDF_ATermArgs *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ATermElems from the ATerm garbage collector. Every SDF_ATermElems that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ATermElems
 */
void SDF_protectATermElems(SDF_ATermElems *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ATermElems from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ATermElems
 */
void SDF_unprotectATermElems(SDF_ATermElems *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ATermAnnos from the ATerm garbage collector. Every SDF_ATermAnnos that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ATermAnnos
 */
void SDF_protectATermAnnos(SDF_ATermAnnos *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ATermAnnos from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ATermAnnos
 */
void SDF_unprotectATermAnnos(SDF_ATermAnnos *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_IntCon from the ATerm garbage collector. Every SDF_IntCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_IntCon
 */
void SDF_protectIntCon(SDF_IntCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_IntCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_IntCon
 */
void SDF_unprotectIntCon(SDF_IntCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_OptExp from the ATerm garbage collector. Every SDF_OptExp that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_OptExp
 */
void SDF_protectOptExp(SDF_OptExp *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_OptExp from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_OptExp
 */
void SDF_unprotectOptExp(SDF_OptExp *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_RealCon from the ATerm garbage collector. Every SDF_RealCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_RealCon
 */
void SDF_protectRealCon(SDF_RealCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_RealCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_RealCon
 */
void SDF_unprotectRealCon(SDF_RealCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Grammar from the ATerm garbage collector. Every SDF_Grammar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Grammar
 */
void SDF_protectGrammar(SDF_Grammar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Grammar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Grammar
 */
void SDF_unprotectGrammar(SDF_Grammar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Alias from the ATerm garbage collector. Every SDF_Alias that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Alias
 */
void SDF_protectAlias(SDF_Alias *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Alias from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Alias
 */
void SDF_unprotectAlias(SDF_Alias *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Aliases from the ATerm garbage collector. Every SDF_Aliases that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Aliases
 */
void SDF_protectAliases(SDF_Aliases *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Aliases from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Aliases
 */
void SDF_unprotectAliases(SDF_Aliases *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_AliasList from the ATerm garbage collector. Every SDF_AliasList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_AliasList
 */
void SDF_protectAliasList(SDF_AliasList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_AliasList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_AliasList
 */
void SDF_unprotectAliasList(SDF_AliasList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Symbol from the ATerm garbage collector. Every SDF_Symbol that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Symbol
 */
void SDF_protectSymbol(SDF_Symbol *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Symbol from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Symbol
 */
void SDF_unprotectSymbol(SDF_Symbol *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_CharRange from the ATerm garbage collector. Every SDF_CharRange that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_CharRange
 */
void SDF_protectCharRange(SDF_CharRange *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_CharRange from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_CharRange
 */
void SDF_unprotectCharRange(SDF_CharRange *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_CharRanges from the ATerm garbage collector. Every SDF_CharRanges that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_CharRanges
 */
void SDF_protectCharRanges(SDF_CharRanges *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_CharRanges from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_CharRanges
 */
void SDF_unprotectCharRanges(SDF_CharRanges *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_OptCharRanges from the ATerm garbage collector. Every SDF_OptCharRanges that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_OptCharRanges
 */
void SDF_protectOptCharRanges(SDF_OptCharRanges *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_OptCharRanges from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_OptCharRanges
 */
void SDF_unprotectOptCharRanges(SDF_OptCharRanges *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_CharClass from the ATerm garbage collector. Every SDF_CharClass that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_CharClass
 */
void SDF_protectCharClass(SDF_CharClass *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_CharClass from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_CharClass
 */
void SDF_unprotectCharClass(SDF_CharClass *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexNumChar from the ATerm garbage collector. Every SDF_LexNumChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexNumChar
 */
void SDF_protectLexNumChar(SDF_LexNumChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexNumChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexNumChar
 */
void SDF_unprotectLexNumChar(SDF_LexNumChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_NumChar from the ATerm garbage collector. Every SDF_NumChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_NumChar
 */
void SDF_protectNumChar(SDF_NumChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_NumChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_NumChar
 */
void SDF_unprotectNumChar(SDF_NumChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexShortChar from the ATerm garbage collector. Every SDF_LexShortChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexShortChar
 */
void SDF_protectLexShortChar(SDF_LexShortChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexShortChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexShortChar
 */
void SDF_unprotectLexShortChar(SDF_LexShortChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ShortChar from the ATerm garbage collector. Every SDF_ShortChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ShortChar
 */
void SDF_protectShortChar(SDF_ShortChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ShortChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ShortChar
 */
void SDF_unprotectShortChar(SDF_ShortChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Character from the ATerm garbage collector. Every SDF_Character that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Character
 */
void SDF_protectCharacter(SDF_Character *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Character from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Character
 */
void SDF_unprotectCharacter(SDF_Character *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ATermAttribute from the ATerm garbage collector. Every SDF_ATermAttribute that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ATermAttribute
 */
void SDF_protectATermAttribute(SDF_ATermAttribute *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ATermAttribute from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ATermAttribute
 */
void SDF_unprotectATermAttribute(SDF_ATermAttribute *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Attribute from the ATerm garbage collector. Every SDF_Attribute that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Attribute
 */
void SDF_protectAttribute(SDF_Attribute *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Attribute from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Attribute
 */
void SDF_unprotectAttribute(SDF_Attribute *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Attributes from the ATerm garbage collector. Every SDF_Attributes that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Attributes
 */
void SDF_protectAttributes(SDF_Attributes *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Attributes from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Attributes
 */
void SDF_unprotectAttributes(SDF_Attributes *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Production from the ATerm garbage collector. Every SDF_Production that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Production
 */
void SDF_protectProduction(SDF_Production *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Production from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Production
 */
void SDF_unprotectProduction(SDF_Production *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Productions from the ATerm garbage collector. Every SDF_Productions that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Productions
 */
void SDF_protectProductions(SDF_Productions *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Productions from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Productions
 */
void SDF_unprotectProductions(SDF_Productions *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_AttributeList from the ATerm garbage collector. Every SDF_AttributeList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_AttributeList
 */
void SDF_protectAttributeList(SDF_AttributeList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_AttributeList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_AttributeList
 */
void SDF_unprotectAttributeList(SDF_AttributeList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ProductionList from the ATerm garbage collector. Every SDF_ProductionList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ProductionList
 */
void SDF_protectProductionList(SDF_ProductionList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ProductionList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ProductionList
 */
void SDF_unprotectProductionList(SDF_ProductionList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Label from the ATerm garbage collector. Every SDF_Label that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Label
 */
void SDF_protectLabel(SDF_Label *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Label from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Label
 */
void SDF_unprotectLabel(SDF_Label *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexSingleQuotedStrChar from the ATerm garbage collector. Every SDF_LexSingleQuotedStrChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrChar
 */
void SDF_protectLexSingleQuotedStrChar(SDF_LexSingleQuotedStrChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexSingleQuotedStrChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrChar
 */
void SDF_unprotectLexSingleQuotedStrChar(SDF_LexSingleQuotedStrChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SingleQuotedStrChar from the ATerm garbage collector. Every SDF_SingleQuotedStrChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SingleQuotedStrChar
 */
void SDF_protectSingleQuotedStrChar(SDF_SingleQuotedStrChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SingleQuotedStrChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SingleQuotedStrChar
 */
void SDF_unprotectSingleQuotedStrChar(SDF_SingleQuotedStrChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexSingleQuotedStrCon from the ATerm garbage collector. Every SDF_LexSingleQuotedStrCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrCon
 */
void SDF_protectLexSingleQuotedStrCon(SDF_LexSingleQuotedStrCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexSingleQuotedStrCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrCon
 */
void SDF_unprotectLexSingleQuotedStrCon(SDF_LexSingleQuotedStrCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SingleQuotedStrCon from the ATerm garbage collector. Every SDF_SingleQuotedStrCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SingleQuotedStrCon
 */
void SDF_protectSingleQuotedStrCon(SDF_SingleQuotedStrCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SingleQuotedStrCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SingleQuotedStrCon
 */
void SDF_unprotectSingleQuotedStrCon(SDF_SingleQuotedStrCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_FunctionName from the ATerm garbage collector. Every SDF_FunctionName that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_FunctionName
 */
void SDF_protectFunctionName(SDF_FunctionName *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_FunctionName from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_FunctionName
 */
void SDF_unprotectFunctionName(SDF_FunctionName *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexSingleQuotedStrCharChars from the ATerm garbage collector. Every SDF_LexSingleQuotedStrCharChars that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrCharChars
 */
void SDF_protectLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexSingleQuotedStrCharChars from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexSingleQuotedStrCharChars
 */
void SDF_unprotectLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SymbolArguments from the ATerm garbage collector. Every SDF_SymbolArguments that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SymbolArguments
 */
void SDF_protectSymbolArguments(SDF_SymbolArguments *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SymbolArguments from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SymbolArguments
 */
void SDF_unprotectSymbolArguments(SDF_SymbolArguments *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexModuleWord from the ATerm garbage collector. Every SDF_LexModuleWord that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexModuleWord
 */
void SDF_protectLexModuleWord(SDF_LexModuleWord *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexModuleWord from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexModuleWord
 */
void SDF_unprotectLexModuleWord(SDF_LexModuleWord *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ModuleWord from the ATerm garbage collector. Every SDF_ModuleWord that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ModuleWord
 */
void SDF_protectModuleWord(SDF_ModuleWord *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ModuleWord from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ModuleWord
 */
void SDF_unprotectModuleWord(SDF_ModuleWord *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexModuleId from the ATerm garbage collector. Every SDF_LexModuleId that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexModuleId
 */
void SDF_protectLexModuleId(SDF_LexModuleId *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexModuleId from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexModuleId
 */
void SDF_unprotectLexModuleId(SDF_LexModuleId *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ModuleId from the ATerm garbage collector. Every SDF_ModuleId that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ModuleId
 */
void SDF_protectModuleId(SDF_ModuleId *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ModuleId from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ModuleId
 */
void SDF_unprotectModuleId(SDF_ModuleId *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Definition from the ATerm garbage collector. Every SDF_Definition that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Definition
 */
void SDF_protectDefinition(SDF_Definition *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Definition from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Definition
 */
void SDF_unprotectDefinition(SDF_Definition *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Module from the ATerm garbage collector. Every SDF_Module that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Module
 */
void SDF_protectModule(SDF_Module *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Module from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Module
 */
void SDF_unprotectModule(SDF_Module *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Section from the ATerm garbage collector. Every SDF_Section that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Section
 */
void SDF_protectSection(SDF_Section *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Section from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Section
 */
void SDF_unprotectSection(SDF_Section *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Sections from the ATerm garbage collector. Every SDF_Sections that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Sections
 */
void SDF_protectSections(SDF_Sections *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Sections from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Sections
 */
void SDF_unprotectSections(SDF_Sections *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ModuleName from the ATerm garbage collector. Every SDF_ModuleName that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ModuleName
 */
void SDF_protectModuleName(SDF_ModuleName *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ModuleName from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ModuleName
 */
void SDF_unprotectModuleName(SDF_ModuleName *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ImpSection from the ATerm garbage collector. Every SDF_ImpSection that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ImpSection
 */
void SDF_protectImpSection(SDF_ImpSection *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ImpSection from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ImpSection
 */
void SDF_unprotectImpSection(SDF_ImpSection *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Imports from the ATerm garbage collector. Every SDF_Imports that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Imports
 */
void SDF_protectImports(SDF_Imports *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Imports from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Imports
 */
void SDF_unprotectImports(SDF_Imports *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Import from the ATerm garbage collector. Every SDF_Import that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Import
 */
void SDF_protectImport(SDF_Import *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Import from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Import
 */
void SDF_unprotectImport(SDF_Import *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ModuleList from the ATerm garbage collector. Every SDF_ModuleList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ModuleList
 */
void SDF_protectModuleList(SDF_ModuleList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ModuleList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ModuleList
 */
void SDF_unprotectModuleList(SDF_ModuleList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ImpSectionList from the ATerm garbage collector. Every SDF_ImpSectionList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ImpSectionList
 */
void SDF_protectImpSectionList(SDF_ImpSectionList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ImpSectionList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ImpSectionList
 */
void SDF_unprotectImpSectionList(SDF_ImpSectionList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SectionList from the ATerm garbage collector. Every SDF_SectionList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SectionList
 */
void SDF_protectSectionList(SDF_SectionList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SectionList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SectionList
 */
void SDF_unprotectSectionList(SDF_SectionList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ImportList from the ATerm garbage collector. Every SDF_ImportList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ImportList
 */
void SDF_protectImportList(SDF_ImportList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ImportList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ImportList
 */
void SDF_unprotectImportList(SDF_ImportList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Associativity from the ATerm garbage collector. Every SDF_Associativity that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Associativity
 */
void SDF_protectAssociativity(SDF_Associativity *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Associativity from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Associativity
 */
void SDF_unprotectAssociativity(SDF_Associativity *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_ArgumentIndicator from the ATerm garbage collector. Every SDF_ArgumentIndicator that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_ArgumentIndicator
 */
void SDF_protectArgumentIndicator(SDF_ArgumentIndicator *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_ArgumentIndicator from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_ArgumentIndicator
 */
void SDF_unprotectArgumentIndicator(SDF_ArgumentIndicator *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Group from the ATerm garbage collector. Every SDF_Group that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Group
 */
void SDF_protectGroup(SDF_Group *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Group from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Group
 */
void SDF_unprotectGroup(SDF_Group *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Priority from the ATerm garbage collector. Every SDF_Priority that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Priority
 */
void SDF_protectPriority(SDF_Priority *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Priority from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Priority
 */
void SDF_unprotectPriority(SDF_Priority *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Priorities from the ATerm garbage collector. Every SDF_Priorities that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Priorities
 */
void SDF_protectPriorities(SDF_Priorities *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Priorities from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Priorities
 */
void SDF_unprotectPriorities(SDF_Priorities *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_NatConArguments from the ATerm garbage collector. Every SDF_NatConArguments that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_NatConArguments
 */
void SDF_protectNatConArguments(SDF_NatConArguments *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_NatConArguments from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_NatConArguments
 */
void SDF_unprotectNatConArguments(SDF_NatConArguments *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_GroupList from the ATerm garbage collector. Every SDF_GroupList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_GroupList
 */
void SDF_protectGroupList(SDF_GroupList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_GroupList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_GroupList
 */
void SDF_unprotectGroupList(SDF_GroupList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_PriorityList from the ATerm garbage collector. Every SDF_PriorityList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_PriorityList
 */
void SDF_protectPriorityList(SDF_PriorityList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_PriorityList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_PriorityList
 */
void SDF_unprotectPriorityList(SDF_PriorityList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SymbolTail from the ATerm garbage collector. Every SDF_SymbolTail that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SymbolTail
 */
void SDF_protectSymbolTail(SDF_SymbolTail *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SymbolTail from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SymbolTail
 */
void SDF_unprotectSymbolTail(SDF_SymbolTail *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SymbolRest from the ATerm garbage collector. Every SDF_SymbolRest that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SymbolRest
 */
void SDF_protectSymbolRest(SDF_SymbolRest *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SymbolRest from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SymbolRest
 */
void SDF_unprotectSymbolRest(SDF_SymbolRest *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Renamings from the ATerm garbage collector. Every SDF_Renamings that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Renamings
 */
void SDF_protectRenamings(SDF_Renamings *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Renamings from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Renamings
 */
void SDF_unprotectRenamings(SDF_Renamings *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Renaming from the ATerm garbage collector. Every SDF_Renaming that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Renaming
 */
void SDF_protectRenaming(SDF_Renaming *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Renaming from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Renaming
 */
void SDF_unprotectRenaming(SDF_Renaming *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_RenamingList from the ATerm garbage collector. Every SDF_RenamingList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_RenamingList
 */
void SDF_protectRenamingList(SDF_RenamingList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_RenamingList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_RenamingList
 */
void SDF_unprotectRenamingList(SDF_RenamingList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Lookahead from the ATerm garbage collector. Every SDF_Lookahead that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Lookahead
 */
void SDF_protectLookahead(SDF_Lookahead *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Lookahead from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Lookahead
 */
void SDF_unprotectLookahead(SDF_Lookahead *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Lookaheads from the ATerm garbage collector. Every SDF_Lookaheads that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Lookaheads
 */
void SDF_protectLookaheads(SDF_Lookaheads *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Lookaheads from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Lookaheads
 */
void SDF_unprotectLookaheads(SDF_Lookaheads *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Restriction from the ATerm garbage collector. Every SDF_Restriction that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Restriction
 */
void SDF_protectRestriction(SDF_Restriction *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Restriction from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Restriction
 */
void SDF_unprotectRestriction(SDF_Restriction *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Restrictions from the ATerm garbage collector. Every SDF_Restrictions that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Restrictions
 */
void SDF_protectRestrictions(SDF_Restrictions *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Restrictions from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Restrictions
 */
void SDF_unprotectRestrictions(SDF_Restrictions *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LookaheadList from the ATerm garbage collector. Every SDF_LookaheadList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LookaheadList
 */
void SDF_protectLookaheadList(SDF_LookaheadList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LookaheadList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LookaheadList
 */
void SDF_unprotectLookaheadList(SDF_LookaheadList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_RestrictionList from the ATerm garbage collector. Every SDF_RestrictionList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_RestrictionList
 */
void SDF_protectRestrictionList(SDF_RestrictionList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_RestrictionList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_RestrictionList
 */
void SDF_unprotectRestrictionList(SDF_RestrictionList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Sort from the ATerm garbage collector. Every SDF_Sort that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Sort
 */
void SDF_protectSort(SDF_Sort *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Sort from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Sort
 */
void SDF_unprotectSort(SDF_Sort *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SDF from the ATerm garbage collector. Every SDF_SDF that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SDF
 */
void SDF_protectSDF(SDF_SDF *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SDF from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SDF
 */
void SDF_unprotectSDF(SDF_SDF *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexSort from the ATerm garbage collector. Every SDF_LexSort that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexSort
 */
void SDF_protectLexSort(SDF_LexSort *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexSort from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexSort
 */
void SDF_unprotectLexSort(SDF_LexSort *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SymbolParameters from the ATerm garbage collector. Every SDF_SymbolParameters that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SymbolParameters
 */
void SDF_protectSymbolParameters(SDF_SymbolParameters *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SymbolParameters from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SymbolParameters
 */
void SDF_unprotectSymbolParameters(SDF_SymbolParameters *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_Symbols from the ATerm garbage collector. Every SDF_Symbols that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_Symbols
 */
void SDF_protectSymbols(SDF_Symbols *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_Symbols from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_Symbols
 */
void SDF_unprotectSymbols(SDF_Symbols *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_SymbolList from the ATerm garbage collector. Every SDF_SymbolList that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_SymbolList
 */
void SDF_protectSymbolList(SDF_SymbolList *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_SymbolList from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_SymbolList
 */
void SDF_unprotectSymbolList(SDF_SymbolList *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexLayout from the ATerm garbage collector. Every SDF_LexLayout that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexLayout
 */
void SDF_protectLexLayout(SDF_LexLayout *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexLayout from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexLayout
 */
void SDF_unprotectLexLayout(SDF_LexLayout *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexStrChar from the ATerm garbage collector. Every SDF_LexStrChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexStrChar
 */
void SDF_protectLexStrChar(SDF_LexStrChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexStrChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexStrChar
 */
void SDF_unprotectLexStrChar(SDF_LexStrChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_StrChar from the ATerm garbage collector. Every SDF_StrChar that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_StrChar
 */
void SDF_protectStrChar(SDF_StrChar *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_StrChar from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_StrChar
 */
void SDF_unprotectStrChar(SDF_StrChar *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexStrCon from the ATerm garbage collector. Every SDF_LexStrCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexStrCon
 */
void SDF_protectLexStrCon(SDF_LexStrCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexStrCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexStrCon
 */
void SDF_unprotectLexStrCon(SDF_LexStrCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_StrCon from the ATerm garbage collector. Every SDF_StrCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_StrCon
 */
void SDF_protectStrCon(SDF_StrCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_StrCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_StrCon
 */
void SDF_unprotectStrCon(SDF_StrCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexStrCharChars from the ATerm garbage collector. Every SDF_LexStrCharChars that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexStrCharChars
 */
void SDF_protectLexStrCharChars(SDF_LexStrCharChars *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexStrCharChars from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexStrCharChars
 */
void SDF_unprotectLexStrCharChars(SDF_LexStrCharChars *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexNatCon from the ATerm garbage collector. Every SDF_LexNatCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexNatCon
 */
void SDF_protectLexNatCon(SDF_LexNatCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexNatCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexNatCon
 */
void SDF_unprotectLexNatCon(SDF_LexNatCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_NatCon from the ATerm garbage collector. Every SDF_NatCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_NatCon
 */
void SDF_protectNatCon(SDF_NatCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_NatCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_NatCon
 */
void SDF_unprotectNatCon(SDF_NatCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_LexIdCon from the ATerm garbage collector. Every SDF_LexIdCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_LexIdCon
 */
void SDF_protectLexIdCon(SDF_LexIdCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_LexIdCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_LexIdCon
 */
void SDF_unprotectLexIdCon(SDF_LexIdCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Protect a SDF_IdCon from the ATerm garbage collector. Every SDF_IdCon that is not rooted somewhere on the C call stack must be protected. Examples are global variables
 * \param[in] arg pointer to a SDF_IdCon
 */
void SDF_protectIdCon(SDF_IdCon *arg) {
  ATprotect((ATerm*)((void*) arg));
}

/**
 * Unprotect a SDF_IdCon from the ATerm garbage collector. This improves the efficiency of the garbage collector, as well as provide opportunity for reclaiming space
 * \param[in] arg pointer to a SDF_IdCon
 */
void SDF_unprotectIdCon(SDF_IdCon *arg) {
  ATunprotect((ATerm*)((void*) arg));
}

/**
 * Transforms an ATerm to a SDF_OptLayout. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_OptLayout that was encoded by \arg
 */
SDF_OptLayout SDF_OptLayoutFromTerm(ATerm t) {
  return (SDF_OptLayout)t;
}

/**
 * Transforms a SDF_OptLayoutto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_OptLayout to be converted
 * \return ATerm that represents the SDF_OptLayout
 */
ATerm SDF_OptLayoutToTerm(SDF_OptLayout arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Layout. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Layout that was encoded by \arg
 */
SDF_Layout SDF_LayoutFromTerm(ATerm t) {
  return (SDF_Layout)t;
}

/**
 * Transforms a SDF_Layoutto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Layout to be converted
 * \return ATerm that represents the SDF_Layout
 */
ATerm SDF_LayoutToTerm(SDF_Layout arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexLayoutList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexLayoutList that was encoded by \arg
 */
SDF_LexLayoutList SDF_LexLayoutListFromTerm(ATerm t) {
  return (SDF_LexLayoutList)t;
}

/**
 * Transforms a SDF_LexLayoutListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexLayoutList to be converted
 * \return ATerm that represents the SDF_LexLayoutList
 */
ATerm SDF_LexLayoutListToTerm(SDF_LexLayoutList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_AFun. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_AFun that was encoded by \arg
 */
SDF_AFun SDF_AFunFromTerm(ATerm t) {
  return (SDF_AFun)t;
}

/**
 * Transforms a SDF_AFunto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_AFun to be converted
 * \return ATerm that represents the SDF_AFun
 */
ATerm SDF_AFunToTerm(SDF_AFun arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ATerm. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ATerm that was encoded by \arg
 */
SDF_ATerm SDF_ATermFromTerm(ATerm t) {
  return (SDF_ATerm)t;
}

/**
 * Transforms a SDF_ATermto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ATerm to be converted
 * \return ATerm that represents the SDF_ATerm
 */
ATerm SDF_ATermToTerm(SDF_ATerm arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Annotation. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Annotation that was encoded by \arg
 */
SDF_Annotation SDF_AnnotationFromTerm(ATerm t) {
  return (SDF_Annotation)t;
}

/**
 * Transforms a SDF_Annotationto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Annotation to be converted
 * \return ATerm that represents the SDF_Annotation
 */
ATerm SDF_AnnotationToTerm(SDF_Annotation arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Start. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Start that was encoded by \arg
 */
SDF_Start SDF_StartFromTerm(ATerm t) {
  return (SDF_Start)t;
}

/**
 * Transforms a SDF_Startto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Start to be converted
 * \return ATerm that represents the SDF_Start
 */
ATerm SDF_StartToTerm(SDF_Start arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ATermArgs. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ATermArgs that was encoded by \arg
 */
SDF_ATermArgs SDF_ATermArgsFromTerm(ATerm t) {
  return (SDF_ATermArgs)t;
}

/**
 * Transforms a SDF_ATermArgsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ATermArgs to be converted
 * \return ATerm that represents the SDF_ATermArgs
 */
ATerm SDF_ATermArgsToTerm(SDF_ATermArgs arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ATermElems. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ATermElems that was encoded by \arg
 */
SDF_ATermElems SDF_ATermElemsFromTerm(ATerm t) {
  return (SDF_ATermElems)t;
}

/**
 * Transforms a SDF_ATermElemsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ATermElems to be converted
 * \return ATerm that represents the SDF_ATermElems
 */
ATerm SDF_ATermElemsToTerm(SDF_ATermElems arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ATermAnnos. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ATermAnnos that was encoded by \arg
 */
SDF_ATermAnnos SDF_ATermAnnosFromTerm(ATerm t) {
  return (SDF_ATermAnnos)t;
}

/**
 * Transforms a SDF_ATermAnnosto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ATermAnnos to be converted
 * \return ATerm that represents the SDF_ATermAnnos
 */
ATerm SDF_ATermAnnosToTerm(SDF_ATermAnnos arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_IntCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_IntCon that was encoded by \arg
 */
SDF_IntCon SDF_IntConFromTerm(ATerm t) {
  return (SDF_IntCon)t;
}

/**
 * Transforms a SDF_IntConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_IntCon to be converted
 * \return ATerm that represents the SDF_IntCon
 */
ATerm SDF_IntConToTerm(SDF_IntCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_OptExp. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_OptExp that was encoded by \arg
 */
SDF_OptExp SDF_OptExpFromTerm(ATerm t) {
  return (SDF_OptExp)t;
}

/**
 * Transforms a SDF_OptExpto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_OptExp to be converted
 * \return ATerm that represents the SDF_OptExp
 */
ATerm SDF_OptExpToTerm(SDF_OptExp arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_RealCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_RealCon that was encoded by \arg
 */
SDF_RealCon SDF_RealConFromTerm(ATerm t) {
  return (SDF_RealCon)t;
}

/**
 * Transforms a SDF_RealConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_RealCon to be converted
 * \return ATerm that represents the SDF_RealCon
 */
ATerm SDF_RealConToTerm(SDF_RealCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Grammar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Grammar that was encoded by \arg
 */
SDF_Grammar SDF_GrammarFromTerm(ATerm t) {
  return (SDF_Grammar)t;
}

/**
 * Transforms a SDF_Grammarto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Grammar to be converted
 * \return ATerm that represents the SDF_Grammar
 */
ATerm SDF_GrammarToTerm(SDF_Grammar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Alias. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Alias that was encoded by \arg
 */
SDF_Alias SDF_AliasFromTerm(ATerm t) {
  return (SDF_Alias)t;
}

/**
 * Transforms a SDF_Aliasto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Alias to be converted
 * \return ATerm that represents the SDF_Alias
 */
ATerm SDF_AliasToTerm(SDF_Alias arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Aliases. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Aliases that was encoded by \arg
 */
SDF_Aliases SDF_AliasesFromTerm(ATerm t) {
  return (SDF_Aliases)t;
}

/**
 * Transforms a SDF_Aliasesto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Aliases to be converted
 * \return ATerm that represents the SDF_Aliases
 */
ATerm SDF_AliasesToTerm(SDF_Aliases arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_AliasList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_AliasList that was encoded by \arg
 */
SDF_AliasList SDF_AliasListFromTerm(ATerm t) {
  return (SDF_AliasList)t;
}

/**
 * Transforms a SDF_AliasListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_AliasList to be converted
 * \return ATerm that represents the SDF_AliasList
 */
ATerm SDF_AliasListToTerm(SDF_AliasList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Symbol. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Symbol that was encoded by \arg
 */
SDF_Symbol SDF_SymbolFromTerm(ATerm t) {
  return (SDF_Symbol)t;
}

/**
 * Transforms a SDF_Symbolto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Symbol to be converted
 * \return ATerm that represents the SDF_Symbol
 */
ATerm SDF_SymbolToTerm(SDF_Symbol arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_CharRange. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_CharRange that was encoded by \arg
 */
SDF_CharRange SDF_CharRangeFromTerm(ATerm t) {
  return (SDF_CharRange)t;
}

/**
 * Transforms a SDF_CharRangeto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_CharRange to be converted
 * \return ATerm that represents the SDF_CharRange
 */
ATerm SDF_CharRangeToTerm(SDF_CharRange arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_CharRanges. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_CharRanges that was encoded by \arg
 */
SDF_CharRanges SDF_CharRangesFromTerm(ATerm t) {
  return (SDF_CharRanges)t;
}

/**
 * Transforms a SDF_CharRangesto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_CharRanges to be converted
 * \return ATerm that represents the SDF_CharRanges
 */
ATerm SDF_CharRangesToTerm(SDF_CharRanges arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_OptCharRanges. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_OptCharRanges that was encoded by \arg
 */
SDF_OptCharRanges SDF_OptCharRangesFromTerm(ATerm t) {
  return (SDF_OptCharRanges)t;
}

/**
 * Transforms a SDF_OptCharRangesto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_OptCharRanges to be converted
 * \return ATerm that represents the SDF_OptCharRanges
 */
ATerm SDF_OptCharRangesToTerm(SDF_OptCharRanges arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_CharClass. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_CharClass that was encoded by \arg
 */
SDF_CharClass SDF_CharClassFromTerm(ATerm t) {
  return (SDF_CharClass)t;
}

/**
 * Transforms a SDF_CharClassto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_CharClass to be converted
 * \return ATerm that represents the SDF_CharClass
 */
ATerm SDF_CharClassToTerm(SDF_CharClass arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexNumChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexNumChar that was encoded by \arg
 */
SDF_LexNumChar SDF_LexNumCharFromTerm(ATerm t) {
  return (SDF_LexNumChar)t;
}

/**
 * Transforms a SDF_LexNumCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexNumChar to be converted
 * \return ATerm that represents the SDF_LexNumChar
 */
ATerm SDF_LexNumCharToTerm(SDF_LexNumChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_NumChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_NumChar that was encoded by \arg
 */
SDF_NumChar SDF_NumCharFromTerm(ATerm t) {
  return (SDF_NumChar)t;
}

/**
 * Transforms a SDF_NumCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_NumChar to be converted
 * \return ATerm that represents the SDF_NumChar
 */
ATerm SDF_NumCharToTerm(SDF_NumChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexShortChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexShortChar that was encoded by \arg
 */
SDF_LexShortChar SDF_LexShortCharFromTerm(ATerm t) {
  return (SDF_LexShortChar)t;
}

/**
 * Transforms a SDF_LexShortCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexShortChar to be converted
 * \return ATerm that represents the SDF_LexShortChar
 */
ATerm SDF_LexShortCharToTerm(SDF_LexShortChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ShortChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ShortChar that was encoded by \arg
 */
SDF_ShortChar SDF_ShortCharFromTerm(ATerm t) {
  return (SDF_ShortChar)t;
}

/**
 * Transforms a SDF_ShortCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ShortChar to be converted
 * \return ATerm that represents the SDF_ShortChar
 */
ATerm SDF_ShortCharToTerm(SDF_ShortChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Character. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Character that was encoded by \arg
 */
SDF_Character SDF_CharacterFromTerm(ATerm t) {
  return (SDF_Character)t;
}

/**
 * Transforms a SDF_Characterto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Character to be converted
 * \return ATerm that represents the SDF_Character
 */
ATerm SDF_CharacterToTerm(SDF_Character arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ATermAttribute. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ATermAttribute that was encoded by \arg
 */
SDF_ATermAttribute SDF_ATermAttributeFromTerm(ATerm t) {
  return (SDF_ATermAttribute)t;
}

/**
 * Transforms a SDF_ATermAttributeto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ATermAttribute to be converted
 * \return ATerm that represents the SDF_ATermAttribute
 */
ATerm SDF_ATermAttributeToTerm(SDF_ATermAttribute arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Attribute. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Attribute that was encoded by \arg
 */
SDF_Attribute SDF_AttributeFromTerm(ATerm t) {
  return (SDF_Attribute)t;
}

/**
 * Transforms a SDF_Attributeto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Attribute to be converted
 * \return ATerm that represents the SDF_Attribute
 */
ATerm SDF_AttributeToTerm(SDF_Attribute arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Attributes. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Attributes that was encoded by \arg
 */
SDF_Attributes SDF_AttributesFromTerm(ATerm t) {
  return (SDF_Attributes)t;
}

/**
 * Transforms a SDF_Attributesto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Attributes to be converted
 * \return ATerm that represents the SDF_Attributes
 */
ATerm SDF_AttributesToTerm(SDF_Attributes arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Production. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Production that was encoded by \arg
 */
SDF_Production SDF_ProductionFromTerm(ATerm t) {
  return (SDF_Production)t;
}

/**
 * Transforms a SDF_Productionto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Production to be converted
 * \return ATerm that represents the SDF_Production
 */
ATerm SDF_ProductionToTerm(SDF_Production arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Productions. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Productions that was encoded by \arg
 */
SDF_Productions SDF_ProductionsFromTerm(ATerm t) {
  return (SDF_Productions)t;
}

/**
 * Transforms a SDF_Productionsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Productions to be converted
 * \return ATerm that represents the SDF_Productions
 */
ATerm SDF_ProductionsToTerm(SDF_Productions arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_AttributeList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_AttributeList that was encoded by \arg
 */
SDF_AttributeList SDF_AttributeListFromTerm(ATerm t) {
  return (SDF_AttributeList)t;
}

/**
 * Transforms a SDF_AttributeListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_AttributeList to be converted
 * \return ATerm that represents the SDF_AttributeList
 */
ATerm SDF_AttributeListToTerm(SDF_AttributeList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ProductionList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ProductionList that was encoded by \arg
 */
SDF_ProductionList SDF_ProductionListFromTerm(ATerm t) {
  return (SDF_ProductionList)t;
}

/**
 * Transforms a SDF_ProductionListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ProductionList to be converted
 * \return ATerm that represents the SDF_ProductionList
 */
ATerm SDF_ProductionListToTerm(SDF_ProductionList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Label. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Label that was encoded by \arg
 */
SDF_Label SDF_LabelFromTerm(ATerm t) {
  return (SDF_Label)t;
}

/**
 * Transforms a SDF_Labelto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Label to be converted
 * \return ATerm that represents the SDF_Label
 */
ATerm SDF_LabelToTerm(SDF_Label arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexSingleQuotedStrChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexSingleQuotedStrChar that was encoded by \arg
 */
SDF_LexSingleQuotedStrChar SDF_LexSingleQuotedStrCharFromTerm(ATerm t) {
  return (SDF_LexSingleQuotedStrChar)t;
}

/**
 * Transforms a SDF_LexSingleQuotedStrCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexSingleQuotedStrChar to be converted
 * \return ATerm that represents the SDF_LexSingleQuotedStrChar
 */
ATerm SDF_LexSingleQuotedStrCharToTerm(SDF_LexSingleQuotedStrChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SingleQuotedStrChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SingleQuotedStrChar that was encoded by \arg
 */
SDF_SingleQuotedStrChar SDF_SingleQuotedStrCharFromTerm(ATerm t) {
  return (SDF_SingleQuotedStrChar)t;
}

/**
 * Transforms a SDF_SingleQuotedStrCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SingleQuotedStrChar to be converted
 * \return ATerm that represents the SDF_SingleQuotedStrChar
 */
ATerm SDF_SingleQuotedStrCharToTerm(SDF_SingleQuotedStrChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexSingleQuotedStrCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexSingleQuotedStrCon that was encoded by \arg
 */
SDF_LexSingleQuotedStrCon SDF_LexSingleQuotedStrConFromTerm(ATerm t) {
  return (SDF_LexSingleQuotedStrCon)t;
}

/**
 * Transforms a SDF_LexSingleQuotedStrConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexSingleQuotedStrCon to be converted
 * \return ATerm that represents the SDF_LexSingleQuotedStrCon
 */
ATerm SDF_LexSingleQuotedStrConToTerm(SDF_LexSingleQuotedStrCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SingleQuotedStrCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SingleQuotedStrCon that was encoded by \arg
 */
SDF_SingleQuotedStrCon SDF_SingleQuotedStrConFromTerm(ATerm t) {
  return (SDF_SingleQuotedStrCon)t;
}

/**
 * Transforms a SDF_SingleQuotedStrConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SingleQuotedStrCon to be converted
 * \return ATerm that represents the SDF_SingleQuotedStrCon
 */
ATerm SDF_SingleQuotedStrConToTerm(SDF_SingleQuotedStrCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_FunctionName. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_FunctionName that was encoded by \arg
 */
SDF_FunctionName SDF_FunctionNameFromTerm(ATerm t) {
  return (SDF_FunctionName)t;
}

/**
 * Transforms a SDF_FunctionNameto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_FunctionName to be converted
 * \return ATerm that represents the SDF_FunctionName
 */
ATerm SDF_FunctionNameToTerm(SDF_FunctionName arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexSingleQuotedStrCharChars. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexSingleQuotedStrCharChars that was encoded by \arg
 */
SDF_LexSingleQuotedStrCharChars SDF_LexSingleQuotedStrCharCharsFromTerm(ATerm t) {
  return (SDF_LexSingleQuotedStrCharChars)t;
}

/**
 * Transforms a SDF_LexSingleQuotedStrCharCharsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to be converted
 * \return ATerm that represents the SDF_LexSingleQuotedStrCharChars
 */
ATerm SDF_LexSingleQuotedStrCharCharsToTerm(SDF_LexSingleQuotedStrCharChars arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SymbolArguments. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SymbolArguments that was encoded by \arg
 */
SDF_SymbolArguments SDF_SymbolArgumentsFromTerm(ATerm t) {
  return (SDF_SymbolArguments)t;
}

/**
 * Transforms a SDF_SymbolArgumentsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SymbolArguments to be converted
 * \return ATerm that represents the SDF_SymbolArguments
 */
ATerm SDF_SymbolArgumentsToTerm(SDF_SymbolArguments arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexModuleWord. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexModuleWord that was encoded by \arg
 */
SDF_LexModuleWord SDF_LexModuleWordFromTerm(ATerm t) {
  return (SDF_LexModuleWord)t;
}

/**
 * Transforms a SDF_LexModuleWordto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexModuleWord to be converted
 * \return ATerm that represents the SDF_LexModuleWord
 */
ATerm SDF_LexModuleWordToTerm(SDF_LexModuleWord arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ModuleWord. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ModuleWord that was encoded by \arg
 */
SDF_ModuleWord SDF_ModuleWordFromTerm(ATerm t) {
  return (SDF_ModuleWord)t;
}

/**
 * Transforms a SDF_ModuleWordto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ModuleWord to be converted
 * \return ATerm that represents the SDF_ModuleWord
 */
ATerm SDF_ModuleWordToTerm(SDF_ModuleWord arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexModuleId. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexModuleId that was encoded by \arg
 */
SDF_LexModuleId SDF_LexModuleIdFromTerm(ATerm t) {
  return (SDF_LexModuleId)t;
}

/**
 * Transforms a SDF_LexModuleIdto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexModuleId to be converted
 * \return ATerm that represents the SDF_LexModuleId
 */
ATerm SDF_LexModuleIdToTerm(SDF_LexModuleId arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ModuleId. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ModuleId that was encoded by \arg
 */
SDF_ModuleId SDF_ModuleIdFromTerm(ATerm t) {
  return (SDF_ModuleId)t;
}

/**
 * Transforms a SDF_ModuleIdto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ModuleId to be converted
 * \return ATerm that represents the SDF_ModuleId
 */
ATerm SDF_ModuleIdToTerm(SDF_ModuleId arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Definition. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Definition that was encoded by \arg
 */
SDF_Definition SDF_DefinitionFromTerm(ATerm t) {
  return (SDF_Definition)t;
}

/**
 * Transforms a SDF_Definitionto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Definition to be converted
 * \return ATerm that represents the SDF_Definition
 */
ATerm SDF_DefinitionToTerm(SDF_Definition arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Module. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Module that was encoded by \arg
 */
SDF_Module SDF_ModuleFromTerm(ATerm t) {
  return (SDF_Module)t;
}

/**
 * Transforms a SDF_Moduleto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Module to be converted
 * \return ATerm that represents the SDF_Module
 */
ATerm SDF_ModuleToTerm(SDF_Module arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Section. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Section that was encoded by \arg
 */
SDF_Section SDF_SectionFromTerm(ATerm t) {
  return (SDF_Section)t;
}

/**
 * Transforms a SDF_Sectionto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Section to be converted
 * \return ATerm that represents the SDF_Section
 */
ATerm SDF_SectionToTerm(SDF_Section arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Sections. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Sections that was encoded by \arg
 */
SDF_Sections SDF_SectionsFromTerm(ATerm t) {
  return (SDF_Sections)t;
}

/**
 * Transforms a SDF_Sectionsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Sections to be converted
 * \return ATerm that represents the SDF_Sections
 */
ATerm SDF_SectionsToTerm(SDF_Sections arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ModuleName. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ModuleName that was encoded by \arg
 */
SDF_ModuleName SDF_ModuleNameFromTerm(ATerm t) {
  return (SDF_ModuleName)t;
}

/**
 * Transforms a SDF_ModuleNameto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ModuleName to be converted
 * \return ATerm that represents the SDF_ModuleName
 */
ATerm SDF_ModuleNameToTerm(SDF_ModuleName arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ImpSection. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ImpSection that was encoded by \arg
 */
SDF_ImpSection SDF_ImpSectionFromTerm(ATerm t) {
  return (SDF_ImpSection)t;
}

/**
 * Transforms a SDF_ImpSectionto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ImpSection to be converted
 * \return ATerm that represents the SDF_ImpSection
 */
ATerm SDF_ImpSectionToTerm(SDF_ImpSection arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Imports. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Imports that was encoded by \arg
 */
SDF_Imports SDF_ImportsFromTerm(ATerm t) {
  return (SDF_Imports)t;
}

/**
 * Transforms a SDF_Importsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Imports to be converted
 * \return ATerm that represents the SDF_Imports
 */
ATerm SDF_ImportsToTerm(SDF_Imports arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Import. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Import that was encoded by \arg
 */
SDF_Import SDF_ImportFromTerm(ATerm t) {
  return (SDF_Import)t;
}

/**
 * Transforms a SDF_Importto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Import to be converted
 * \return ATerm that represents the SDF_Import
 */
ATerm SDF_ImportToTerm(SDF_Import arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ModuleList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ModuleList that was encoded by \arg
 */
SDF_ModuleList SDF_ModuleListFromTerm(ATerm t) {
  return (SDF_ModuleList)t;
}

/**
 * Transforms a SDF_ModuleListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ModuleList to be converted
 * \return ATerm that represents the SDF_ModuleList
 */
ATerm SDF_ModuleListToTerm(SDF_ModuleList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ImpSectionList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ImpSectionList that was encoded by \arg
 */
SDF_ImpSectionList SDF_ImpSectionListFromTerm(ATerm t) {
  return (SDF_ImpSectionList)t;
}

/**
 * Transforms a SDF_ImpSectionListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ImpSectionList to be converted
 * \return ATerm that represents the SDF_ImpSectionList
 */
ATerm SDF_ImpSectionListToTerm(SDF_ImpSectionList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SectionList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SectionList that was encoded by \arg
 */
SDF_SectionList SDF_SectionListFromTerm(ATerm t) {
  return (SDF_SectionList)t;
}

/**
 * Transforms a SDF_SectionListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SectionList to be converted
 * \return ATerm that represents the SDF_SectionList
 */
ATerm SDF_SectionListToTerm(SDF_SectionList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ImportList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ImportList that was encoded by \arg
 */
SDF_ImportList SDF_ImportListFromTerm(ATerm t) {
  return (SDF_ImportList)t;
}

/**
 * Transforms a SDF_ImportListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ImportList to be converted
 * \return ATerm that represents the SDF_ImportList
 */
ATerm SDF_ImportListToTerm(SDF_ImportList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Associativity. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Associativity that was encoded by \arg
 */
SDF_Associativity SDF_AssociativityFromTerm(ATerm t) {
  return (SDF_Associativity)t;
}

/**
 * Transforms a SDF_Associativityto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Associativity to be converted
 * \return ATerm that represents the SDF_Associativity
 */
ATerm SDF_AssociativityToTerm(SDF_Associativity arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_ArgumentIndicator. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_ArgumentIndicator that was encoded by \arg
 */
SDF_ArgumentIndicator SDF_ArgumentIndicatorFromTerm(ATerm t) {
  return (SDF_ArgumentIndicator)t;
}

/**
 * Transforms a SDF_ArgumentIndicatorto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_ArgumentIndicator to be converted
 * \return ATerm that represents the SDF_ArgumentIndicator
 */
ATerm SDF_ArgumentIndicatorToTerm(SDF_ArgumentIndicator arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Group. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Group that was encoded by \arg
 */
SDF_Group SDF_GroupFromTerm(ATerm t) {
  return (SDF_Group)t;
}

/**
 * Transforms a SDF_Groupto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Group to be converted
 * \return ATerm that represents the SDF_Group
 */
ATerm SDF_GroupToTerm(SDF_Group arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Priority. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Priority that was encoded by \arg
 */
SDF_Priority SDF_PriorityFromTerm(ATerm t) {
  return (SDF_Priority)t;
}

/**
 * Transforms a SDF_Priorityto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Priority to be converted
 * \return ATerm that represents the SDF_Priority
 */
ATerm SDF_PriorityToTerm(SDF_Priority arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Priorities. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Priorities that was encoded by \arg
 */
SDF_Priorities SDF_PrioritiesFromTerm(ATerm t) {
  return (SDF_Priorities)t;
}

/**
 * Transforms a SDF_Prioritiesto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Priorities to be converted
 * \return ATerm that represents the SDF_Priorities
 */
ATerm SDF_PrioritiesToTerm(SDF_Priorities arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_NatConArguments. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_NatConArguments that was encoded by \arg
 */
SDF_NatConArguments SDF_NatConArgumentsFromTerm(ATerm t) {
  return (SDF_NatConArguments)t;
}

/**
 * Transforms a SDF_NatConArgumentsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_NatConArguments to be converted
 * \return ATerm that represents the SDF_NatConArguments
 */
ATerm SDF_NatConArgumentsToTerm(SDF_NatConArguments arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_GroupList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_GroupList that was encoded by \arg
 */
SDF_GroupList SDF_GroupListFromTerm(ATerm t) {
  return (SDF_GroupList)t;
}

/**
 * Transforms a SDF_GroupListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_GroupList to be converted
 * \return ATerm that represents the SDF_GroupList
 */
ATerm SDF_GroupListToTerm(SDF_GroupList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_PriorityList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_PriorityList that was encoded by \arg
 */
SDF_PriorityList SDF_PriorityListFromTerm(ATerm t) {
  return (SDF_PriorityList)t;
}

/**
 * Transforms a SDF_PriorityListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_PriorityList to be converted
 * \return ATerm that represents the SDF_PriorityList
 */
ATerm SDF_PriorityListToTerm(SDF_PriorityList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SymbolTail. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SymbolTail that was encoded by \arg
 */
SDF_SymbolTail SDF_SymbolTailFromTerm(ATerm t) {
  return (SDF_SymbolTail)t;
}

/**
 * Transforms a SDF_SymbolTailto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SymbolTail to be converted
 * \return ATerm that represents the SDF_SymbolTail
 */
ATerm SDF_SymbolTailToTerm(SDF_SymbolTail arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SymbolRest. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SymbolRest that was encoded by \arg
 */
SDF_SymbolRest SDF_SymbolRestFromTerm(ATerm t) {
  return (SDF_SymbolRest)t;
}

/**
 * Transforms a SDF_SymbolRestto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SymbolRest to be converted
 * \return ATerm that represents the SDF_SymbolRest
 */
ATerm SDF_SymbolRestToTerm(SDF_SymbolRest arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Renamings. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Renamings that was encoded by \arg
 */
SDF_Renamings SDF_RenamingsFromTerm(ATerm t) {
  return (SDF_Renamings)t;
}

/**
 * Transforms a SDF_Renamingsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Renamings to be converted
 * \return ATerm that represents the SDF_Renamings
 */
ATerm SDF_RenamingsToTerm(SDF_Renamings arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Renaming. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Renaming that was encoded by \arg
 */
SDF_Renaming SDF_RenamingFromTerm(ATerm t) {
  return (SDF_Renaming)t;
}

/**
 * Transforms a SDF_Renamingto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Renaming to be converted
 * \return ATerm that represents the SDF_Renaming
 */
ATerm SDF_RenamingToTerm(SDF_Renaming arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_RenamingList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_RenamingList that was encoded by \arg
 */
SDF_RenamingList SDF_RenamingListFromTerm(ATerm t) {
  return (SDF_RenamingList)t;
}

/**
 * Transforms a SDF_RenamingListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_RenamingList to be converted
 * \return ATerm that represents the SDF_RenamingList
 */
ATerm SDF_RenamingListToTerm(SDF_RenamingList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Lookahead. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Lookahead that was encoded by \arg
 */
SDF_Lookahead SDF_LookaheadFromTerm(ATerm t) {
  return (SDF_Lookahead)t;
}

/**
 * Transforms a SDF_Lookaheadto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Lookahead to be converted
 * \return ATerm that represents the SDF_Lookahead
 */
ATerm SDF_LookaheadToTerm(SDF_Lookahead arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Lookaheads. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Lookaheads that was encoded by \arg
 */
SDF_Lookaheads SDF_LookaheadsFromTerm(ATerm t) {
  return (SDF_Lookaheads)t;
}

/**
 * Transforms a SDF_Lookaheadsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Lookaheads to be converted
 * \return ATerm that represents the SDF_Lookaheads
 */
ATerm SDF_LookaheadsToTerm(SDF_Lookaheads arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Restriction. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Restriction that was encoded by \arg
 */
SDF_Restriction SDF_RestrictionFromTerm(ATerm t) {
  return (SDF_Restriction)t;
}

/**
 * Transforms a SDF_Restrictionto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Restriction to be converted
 * \return ATerm that represents the SDF_Restriction
 */
ATerm SDF_RestrictionToTerm(SDF_Restriction arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Restrictions. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Restrictions that was encoded by \arg
 */
SDF_Restrictions SDF_RestrictionsFromTerm(ATerm t) {
  return (SDF_Restrictions)t;
}

/**
 * Transforms a SDF_Restrictionsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Restrictions to be converted
 * \return ATerm that represents the SDF_Restrictions
 */
ATerm SDF_RestrictionsToTerm(SDF_Restrictions arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LookaheadList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LookaheadList that was encoded by \arg
 */
SDF_LookaheadList SDF_LookaheadListFromTerm(ATerm t) {
  return (SDF_LookaheadList)t;
}

/**
 * Transforms a SDF_LookaheadListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LookaheadList to be converted
 * \return ATerm that represents the SDF_LookaheadList
 */
ATerm SDF_LookaheadListToTerm(SDF_LookaheadList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_RestrictionList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_RestrictionList that was encoded by \arg
 */
SDF_RestrictionList SDF_RestrictionListFromTerm(ATerm t) {
  return (SDF_RestrictionList)t;
}

/**
 * Transforms a SDF_RestrictionListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_RestrictionList to be converted
 * \return ATerm that represents the SDF_RestrictionList
 */
ATerm SDF_RestrictionListToTerm(SDF_RestrictionList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Sort. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Sort that was encoded by \arg
 */
SDF_Sort SDF_SortFromTerm(ATerm t) {
  return (SDF_Sort)t;
}

/**
 * Transforms a SDF_Sortto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Sort to be converted
 * \return ATerm that represents the SDF_Sort
 */
ATerm SDF_SortToTerm(SDF_Sort arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SDF. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SDF that was encoded by \arg
 */
SDF_SDF SDF_SDFFromTerm(ATerm t) {
  return (SDF_SDF)t;
}

/**
 * Transforms a SDF_SDFto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SDF to be converted
 * \return ATerm that represents the SDF_SDF
 */
ATerm SDF_SDFToTerm(SDF_SDF arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexSort. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexSort that was encoded by \arg
 */
SDF_LexSort SDF_LexSortFromTerm(ATerm t) {
  return (SDF_LexSort)t;
}

/**
 * Transforms a SDF_LexSortto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexSort to be converted
 * \return ATerm that represents the SDF_LexSort
 */
ATerm SDF_LexSortToTerm(SDF_LexSort arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SymbolParameters. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SymbolParameters that was encoded by \arg
 */
SDF_SymbolParameters SDF_SymbolParametersFromTerm(ATerm t) {
  return (SDF_SymbolParameters)t;
}

/**
 * Transforms a SDF_SymbolParametersto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SymbolParameters to be converted
 * \return ATerm that represents the SDF_SymbolParameters
 */
ATerm SDF_SymbolParametersToTerm(SDF_SymbolParameters arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_Symbols. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_Symbols that was encoded by \arg
 */
SDF_Symbols SDF_SymbolsFromTerm(ATerm t) {
  return (SDF_Symbols)t;
}

/**
 * Transforms a SDF_Symbolsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_Symbols to be converted
 * \return ATerm that represents the SDF_Symbols
 */
ATerm SDF_SymbolsToTerm(SDF_Symbols arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_SymbolList. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_SymbolList that was encoded by \arg
 */
SDF_SymbolList SDF_SymbolListFromTerm(ATerm t) {
  return (SDF_SymbolList)t;
}

/**
 * Transforms a SDF_SymbolListto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_SymbolList to be converted
 * \return ATerm that represents the SDF_SymbolList
 */
ATerm SDF_SymbolListToTerm(SDF_SymbolList arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexLayout. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexLayout that was encoded by \arg
 */
SDF_LexLayout SDF_LexLayoutFromTerm(ATerm t) {
  return (SDF_LexLayout)t;
}

/**
 * Transforms a SDF_LexLayoutto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexLayout to be converted
 * \return ATerm that represents the SDF_LexLayout
 */
ATerm SDF_LexLayoutToTerm(SDF_LexLayout arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexStrChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexStrChar that was encoded by \arg
 */
SDF_LexStrChar SDF_LexStrCharFromTerm(ATerm t) {
  return (SDF_LexStrChar)t;
}

/**
 * Transforms a SDF_LexStrCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexStrChar to be converted
 * \return ATerm that represents the SDF_LexStrChar
 */
ATerm SDF_LexStrCharToTerm(SDF_LexStrChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_StrChar. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_StrChar that was encoded by \arg
 */
SDF_StrChar SDF_StrCharFromTerm(ATerm t) {
  return (SDF_StrChar)t;
}

/**
 * Transforms a SDF_StrCharto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_StrChar to be converted
 * \return ATerm that represents the SDF_StrChar
 */
ATerm SDF_StrCharToTerm(SDF_StrChar arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexStrCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexStrCon that was encoded by \arg
 */
SDF_LexStrCon SDF_LexStrConFromTerm(ATerm t) {
  return (SDF_LexStrCon)t;
}

/**
 * Transforms a SDF_LexStrConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexStrCon to be converted
 * \return ATerm that represents the SDF_LexStrCon
 */
ATerm SDF_LexStrConToTerm(SDF_LexStrCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_StrCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_StrCon that was encoded by \arg
 */
SDF_StrCon SDF_StrConFromTerm(ATerm t) {
  return (SDF_StrCon)t;
}

/**
 * Transforms a SDF_StrConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_StrCon to be converted
 * \return ATerm that represents the SDF_StrCon
 */
ATerm SDF_StrConToTerm(SDF_StrCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexStrCharChars. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexStrCharChars that was encoded by \arg
 */
SDF_LexStrCharChars SDF_LexStrCharCharsFromTerm(ATerm t) {
  return (SDF_LexStrCharChars)t;
}

/**
 * Transforms a SDF_LexStrCharCharsto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexStrCharChars to be converted
 * \return ATerm that represents the SDF_LexStrCharChars
 */
ATerm SDF_LexStrCharCharsToTerm(SDF_LexStrCharChars arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexNatCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexNatCon that was encoded by \arg
 */
SDF_LexNatCon SDF_LexNatConFromTerm(ATerm t) {
  return (SDF_LexNatCon)t;
}

/**
 * Transforms a SDF_LexNatConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexNatCon to be converted
 * \return ATerm that represents the SDF_LexNatCon
 */
ATerm SDF_LexNatConToTerm(SDF_LexNatCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_NatCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_NatCon that was encoded by \arg
 */
SDF_NatCon SDF_NatConFromTerm(ATerm t) {
  return (SDF_NatCon)t;
}

/**
 * Transforms a SDF_NatConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_NatCon to be converted
 * \return ATerm that represents the SDF_NatCon
 */
ATerm SDF_NatConToTerm(SDF_NatCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_LexIdCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_LexIdCon that was encoded by \arg
 */
SDF_LexIdCon SDF_LexIdConFromTerm(ATerm t) {
  return (SDF_LexIdCon)t;
}

/**
 * Transforms a SDF_LexIdConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_LexIdCon to be converted
 * \return ATerm that represents the SDF_LexIdCon
 */
ATerm SDF_LexIdConToTerm(SDF_LexIdCon arg) {
  return (ATerm)arg;
}

/**
 * Transforms an ATerm to a SDF_IdCon. This is just a wrapper for a cast, so no structural validation is done!
 * \param[in] t ATerm to be converted
 * \return SDF_IdCon that was encoded by \arg
 */
SDF_IdCon SDF_IdConFromTerm(ATerm t) {
  return (SDF_IdCon)t;
}

/**
 * Transforms a SDF_IdConto an ATerm. This is just a wrapper for a cast.
 * \param[in] arg SDF_IdCon to be converted
 * \return ATerm that represents the SDF_IdCon
 */
ATerm SDF_IdConToTerm(SDF_IdCon arg) {
  return (ATerm)arg;
}

/**
 * Retrieve the length of a SDF_LexLayoutList. 
 * \param[in] arg input SDF_LexLayoutList
 * \return The number of elements in the SDF_LexLayoutList
 */
int SDF_getLexLayoutListLength (SDF_LexLayoutList arg) {
  return ATgetLength((ATermList) arg);
}

/**
 * Reverse a SDF_LexLayoutList. 
 * \param[in] arg SDF_LexLayoutList to be reversed
 * \return a reversed #arg
 */
SDF_LexLayoutList SDF_reverseLexLayoutList(SDF_LexLayoutList arg) {
  return (SDF_LexLayoutList) ATreverse((ATermList) arg);
}

/**
 * Append a SDF_LexLayout to the end of a SDF_LexLayoutList. 
 * \param[in] arg SDF_LexLayoutList to append the SDF_LexLayout to
 * \param[in] elem SDF_LexLayout to be appended
 * \return new SDF_LexLayoutList with #elem appended
 */
SDF_LexLayoutList SDF_appendLexLayoutList(SDF_LexLayoutList arg, SDF_LexLayout elem) {
  return (SDF_LexLayoutList) ATappend((ATermList) arg, (ATerm) ((ATerm) elem));
}

/**
 * Concatenate two SDF_LexLayoutLists. 
 * \param[in] arg0 first SDF_LexLayoutList
 * \param[in] arg1 second SDF_LexLayoutList
 * \return SDF_LexLayoutList with the elements of #arg0 before the elements of #arg1
 */
SDF_LexLayoutList SDF_concatLexLayoutList(SDF_LexLayoutList arg0, SDF_LexLayoutList arg1) {
  return (SDF_LexLayoutList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_LexLayoutList. 
 * \param[in] arg SDF_LexLayoutList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_LexLayoutList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_LexLayoutList SDF_sliceLexLayoutList(SDF_LexLayoutList arg, int start, int end) {
  return (SDF_LexLayoutList) ATgetSlice((ATermList) arg, start, end);
}

/**
 * Retrieve the SDF_LexLayout at #index from a SDF_LexLayoutList. 
 * \param[in] arg SDF_LexLayoutList to retrieve the SDF_LexLayout from
 * \param[in] index index to use to point in the SDF_LexLayoutList
 * \return SDF_LexLayout at position #index in #arg
 */
SDF_LexLayout SDF_getLexLayoutListLexLayoutAt(SDF_LexLayoutList arg, int index) {
 return (SDF_LexLayout)ATelementAt((ATermList) arg,index);
}

/**
 * Replace the SDF_LexLayout at #index from a SDF_LexLayoutList by a new one. 
 * \param[in] arg SDF_LexLayoutList to retrieve the SDF_LexLayout from
 * \param[in] elem new SDF_LexLayout to replace another
 * \param[in] index index to use to point in the SDF_LexLayoutList
 * \return A new SDF_LexLayoutListwith #elem replaced in #arg at position #index
 */
SDF_LexLayoutList SDF_replaceLexLayoutListLexLayoutAt(SDF_LexLayoutList arg, SDF_LexLayout elem, int index) {
 return (SDF_LexLayoutList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index);
}

/**
 * Builds a SDF_LexLayoutList of 2 consecutive elements. 
 * \param[in] elem1 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem2 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \return A new SDF_LexLayoutList consisting of 2 SDF_LexLayouts
 */
SDF_LexLayoutList SDF_makeLexLayoutList2(SDF_LexLayout elem1, SDF_LexLayout elem2) {
  return (SDF_LexLayoutList) ATmakeList2((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2));
}

/**
 * Builds a SDF_LexLayoutList of 3 consecutive elements. 
 * \param[in] elem1 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem2 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem3 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \return A new SDF_LexLayoutList consisting of 3 SDF_LexLayouts
 */
SDF_LexLayoutList SDF_makeLexLayoutList3(SDF_LexLayout elem1, SDF_LexLayout elem2, SDF_LexLayout elem3) {
  return (SDF_LexLayoutList) ATmakeList3((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3));
}

/**
 * Builds a SDF_LexLayoutList of 4 consecutive elements. 
 * \param[in] elem1 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem2 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem3 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem4 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \return A new SDF_LexLayoutList consisting of 4 SDF_LexLayouts
 */
SDF_LexLayoutList SDF_makeLexLayoutList4(SDF_LexLayout elem1, SDF_LexLayout elem2, SDF_LexLayout elem3, SDF_LexLayout elem4) {
  return (SDF_LexLayoutList) ATmakeList4((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4));
}

/**
 * Builds a SDF_LexLayoutList of 5 consecutive elements. 
 * \param[in] elem1 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem2 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem3 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem4 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem5 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \return A new SDF_LexLayoutList consisting of 5 SDF_LexLayouts
 */
SDF_LexLayoutList SDF_makeLexLayoutList5(SDF_LexLayout elem1, SDF_LexLayout elem2, SDF_LexLayout elem3, SDF_LexLayout elem4, SDF_LexLayout elem5) {
  return (SDF_LexLayoutList) ATmakeList5((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5));
}

/**
 * Builds a SDF_LexLayoutList of 6 consecutive elements. 
 * \param[in] elem1 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem2 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem3 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem4 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem5 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \param[in] elem6 One SDF_LexLayout element of the new SDF_LexLayoutList
 * \return A new SDF_LexLayoutList consisting of 6 SDF_LexLayouts
 */
SDF_LexLayoutList SDF_makeLexLayoutList6(SDF_LexLayout elem1, SDF_LexLayout elem2, SDF_LexLayout elem3, SDF_LexLayout elem4, SDF_LexLayout elem5, SDF_LexLayout elem6) {
  return (SDF_LexLayoutList) ATmakeList6((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5), (ATerm) ((ATerm) elem6));
}

/**
 * Retrieve the number of elements in a SDF_ATermArgs. 
 * \param[in] arg input SDF_ATermArgs
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getATermArgsLength (SDF_ATermArgs arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_ATermArgs. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ATermArgs to be reversed
 * \return #arg reversed
 */
SDF_ATermArgs SDF_reverseATermArgs(SDF_ATermArgs arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ATermArgs) result;
}

/**
 * Append a SDF_ATerm to the end of a SDF_ATermArgs. 
 * \param[in] arg SDF_ATermArgs to append the SDF_ATerm to
 * \param[in] elem SDF_ATerm to be appended
 * \return new SDF_ATermArgs with #elem appended after the separators
 */
SDF_ATermArgs SDF_appendATermArgs(SDF_ATermArgs arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm arg1) {
  return SDF_concatATermArgs(arg0, wsAfterHead, wsAfterSep, SDF_makeATermArgsSingle(arg1));
}

/**
 * Concatenate two SDF_ATermArgss. 
 * \param[in] arg0 first SDF_ATermArgs
 * \param[in] arg1 second SDF_ATermArgs
 * \return SDF_ATermArgs with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ATermArgs SDF_concatATermArgs(SDF_ATermArgs arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermArgs arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeATermArgsMany((SDF_ATerm)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_ATermArgs) ATgetNext((ATermList) arg1);
  return (SDF_ATermArgs) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ATermArgs. 
 * \param[in] arg SDF_ATermArgs to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ATermArgs with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ATermArgs SDF_sliceATermArgs(SDF_ATermArgs arg, int start, int end) {
  return (SDF_ATermArgs) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_ATerm at #index from a SDF_ATermArgs. 
 * \param[in] arg SDF_ATermArgs to retrieve the SDF_ATerm from
 * \param[in] index index to use to point in the SDF_ATermArgs
 * \return SDF_ATerm at position #index in #arg
 */
SDF_ATerm SDF_getATermArgsATermAt(SDF_ATermArgs arg, int index) {
 return (SDF_ATerm)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_ATerm at #index from a SDF_ATermArgs by a new one. 
 * \param[in] arg SDF_ATermArgs to retrieve the SDF_ATerm from
 * \param[in] elem new SDF_ATerm to replace another
 * \param[in] index index to use to point in the SDF_ATermArgs
 * \return A new SDF_ATermArgswith #elem replaced in #arg at position #index
 */
SDF_ATermArgs SDF_replaceATermArgsATermAt(SDF_ATermArgs arg, SDF_ATerm elem, int index) {
 return (SDF_ATermArgs) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_ATermArgs of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermArgs
 * \return A new SDF_ATermArgs consisting of 2 SDF_ATerms
 */
SDF_ATermArgs SDF_makeATermArgs2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2) {
  return SDF_makeATermArgsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermArgsSingle(elem2));
}

/**
 * Builds a SDF_ATermArgs of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermArgs
 * \return A new SDF_ATermArgs consisting of 3 SDF_ATerms
 */
SDF_ATermArgs SDF_makeATermArgs3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3) {
  return SDF_makeATermArgsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermArgs2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_ATermArgs of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermArgs
 * \return A new SDF_ATermArgs consisting of 4 SDF_ATerms
 */
SDF_ATermArgs SDF_makeATermArgs4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4) {
  return SDF_makeATermArgsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermArgs3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ATermArgs of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermArgs
 * \return A new SDF_ATermArgs consisting of 5 SDF_ATerms
 */
SDF_ATermArgs SDF_makeATermArgs5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5) {
  return SDF_makeATermArgsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermArgs4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ATermArgs of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermArgs
 * \param[in] elem6 One SDF_ATerm element of the new SDF_ATermArgs
 * \return A new SDF_ATermArgs consisting of 6 SDF_ATerms
 */
SDF_ATermArgs SDF_makeATermArgs6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5, SDF_ATerm elem6) {
  return SDF_makeATermArgsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermArgs5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ATermElems. 
 * \param[in] arg input SDF_ATermElems
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getATermElemsLength (SDF_ATermElems arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_ATermElems. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ATermElems to be reversed
 * \return #arg reversed
 */
SDF_ATermElems SDF_reverseATermElems(SDF_ATermElems arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ATermElems) result;
}

/**
 * Append a SDF_ATerm to the end of a SDF_ATermElems. 
 * \param[in] arg SDF_ATermElems to append the SDF_ATerm to
 * \param[in] elem SDF_ATerm to be appended
 * \return new SDF_ATermElems with #elem appended after the separators
 */
SDF_ATermElems SDF_appendATermElems(SDF_ATermElems arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm arg1) {
  return SDF_concatATermElems(arg0, wsAfterHead, wsAfterSep, SDF_makeATermElemsSingle(arg1));
}

/**
 * Concatenate two SDF_ATermElemss. 
 * \param[in] arg0 first SDF_ATermElems
 * \param[in] arg1 second SDF_ATermElems
 * \return SDF_ATermElems with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ATermElems SDF_concatATermElems(SDF_ATermElems arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermElems arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeATermElemsMany((SDF_ATerm)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_ATermElems) ATgetNext((ATermList) arg1);
  return (SDF_ATermElems) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ATermElems. 
 * \param[in] arg SDF_ATermElems to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ATermElems with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ATermElems SDF_sliceATermElems(SDF_ATermElems arg, int start, int end) {
  return (SDF_ATermElems) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_ATerm at #index from a SDF_ATermElems. 
 * \param[in] arg SDF_ATermElems to retrieve the SDF_ATerm from
 * \param[in] index index to use to point in the SDF_ATermElems
 * \return SDF_ATerm at position #index in #arg
 */
SDF_ATerm SDF_getATermElemsATermAt(SDF_ATermElems arg, int index) {
 return (SDF_ATerm)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_ATerm at #index from a SDF_ATermElems by a new one. 
 * \param[in] arg SDF_ATermElems to retrieve the SDF_ATerm from
 * \param[in] elem new SDF_ATerm to replace another
 * \param[in] index index to use to point in the SDF_ATermElems
 * \return A new SDF_ATermElemswith #elem replaced in #arg at position #index
 */
SDF_ATermElems SDF_replaceATermElemsATermAt(SDF_ATermElems arg, SDF_ATerm elem, int index) {
 return (SDF_ATermElems) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_ATermElems of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermElems
 * \return A new SDF_ATermElems consisting of 2 SDF_ATerms
 */
SDF_ATermElems SDF_makeATermElems2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2) {
  return SDF_makeATermElemsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermElemsSingle(elem2));
}

/**
 * Builds a SDF_ATermElems of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermElems
 * \return A new SDF_ATermElems consisting of 3 SDF_ATerms
 */
SDF_ATermElems SDF_makeATermElems3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3) {
  return SDF_makeATermElemsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermElems2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_ATermElems of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermElems
 * \return A new SDF_ATermElems consisting of 4 SDF_ATerms
 */
SDF_ATermElems SDF_makeATermElems4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4) {
  return SDF_makeATermElemsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermElems3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ATermElems of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermElems
 * \return A new SDF_ATermElems consisting of 5 SDF_ATerms
 */
SDF_ATermElems SDF_makeATermElems5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5) {
  return SDF_makeATermElemsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermElems4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ATermElems of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermElems
 * \param[in] elem6 One SDF_ATerm element of the new SDF_ATermElems
 * \return A new SDF_ATermElems consisting of 6 SDF_ATerms
 */
SDF_ATermElems SDF_makeATermElems6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5, SDF_ATerm elem6) {
  return SDF_makeATermElemsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermElems5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ATermAnnos. 
 * \param[in] arg input SDF_ATermAnnos
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getATermAnnosLength (SDF_ATermAnnos arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_ATermAnnos. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ATermAnnos to be reversed
 * \return #arg reversed
 */
SDF_ATermAnnos SDF_reverseATermAnnos(SDF_ATermAnnos arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ATermAnnos) result;
}

/**
 * Append a SDF_ATerm to the end of a SDF_ATermAnnos. 
 * \param[in] arg SDF_ATermAnnos to append the SDF_ATerm to
 * \param[in] elem SDF_ATerm to be appended
 * \return new SDF_ATermAnnos with #elem appended after the separators
 */
SDF_ATermAnnos SDF_appendATermAnnos(SDF_ATermAnnos arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm arg1) {
  return SDF_concatATermAnnos(arg0, wsAfterHead, wsAfterSep, SDF_makeATermAnnosSingle(arg1));
}

/**
 * Concatenate two SDF_ATermAnnoss. 
 * \param[in] arg0 first SDF_ATermAnnos
 * \param[in] arg1 second SDF_ATermAnnos
 * \return SDF_ATermAnnos with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ATermAnnos SDF_concatATermAnnos(SDF_ATermAnnos arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermAnnos arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeATermAnnosMany((SDF_ATerm)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_ATermAnnos) ATgetNext((ATermList) arg1);
  return (SDF_ATermAnnos) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ATermAnnos. 
 * \param[in] arg SDF_ATermAnnos to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ATermAnnos with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ATermAnnos SDF_sliceATermAnnos(SDF_ATermAnnos arg, int start, int end) {
  return (SDF_ATermAnnos) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_ATerm at #index from a SDF_ATermAnnos. 
 * \param[in] arg SDF_ATermAnnos to retrieve the SDF_ATerm from
 * \param[in] index index to use to point in the SDF_ATermAnnos
 * \return SDF_ATerm at position #index in #arg
 */
SDF_ATerm SDF_getATermAnnosATermAt(SDF_ATermAnnos arg, int index) {
 return (SDF_ATerm)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_ATerm at #index from a SDF_ATermAnnos by a new one. 
 * \param[in] arg SDF_ATermAnnos to retrieve the SDF_ATerm from
 * \param[in] elem new SDF_ATerm to replace another
 * \param[in] index index to use to point in the SDF_ATermAnnos
 * \return A new SDF_ATermAnnoswith #elem replaced in #arg at position #index
 */
SDF_ATermAnnos SDF_replaceATermAnnosATermAt(SDF_ATermAnnos arg, SDF_ATerm elem, int index) {
 return (SDF_ATermAnnos) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_ATermAnnos of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermAnnos
 * \return A new SDF_ATermAnnos consisting of 2 SDF_ATerms
 */
SDF_ATermAnnos SDF_makeATermAnnos2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2) {
  return SDF_makeATermAnnosMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermAnnosSingle(elem2));
}

/**
 * Builds a SDF_ATermAnnos of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermAnnos
 * \return A new SDF_ATermAnnos consisting of 3 SDF_ATerms
 */
SDF_ATermAnnos SDF_makeATermAnnos3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3) {
  return SDF_makeATermAnnosMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermAnnos2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_ATermAnnos of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermAnnos
 * \return A new SDF_ATermAnnos consisting of 4 SDF_ATerms
 */
SDF_ATermAnnos SDF_makeATermAnnos4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4) {
  return SDF_makeATermAnnosMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermAnnos3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ATermAnnos of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermAnnos
 * \return A new SDF_ATermAnnos consisting of 5 SDF_ATerms
 */
SDF_ATermAnnos SDF_makeATermAnnos5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5) {
  return SDF_makeATermAnnosMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermAnnos4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ATermAnnos of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem2 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem3 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem4 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem5 One SDF_ATerm element of the new SDF_ATermAnnos
 * \param[in] elem6 One SDF_ATerm element of the new SDF_ATermAnnos
 * \return A new SDF_ATermAnnos consisting of 6 SDF_ATerms
 */
SDF_ATermAnnos SDF_makeATermAnnos6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATerm elem1, SDF_ATerm elem2, SDF_ATerm elem3, SDF_ATerm elem4, SDF_ATerm elem5, SDF_ATerm elem6) {
  return SDF_makeATermAnnosMany(elem1, wsAfterHead, wsAfterSep, SDF_makeATermAnnos5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_AliasList. 
 * \param[in] arg input SDF_AliasList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getAliasListLength (SDF_AliasList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_AliasList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_AliasList to be reversed
 * \return #arg reversed
 */
SDF_AliasList SDF_reverseAliasList(SDF_AliasList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_AliasList) result;
}

/**
 * Append a SDF_Alias to the end of a SDF_AliasList. 
 * \param[in] arg SDF_AliasList to append the SDF_Alias to
 * \param[in] elem SDF_Alias to be appended
 * \return new SDF_AliasList with #elem appended after the separators
 */
SDF_AliasList SDF_appendAliasList(SDF_AliasList arg0, SDF_OptLayout wsAfterHead, SDF_Alias arg1) {
  return SDF_concatAliasList(arg0, wsAfterHead, SDF_makeAliasListSingle(arg1));
}

/**
 * Concatenate two SDF_AliasLists. 
 * \param[in] arg0 first SDF_AliasList
 * \param[in] arg1 second SDF_AliasList
 * \return SDF_AliasList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_AliasList SDF_concatAliasList(SDF_AliasList arg0, SDF_OptLayout wsAfterHead, SDF_AliasList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeAliasListMany((SDF_Alias)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_AliasList) ATgetNext((ATermList) arg1);
  return (SDF_AliasList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_AliasList. 
 * \param[in] arg SDF_AliasList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_AliasList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_AliasList SDF_sliceAliasList(SDF_AliasList arg, int start, int end) {
  return (SDF_AliasList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Alias at #index from a SDF_AliasList. 
 * \param[in] arg SDF_AliasList to retrieve the SDF_Alias from
 * \param[in] index index to use to point in the SDF_AliasList
 * \return SDF_Alias at position #index in #arg
 */
SDF_Alias SDF_getAliasListAliasAt(SDF_AliasList arg, int index) {
 return (SDF_Alias)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Alias at #index from a SDF_AliasList by a new one. 
 * \param[in] arg SDF_AliasList to retrieve the SDF_Alias from
 * \param[in] elem new SDF_Alias to replace another
 * \param[in] index index to use to point in the SDF_AliasList
 * \return A new SDF_AliasListwith #elem replaced in #arg at position #index
 */
SDF_AliasList SDF_replaceAliasListAliasAt(SDF_AliasList arg, SDF_Alias elem, int index) {
 return (SDF_AliasList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_AliasList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem2 One SDF_Alias element of the new SDF_AliasList
 * \return A new SDF_AliasList consisting of 2 SDF_Aliass
 */
SDF_AliasList SDF_makeAliasList2(SDF_OptLayout wsAfterHead, SDF_Alias elem1, SDF_Alias elem2) {
  return SDF_makeAliasListMany(elem1, wsAfterHead, SDF_makeAliasListSingle(elem2));
}

/**
 * Builds a SDF_AliasList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem2 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem3 One SDF_Alias element of the new SDF_AliasList
 * \return A new SDF_AliasList consisting of 3 SDF_Aliass
 */
SDF_AliasList SDF_makeAliasList3(SDF_OptLayout wsAfterHead, SDF_Alias elem1, SDF_Alias elem2, SDF_Alias elem3) {
  return SDF_makeAliasListMany(elem1, wsAfterHead, SDF_makeAliasList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_AliasList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem2 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem3 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem4 One SDF_Alias element of the new SDF_AliasList
 * \return A new SDF_AliasList consisting of 4 SDF_Aliass
 */
SDF_AliasList SDF_makeAliasList4(SDF_OptLayout wsAfterHead, SDF_Alias elem1, SDF_Alias elem2, SDF_Alias elem3, SDF_Alias elem4) {
  return SDF_makeAliasListMany(elem1, wsAfterHead, SDF_makeAliasList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_AliasList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem2 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem3 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem4 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem5 One SDF_Alias element of the new SDF_AliasList
 * \return A new SDF_AliasList consisting of 5 SDF_Aliass
 */
SDF_AliasList SDF_makeAliasList5(SDF_OptLayout wsAfterHead, SDF_Alias elem1, SDF_Alias elem2, SDF_Alias elem3, SDF_Alias elem4, SDF_Alias elem5) {
  return SDF_makeAliasListMany(elem1, wsAfterHead, SDF_makeAliasList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_AliasList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem2 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem3 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem4 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem5 One SDF_Alias element of the new SDF_AliasList
 * \param[in] elem6 One SDF_Alias element of the new SDF_AliasList
 * \return A new SDF_AliasList consisting of 6 SDF_Aliass
 */
SDF_AliasList SDF_makeAliasList6(SDF_OptLayout wsAfterHead, SDF_Alias elem1, SDF_Alias elem2, SDF_Alias elem3, SDF_Alias elem4, SDF_Alias elem5, SDF_Alias elem6) {
  return SDF_makeAliasListMany(elem1, wsAfterHead, SDF_makeAliasList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_AttributeList. 
 * \param[in] arg input SDF_AttributeList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getAttributeListLength (SDF_AttributeList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_AttributeList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_AttributeList to be reversed
 * \return #arg reversed
 */
SDF_AttributeList SDF_reverseAttributeList(SDF_AttributeList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_AttributeList) result;
}

/**
 * Append a SDF_Attribute to the end of a SDF_AttributeList. 
 * \param[in] arg SDF_AttributeList to append the SDF_Attribute to
 * \param[in] elem SDF_Attribute to be appended
 * \return new SDF_AttributeList with #elem appended after the separators
 */
SDF_AttributeList SDF_appendAttributeList(SDF_AttributeList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute arg1) {
  return SDF_concatAttributeList(arg0, wsAfterHead, wsAfterSep, SDF_makeAttributeListSingle(arg1));
}

/**
 * Concatenate two SDF_AttributeLists. 
 * \param[in] arg0 first SDF_AttributeList
 * \param[in] arg1 second SDF_AttributeList
 * \return SDF_AttributeList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_AttributeList SDF_concatAttributeList(SDF_AttributeList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_AttributeList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeAttributeListMany((SDF_Attribute)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_AttributeList) ATgetNext((ATermList) arg1);
  return (SDF_AttributeList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_AttributeList. 
 * \param[in] arg SDF_AttributeList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_AttributeList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_AttributeList SDF_sliceAttributeList(SDF_AttributeList arg, int start, int end) {
  return (SDF_AttributeList) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Attribute at #index from a SDF_AttributeList. 
 * \param[in] arg SDF_AttributeList to retrieve the SDF_Attribute from
 * \param[in] index index to use to point in the SDF_AttributeList
 * \return SDF_Attribute at position #index in #arg
 */
SDF_Attribute SDF_getAttributeListAttributeAt(SDF_AttributeList arg, int index) {
 return (SDF_Attribute)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Attribute at #index from a SDF_AttributeList by a new one. 
 * \param[in] arg SDF_AttributeList to retrieve the SDF_Attribute from
 * \param[in] elem new SDF_Attribute to replace another
 * \param[in] index index to use to point in the SDF_AttributeList
 * \return A new SDF_AttributeListwith #elem replaced in #arg at position #index
 */
SDF_AttributeList SDF_replaceAttributeListAttributeAt(SDF_AttributeList arg, SDF_Attribute elem, int index) {
 return (SDF_AttributeList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_AttributeList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem2 One SDF_Attribute element of the new SDF_AttributeList
 * \return A new SDF_AttributeList consisting of 2 SDF_Attributes
 */
SDF_AttributeList SDF_makeAttributeList2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute elem1, SDF_Attribute elem2) {
  return SDF_makeAttributeListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeAttributeListSingle(elem2));
}

/**
 * Builds a SDF_AttributeList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem2 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem3 One SDF_Attribute element of the new SDF_AttributeList
 * \return A new SDF_AttributeList consisting of 3 SDF_Attributes
 */
SDF_AttributeList SDF_makeAttributeList3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute elem1, SDF_Attribute elem2, SDF_Attribute elem3) {
  return SDF_makeAttributeListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeAttributeList2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_AttributeList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem2 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem3 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem4 One SDF_Attribute element of the new SDF_AttributeList
 * \return A new SDF_AttributeList consisting of 4 SDF_Attributes
 */
SDF_AttributeList SDF_makeAttributeList4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute elem1, SDF_Attribute elem2, SDF_Attribute elem3, SDF_Attribute elem4) {
  return SDF_makeAttributeListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeAttributeList3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_AttributeList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem2 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem3 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem4 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem5 One SDF_Attribute element of the new SDF_AttributeList
 * \return A new SDF_AttributeList consisting of 5 SDF_Attributes
 */
SDF_AttributeList SDF_makeAttributeList5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute elem1, SDF_Attribute elem2, SDF_Attribute elem3, SDF_Attribute elem4, SDF_Attribute elem5) {
  return SDF_makeAttributeListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeAttributeList4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_AttributeList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem2 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem3 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem4 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem5 One SDF_Attribute element of the new SDF_AttributeList
 * \param[in] elem6 One SDF_Attribute element of the new SDF_AttributeList
 * \return A new SDF_AttributeList consisting of 6 SDF_Attributes
 */
SDF_AttributeList SDF_makeAttributeList6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Attribute elem1, SDF_Attribute elem2, SDF_Attribute elem3, SDF_Attribute elem4, SDF_Attribute elem5, SDF_Attribute elem6) {
  return SDF_makeAttributeListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeAttributeList5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ProductionList. 
 * \param[in] arg input SDF_ProductionList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getProductionListLength (SDF_ProductionList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_ProductionList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ProductionList to be reversed
 * \return #arg reversed
 */
SDF_ProductionList SDF_reverseProductionList(SDF_ProductionList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ProductionList) result;
}

/**
 * Append a SDF_Production to the end of a SDF_ProductionList. 
 * \param[in] arg SDF_ProductionList to append the SDF_Production to
 * \param[in] elem SDF_Production to be appended
 * \return new SDF_ProductionList with #elem appended after the separators
 */
SDF_ProductionList SDF_appendProductionList(SDF_ProductionList arg0, SDF_OptLayout wsAfterHead, SDF_Production arg1) {
  return SDF_concatProductionList(arg0, wsAfterHead, SDF_makeProductionListSingle(arg1));
}

/**
 * Concatenate two SDF_ProductionLists. 
 * \param[in] arg0 first SDF_ProductionList
 * \param[in] arg1 second SDF_ProductionList
 * \return SDF_ProductionList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ProductionList SDF_concatProductionList(SDF_ProductionList arg0, SDF_OptLayout wsAfterHead, SDF_ProductionList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeProductionListMany((SDF_Production)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_ProductionList) ATgetNext((ATermList) arg1);
  return (SDF_ProductionList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ProductionList. 
 * \param[in] arg SDF_ProductionList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ProductionList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ProductionList SDF_sliceProductionList(SDF_ProductionList arg, int start, int end) {
  return (SDF_ProductionList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Production at #index from a SDF_ProductionList. 
 * \param[in] arg SDF_ProductionList to retrieve the SDF_Production from
 * \param[in] index index to use to point in the SDF_ProductionList
 * \return SDF_Production at position #index in #arg
 */
SDF_Production SDF_getProductionListProductionAt(SDF_ProductionList arg, int index) {
 return (SDF_Production)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Production at #index from a SDF_ProductionList by a new one. 
 * \param[in] arg SDF_ProductionList to retrieve the SDF_Production from
 * \param[in] elem new SDF_Production to replace another
 * \param[in] index index to use to point in the SDF_ProductionList
 * \return A new SDF_ProductionListwith #elem replaced in #arg at position #index
 */
SDF_ProductionList SDF_replaceProductionListProductionAt(SDF_ProductionList arg, SDF_Production elem, int index) {
 return (SDF_ProductionList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_ProductionList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem2 One SDF_Production element of the new SDF_ProductionList
 * \return A new SDF_ProductionList consisting of 2 SDF_Productions
 */
SDF_ProductionList SDF_makeProductionList2(SDF_OptLayout wsAfterHead, SDF_Production elem1, SDF_Production elem2) {
  return SDF_makeProductionListMany(elem1, wsAfterHead, SDF_makeProductionListSingle(elem2));
}

/**
 * Builds a SDF_ProductionList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem2 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem3 One SDF_Production element of the new SDF_ProductionList
 * \return A new SDF_ProductionList consisting of 3 SDF_Productions
 */
SDF_ProductionList SDF_makeProductionList3(SDF_OptLayout wsAfterHead, SDF_Production elem1, SDF_Production elem2, SDF_Production elem3) {
  return SDF_makeProductionListMany(elem1, wsAfterHead, SDF_makeProductionList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_ProductionList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem2 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem3 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem4 One SDF_Production element of the new SDF_ProductionList
 * \return A new SDF_ProductionList consisting of 4 SDF_Productions
 */
SDF_ProductionList SDF_makeProductionList4(SDF_OptLayout wsAfterHead, SDF_Production elem1, SDF_Production elem2, SDF_Production elem3, SDF_Production elem4) {
  return SDF_makeProductionListMany(elem1, wsAfterHead, SDF_makeProductionList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ProductionList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem2 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem3 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem4 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem5 One SDF_Production element of the new SDF_ProductionList
 * \return A new SDF_ProductionList consisting of 5 SDF_Productions
 */
SDF_ProductionList SDF_makeProductionList5(SDF_OptLayout wsAfterHead, SDF_Production elem1, SDF_Production elem2, SDF_Production elem3, SDF_Production elem4, SDF_Production elem5) {
  return SDF_makeProductionListMany(elem1, wsAfterHead, SDF_makeProductionList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ProductionList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem2 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem3 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem4 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem5 One SDF_Production element of the new SDF_ProductionList
 * \param[in] elem6 One SDF_Production element of the new SDF_ProductionList
 * \return A new SDF_ProductionList consisting of 6 SDF_Productions
 */
SDF_ProductionList SDF_makeProductionList6(SDF_OptLayout wsAfterHead, SDF_Production elem1, SDF_Production elem2, SDF_Production elem3, SDF_Production elem4, SDF_Production elem5, SDF_Production elem6) {
  return SDF_makeProductionListMany(elem1, wsAfterHead, SDF_makeProductionList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the length of a SDF_LexSingleQuotedStrCharChars. 
 * \param[in] arg input SDF_LexSingleQuotedStrCharChars
 * \return The number of elements in the SDF_LexSingleQuotedStrCharChars
 */
int SDF_getLexSingleQuotedStrCharCharsLength (SDF_LexSingleQuotedStrCharChars arg) {
  return ATgetLength((ATermList) arg);
}

/**
 * Reverse a SDF_LexSingleQuotedStrCharChars. 
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to be reversed
 * \return a reversed #arg
 */
SDF_LexSingleQuotedStrCharChars SDF_reverseLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars arg) {
  return (SDF_LexSingleQuotedStrCharChars) ATreverse((ATermList) arg);
}

/**
 * Append a SDF_LexSingleQuotedStrChar to the end of a SDF_LexSingleQuotedStrCharChars. 
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to append the SDF_LexSingleQuotedStrChar to
 * \param[in] elem SDF_LexSingleQuotedStrChar to be appended
 * \return new SDF_LexSingleQuotedStrCharChars with #elem appended
 */
SDF_LexSingleQuotedStrCharChars SDF_appendLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars arg, SDF_LexSingleQuotedStrChar elem) {
  return (SDF_LexSingleQuotedStrCharChars) ATappend((ATermList) arg, (ATerm) ((ATerm) elem));
}

/**
 * Concatenate two SDF_LexSingleQuotedStrCharCharss. 
 * \param[in] arg0 first SDF_LexSingleQuotedStrCharChars
 * \param[in] arg1 second SDF_LexSingleQuotedStrCharChars
 * \return SDF_LexSingleQuotedStrCharChars with the elements of #arg0 before the elements of #arg1
 */
SDF_LexSingleQuotedStrCharChars SDF_concatLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars arg0, SDF_LexSingleQuotedStrCharChars arg1) {
  return (SDF_LexSingleQuotedStrCharChars) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_LexSingleQuotedStrCharChars. 
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_LexSingleQuotedStrCharChars with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_LexSingleQuotedStrCharChars SDF_sliceLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars arg, int start, int end) {
  return (SDF_LexSingleQuotedStrCharChars) ATgetSlice((ATermList) arg, start, end);
}

/**
 * Retrieve the SDF_LexSingleQuotedStrChar at #index from a SDF_LexSingleQuotedStrCharChars. 
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to retrieve the SDF_LexSingleQuotedStrChar from
 * \param[in] index index to use to point in the SDF_LexSingleQuotedStrCharChars
 * \return SDF_LexSingleQuotedStrChar at position #index in #arg
 */
SDF_LexSingleQuotedStrChar SDF_getLexSingleQuotedStrCharCharsLexSingleQuotedStrCharAt(SDF_LexSingleQuotedStrCharChars arg, int index) {
 return (SDF_LexSingleQuotedStrChar)ATelementAt((ATermList) arg,index);
}

/**
 * Replace the SDF_LexSingleQuotedStrChar at #index from a SDF_LexSingleQuotedStrCharChars by a new one. 
 * \param[in] arg SDF_LexSingleQuotedStrCharChars to retrieve the SDF_LexSingleQuotedStrChar from
 * \param[in] elem new SDF_LexSingleQuotedStrChar to replace another
 * \param[in] index index to use to point in the SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharCharswith #elem replaced in #arg at position #index
 */
SDF_LexSingleQuotedStrCharChars SDF_replaceLexSingleQuotedStrCharCharsLexSingleQuotedStrCharAt(SDF_LexSingleQuotedStrCharChars arg, SDF_LexSingleQuotedStrChar elem, int index) {
 return (SDF_LexSingleQuotedStrCharChars) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index);
}

/**
 * Builds a SDF_LexSingleQuotedStrCharChars of 2 consecutive elements. 
 * \param[in] elem1 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem2 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharChars consisting of 2 SDF_LexSingleQuotedStrChars
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharChars2(SDF_LexSingleQuotedStrChar elem1, SDF_LexSingleQuotedStrChar elem2) {
  return (SDF_LexSingleQuotedStrCharChars) ATmakeList2((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2));
}

/**
 * Builds a SDF_LexSingleQuotedStrCharChars of 3 consecutive elements. 
 * \param[in] elem1 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem2 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem3 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharChars consisting of 3 SDF_LexSingleQuotedStrChars
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharChars3(SDF_LexSingleQuotedStrChar elem1, SDF_LexSingleQuotedStrChar elem2, SDF_LexSingleQuotedStrChar elem3) {
  return (SDF_LexSingleQuotedStrCharChars) ATmakeList3((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3));
}

/**
 * Builds a SDF_LexSingleQuotedStrCharChars of 4 consecutive elements. 
 * \param[in] elem1 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem2 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem3 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem4 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharChars consisting of 4 SDF_LexSingleQuotedStrChars
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharChars4(SDF_LexSingleQuotedStrChar elem1, SDF_LexSingleQuotedStrChar elem2, SDF_LexSingleQuotedStrChar elem3, SDF_LexSingleQuotedStrChar elem4) {
  return (SDF_LexSingleQuotedStrCharChars) ATmakeList4((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4));
}

/**
 * Builds a SDF_LexSingleQuotedStrCharChars of 5 consecutive elements. 
 * \param[in] elem1 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem2 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem3 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem4 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem5 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharChars consisting of 5 SDF_LexSingleQuotedStrChars
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharChars5(SDF_LexSingleQuotedStrChar elem1, SDF_LexSingleQuotedStrChar elem2, SDF_LexSingleQuotedStrChar elem3, SDF_LexSingleQuotedStrChar elem4, SDF_LexSingleQuotedStrChar elem5) {
  return (SDF_LexSingleQuotedStrCharChars) ATmakeList5((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5));
}

/**
 * Builds a SDF_LexSingleQuotedStrCharChars of 6 consecutive elements. 
 * \param[in] elem1 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem2 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem3 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem4 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem5 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \param[in] elem6 One SDF_LexSingleQuotedStrChar element of the new SDF_LexSingleQuotedStrCharChars
 * \return A new SDF_LexSingleQuotedStrCharChars consisting of 6 SDF_LexSingleQuotedStrChars
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharChars6(SDF_LexSingleQuotedStrChar elem1, SDF_LexSingleQuotedStrChar elem2, SDF_LexSingleQuotedStrChar elem3, SDF_LexSingleQuotedStrChar elem4, SDF_LexSingleQuotedStrChar elem5, SDF_LexSingleQuotedStrChar elem6) {
  return (SDF_LexSingleQuotedStrCharChars) ATmakeList6((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5), (ATerm) ((ATerm) elem6));
}

/**
 * Retrieve the number of elements in a SDF_SymbolArguments. 
 * \param[in] arg input SDF_SymbolArguments
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSymbolArgumentsLength (SDF_SymbolArguments arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_SymbolArguments. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SymbolArguments to be reversed
 * \return #arg reversed
 */
SDF_SymbolArguments SDF_reverseSymbolArguments(SDF_SymbolArguments arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SymbolArguments) result;
}

/**
 * Append a SDF_Symbol to the end of a SDF_SymbolArguments. 
 * \param[in] arg SDF_SymbolArguments to append the SDF_Symbol to
 * \param[in] elem SDF_Symbol to be appended
 * \return new SDF_SymbolArguments with #elem appended after the separators
 */
SDF_SymbolArguments SDF_appendSymbolArguments(SDF_SymbolArguments arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol arg1) {
  return SDF_concatSymbolArguments(arg0, wsAfterHead, wsAfterSep, SDF_makeSymbolArgumentsSingle(arg1));
}

/**
 * Concatenate two SDF_SymbolArgumentss. 
 * \param[in] arg0 first SDF_SymbolArguments
 * \param[in] arg1 second SDF_SymbolArguments
 * \return SDF_SymbolArguments with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SymbolArguments SDF_concatSymbolArguments(SDF_SymbolArguments arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolArguments arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSymbolArgumentsMany((SDF_Symbol)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_SymbolArguments) ATgetNext((ATermList) arg1);
  return (SDF_SymbolArguments) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SymbolArguments. 
 * \param[in] arg SDF_SymbolArguments to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SymbolArguments with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SymbolArguments SDF_sliceSymbolArguments(SDF_SymbolArguments arg, int start, int end) {
  return (SDF_SymbolArguments) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Symbol at #index from a SDF_SymbolArguments. 
 * \param[in] arg SDF_SymbolArguments to retrieve the SDF_Symbol from
 * \param[in] index index to use to point in the SDF_SymbolArguments
 * \return SDF_Symbol at position #index in #arg
 */
SDF_Symbol SDF_getSymbolArgumentsSymbolAt(SDF_SymbolArguments arg, int index) {
 return (SDF_Symbol)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Symbol at #index from a SDF_SymbolArguments by a new one. 
 * \param[in] arg SDF_SymbolArguments to retrieve the SDF_Symbol from
 * \param[in] elem new SDF_Symbol to replace another
 * \param[in] index index to use to point in the SDF_SymbolArguments
 * \return A new SDF_SymbolArgumentswith #elem replaced in #arg at position #index
 */
SDF_SymbolArguments SDF_replaceSymbolArgumentsSymbolAt(SDF_SymbolArguments arg, SDF_Symbol elem, int index) {
 return (SDF_SymbolArguments) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_SymbolArguments of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolArguments
 * \return A new SDF_SymbolArguments consisting of 2 SDF_Symbols
 */
SDF_SymbolArguments SDF_makeSymbolArguments2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2) {
  return SDF_makeSymbolArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolArgumentsSingle(elem2));
}

/**
 * Builds a SDF_SymbolArguments of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolArguments
 * \return A new SDF_SymbolArguments consisting of 3 SDF_Symbols
 */
SDF_SymbolArguments SDF_makeSymbolArguments3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3) {
  return SDF_makeSymbolArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolArguments2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_SymbolArguments of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolArguments
 * \return A new SDF_SymbolArguments consisting of 4 SDF_Symbols
 */
SDF_SymbolArguments SDF_makeSymbolArguments4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4) {
  return SDF_makeSymbolArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolArguments3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SymbolArguments of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolArguments
 * \return A new SDF_SymbolArguments consisting of 5 SDF_Symbols
 */
SDF_SymbolArguments SDF_makeSymbolArguments5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5) {
  return SDF_makeSymbolArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolArguments4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SymbolArguments of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolArguments
 * \param[in] elem6 One SDF_Symbol element of the new SDF_SymbolArguments
 * \return A new SDF_SymbolArguments consisting of 6 SDF_Symbols
 */
SDF_SymbolArguments SDF_makeSymbolArguments6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5, SDF_Symbol elem6) {
  return SDF_makeSymbolArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolArguments5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ModuleList. 
 * \param[in] arg input SDF_ModuleList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getModuleListLength (SDF_ModuleList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_ModuleList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ModuleList to be reversed
 * \return #arg reversed
 */
SDF_ModuleList SDF_reverseModuleList(SDF_ModuleList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ModuleList) result;
}

/**
 * Append a SDF_Module to the end of a SDF_ModuleList. 
 * \param[in] arg SDF_ModuleList to append the SDF_Module to
 * \param[in] elem SDF_Module to be appended
 * \return new SDF_ModuleList with #elem appended after the separators
 */
SDF_ModuleList SDF_appendModuleList(SDF_ModuleList arg0, SDF_OptLayout wsAfterHead, SDF_Module arg1) {
  return SDF_concatModuleList(arg0, wsAfterHead, SDF_makeModuleListSingle(arg1));
}

/**
 * Concatenate two SDF_ModuleLists. 
 * \param[in] arg0 first SDF_ModuleList
 * \param[in] arg1 second SDF_ModuleList
 * \return SDF_ModuleList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ModuleList SDF_concatModuleList(SDF_ModuleList arg0, SDF_OptLayout wsAfterHead, SDF_ModuleList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeModuleListMany((SDF_Module)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_ModuleList) ATgetNext((ATermList) arg1);
  return (SDF_ModuleList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ModuleList. 
 * \param[in] arg SDF_ModuleList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ModuleList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ModuleList SDF_sliceModuleList(SDF_ModuleList arg, int start, int end) {
  return (SDF_ModuleList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Module at #index from a SDF_ModuleList. 
 * \param[in] arg SDF_ModuleList to retrieve the SDF_Module from
 * \param[in] index index to use to point in the SDF_ModuleList
 * \return SDF_Module at position #index in #arg
 */
SDF_Module SDF_getModuleListModuleAt(SDF_ModuleList arg, int index) {
 return (SDF_Module)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Module at #index from a SDF_ModuleList by a new one. 
 * \param[in] arg SDF_ModuleList to retrieve the SDF_Module from
 * \param[in] elem new SDF_Module to replace another
 * \param[in] index index to use to point in the SDF_ModuleList
 * \return A new SDF_ModuleListwith #elem replaced in #arg at position #index
 */
SDF_ModuleList SDF_replaceModuleListModuleAt(SDF_ModuleList arg, SDF_Module elem, int index) {
 return (SDF_ModuleList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_ModuleList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem2 One SDF_Module element of the new SDF_ModuleList
 * \return A new SDF_ModuleList consisting of 2 SDF_Modules
 */
SDF_ModuleList SDF_makeModuleList2(SDF_OptLayout wsAfterHead, SDF_Module elem1, SDF_Module elem2) {
  return SDF_makeModuleListMany(elem1, wsAfterHead, SDF_makeModuleListSingle(elem2));
}

/**
 * Builds a SDF_ModuleList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem2 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem3 One SDF_Module element of the new SDF_ModuleList
 * \return A new SDF_ModuleList consisting of 3 SDF_Modules
 */
SDF_ModuleList SDF_makeModuleList3(SDF_OptLayout wsAfterHead, SDF_Module elem1, SDF_Module elem2, SDF_Module elem3) {
  return SDF_makeModuleListMany(elem1, wsAfterHead, SDF_makeModuleList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_ModuleList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem2 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem3 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem4 One SDF_Module element of the new SDF_ModuleList
 * \return A new SDF_ModuleList consisting of 4 SDF_Modules
 */
SDF_ModuleList SDF_makeModuleList4(SDF_OptLayout wsAfterHead, SDF_Module elem1, SDF_Module elem2, SDF_Module elem3, SDF_Module elem4) {
  return SDF_makeModuleListMany(elem1, wsAfterHead, SDF_makeModuleList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ModuleList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem2 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem3 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem4 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem5 One SDF_Module element of the new SDF_ModuleList
 * \return A new SDF_ModuleList consisting of 5 SDF_Modules
 */
SDF_ModuleList SDF_makeModuleList5(SDF_OptLayout wsAfterHead, SDF_Module elem1, SDF_Module elem2, SDF_Module elem3, SDF_Module elem4, SDF_Module elem5) {
  return SDF_makeModuleListMany(elem1, wsAfterHead, SDF_makeModuleList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ModuleList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem2 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem3 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem4 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem5 One SDF_Module element of the new SDF_ModuleList
 * \param[in] elem6 One SDF_Module element of the new SDF_ModuleList
 * \return A new SDF_ModuleList consisting of 6 SDF_Modules
 */
SDF_ModuleList SDF_makeModuleList6(SDF_OptLayout wsAfterHead, SDF_Module elem1, SDF_Module elem2, SDF_Module elem3, SDF_Module elem4, SDF_Module elem5, SDF_Module elem6) {
  return SDF_makeModuleListMany(elem1, wsAfterHead, SDF_makeModuleList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ImpSectionList. 
 * \param[in] arg input SDF_ImpSectionList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getImpSectionListLength (SDF_ImpSectionList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_ImpSectionList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ImpSectionList to be reversed
 * \return #arg reversed
 */
SDF_ImpSectionList SDF_reverseImpSectionList(SDF_ImpSectionList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ImpSectionList) result;
}

/**
 * Append a SDF_ImpSection to the end of a SDF_ImpSectionList. 
 * \param[in] arg SDF_ImpSectionList to append the SDF_ImpSection to
 * \param[in] elem SDF_ImpSection to be appended
 * \return new SDF_ImpSectionList with #elem appended after the separators
 */
SDF_ImpSectionList SDF_appendImpSectionList(SDF_ImpSectionList arg0, SDF_OptLayout wsAfterHead, SDF_ImpSection arg1) {
  return SDF_concatImpSectionList(arg0, wsAfterHead, SDF_makeImpSectionListSingle(arg1));
}

/**
 * Concatenate two SDF_ImpSectionLists. 
 * \param[in] arg0 first SDF_ImpSectionList
 * \param[in] arg1 second SDF_ImpSectionList
 * \return SDF_ImpSectionList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ImpSectionList SDF_concatImpSectionList(SDF_ImpSectionList arg0, SDF_OptLayout wsAfterHead, SDF_ImpSectionList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeImpSectionListMany((SDF_ImpSection)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_ImpSectionList) ATgetNext((ATermList) arg1);
  return (SDF_ImpSectionList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ImpSectionList. 
 * \param[in] arg SDF_ImpSectionList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ImpSectionList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ImpSectionList SDF_sliceImpSectionList(SDF_ImpSectionList arg, int start, int end) {
  return (SDF_ImpSectionList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_ImpSection at #index from a SDF_ImpSectionList. 
 * \param[in] arg SDF_ImpSectionList to retrieve the SDF_ImpSection from
 * \param[in] index index to use to point in the SDF_ImpSectionList
 * \return SDF_ImpSection at position #index in #arg
 */
SDF_ImpSection SDF_getImpSectionListImpSectionAt(SDF_ImpSectionList arg, int index) {
 return (SDF_ImpSection)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_ImpSection at #index from a SDF_ImpSectionList by a new one. 
 * \param[in] arg SDF_ImpSectionList to retrieve the SDF_ImpSection from
 * \param[in] elem new SDF_ImpSection to replace another
 * \param[in] index index to use to point in the SDF_ImpSectionList
 * \return A new SDF_ImpSectionListwith #elem replaced in #arg at position #index
 */
SDF_ImpSectionList SDF_replaceImpSectionListImpSectionAt(SDF_ImpSectionList arg, SDF_ImpSection elem, int index) {
 return (SDF_ImpSectionList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_ImpSectionList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem2 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \return A new SDF_ImpSectionList consisting of 2 SDF_ImpSections
 */
SDF_ImpSectionList SDF_makeImpSectionList2(SDF_OptLayout wsAfterHead, SDF_ImpSection elem1, SDF_ImpSection elem2) {
  return SDF_makeImpSectionListMany(elem1, wsAfterHead, SDF_makeImpSectionListSingle(elem2));
}

/**
 * Builds a SDF_ImpSectionList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem2 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem3 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \return A new SDF_ImpSectionList consisting of 3 SDF_ImpSections
 */
SDF_ImpSectionList SDF_makeImpSectionList3(SDF_OptLayout wsAfterHead, SDF_ImpSection elem1, SDF_ImpSection elem2, SDF_ImpSection elem3) {
  return SDF_makeImpSectionListMany(elem1, wsAfterHead, SDF_makeImpSectionList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_ImpSectionList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem2 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem3 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem4 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \return A new SDF_ImpSectionList consisting of 4 SDF_ImpSections
 */
SDF_ImpSectionList SDF_makeImpSectionList4(SDF_OptLayout wsAfterHead, SDF_ImpSection elem1, SDF_ImpSection elem2, SDF_ImpSection elem3, SDF_ImpSection elem4) {
  return SDF_makeImpSectionListMany(elem1, wsAfterHead, SDF_makeImpSectionList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ImpSectionList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem2 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem3 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem4 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem5 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \return A new SDF_ImpSectionList consisting of 5 SDF_ImpSections
 */
SDF_ImpSectionList SDF_makeImpSectionList5(SDF_OptLayout wsAfterHead, SDF_ImpSection elem1, SDF_ImpSection elem2, SDF_ImpSection elem3, SDF_ImpSection elem4, SDF_ImpSection elem5) {
  return SDF_makeImpSectionListMany(elem1, wsAfterHead, SDF_makeImpSectionList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ImpSectionList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem2 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem3 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem4 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem5 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \param[in] elem6 One SDF_ImpSection element of the new SDF_ImpSectionList
 * \return A new SDF_ImpSectionList consisting of 6 SDF_ImpSections
 */
SDF_ImpSectionList SDF_makeImpSectionList6(SDF_OptLayout wsAfterHead, SDF_ImpSection elem1, SDF_ImpSection elem2, SDF_ImpSection elem3, SDF_ImpSection elem4, SDF_ImpSection elem5, SDF_ImpSection elem6) {
  return SDF_makeImpSectionListMany(elem1, wsAfterHead, SDF_makeImpSectionList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_SectionList. 
 * \param[in] arg input SDF_SectionList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSectionListLength (SDF_SectionList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_SectionList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SectionList to be reversed
 * \return #arg reversed
 */
SDF_SectionList SDF_reverseSectionList(SDF_SectionList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SectionList) result;
}

/**
 * Append a SDF_Section to the end of a SDF_SectionList. 
 * \param[in] arg SDF_SectionList to append the SDF_Section to
 * \param[in] elem SDF_Section to be appended
 * \return new SDF_SectionList with #elem appended after the separators
 */
SDF_SectionList SDF_appendSectionList(SDF_SectionList arg0, SDF_OptLayout wsAfterHead, SDF_Section arg1) {
  return SDF_concatSectionList(arg0, wsAfterHead, SDF_makeSectionListSingle(arg1));
}

/**
 * Concatenate two SDF_SectionLists. 
 * \param[in] arg0 first SDF_SectionList
 * \param[in] arg1 second SDF_SectionList
 * \return SDF_SectionList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SectionList SDF_concatSectionList(SDF_SectionList arg0, SDF_OptLayout wsAfterHead, SDF_SectionList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSectionListMany((SDF_Section)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_SectionList) ATgetNext((ATermList) arg1);
  return (SDF_SectionList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SectionList. 
 * \param[in] arg SDF_SectionList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SectionList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SectionList SDF_sliceSectionList(SDF_SectionList arg, int start, int end) {
  return (SDF_SectionList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Section at #index from a SDF_SectionList. 
 * \param[in] arg SDF_SectionList to retrieve the SDF_Section from
 * \param[in] index index to use to point in the SDF_SectionList
 * \return SDF_Section at position #index in #arg
 */
SDF_Section SDF_getSectionListSectionAt(SDF_SectionList arg, int index) {
 return (SDF_Section)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Section at #index from a SDF_SectionList by a new one. 
 * \param[in] arg SDF_SectionList to retrieve the SDF_Section from
 * \param[in] elem new SDF_Section to replace another
 * \param[in] index index to use to point in the SDF_SectionList
 * \return A new SDF_SectionListwith #elem replaced in #arg at position #index
 */
SDF_SectionList SDF_replaceSectionListSectionAt(SDF_SectionList arg, SDF_Section elem, int index) {
 return (SDF_SectionList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_SectionList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem2 One SDF_Section element of the new SDF_SectionList
 * \return A new SDF_SectionList consisting of 2 SDF_Sections
 */
SDF_SectionList SDF_makeSectionList2(SDF_OptLayout wsAfterHead, SDF_Section elem1, SDF_Section elem2) {
  return SDF_makeSectionListMany(elem1, wsAfterHead, SDF_makeSectionListSingle(elem2));
}

/**
 * Builds a SDF_SectionList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem2 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem3 One SDF_Section element of the new SDF_SectionList
 * \return A new SDF_SectionList consisting of 3 SDF_Sections
 */
SDF_SectionList SDF_makeSectionList3(SDF_OptLayout wsAfterHead, SDF_Section elem1, SDF_Section elem2, SDF_Section elem3) {
  return SDF_makeSectionListMany(elem1, wsAfterHead, SDF_makeSectionList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_SectionList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem2 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem3 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem4 One SDF_Section element of the new SDF_SectionList
 * \return A new SDF_SectionList consisting of 4 SDF_Sections
 */
SDF_SectionList SDF_makeSectionList4(SDF_OptLayout wsAfterHead, SDF_Section elem1, SDF_Section elem2, SDF_Section elem3, SDF_Section elem4) {
  return SDF_makeSectionListMany(elem1, wsAfterHead, SDF_makeSectionList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SectionList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem2 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem3 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem4 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem5 One SDF_Section element of the new SDF_SectionList
 * \return A new SDF_SectionList consisting of 5 SDF_Sections
 */
SDF_SectionList SDF_makeSectionList5(SDF_OptLayout wsAfterHead, SDF_Section elem1, SDF_Section elem2, SDF_Section elem3, SDF_Section elem4, SDF_Section elem5) {
  return SDF_makeSectionListMany(elem1, wsAfterHead, SDF_makeSectionList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SectionList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem2 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem3 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem4 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem5 One SDF_Section element of the new SDF_SectionList
 * \param[in] elem6 One SDF_Section element of the new SDF_SectionList
 * \return A new SDF_SectionList consisting of 6 SDF_Sections
 */
SDF_SectionList SDF_makeSectionList6(SDF_OptLayout wsAfterHead, SDF_Section elem1, SDF_Section elem2, SDF_Section elem3, SDF_Section elem4, SDF_Section elem5, SDF_Section elem6) {
  return SDF_makeSectionListMany(elem1, wsAfterHead, SDF_makeSectionList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_ImportList. 
 * \param[in] arg input SDF_ImportList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getImportListLength (SDF_ImportList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_ImportList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_ImportList to be reversed
 * \return #arg reversed
 */
SDF_ImportList SDF_reverseImportList(SDF_ImportList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_ImportList) result;
}

/**
 * Append a SDF_Import to the end of a SDF_ImportList. 
 * \param[in] arg SDF_ImportList to append the SDF_Import to
 * \param[in] elem SDF_Import to be appended
 * \return new SDF_ImportList with #elem appended after the separators
 */
SDF_ImportList SDF_appendImportList(SDF_ImportList arg0, SDF_OptLayout wsAfterHead, SDF_Import arg1) {
  return SDF_concatImportList(arg0, wsAfterHead, SDF_makeImportListSingle(arg1));
}

/**
 * Concatenate two SDF_ImportLists. 
 * \param[in] arg0 first SDF_ImportList
 * \param[in] arg1 second SDF_ImportList
 * \return SDF_ImportList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_ImportList SDF_concatImportList(SDF_ImportList arg0, SDF_OptLayout wsAfterHead, SDF_ImportList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeImportListMany((SDF_Import)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_ImportList) ATgetNext((ATermList) arg1);
  return (SDF_ImportList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_ImportList. 
 * \param[in] arg SDF_ImportList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_ImportList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_ImportList SDF_sliceImportList(SDF_ImportList arg, int start, int end) {
  return (SDF_ImportList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Import at #index from a SDF_ImportList. 
 * \param[in] arg SDF_ImportList to retrieve the SDF_Import from
 * \param[in] index index to use to point in the SDF_ImportList
 * \return SDF_Import at position #index in #arg
 */
SDF_Import SDF_getImportListImportAt(SDF_ImportList arg, int index) {
 return (SDF_Import)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Import at #index from a SDF_ImportList by a new one. 
 * \param[in] arg SDF_ImportList to retrieve the SDF_Import from
 * \param[in] elem new SDF_Import to replace another
 * \param[in] index index to use to point in the SDF_ImportList
 * \return A new SDF_ImportListwith #elem replaced in #arg at position #index
 */
SDF_ImportList SDF_replaceImportListImportAt(SDF_ImportList arg, SDF_Import elem, int index) {
 return (SDF_ImportList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_ImportList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem2 One SDF_Import element of the new SDF_ImportList
 * \return A new SDF_ImportList consisting of 2 SDF_Imports
 */
SDF_ImportList SDF_makeImportList2(SDF_OptLayout wsAfterHead, SDF_Import elem1, SDF_Import elem2) {
  return SDF_makeImportListMany(elem1, wsAfterHead, SDF_makeImportListSingle(elem2));
}

/**
 * Builds a SDF_ImportList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem2 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem3 One SDF_Import element of the new SDF_ImportList
 * \return A new SDF_ImportList consisting of 3 SDF_Imports
 */
SDF_ImportList SDF_makeImportList3(SDF_OptLayout wsAfterHead, SDF_Import elem1, SDF_Import elem2, SDF_Import elem3) {
  return SDF_makeImportListMany(elem1, wsAfterHead, SDF_makeImportList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_ImportList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem2 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem3 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem4 One SDF_Import element of the new SDF_ImportList
 * \return A new SDF_ImportList consisting of 4 SDF_Imports
 */
SDF_ImportList SDF_makeImportList4(SDF_OptLayout wsAfterHead, SDF_Import elem1, SDF_Import elem2, SDF_Import elem3, SDF_Import elem4) {
  return SDF_makeImportListMany(elem1, wsAfterHead, SDF_makeImportList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_ImportList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem2 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem3 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem4 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem5 One SDF_Import element of the new SDF_ImportList
 * \return A new SDF_ImportList consisting of 5 SDF_Imports
 */
SDF_ImportList SDF_makeImportList5(SDF_OptLayout wsAfterHead, SDF_Import elem1, SDF_Import elem2, SDF_Import elem3, SDF_Import elem4, SDF_Import elem5) {
  return SDF_makeImportListMany(elem1, wsAfterHead, SDF_makeImportList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_ImportList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem2 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem3 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem4 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem5 One SDF_Import element of the new SDF_ImportList
 * \param[in] elem6 One SDF_Import element of the new SDF_ImportList
 * \return A new SDF_ImportList consisting of 6 SDF_Imports
 */
SDF_ImportList SDF_makeImportList6(SDF_OptLayout wsAfterHead, SDF_Import elem1, SDF_Import elem2, SDF_Import elem3, SDF_Import elem4, SDF_Import elem5, SDF_Import elem6) {
  return SDF_makeImportListMany(elem1, wsAfterHead, SDF_makeImportList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_NatConArguments. 
 * \param[in] arg input SDF_NatConArguments
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getNatConArgumentsLength (SDF_NatConArguments arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_NatConArguments. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_NatConArguments to be reversed
 * \return #arg reversed
 */
SDF_NatConArguments SDF_reverseNatConArguments(SDF_NatConArguments arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_NatConArguments) result;
}

/**
 * Append a SDF_NatCon to the end of a SDF_NatConArguments. 
 * \param[in] arg SDF_NatConArguments to append the SDF_NatCon to
 * \param[in] elem SDF_NatCon to be appended
 * \return new SDF_NatConArguments with #elem appended after the separators
 */
SDF_NatConArguments SDF_appendNatConArguments(SDF_NatConArguments arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon arg1) {
  return SDF_concatNatConArguments(arg0, wsAfterHead, wsAfterSep, SDF_makeNatConArgumentsSingle(arg1));
}

/**
 * Concatenate two SDF_NatConArgumentss. 
 * \param[in] arg0 first SDF_NatConArguments
 * \param[in] arg1 second SDF_NatConArguments
 * \return SDF_NatConArguments with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_NatConArguments SDF_concatNatConArguments(SDF_NatConArguments arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatConArguments arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeNatConArgumentsMany((SDF_NatCon)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_NatConArguments) ATgetNext((ATermList) arg1);
  return (SDF_NatConArguments) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_NatConArguments. 
 * \param[in] arg SDF_NatConArguments to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_NatConArguments with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_NatConArguments SDF_sliceNatConArguments(SDF_NatConArguments arg, int start, int end) {
  return (SDF_NatConArguments) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_NatCon at #index from a SDF_NatConArguments. 
 * \param[in] arg SDF_NatConArguments to retrieve the SDF_NatCon from
 * \param[in] index index to use to point in the SDF_NatConArguments
 * \return SDF_NatCon at position #index in #arg
 */
SDF_NatCon SDF_getNatConArgumentsNatConAt(SDF_NatConArguments arg, int index) {
 return (SDF_NatCon)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_NatCon at #index from a SDF_NatConArguments by a new one. 
 * \param[in] arg SDF_NatConArguments to retrieve the SDF_NatCon from
 * \param[in] elem new SDF_NatCon to replace another
 * \param[in] index index to use to point in the SDF_NatConArguments
 * \return A new SDF_NatConArgumentswith #elem replaced in #arg at position #index
 */
SDF_NatConArguments SDF_replaceNatConArgumentsNatConAt(SDF_NatConArguments arg, SDF_NatCon elem, int index) {
 return (SDF_NatConArguments) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_NatConArguments of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem2 One SDF_NatCon element of the new SDF_NatConArguments
 * \return A new SDF_NatConArguments consisting of 2 SDF_NatCons
 */
SDF_NatConArguments SDF_makeNatConArguments2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon elem1, SDF_NatCon elem2) {
  return SDF_makeNatConArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeNatConArgumentsSingle(elem2));
}

/**
 * Builds a SDF_NatConArguments of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem2 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem3 One SDF_NatCon element of the new SDF_NatConArguments
 * \return A new SDF_NatConArguments consisting of 3 SDF_NatCons
 */
SDF_NatConArguments SDF_makeNatConArguments3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon elem1, SDF_NatCon elem2, SDF_NatCon elem3) {
  return SDF_makeNatConArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeNatConArguments2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_NatConArguments of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem2 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem3 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem4 One SDF_NatCon element of the new SDF_NatConArguments
 * \return A new SDF_NatConArguments consisting of 4 SDF_NatCons
 */
SDF_NatConArguments SDF_makeNatConArguments4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon elem1, SDF_NatCon elem2, SDF_NatCon elem3, SDF_NatCon elem4) {
  return SDF_makeNatConArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeNatConArguments3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_NatConArguments of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem2 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem3 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem4 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem5 One SDF_NatCon element of the new SDF_NatConArguments
 * \return A new SDF_NatConArguments consisting of 5 SDF_NatCons
 */
SDF_NatConArguments SDF_makeNatConArguments5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon elem1, SDF_NatCon elem2, SDF_NatCon elem3, SDF_NatCon elem4, SDF_NatCon elem5) {
  return SDF_makeNatConArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeNatConArguments4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_NatConArguments of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem2 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem3 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem4 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem5 One SDF_NatCon element of the new SDF_NatConArguments
 * \param[in] elem6 One SDF_NatCon element of the new SDF_NatConArguments
 * \return A new SDF_NatConArguments consisting of 6 SDF_NatCons
 */
SDF_NatConArguments SDF_makeNatConArguments6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatCon elem1, SDF_NatCon elem2, SDF_NatCon elem3, SDF_NatCon elem4, SDF_NatCon elem5, SDF_NatCon elem6) {
  return SDF_makeNatConArgumentsMany(elem1, wsAfterHead, wsAfterSep, SDF_makeNatConArguments5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_GroupList. 
 * \param[in] arg input SDF_GroupList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getGroupListLength (SDF_GroupList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_GroupList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_GroupList to be reversed
 * \return #arg reversed
 */
SDF_GroupList SDF_reverseGroupList(SDF_GroupList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_GroupList) result;
}

/**
 * Append a SDF_Group to the end of a SDF_GroupList. 
 * \param[in] arg SDF_GroupList to append the SDF_Group to
 * \param[in] elem SDF_Group to be appended
 * \return new SDF_GroupList with #elem appended after the separators
 */
SDF_GroupList SDF_appendGroupList(SDF_GroupList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group arg1) {
  return SDF_concatGroupList(arg0, wsAfterHead, wsAfterSep, SDF_makeGroupListSingle(arg1));
}

/**
 * Concatenate two SDF_GroupLists. 
 * \param[in] arg0 first SDF_GroupList
 * \param[in] arg1 second SDF_GroupList
 * \return SDF_GroupList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_GroupList SDF_concatGroupList(SDF_GroupList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_GroupList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeGroupListMany((SDF_Group)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_GroupList) ATgetNext((ATermList) arg1);
  return (SDF_GroupList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_GroupList. 
 * \param[in] arg SDF_GroupList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_GroupList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_GroupList SDF_sliceGroupList(SDF_GroupList arg, int start, int end) {
  return (SDF_GroupList) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Group at #index from a SDF_GroupList. 
 * \param[in] arg SDF_GroupList to retrieve the SDF_Group from
 * \param[in] index index to use to point in the SDF_GroupList
 * \return SDF_Group at position #index in #arg
 */
SDF_Group SDF_getGroupListGroupAt(SDF_GroupList arg, int index) {
 return (SDF_Group)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Group at #index from a SDF_GroupList by a new one. 
 * \param[in] arg SDF_GroupList to retrieve the SDF_Group from
 * \param[in] elem new SDF_Group to replace another
 * \param[in] index index to use to point in the SDF_GroupList
 * \return A new SDF_GroupListwith #elem replaced in #arg at position #index
 */
SDF_GroupList SDF_replaceGroupListGroupAt(SDF_GroupList arg, SDF_Group elem, int index) {
 return (SDF_GroupList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_GroupList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem2 One SDF_Group element of the new SDF_GroupList
 * \return A new SDF_GroupList consisting of 2 SDF_Groups
 */
SDF_GroupList SDF_makeGroupList2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group elem1, SDF_Group elem2) {
  return SDF_makeGroupListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeGroupListSingle(elem2));
}

/**
 * Builds a SDF_GroupList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem2 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem3 One SDF_Group element of the new SDF_GroupList
 * \return A new SDF_GroupList consisting of 3 SDF_Groups
 */
SDF_GroupList SDF_makeGroupList3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group elem1, SDF_Group elem2, SDF_Group elem3) {
  return SDF_makeGroupListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeGroupList2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_GroupList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem2 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem3 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem4 One SDF_Group element of the new SDF_GroupList
 * \return A new SDF_GroupList consisting of 4 SDF_Groups
 */
SDF_GroupList SDF_makeGroupList4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group elem1, SDF_Group elem2, SDF_Group elem3, SDF_Group elem4) {
  return SDF_makeGroupListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeGroupList3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_GroupList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem2 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem3 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem4 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem5 One SDF_Group element of the new SDF_GroupList
 * \return A new SDF_GroupList consisting of 5 SDF_Groups
 */
SDF_GroupList SDF_makeGroupList5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group elem1, SDF_Group elem2, SDF_Group elem3, SDF_Group elem4, SDF_Group elem5) {
  return SDF_makeGroupListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeGroupList4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_GroupList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem2 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem3 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem4 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem5 One SDF_Group element of the new SDF_GroupList
 * \param[in] elem6 One SDF_Group element of the new SDF_GroupList
 * \return A new SDF_GroupList consisting of 6 SDF_Groups
 */
SDF_GroupList SDF_makeGroupList6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Group elem1, SDF_Group elem2, SDF_Group elem3, SDF_Group elem4, SDF_Group elem5, SDF_Group elem6) {
  return SDF_makeGroupListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeGroupList5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_PriorityList. 
 * \param[in] arg input SDF_PriorityList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getPriorityListLength (SDF_PriorityList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_PriorityList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_PriorityList to be reversed
 * \return #arg reversed
 */
SDF_PriorityList SDF_reversePriorityList(SDF_PriorityList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_PriorityList) result;
}

/**
 * Append a SDF_Priority to the end of a SDF_PriorityList. 
 * \param[in] arg SDF_PriorityList to append the SDF_Priority to
 * \param[in] elem SDF_Priority to be appended
 * \return new SDF_PriorityList with #elem appended after the separators
 */
SDF_PriorityList SDF_appendPriorityList(SDF_PriorityList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority arg1) {
  return SDF_concatPriorityList(arg0, wsAfterHead, wsAfterSep, SDF_makePriorityListSingle(arg1));
}

/**
 * Concatenate two SDF_PriorityLists. 
 * \param[in] arg0 first SDF_PriorityList
 * \param[in] arg1 second SDF_PriorityList
 * \return SDF_PriorityList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_PriorityList SDF_concatPriorityList(SDF_PriorityList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_PriorityList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makePriorityListMany((SDF_Priority)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_PriorityList) ATgetNext((ATermList) arg1);
  return (SDF_PriorityList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_PriorityList. 
 * \param[in] arg SDF_PriorityList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_PriorityList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_PriorityList SDF_slicePriorityList(SDF_PriorityList arg, int start, int end) {
  return (SDF_PriorityList) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Priority at #index from a SDF_PriorityList. 
 * \param[in] arg SDF_PriorityList to retrieve the SDF_Priority from
 * \param[in] index index to use to point in the SDF_PriorityList
 * \return SDF_Priority at position #index in #arg
 */
SDF_Priority SDF_getPriorityListPriorityAt(SDF_PriorityList arg, int index) {
 return (SDF_Priority)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Priority at #index from a SDF_PriorityList by a new one. 
 * \param[in] arg SDF_PriorityList to retrieve the SDF_Priority from
 * \param[in] elem new SDF_Priority to replace another
 * \param[in] index index to use to point in the SDF_PriorityList
 * \return A new SDF_PriorityListwith #elem replaced in #arg at position #index
 */
SDF_PriorityList SDF_replacePriorityListPriorityAt(SDF_PriorityList arg, SDF_Priority elem, int index) {
 return (SDF_PriorityList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_PriorityList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem2 One SDF_Priority element of the new SDF_PriorityList
 * \return A new SDF_PriorityList consisting of 2 SDF_Prioritys
 */
SDF_PriorityList SDF_makePriorityList2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority elem1, SDF_Priority elem2) {
  return SDF_makePriorityListMany(elem1, wsAfterHead, wsAfterSep, SDF_makePriorityListSingle(elem2));
}

/**
 * Builds a SDF_PriorityList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem2 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem3 One SDF_Priority element of the new SDF_PriorityList
 * \return A new SDF_PriorityList consisting of 3 SDF_Prioritys
 */
SDF_PriorityList SDF_makePriorityList3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority elem1, SDF_Priority elem2, SDF_Priority elem3) {
  return SDF_makePriorityListMany(elem1, wsAfterHead, wsAfterSep, SDF_makePriorityList2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_PriorityList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem2 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem3 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem4 One SDF_Priority element of the new SDF_PriorityList
 * \return A new SDF_PriorityList consisting of 4 SDF_Prioritys
 */
SDF_PriorityList SDF_makePriorityList4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority elem1, SDF_Priority elem2, SDF_Priority elem3, SDF_Priority elem4) {
  return SDF_makePriorityListMany(elem1, wsAfterHead, wsAfterSep, SDF_makePriorityList3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_PriorityList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem2 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem3 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem4 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem5 One SDF_Priority element of the new SDF_PriorityList
 * \return A new SDF_PriorityList consisting of 5 SDF_Prioritys
 */
SDF_PriorityList SDF_makePriorityList5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority elem1, SDF_Priority elem2, SDF_Priority elem3, SDF_Priority elem4, SDF_Priority elem5) {
  return SDF_makePriorityListMany(elem1, wsAfterHead, wsAfterSep, SDF_makePriorityList4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_PriorityList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem2 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem3 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem4 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem5 One SDF_Priority element of the new SDF_PriorityList
 * \param[in] elem6 One SDF_Priority element of the new SDF_PriorityList
 * \return A new SDF_PriorityList consisting of 6 SDF_Prioritys
 */
SDF_PriorityList SDF_makePriorityList6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Priority elem1, SDF_Priority elem2, SDF_Priority elem3, SDF_Priority elem4, SDF_Priority elem5, SDF_Priority elem6) {
  return SDF_makePriorityListMany(elem1, wsAfterHead, wsAfterSep, SDF_makePriorityList5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_SymbolTail. 
 * \param[in] arg input SDF_SymbolTail
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSymbolTailLength (SDF_SymbolTail arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_SymbolTail. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SymbolTail to be reversed
 * \return #arg reversed
 */
SDF_SymbolTail SDF_reverseSymbolTail(SDF_SymbolTail arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SymbolTail) result;
}

/**
 * Append a SDF_Symbol to the end of a SDF_SymbolTail. 
 * \param[in] arg SDF_SymbolTail to append the SDF_Symbol to
 * \param[in] elem SDF_Symbol to be appended
 * \return new SDF_SymbolTail with #elem appended after the separators
 */
SDF_SymbolTail SDF_appendSymbolTail(SDF_SymbolTail arg0, SDF_OptLayout wsAfterHead, SDF_Symbol arg1) {
  return SDF_concatSymbolTail(arg0, wsAfterHead, SDF_makeSymbolTailSingle(arg1));
}

/**
 * Concatenate two SDF_SymbolTails. 
 * \param[in] arg0 first SDF_SymbolTail
 * \param[in] arg1 second SDF_SymbolTail
 * \return SDF_SymbolTail with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SymbolTail SDF_concatSymbolTail(SDF_SymbolTail arg0, SDF_OptLayout wsAfterHead, SDF_SymbolTail arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSymbolTailMany((SDF_Symbol)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_SymbolTail) ATgetNext((ATermList) arg1);
  return (SDF_SymbolTail) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SymbolTail. 
 * \param[in] arg SDF_SymbolTail to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SymbolTail with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SymbolTail SDF_sliceSymbolTail(SDF_SymbolTail arg, int start, int end) {
  return (SDF_SymbolTail) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Symbol at #index from a SDF_SymbolTail. 
 * \param[in] arg SDF_SymbolTail to retrieve the SDF_Symbol from
 * \param[in] index index to use to point in the SDF_SymbolTail
 * \return SDF_Symbol at position #index in #arg
 */
SDF_Symbol SDF_getSymbolTailSymbolAt(SDF_SymbolTail arg, int index) {
 return (SDF_Symbol)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Symbol at #index from a SDF_SymbolTail by a new one. 
 * \param[in] arg SDF_SymbolTail to retrieve the SDF_Symbol from
 * \param[in] elem new SDF_Symbol to replace another
 * \param[in] index index to use to point in the SDF_SymbolTail
 * \return A new SDF_SymbolTailwith #elem replaced in #arg at position #index
 */
SDF_SymbolTail SDF_replaceSymbolTailSymbolAt(SDF_SymbolTail arg, SDF_Symbol elem, int index) {
 return (SDF_SymbolTail) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_SymbolTail of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolTail
 * \return A new SDF_SymbolTail consisting of 2 SDF_Symbols
 */
SDF_SymbolTail SDF_makeSymbolTail2(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2) {
  return SDF_makeSymbolTailMany(elem1, wsAfterHead, SDF_makeSymbolTailSingle(elem2));
}

/**
 * Builds a SDF_SymbolTail of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolTail
 * \return A new SDF_SymbolTail consisting of 3 SDF_Symbols
 */
SDF_SymbolTail SDF_makeSymbolTail3(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3) {
  return SDF_makeSymbolTailMany(elem1, wsAfterHead, SDF_makeSymbolTail2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_SymbolTail of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolTail
 * \return A new SDF_SymbolTail consisting of 4 SDF_Symbols
 */
SDF_SymbolTail SDF_makeSymbolTail4(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4) {
  return SDF_makeSymbolTailMany(elem1, wsAfterHead, SDF_makeSymbolTail3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SymbolTail of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolTail
 * \return A new SDF_SymbolTail consisting of 5 SDF_Symbols
 */
SDF_SymbolTail SDF_makeSymbolTail5(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5) {
  return SDF_makeSymbolTailMany(elem1, wsAfterHead, SDF_makeSymbolTail4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SymbolTail of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolTail
 * \param[in] elem6 One SDF_Symbol element of the new SDF_SymbolTail
 * \return A new SDF_SymbolTail consisting of 6 SDF_Symbols
 */
SDF_SymbolTail SDF_makeSymbolTail6(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5, SDF_Symbol elem6) {
  return SDF_makeSymbolTailMany(elem1, wsAfterHead, SDF_makeSymbolTail5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_SymbolRest. 
 * \param[in] arg input SDF_SymbolRest
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSymbolRestLength (SDF_SymbolRest arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_SymbolRest. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SymbolRest to be reversed
 * \return #arg reversed
 */
SDF_SymbolRest SDF_reverseSymbolRest(SDF_SymbolRest arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SymbolRest) result;
}

/**
 * Append a SDF_Symbol to the end of a SDF_SymbolRest. 
 * \param[in] arg SDF_SymbolRest to append the SDF_Symbol to
 * \param[in] elem SDF_Symbol to be appended
 * \return new SDF_SymbolRest with #elem appended after the separators
 */
SDF_SymbolRest SDF_appendSymbolRest(SDF_SymbolRest arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol arg1) {
  return SDF_concatSymbolRest(arg0, wsAfterHead, wsAfterSep, SDF_makeSymbolRestSingle(arg1));
}

/**
 * Concatenate two SDF_SymbolRests. 
 * \param[in] arg0 first SDF_SymbolRest
 * \param[in] arg1 second SDF_SymbolRest
 * \return SDF_SymbolRest with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SymbolRest SDF_concatSymbolRest(SDF_SymbolRest arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolRest arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSymbolRestMany((SDF_Symbol)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_SymbolRest) ATgetNext((ATermList) arg1);
  return (SDF_SymbolRest) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SymbolRest. 
 * \param[in] arg SDF_SymbolRest to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SymbolRest with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SymbolRest SDF_sliceSymbolRest(SDF_SymbolRest arg, int start, int end) {
  return (SDF_SymbolRest) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Symbol at #index from a SDF_SymbolRest. 
 * \param[in] arg SDF_SymbolRest to retrieve the SDF_Symbol from
 * \param[in] index index to use to point in the SDF_SymbolRest
 * \return SDF_Symbol at position #index in #arg
 */
SDF_Symbol SDF_getSymbolRestSymbolAt(SDF_SymbolRest arg, int index) {
 return (SDF_Symbol)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Symbol at #index from a SDF_SymbolRest by a new one. 
 * \param[in] arg SDF_SymbolRest to retrieve the SDF_Symbol from
 * \param[in] elem new SDF_Symbol to replace another
 * \param[in] index index to use to point in the SDF_SymbolRest
 * \return A new SDF_SymbolRestwith #elem replaced in #arg at position #index
 */
SDF_SymbolRest SDF_replaceSymbolRestSymbolAt(SDF_SymbolRest arg, SDF_Symbol elem, int index) {
 return (SDF_SymbolRest) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_SymbolRest of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolRest
 * \return A new SDF_SymbolRest consisting of 2 SDF_Symbols
 */
SDF_SymbolRest SDF_makeSymbolRest2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2) {
  return SDF_makeSymbolRestMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolRestSingle(elem2));
}

/**
 * Builds a SDF_SymbolRest of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolRest
 * \return A new SDF_SymbolRest consisting of 3 SDF_Symbols
 */
SDF_SymbolRest SDF_makeSymbolRest3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3) {
  return SDF_makeSymbolRestMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolRest2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_SymbolRest of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolRest
 * \return A new SDF_SymbolRest consisting of 4 SDF_Symbols
 */
SDF_SymbolRest SDF_makeSymbolRest4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4) {
  return SDF_makeSymbolRestMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolRest3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SymbolRest of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolRest
 * \return A new SDF_SymbolRest consisting of 5 SDF_Symbols
 */
SDF_SymbolRest SDF_makeSymbolRest5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5) {
  return SDF_makeSymbolRestMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolRest4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SymbolRest of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolRest
 * \param[in] elem6 One SDF_Symbol element of the new SDF_SymbolRest
 * \return A new SDF_SymbolRest consisting of 6 SDF_Symbols
 */
SDF_SymbolRest SDF_makeSymbolRest6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5, SDF_Symbol elem6) {
  return SDF_makeSymbolRestMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolRest5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_RenamingList. 
 * \param[in] arg input SDF_RenamingList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getRenamingListLength (SDF_RenamingList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_RenamingList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_RenamingList to be reversed
 * \return #arg reversed
 */
SDF_RenamingList SDF_reverseRenamingList(SDF_RenamingList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_RenamingList) result;
}

/**
 * Append a SDF_Renaming to the end of a SDF_RenamingList. 
 * \param[in] arg SDF_RenamingList to append the SDF_Renaming to
 * \param[in] elem SDF_Renaming to be appended
 * \return new SDF_RenamingList with #elem appended after the separators
 */
SDF_RenamingList SDF_appendRenamingList(SDF_RenamingList arg0, SDF_OptLayout wsAfterHead, SDF_Renaming arg1) {
  return SDF_concatRenamingList(arg0, wsAfterHead, SDF_makeRenamingListSingle(arg1));
}

/**
 * Concatenate two SDF_RenamingLists. 
 * \param[in] arg0 first SDF_RenamingList
 * \param[in] arg1 second SDF_RenamingList
 * \return SDF_RenamingList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_RenamingList SDF_concatRenamingList(SDF_RenamingList arg0, SDF_OptLayout wsAfterHead, SDF_RenamingList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeRenamingListMany((SDF_Renaming)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_RenamingList) ATgetNext((ATermList) arg1);
  return (SDF_RenamingList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_RenamingList. 
 * \param[in] arg SDF_RenamingList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_RenamingList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_RenamingList SDF_sliceRenamingList(SDF_RenamingList arg, int start, int end) {
  return (SDF_RenamingList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Renaming at #index from a SDF_RenamingList. 
 * \param[in] arg SDF_RenamingList to retrieve the SDF_Renaming from
 * \param[in] index index to use to point in the SDF_RenamingList
 * \return SDF_Renaming at position #index in #arg
 */
SDF_Renaming SDF_getRenamingListRenamingAt(SDF_RenamingList arg, int index) {
 return (SDF_Renaming)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Renaming at #index from a SDF_RenamingList by a new one. 
 * \param[in] arg SDF_RenamingList to retrieve the SDF_Renaming from
 * \param[in] elem new SDF_Renaming to replace another
 * \param[in] index index to use to point in the SDF_RenamingList
 * \return A new SDF_RenamingListwith #elem replaced in #arg at position #index
 */
SDF_RenamingList SDF_replaceRenamingListRenamingAt(SDF_RenamingList arg, SDF_Renaming elem, int index) {
 return (SDF_RenamingList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_RenamingList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem2 One SDF_Renaming element of the new SDF_RenamingList
 * \return A new SDF_RenamingList consisting of 2 SDF_Renamings
 */
SDF_RenamingList SDF_makeRenamingList2(SDF_OptLayout wsAfterHead, SDF_Renaming elem1, SDF_Renaming elem2) {
  return SDF_makeRenamingListMany(elem1, wsAfterHead, SDF_makeRenamingListSingle(elem2));
}

/**
 * Builds a SDF_RenamingList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem2 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem3 One SDF_Renaming element of the new SDF_RenamingList
 * \return A new SDF_RenamingList consisting of 3 SDF_Renamings
 */
SDF_RenamingList SDF_makeRenamingList3(SDF_OptLayout wsAfterHead, SDF_Renaming elem1, SDF_Renaming elem2, SDF_Renaming elem3) {
  return SDF_makeRenamingListMany(elem1, wsAfterHead, SDF_makeRenamingList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_RenamingList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem2 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem3 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem4 One SDF_Renaming element of the new SDF_RenamingList
 * \return A new SDF_RenamingList consisting of 4 SDF_Renamings
 */
SDF_RenamingList SDF_makeRenamingList4(SDF_OptLayout wsAfterHead, SDF_Renaming elem1, SDF_Renaming elem2, SDF_Renaming elem3, SDF_Renaming elem4) {
  return SDF_makeRenamingListMany(elem1, wsAfterHead, SDF_makeRenamingList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_RenamingList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem2 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem3 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem4 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem5 One SDF_Renaming element of the new SDF_RenamingList
 * \return A new SDF_RenamingList consisting of 5 SDF_Renamings
 */
SDF_RenamingList SDF_makeRenamingList5(SDF_OptLayout wsAfterHead, SDF_Renaming elem1, SDF_Renaming elem2, SDF_Renaming elem3, SDF_Renaming elem4, SDF_Renaming elem5) {
  return SDF_makeRenamingListMany(elem1, wsAfterHead, SDF_makeRenamingList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_RenamingList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem2 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem3 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem4 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem5 One SDF_Renaming element of the new SDF_RenamingList
 * \param[in] elem6 One SDF_Renaming element of the new SDF_RenamingList
 * \return A new SDF_RenamingList consisting of 6 SDF_Renamings
 */
SDF_RenamingList SDF_makeRenamingList6(SDF_OptLayout wsAfterHead, SDF_Renaming elem1, SDF_Renaming elem2, SDF_Renaming elem3, SDF_Renaming elem4, SDF_Renaming elem5, SDF_Renaming elem6) {
  return SDF_makeRenamingListMany(elem1, wsAfterHead, SDF_makeRenamingList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_LookaheadList. 
 * \param[in] arg input SDF_LookaheadList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getLookaheadListLength (SDF_LookaheadList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_LookaheadList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_LookaheadList to be reversed
 * \return #arg reversed
 */
SDF_LookaheadList SDF_reverseLookaheadList(SDF_LookaheadList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_LookaheadList) result;
}

/**
 * Append a SDF_Lookahead to the end of a SDF_LookaheadList. 
 * \param[in] arg SDF_LookaheadList to append the SDF_Lookahead to
 * \param[in] elem SDF_Lookahead to be appended
 * \return new SDF_LookaheadList with #elem appended after the separators
 */
SDF_LookaheadList SDF_appendLookaheadList(SDF_LookaheadList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead arg1) {
  return SDF_concatLookaheadList(arg0, wsAfterHead, wsAfterSep, SDF_makeLookaheadListSingle(arg1));
}

/**
 * Concatenate two SDF_LookaheadLists. 
 * \param[in] arg0 first SDF_LookaheadList
 * \param[in] arg1 second SDF_LookaheadList
 * \return SDF_LookaheadList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_LookaheadList SDF_concatLookaheadList(SDF_LookaheadList arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_LookaheadList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeLookaheadListMany((SDF_Lookahead)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_LookaheadList) ATgetNext((ATermList) arg1);
  return (SDF_LookaheadList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_LookaheadList. 
 * \param[in] arg SDF_LookaheadList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_LookaheadList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_LookaheadList SDF_sliceLookaheadList(SDF_LookaheadList arg, int start, int end) {
  return (SDF_LookaheadList) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Lookahead at #index from a SDF_LookaheadList. 
 * \param[in] arg SDF_LookaheadList to retrieve the SDF_Lookahead from
 * \param[in] index index to use to point in the SDF_LookaheadList
 * \return SDF_Lookahead at position #index in #arg
 */
SDF_Lookahead SDF_getLookaheadListLookaheadAt(SDF_LookaheadList arg, int index) {
 return (SDF_Lookahead)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Lookahead at #index from a SDF_LookaheadList by a new one. 
 * \param[in] arg SDF_LookaheadList to retrieve the SDF_Lookahead from
 * \param[in] elem new SDF_Lookahead to replace another
 * \param[in] index index to use to point in the SDF_LookaheadList
 * \return A new SDF_LookaheadListwith #elem replaced in #arg at position #index
 */
SDF_LookaheadList SDF_replaceLookaheadListLookaheadAt(SDF_LookaheadList arg, SDF_Lookahead elem, int index) {
 return (SDF_LookaheadList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_LookaheadList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem2 One SDF_Lookahead element of the new SDF_LookaheadList
 * \return A new SDF_LookaheadList consisting of 2 SDF_Lookaheads
 */
SDF_LookaheadList SDF_makeLookaheadList2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead elem1, SDF_Lookahead elem2) {
  return SDF_makeLookaheadListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeLookaheadListSingle(elem2));
}

/**
 * Builds a SDF_LookaheadList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem2 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem3 One SDF_Lookahead element of the new SDF_LookaheadList
 * \return A new SDF_LookaheadList consisting of 3 SDF_Lookaheads
 */
SDF_LookaheadList SDF_makeLookaheadList3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead elem1, SDF_Lookahead elem2, SDF_Lookahead elem3) {
  return SDF_makeLookaheadListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeLookaheadList2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_LookaheadList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem2 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem3 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem4 One SDF_Lookahead element of the new SDF_LookaheadList
 * \return A new SDF_LookaheadList consisting of 4 SDF_Lookaheads
 */
SDF_LookaheadList SDF_makeLookaheadList4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead elem1, SDF_Lookahead elem2, SDF_Lookahead elem3, SDF_Lookahead elem4) {
  return SDF_makeLookaheadListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeLookaheadList3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_LookaheadList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem2 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem3 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem4 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem5 One SDF_Lookahead element of the new SDF_LookaheadList
 * \return A new SDF_LookaheadList consisting of 5 SDF_Lookaheads
 */
SDF_LookaheadList SDF_makeLookaheadList5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead elem1, SDF_Lookahead elem2, SDF_Lookahead elem3, SDF_Lookahead elem4, SDF_Lookahead elem5) {
  return SDF_makeLookaheadListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeLookaheadList4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_LookaheadList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem2 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem3 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem4 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem5 One SDF_Lookahead element of the new SDF_LookaheadList
 * \param[in] elem6 One SDF_Lookahead element of the new SDF_LookaheadList
 * \return A new SDF_LookaheadList consisting of 6 SDF_Lookaheads
 */
SDF_LookaheadList SDF_makeLookaheadList6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Lookahead elem1, SDF_Lookahead elem2, SDF_Lookahead elem3, SDF_Lookahead elem4, SDF_Lookahead elem5, SDF_Lookahead elem6) {
  return SDF_makeLookaheadListMany(elem1, wsAfterHead, wsAfterSep, SDF_makeLookaheadList5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_RestrictionList. 
 * \param[in] arg input SDF_RestrictionList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getRestrictionListLength (SDF_RestrictionList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_RestrictionList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_RestrictionList to be reversed
 * \return #arg reversed
 */
SDF_RestrictionList SDF_reverseRestrictionList(SDF_RestrictionList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_RestrictionList) result;
}

/**
 * Append a SDF_Restriction to the end of a SDF_RestrictionList. 
 * \param[in] arg SDF_RestrictionList to append the SDF_Restriction to
 * \param[in] elem SDF_Restriction to be appended
 * \return new SDF_RestrictionList with #elem appended after the separators
 */
SDF_RestrictionList SDF_appendRestrictionList(SDF_RestrictionList arg0, SDF_OptLayout wsAfterHead, SDF_Restriction arg1) {
  return SDF_concatRestrictionList(arg0, wsAfterHead, SDF_makeRestrictionListSingle(arg1));
}

/**
 * Concatenate two SDF_RestrictionLists. 
 * \param[in] arg0 first SDF_RestrictionList
 * \param[in] arg1 second SDF_RestrictionList
 * \return SDF_RestrictionList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_RestrictionList SDF_concatRestrictionList(SDF_RestrictionList arg0, SDF_OptLayout wsAfterHead, SDF_RestrictionList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeRestrictionListMany((SDF_Restriction)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_RestrictionList) ATgetNext((ATermList) arg1);
  return (SDF_RestrictionList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_RestrictionList. 
 * \param[in] arg SDF_RestrictionList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_RestrictionList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_RestrictionList SDF_sliceRestrictionList(SDF_RestrictionList arg, int start, int end) {
  return (SDF_RestrictionList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Restriction at #index from a SDF_RestrictionList. 
 * \param[in] arg SDF_RestrictionList to retrieve the SDF_Restriction from
 * \param[in] index index to use to point in the SDF_RestrictionList
 * \return SDF_Restriction at position #index in #arg
 */
SDF_Restriction SDF_getRestrictionListRestrictionAt(SDF_RestrictionList arg, int index) {
 return (SDF_Restriction)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Restriction at #index from a SDF_RestrictionList by a new one. 
 * \param[in] arg SDF_RestrictionList to retrieve the SDF_Restriction from
 * \param[in] elem new SDF_Restriction to replace another
 * \param[in] index index to use to point in the SDF_RestrictionList
 * \return A new SDF_RestrictionListwith #elem replaced in #arg at position #index
 */
SDF_RestrictionList SDF_replaceRestrictionListRestrictionAt(SDF_RestrictionList arg, SDF_Restriction elem, int index) {
 return (SDF_RestrictionList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_RestrictionList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem2 One SDF_Restriction element of the new SDF_RestrictionList
 * \return A new SDF_RestrictionList consisting of 2 SDF_Restrictions
 */
SDF_RestrictionList SDF_makeRestrictionList2(SDF_OptLayout wsAfterHead, SDF_Restriction elem1, SDF_Restriction elem2) {
  return SDF_makeRestrictionListMany(elem1, wsAfterHead, SDF_makeRestrictionListSingle(elem2));
}

/**
 * Builds a SDF_RestrictionList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem2 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem3 One SDF_Restriction element of the new SDF_RestrictionList
 * \return A new SDF_RestrictionList consisting of 3 SDF_Restrictions
 */
SDF_RestrictionList SDF_makeRestrictionList3(SDF_OptLayout wsAfterHead, SDF_Restriction elem1, SDF_Restriction elem2, SDF_Restriction elem3) {
  return SDF_makeRestrictionListMany(elem1, wsAfterHead, SDF_makeRestrictionList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_RestrictionList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem2 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem3 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem4 One SDF_Restriction element of the new SDF_RestrictionList
 * \return A new SDF_RestrictionList consisting of 4 SDF_Restrictions
 */
SDF_RestrictionList SDF_makeRestrictionList4(SDF_OptLayout wsAfterHead, SDF_Restriction elem1, SDF_Restriction elem2, SDF_Restriction elem3, SDF_Restriction elem4) {
  return SDF_makeRestrictionListMany(elem1, wsAfterHead, SDF_makeRestrictionList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_RestrictionList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem2 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem3 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem4 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem5 One SDF_Restriction element of the new SDF_RestrictionList
 * \return A new SDF_RestrictionList consisting of 5 SDF_Restrictions
 */
SDF_RestrictionList SDF_makeRestrictionList5(SDF_OptLayout wsAfterHead, SDF_Restriction elem1, SDF_Restriction elem2, SDF_Restriction elem3, SDF_Restriction elem4, SDF_Restriction elem5) {
  return SDF_makeRestrictionListMany(elem1, wsAfterHead, SDF_makeRestrictionList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_RestrictionList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem2 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem3 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem4 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem5 One SDF_Restriction element of the new SDF_RestrictionList
 * \param[in] elem6 One SDF_Restriction element of the new SDF_RestrictionList
 * \return A new SDF_RestrictionList consisting of 6 SDF_Restrictions
 */
SDF_RestrictionList SDF_makeRestrictionList6(SDF_OptLayout wsAfterHead, SDF_Restriction elem1, SDF_Restriction elem2, SDF_Restriction elem3, SDF_Restriction elem4, SDF_Restriction elem5, SDF_Restriction elem6) {
  return SDF_makeRestrictionListMany(elem1, wsAfterHead, SDF_makeRestrictionList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_SymbolParameters. 
 * \param[in] arg input SDF_SymbolParameters
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSymbolParametersLength (SDF_SymbolParameters arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 4) + 1;
}

/**
 * Reverses the elements of a SDF_SymbolParameters. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SymbolParameters to be reversed
 * \return #arg reversed
 */
SDF_SymbolParameters SDF_reverseSymbolParameters(SDF_SymbolParameters arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATerm sep1;
  ATerm sep2;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep2);
    result = ATinsert(result, sep1);
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
  sep1 = ATgetFirst(list);
  list = ATgetNext(list);
  sep2 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SymbolParameters) result;
}

/**
 * Append a SDF_Symbol to the end of a SDF_SymbolParameters. 
 * \param[in] arg SDF_SymbolParameters to append the SDF_Symbol to
 * \param[in] elem SDF_Symbol to be appended
 * \return new SDF_SymbolParameters with #elem appended after the separators
 */
SDF_SymbolParameters SDF_appendSymbolParameters(SDF_SymbolParameters arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol arg1) {
  return SDF_concatSymbolParameters(arg0, wsAfterHead, wsAfterSep, SDF_makeSymbolParametersSingle(arg1));
}

/**
 * Concatenate two SDF_SymbolParameterss. 
 * \param[in] arg0 first SDF_SymbolParameters
 * \param[in] arg1 second SDF_SymbolParameters
 * \return SDF_SymbolParameters with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SymbolParameters SDF_concatSymbolParameters(SDF_SymbolParameters arg0, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolParameters arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSymbolParametersMany((SDF_Symbol)ATgetFirst((ATermList) arg0), wsAfterHead, wsAfterSep,  arg1);
  arg1 = (SDF_SymbolParameters) ATgetNext((ATermList) arg1);
  return (SDF_SymbolParameters) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SymbolParameters. 
 * \param[in] arg SDF_SymbolParameters to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SymbolParameters with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SymbolParameters SDF_sliceSymbolParameters(SDF_SymbolParameters arg, int start, int end) {
  return (SDF_SymbolParameters) ATgetSlice((ATermList) arg, start * 4, end * 4);
}

/**
 * Retrieve the SDF_Symbol at #index from a SDF_SymbolParameters. 
 * \param[in] arg SDF_SymbolParameters to retrieve the SDF_Symbol from
 * \param[in] index index to use to point in the SDF_SymbolParameters
 * \return SDF_Symbol at position #index in #arg
 */
SDF_Symbol SDF_getSymbolParametersSymbolAt(SDF_SymbolParameters arg, int index) {
 return (SDF_Symbol)ATelementAt((ATermList) arg,index * 4);
}

/**
 * Replace the SDF_Symbol at #index from a SDF_SymbolParameters by a new one. 
 * \param[in] arg SDF_SymbolParameters to retrieve the SDF_Symbol from
 * \param[in] elem new SDF_Symbol to replace another
 * \param[in] index index to use to point in the SDF_SymbolParameters
 * \return A new SDF_SymbolParameterswith #elem replaced in #arg at position #index
 */
SDF_SymbolParameters SDF_replaceSymbolParametersSymbolAt(SDF_SymbolParameters arg, SDF_Symbol elem, int index) {
 return (SDF_SymbolParameters) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 4);
}

/**
 * Builds a SDF_SymbolParameters of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolParameters
 * \return A new SDF_SymbolParameters consisting of 2 SDF_Symbols
 */
SDF_SymbolParameters SDF_makeSymbolParameters2(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2) {
  return SDF_makeSymbolParametersMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolParametersSingle(elem2));
}

/**
 * Builds a SDF_SymbolParameters of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolParameters
 * \return A new SDF_SymbolParameters consisting of 3 SDF_Symbols
 */
SDF_SymbolParameters SDF_makeSymbolParameters3(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3) {
  return SDF_makeSymbolParametersMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolParameters2(wsAfterHead, wsAfterSep, elem2, elem3));
}

/**
 * Builds a SDF_SymbolParameters of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolParameters
 * \return A new SDF_SymbolParameters consisting of 4 SDF_Symbols
 */
SDF_SymbolParameters SDF_makeSymbolParameters4(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4) {
  return SDF_makeSymbolParametersMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolParameters3(wsAfterHead, wsAfterSep, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SymbolParameters of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolParameters
 * \return A new SDF_SymbolParameters consisting of 5 SDF_Symbols
 */
SDF_SymbolParameters SDF_makeSymbolParameters5(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5) {
  return SDF_makeSymbolParametersMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolParameters4(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SymbolParameters of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolParameters
 * \param[in] elem6 One SDF_Symbol element of the new SDF_SymbolParameters
 * \return A new SDF_SymbolParameters consisting of 6 SDF_Symbols
 */
SDF_SymbolParameters SDF_makeSymbolParameters6(SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5, SDF_Symbol elem6) {
  return SDF_makeSymbolParametersMany(elem1, wsAfterHead, wsAfterSep, SDF_makeSymbolParameters5(wsAfterHead, wsAfterSep, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the number of elements in a SDF_SymbolList. 
 * \param[in] arg input SDF_SymbolList
 * \return The number of elements in #arg, excluding any separators
 */
int SDF_getSymbolListLength (SDF_SymbolList arg) {
  if (ATisEmpty((ATermList) arg)) {
    return 0;
  }
  return (ATgetLength((ATermList) arg) / 2) + 1;
}

/**
 * Reverses the elements of a SDF_SymbolList. Note that separators are reversed with the list, but the order in which each set of separators inbetween two elements occurs does not change
 * \param[in] arg SDF_SymbolList to be reversed
 * \return #arg reversed
 */
SDF_SymbolList SDF_reverseSymbolList(SDF_SymbolList arg) {
  ATermList list = (ATermList) arg;
  ATerm head;
  ATerm sep0;
  ATermList result;

 if (ATisEmpty(list) || ATgetLength(list) == 1) {
    return arg;
  }

  result = ATmakeList1(ATgetFirst(list));
      list = ATgetNext(list);
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);

  while (!ATisEmpty(list)) {
    result = ATinsert(result, sep0);

   head = ATgetFirst(list);
   result = ATinsert(result, head);
    list = ATgetNext(list);

   if (!ATisEmpty(list)) {
  sep0 = ATgetFirst(list);
  list = ATgetNext(list);
   }
  }

  return (SDF_SymbolList) result;
}

/**
 * Append a SDF_Symbol to the end of a SDF_SymbolList. 
 * \param[in] arg SDF_SymbolList to append the SDF_Symbol to
 * \param[in] elem SDF_Symbol to be appended
 * \return new SDF_SymbolList with #elem appended after the separators
 */
SDF_SymbolList SDF_appendSymbolList(SDF_SymbolList arg0, SDF_OptLayout wsAfterHead, SDF_Symbol arg1) {
  return SDF_concatSymbolList(arg0, wsAfterHead, SDF_makeSymbolListSingle(arg1));
}

/**
 * Concatenate two SDF_SymbolLists. 
 * \param[in] arg0 first SDF_SymbolList
 * \param[in] arg1 second SDF_SymbolList
 * \return SDF_SymbolList with the elements of #arg0 before the elements of #arg1, with the separators in between.
 */
SDF_SymbolList SDF_concatSymbolList(SDF_SymbolList arg0, SDF_OptLayout wsAfterHead, SDF_SymbolList arg1) {
  if (ATisEmpty((ATermList) arg0)) {
    return arg1;
  }
  arg1 = SDF_makeSymbolListMany((SDF_Symbol)ATgetFirst((ATermList) arg0), wsAfterHead,  arg1);
  arg1 = (SDF_SymbolList) ATgetNext((ATermList) arg1);
  return (SDF_SymbolList) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_SymbolList. 
 * \param[in] arg SDF_SymbolList to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_SymbolList with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_SymbolList SDF_sliceSymbolList(SDF_SymbolList arg, int start, int end) {
  return (SDF_SymbolList) ATgetSlice((ATermList) arg, start * 2, end * 2);
}

/**
 * Retrieve the SDF_Symbol at #index from a SDF_SymbolList. 
 * \param[in] arg SDF_SymbolList to retrieve the SDF_Symbol from
 * \param[in] index index to use to point in the SDF_SymbolList
 * \return SDF_Symbol at position #index in #arg
 */
SDF_Symbol SDF_getSymbolListSymbolAt(SDF_SymbolList arg, int index) {
 return (SDF_Symbol)ATelementAt((ATermList) arg,index * 2);
}

/**
 * Replace the SDF_Symbol at #index from a SDF_SymbolList by a new one. 
 * \param[in] arg SDF_SymbolList to retrieve the SDF_Symbol from
 * \param[in] elem new SDF_Symbol to replace another
 * \param[in] index index to use to point in the SDF_SymbolList
 * \return A new SDF_SymbolListwith #elem replaced in #arg at position #index
 */
SDF_SymbolList SDF_replaceSymbolListSymbolAt(SDF_SymbolList arg, SDF_Symbol elem, int index) {
 return (SDF_SymbolList) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index * 2);
}

/**
 * Builds a SDF_SymbolList of 2 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolList
 * \return A new SDF_SymbolList consisting of 2 SDF_Symbols
 */
SDF_SymbolList SDF_makeSymbolList2(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2) {
  return SDF_makeSymbolListMany(elem1, wsAfterHead, SDF_makeSymbolListSingle(elem2));
}

/**
 * Builds a SDF_SymbolList of 3 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolList
 * \return A new SDF_SymbolList consisting of 3 SDF_Symbols
 */
SDF_SymbolList SDF_makeSymbolList3(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3) {
  return SDF_makeSymbolListMany(elem1, wsAfterHead, SDF_makeSymbolList2(wsAfterHead, elem2, elem3));
}

/**
 * Builds a SDF_SymbolList of 4 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolList
 * \return A new SDF_SymbolList consisting of 4 SDF_Symbols
 */
SDF_SymbolList SDF_makeSymbolList4(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4) {
  return SDF_makeSymbolListMany(elem1, wsAfterHead, SDF_makeSymbolList3(wsAfterHead, elem2, elem3, elem4));
}

/**
 * Builds a SDF_SymbolList of 5 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolList
 * \return A new SDF_SymbolList consisting of 5 SDF_Symbols
 */
SDF_SymbolList SDF_makeSymbolList5(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5) {
  return SDF_makeSymbolListMany(elem1, wsAfterHead, SDF_makeSymbolList4(wsAfterHead, elem2, elem3, elem4, elem5));
}

/**
 * Builds a SDF_SymbolList of 6 consecutive elements. The elements are separated.
 * \param[in] elem1 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem2 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem3 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem4 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem5 One SDF_Symbol element of the new SDF_SymbolList
 * \param[in] elem6 One SDF_Symbol element of the new SDF_SymbolList
 * \return A new SDF_SymbolList consisting of 6 SDF_Symbols
 */
SDF_SymbolList SDF_makeSymbolList6(SDF_OptLayout wsAfterHead, SDF_Symbol elem1, SDF_Symbol elem2, SDF_Symbol elem3, SDF_Symbol elem4, SDF_Symbol elem5, SDF_Symbol elem6) {
  return SDF_makeSymbolListMany(elem1, wsAfterHead, SDF_makeSymbolList5(wsAfterHead, elem2, elem3, elem4, elem5, elem6));
}

/**
 * Retrieve the length of a SDF_LexStrCharChars. 
 * \param[in] arg input SDF_LexStrCharChars
 * \return The number of elements in the SDF_LexStrCharChars
 */
int SDF_getLexStrCharCharsLength (SDF_LexStrCharChars arg) {
  return ATgetLength((ATermList) arg);
}

/**
 * Reverse a SDF_LexStrCharChars. 
 * \param[in] arg SDF_LexStrCharChars to be reversed
 * \return a reversed #arg
 */
SDF_LexStrCharChars SDF_reverseLexStrCharChars(SDF_LexStrCharChars arg) {
  return (SDF_LexStrCharChars) ATreverse((ATermList) arg);
}

/**
 * Append a SDF_LexStrChar to the end of a SDF_LexStrCharChars. 
 * \param[in] arg SDF_LexStrCharChars to append the SDF_LexStrChar to
 * \param[in] elem SDF_LexStrChar to be appended
 * \return new SDF_LexStrCharChars with #elem appended
 */
SDF_LexStrCharChars SDF_appendLexStrCharChars(SDF_LexStrCharChars arg, SDF_LexStrChar elem) {
  return (SDF_LexStrCharChars) ATappend((ATermList) arg, (ATerm) ((ATerm) elem));
}

/**
 * Concatenate two SDF_LexStrCharCharss. 
 * \param[in] arg0 first SDF_LexStrCharChars
 * \param[in] arg1 second SDF_LexStrCharChars
 * \return SDF_LexStrCharChars with the elements of #arg0 before the elements of #arg1
 */
SDF_LexStrCharChars SDF_concatLexStrCharChars(SDF_LexStrCharChars arg0, SDF_LexStrCharChars arg1) {
  return (SDF_LexStrCharChars) ATconcat((ATermList) arg0, (ATermList) arg1);
}

/**
 * Extract a sublist from a SDF_LexStrCharChars. 
 * \param[in] arg SDF_LexStrCharChars to extract a slice from
 * \param[in] start inclusive start index of the sublist
 * \param[in] end exclusive end index of the sublist
 * \return new SDF_LexStrCharChars with a first element the element at index #start from #arg, and as last element the element at index (#end - 1).
 */
SDF_LexStrCharChars SDF_sliceLexStrCharChars(SDF_LexStrCharChars arg, int start, int end) {
  return (SDF_LexStrCharChars) ATgetSlice((ATermList) arg, start, end);
}

/**
 * Retrieve the SDF_LexStrChar at #index from a SDF_LexStrCharChars. 
 * \param[in] arg SDF_LexStrCharChars to retrieve the SDF_LexStrChar from
 * \param[in] index index to use to point in the SDF_LexStrCharChars
 * \return SDF_LexStrChar at position #index in #arg
 */
SDF_LexStrChar SDF_getLexStrCharCharsLexStrCharAt(SDF_LexStrCharChars arg, int index) {
 return (SDF_LexStrChar)ATelementAt((ATermList) arg,index);
}

/**
 * Replace the SDF_LexStrChar at #index from a SDF_LexStrCharChars by a new one. 
 * \param[in] arg SDF_LexStrCharChars to retrieve the SDF_LexStrChar from
 * \param[in] elem new SDF_LexStrChar to replace another
 * \param[in] index index to use to point in the SDF_LexStrCharChars
 * \return A new SDF_LexStrCharCharswith #elem replaced in #arg at position #index
 */
SDF_LexStrCharChars SDF_replaceLexStrCharCharsLexStrCharAt(SDF_LexStrCharChars arg, SDF_LexStrChar elem, int index) {
 return (SDF_LexStrCharChars) ATreplace((ATermList) arg, (ATerm) ((ATerm) elem), index);
}

/**
 * Builds a SDF_LexStrCharChars of 2 consecutive elements. 
 * \param[in] elem1 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem2 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \return A new SDF_LexStrCharChars consisting of 2 SDF_LexStrChars
 */
SDF_LexStrCharChars SDF_makeLexStrCharChars2(SDF_LexStrChar elem1, SDF_LexStrChar elem2) {
  return (SDF_LexStrCharChars) ATmakeList2((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2));
}

/**
 * Builds a SDF_LexStrCharChars of 3 consecutive elements. 
 * \param[in] elem1 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem2 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem3 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \return A new SDF_LexStrCharChars consisting of 3 SDF_LexStrChars
 */
SDF_LexStrCharChars SDF_makeLexStrCharChars3(SDF_LexStrChar elem1, SDF_LexStrChar elem2, SDF_LexStrChar elem3) {
  return (SDF_LexStrCharChars) ATmakeList3((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3));
}

/**
 * Builds a SDF_LexStrCharChars of 4 consecutive elements. 
 * \param[in] elem1 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem2 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem3 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem4 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \return A new SDF_LexStrCharChars consisting of 4 SDF_LexStrChars
 */
SDF_LexStrCharChars SDF_makeLexStrCharChars4(SDF_LexStrChar elem1, SDF_LexStrChar elem2, SDF_LexStrChar elem3, SDF_LexStrChar elem4) {
  return (SDF_LexStrCharChars) ATmakeList4((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4));
}

/**
 * Builds a SDF_LexStrCharChars of 5 consecutive elements. 
 * \param[in] elem1 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem2 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem3 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem4 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem5 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \return A new SDF_LexStrCharChars consisting of 5 SDF_LexStrChars
 */
SDF_LexStrCharChars SDF_makeLexStrCharChars5(SDF_LexStrChar elem1, SDF_LexStrChar elem2, SDF_LexStrChar elem3, SDF_LexStrChar elem4, SDF_LexStrChar elem5) {
  return (SDF_LexStrCharChars) ATmakeList5((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5));
}

/**
 * Builds a SDF_LexStrCharChars of 6 consecutive elements. 
 * \param[in] elem1 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem2 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem3 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem4 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem5 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \param[in] elem6 One SDF_LexStrChar element of the new SDF_LexStrCharChars
 * \return A new SDF_LexStrCharChars consisting of 6 SDF_LexStrChars
 */
SDF_LexStrCharChars SDF_makeLexStrCharChars6(SDF_LexStrChar elem1, SDF_LexStrChar elem2, SDF_LexStrChar elem3, SDF_LexStrChar elem4, SDF_LexStrChar elem5, SDF_LexStrChar elem6) {
  return (SDF_LexStrCharChars) ATmakeList6((ATerm) ((ATerm) elem1), (ATerm) ((ATerm) elem2), (ATerm) ((ATerm) elem3), (ATerm) ((ATerm) elem4), (ATerm) ((ATerm) elem5), (ATerm) ((ATerm) elem6));
}

/**
 * Constructs a Absent of type SDF_OptLayout. Like all ATerm types, SDF_OptLayouts are maximally shared.
 * \return A pointer to a Absent, either newly constructed or shared
 */
SDF_OptLayout SDF_makeOptLayoutAbsent(void) {
  return (SDF_OptLayout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATempty, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATempty);
}
/**
 * Constructs a Present of type SDF_OptLayout. Like all ATerm types, SDF_OptLayouts are maximally shared.
 * \param[in] layout a child of the new Present
 * \return A pointer to a Present, either newly constructed or shared
 */
SDF_OptLayout SDF_makeOptLayoutPresent(SDF_Layout layout) {
  return (SDF_OptLayout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl0(SDF_afun4))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) layout));
}
/**
 * Constructs a Lex-to-cf of type SDF_Layout. Like all ATerm types, SDF_Layouts are maximally shared.
 * \param[in] list a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_Layout SDF_makeLayoutLexToCf(SDF_LexLayoutList list) {
  return (SDF_Layout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl0(SDF_afun4)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_LexLayoutList. Like all ATerm types, SDF_LexLayoutLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_LexLayoutList SDF_makeLexLayoutListEmpty(void) {
  return (SDF_LexLayoutList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_LexLayoutList. Like all ATerm types, SDF_LexLayoutLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_LexLayoutList SDF_makeLexLayoutListSingle(SDF_LexLayout head) {
  return (SDF_LexLayoutList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_LexLayoutList. Like all ATerm types, SDF_LexLayoutLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_LexLayoutList SDF_makeLexLayoutListMany(SDF_LexLayout head, SDF_LexLayoutList tail) {
  return (SDF_LexLayoutList)(ATerm)ATinsert((ATermList)tail, (ATerm) head);
}
/**
 * Constructs a quoted of type SDF_AFun. Like all ATerm types, SDF_AFuns are maximally shared.
 * \param[in] StrCon a child of the new quoted
 * \return A pointer to a quoted, either newly constructed or shared
 */
SDF_AFun SDF_makeAFunQuoted(SDF_StrCon StrCon) {
  return (SDF_AFun)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun11))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun15)))))), (ATerm)ATmakeList1((ATerm) StrCon));
}
/**
 * Constructs a unquoted of type SDF_AFun. Like all ATerm types, SDF_AFuns are maximally shared.
 * \param[in] IdCon a child of the new unquoted
 * \return A pointer to a unquoted, either newly constructed or shared
 */
SDF_AFun SDF_makeAFunUnquoted(SDF_IdCon IdCon) {
  return (SDF_AFun)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun11))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun17)))))), (ATerm)ATmakeList1((ATerm) IdCon));
}
/**
 * Constructs a int of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] IntCon a child of the new int
 * \return A pointer to a int, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermInt(SDF_IntCon IntCon) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun20)))))), (ATerm)ATmakeList1((ATerm) IntCon));
}
/**
 * Constructs a real of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] RealCon a child of the new real
 * \return A pointer to a real, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermReal(SDF_RealCon RealCon) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun21)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun22)))))), (ATerm)ATmakeList1((ATerm) RealCon));
}
/**
 * Constructs a fun of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] fun a child of the new fun
 * \return A pointer to a fun, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermFun(SDF_AFun fun) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun11)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun23)))))), (ATerm)ATmakeList1((ATerm) fun));
}
/**
 * Constructs a appl of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] fun a child of the new appl
 * \param[in] wsAfterFun a child of the new appl
 * \param[in] wsAfterParenOpen a child of the new appl
 * \param[in] args a child of the new appl
 * \param[in] wsAfterArgs a child of the new appl
 * \return A pointer to a appl, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermAppl(SDF_AFun fun, SDF_OptLayout wsAfterFun, SDF_OptLayout wsAfterParenOpen, SDF_ATermArgs args, SDF_OptLayout wsAfterArgs) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun11)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun29)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterArgs), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) args)), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm) wsAfterFun), (ATerm) fun));
}
/**
 * Constructs a placeholder of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] wsAfterLessThan a child of the new placeholder
 * \param[in] type a child of the new placeholder
 * \param[in] wsAfterType a child of the new placeholder
 * \return A pointer to a placeholder, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermPlaceholder(SDF_OptLayout wsAfterLessThan, SDF_ATerm type, SDF_OptLayout wsAfterType) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun33)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterType), (ATerm) type), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a list of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] wsAfterBracketOpen a child of the new list
 * \param[in] elems a child of the new list
 * \param[in] wsAfterElems a child of the new list
 * \return A pointer to a list, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermList(SDF_OptLayout wsAfterBracketOpen, SDF_ATermElems elems, SDF_OptLayout wsAfterElems) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun37)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm) wsAfterElems), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) elems)), (ATerm) wsAfterBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))));
}
/**
 * Constructs a annotated of type SDF_ATerm. Like all ATerm types, SDF_ATerms are maximally shared.
 * \param[in] trm a child of the new annotated
 * \param[in] wsAfterTrm a child of the new annotated
 * \param[in] Annotation a child of the new annotated
 * \return A pointer to a annotated, either newly constructed or shared
 */
SDF_ATerm SDF_makeATermAnnotated(SDF_ATerm trm, SDF_OptLayout wsAfterTrm, SDF_Annotation Annotation) {
  return (SDF_ATerm)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun38)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun39)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Annotation), (ATerm) wsAfterTrm), (ATerm) trm));
}
/**
 * Constructs a default of type SDF_Annotation. Like all ATerm types, SDF_Annotations are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new default
 * \param[in] annos a child of the new default
 * \param[in] wsAfterAnnos a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_Annotation SDF_makeAnnotationDefault(SDF_OptLayout wsAfterBraceOpen, SDF_ATermAnnos annos, SDF_OptLayout wsAfterAnnos) {
  return (SDF_Annotation)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun38))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterAnnos), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) annos)), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a ATerm of type SDF_Start. Like all ATerm types, SDF_Starts are maximally shared.
 * \param[in] wsBefore a child of the new ATerm
 * \param[in] topATerm a child of the new ATerm
 * \param[in] wsAfter a child of the new ATerm
 * \param[in] ambCnt a child of the new ATerm
 * \return A pointer to a ATerm, either newly constructed or shared
 */
SDF_Start SDF_makeStartATerm(SDF_OptLayout wsBefore, SDF_ATerm topATerm, SDF_OptLayout wsAfter, int ambCnt) {
  return (SDF_Start)(ATerm)ATmakeAppl2(SDF_afun43, (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) wsAfter), (ATerm) topATerm), (ATerm) wsBefore)), (ATerm) (ATerm) ATmakeInt(ambCnt));
}
/**
 * Constructs a IntCon of type SDF_Start. Like all ATerm types, SDF_Starts are maximally shared.
 * \param[in] wsBefore a child of the new IntCon
 * \param[in] topIntCon a child of the new IntCon
 * \param[in] wsAfter a child of the new IntCon
 * \param[in] ambCnt a child of the new IntCon
 * \return A pointer to a IntCon, either newly constructed or shared
 */
SDF_Start SDF_makeStartIntCon(SDF_OptLayout wsBefore, SDF_IntCon topIntCon, SDF_OptLayout wsAfter, int ambCnt) {
  return (SDF_Start)(ATerm)ATmakeAppl2(SDF_afun43, (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) wsAfter), (ATerm) topIntCon), (ATerm) wsBefore)), (ATerm) (ATerm) ATmakeInt(ambCnt));
}
/**
 * Constructs a RealCon of type SDF_Start. Like all ATerm types, SDF_Starts are maximally shared.
 * \param[in] wsBefore a child of the new RealCon
 * \param[in] topRealCon a child of the new RealCon
 * \param[in] wsAfter a child of the new RealCon
 * \param[in] ambCnt a child of the new RealCon
 * \return A pointer to a RealCon, either newly constructed or shared
 */
SDF_Start SDF_makeStartRealCon(SDF_OptLayout wsBefore, SDF_RealCon topRealCon, SDF_OptLayout wsAfter, int ambCnt) {
  return (SDF_Start)(ATerm)ATmakeAppl2(SDF_afun43, (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun21)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) wsAfter), (ATerm) topRealCon), (ATerm) wsBefore)), (ATerm) (ATerm) ATmakeInt(ambCnt));
}
/**
 * Constructs a Module of type SDF_Start. Like all ATerm types, SDF_Starts are maximally shared.
 * \param[in] wsBefore a child of the new Module
 * \param[in] topModule a child of the new Module
 * \param[in] wsAfter a child of the new Module
 * \param[in] ambCnt a child of the new Module
 * \return A pointer to a Module, either newly constructed or shared
 */
SDF_Start SDF_makeStartModule(SDF_OptLayout wsBefore, SDF_Module topModule, SDF_OptLayout wsAfter, int ambCnt) {
  return (SDF_Start)(ATerm)ATmakeAppl2(SDF_afun43, (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun45)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) wsAfter), (ATerm) topModule), (ATerm) wsBefore)), (ATerm) (ATerm) ATmakeInt(ambCnt));
}
/**
 * Constructs a SDF of type SDF_Start. Like all ATerm types, SDF_Starts are maximally shared.
 * \param[in] wsBefore a child of the new SDF
 * \param[in] topSDF a child of the new SDF
 * \param[in] wsAfter a child of the new SDF
 * \param[in] ambCnt a child of the new SDF
 * \return A pointer to a SDF, either newly constructed or shared
 */
SDF_Start SDF_makeStartSDF(SDF_OptLayout wsBefore, SDF_SDF topSDF, SDF_OptLayout wsAfter, int ambCnt) {
  return (SDF_Start)(ATerm)ATmakeAppl2(SDF_afun43, (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun46)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) wsAfter), (ATerm) topSDF), (ATerm) wsBefore)), (ATerm) (ATerm) ATmakeInt(ambCnt));
}
/**
 * Constructs a empty of type SDF_ATermArgs. Like all ATerm types, SDF_ATermArgss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ATermArgs SDF_makeATermArgsEmpty(void) {
  return (SDF_ATermArgs)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ATermArgs. Like all ATerm types, SDF_ATermArgss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ATermArgs SDF_makeATermArgsSingle(SDF_ATerm head) {
  return (SDF_ATermArgs)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ATermArgs. Like all ATerm types, SDF_ATermArgss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ATermArgs SDF_makeATermArgsMany(SDF_ATerm head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermArgs tail) {
  if (SDF_isATermArgsEmpty(tail)) {
    return SDF_makeATermArgsSingle(head);
  }
  return (SDF_ATermArgs)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_ATermElems. Like all ATerm types, SDF_ATermElemss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ATermElems SDF_makeATermElemsEmpty(void) {
  return (SDF_ATermElems)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ATermElems. Like all ATerm types, SDF_ATermElemss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ATermElems SDF_makeATermElemsSingle(SDF_ATerm head) {
  return (SDF_ATermElems)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ATermElems. Like all ATerm types, SDF_ATermElemss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ATermElems SDF_makeATermElemsMany(SDF_ATerm head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermElems tail) {
  if (SDF_isATermElemsEmpty(tail)) {
    return SDF_makeATermElemsSingle(head);
  }
  return (SDF_ATermElems)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_ATermAnnos. Like all ATerm types, SDF_ATermAnnoss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ATermAnnos SDF_makeATermAnnosEmpty(void) {
  return (SDF_ATermAnnos)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ATermAnnos. Like all ATerm types, SDF_ATermAnnoss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ATermAnnos SDF_makeATermAnnosSingle(SDF_ATerm head) {
  return (SDF_ATermAnnos)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ATermAnnos. Like all ATerm types, SDF_ATermAnnoss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ATermAnnos SDF_makeATermAnnosMany(SDF_ATerm head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_ATermAnnos tail) {
  if (SDF_isATermAnnosEmpty(tail)) {
    return SDF_makeATermAnnosSingle(head);
  }
  return (SDF_ATermAnnos)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a natural of type SDF_IntCon. Like all ATerm types, SDF_IntCons are maximally shared.
 * \param[in] NatCon a child of the new natural
 * \return A pointer to a natural, either newly constructed or shared
 */
SDF_IntCon SDF_makeIntConNatural(SDF_NatCon NatCon) {
  return (SDF_IntCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun48)))))), (ATerm)ATmakeList1((ATerm) NatCon));
}
/**
 * Constructs a positive of type SDF_IntCon. Like all ATerm types, SDF_IntCons are maximally shared.
 * \param[in] wsAfterPos a child of the new positive
 * \param[in] NatCon a child of the new positive
 * \return A pointer to a positive, either newly constructed or shared
 */
SDF_IntCon SDF_makeIntConPositive(SDF_OptLayout wsAfterPos, SDF_NatCon NatCon) {
  return (SDF_IntCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun50)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) NatCon), (ATerm) wsAfterPos), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))));
}
/**
 * Constructs a negative of type SDF_IntCon. Like all ATerm types, SDF_IntCons are maximally shared.
 * \param[in] wsAfterNeg a child of the new negative
 * \param[in] NatCon a child of the new negative
 * \return A pointer to a negative, either newly constructed or shared
 */
SDF_IntCon SDF_makeIntConNegative(SDF_OptLayout wsAfterNeg, SDF_NatCon NatCon) {
  return (SDF_IntCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun51))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun52)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) NatCon), (ATerm) wsAfterNeg), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun51)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))));
}
/**
 * Constructs a present of type SDF_OptExp. Like all ATerm types, SDF_OptExps are maximally shared.
 * \param[in] wsAfterE a child of the new present
 * \param[in] IntCon a child of the new present
 * \return A pointer to a present, either newly constructed or shared
 */
SDF_OptExp SDF_makeOptExpPresent(SDF_OptLayout wsAfterE, SDF_IntCon IntCon) {
  return (SDF_OptExp)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun53))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun54))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun55)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) IntCon), (ATerm) wsAfterE), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun53)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))));
}
/**
 * Constructs a absent of type SDF_OptExp. Like all ATerm types, SDF_OptExps are maximally shared.
 * \return A pointer to a absent, either newly constructed or shared
 */
SDF_OptExp SDF_makeOptExpAbsent(void) {
  return (SDF_OptExp)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATempty, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun54))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun56)))))), (ATerm)ATempty);
}
/**
 * Constructs a real-con of type SDF_RealCon. Like all ATerm types, SDF_RealCons are maximally shared.
 * \param[in] base a child of the new real-con
 * \param[in] wsAfterBase a child of the new real-con
 * \param[in] wsAfterPeriod a child of the new real-con
 * \param[in] decimal a child of the new real-con
 * \param[in] wsAfterDecimal a child of the new real-con
 * \param[in] exp a child of the new real-con
 * \return A pointer to a real-con, either newly constructed or shared
 */
SDF_RealCon SDF_makeRealConRealCon(SDF_IntCon base, SDF_OptLayout wsAfterBase, SDF_OptLayout wsAfterPeriod, SDF_NatCon decimal, SDF_OptLayout wsAfterDecimal, SDF_OptExp exp) {
  return (SDF_RealCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun54)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun18)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun21))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun58)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) exp), (ATerm) wsAfterDecimal), (ATerm) decimal), (ATerm) wsAfterPeriod), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm) wsAfterBase), (ATerm) base));
}
/**
 * Constructs a aliases of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterAliases a child of the new aliases
 * \param[in] Aliases a child of the new aliases
 * \return A pointer to a aliases, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarAliases(SDF_OptLayout wsAfterAliases, SDF_Aliases Aliases) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun59)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun60))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun60)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Aliases), (ATerm) wsAfterAliases), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun60)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)))));
}
/**
 * Constructs a lexical-syntax of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterLexical a child of the new lexical-syntax
 * \param[in] wsAfterSyntax a child of the new lexical-syntax
 * \param[in] Productions a child of the new lexical-syntax
 * \return A pointer to a lexical-syntax, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarLexicalSyntax(SDF_OptLayout wsAfterLexical, SDF_OptLayout wsAfterSyntax, SDF_Productions Productions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun65)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Productions), (ATerm) wsAfterSyntax), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)))), (ATerm) wsAfterLexical), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a context-free-syntax of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterContextFree a child of the new context-free-syntax
 * \param[in] wsAfterSyntax a child of the new context-free-syntax
 * \param[in] Productions a child of the new context-free-syntax
 * \return A pointer to a context-free-syntax, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarContextFreeSyntax(SDF_OptLayout wsAfterContextFree, SDF_OptLayout wsAfterSyntax, SDF_Productions Productions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun67)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Productions), (ATerm) wsAfterSyntax), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)))), (ATerm) wsAfterContextFree), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(99)))));
}
/**
 * Constructs a variables of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterVariables a child of the new variables
 * \param[in] Productions a child of the new variables
 * \return A pointer to a variables, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarVariables(SDF_OptLayout wsAfterVariables, SDF_Productions Productions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun68))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun68)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Productions), (ATerm) wsAfterVariables), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(118)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun68)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(98)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(118)))));
}
/**
 * Constructs a lexical-variables of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterLexical a child of the new lexical-variables
 * \param[in] wsAfterVariables a child of the new lexical-variables
 * \param[in] Productions a child of the new lexical-variables
 * \return A pointer to a lexical-variables, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarLexicalVariables(SDF_OptLayout wsAfterLexical, SDF_OptLayout wsAfterVariables, SDF_Productions Productions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun68))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun69)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Productions), (ATerm) wsAfterVariables), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(118)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun68)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(98)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(118)))), (ATerm) wsAfterLexical), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a empty-grammar of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \return A pointer to a empty-grammar, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarEmptyGrammar(void) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun70))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun71)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun70)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(41)), (ATerm)ATmakeInt(47)), (ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a conc-grammars of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] left a child of the new conc-grammars
 * \param[in] wsAfterLeft a child of the new conc-grammars
 * \param[in] right a child of the new conc-grammars
 * \return A pointer to a conc-grammars, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarConcGrammars(SDF_Grammar left, SDF_OptLayout wsAfterLeft, SDF_Grammar right) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun72)))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun74))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a Bracket of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] Grammar a child of the new Bracket
 * \param[in] wsAfterGrammar a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarBracket(SDF_OptLayout wsAfterParenOpen, SDF_Grammar Grammar, SDF_OptLayout wsAfterGrammar) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterGrammar), (ATerm) Grammar), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a syntax of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterSyntax a child of the new syntax
 * \param[in] Productions a child of the new syntax
 * \return A pointer to a syntax, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarSyntax(SDF_OptLayout wsAfterSyntax, SDF_Productions Productions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun63)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Productions), (ATerm) wsAfterSyntax), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun63)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)))));
}
/**
 * Constructs a imp-section of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] ImpSection a child of the new imp-section
 * \return A pointer to a imp-section, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarImpSection(SDF_ImpSection ImpSection) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun76)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun77)))))), (ATerm)ATmakeList1((ATerm) ImpSection));
}
/**
 * Constructs a priorities of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterPriorities a child of the new priorities
 * \param[in] Priorities a child of the new priorities
 * \return A pointer to a priorities, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarPriorities(SDF_OptLayout wsAfterPriorities, SDF_Priorities Priorities) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun78)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun79)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Priorities), (ATerm) wsAfterPriorities), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(112)))));
}
/**
 * Constructs a restrictions of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterRestrictions a child of the new restrictions
 * \param[in] Restrictions a child of the new restrictions
 * \return A pointer to a restrictions, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarRestrictions(SDF_OptLayout wsAfterRestrictions, SDF_Restrictions Restrictions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun80)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun81)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Restrictions), (ATerm) wsAfterRestrictions), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)))));
}
/**
 * Constructs a lexical-priorities of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterLexical a child of the new lexical-priorities
 * \param[in] wsAfterPriorities a child of the new lexical-priorities
 * \param[in] Priorities a child of the new lexical-priorities
 * \return A pointer to a lexical-priorities, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarLexicalPriorities(SDF_OptLayout wsAfterLexical, SDF_OptLayout wsAfterPriorities, SDF_Priorities Priorities) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun78)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun82)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Priorities), (ATerm) wsAfterPriorities), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(112)))), (ATerm) wsAfterLexical), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a context-free-priorities of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterContextFree a child of the new context-free-priorities
 * \param[in] wsAfterPriorities a child of the new context-free-priorities
 * \param[in] Priorities a child of the new context-free-priorities
 * \return A pointer to a context-free-priorities, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarContextFreePriorities(SDF_OptLayout wsAfterContextFree, SDF_OptLayout wsAfterPriorities, SDF_Priorities Priorities) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun78)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun83)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Priorities), (ATerm) wsAfterPriorities), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun79)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(112)))), (ATerm) wsAfterContextFree), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(99)))));
}
/**
 * Constructs a lexical-restrictions of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterLexical a child of the new lexical-restrictions
 * \param[in] wsAfterRestrictions a child of the new lexical-restrictions
 * \param[in] Restrictions a child of the new lexical-restrictions
 * \return A pointer to a lexical-restrictions, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarLexicalRestrictions(SDF_OptLayout wsAfterLexical, SDF_OptLayout wsAfterRestrictions, SDF_Restrictions Restrictions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun80)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun84)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Restrictions), (ATerm) wsAfterRestrictions), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)))), (ATerm) wsAfterLexical), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a context-free-restrictions of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterContextFree a child of the new context-free-restrictions
 * \param[in] wsAfterRestrictions a child of the new context-free-restrictions
 * \param[in] Restrictions a child of the new context-free-restrictions
 * \return A pointer to a context-free-restrictions, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarContextFreeRestrictions(SDF_OptLayout wsAfterContextFree, SDF_OptLayout wsAfterRestrictions, SDF_Restrictions Restrictions) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun80)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun85)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Restrictions), (ATerm) wsAfterRestrictions), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun81)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)))), (ATerm) wsAfterContextFree), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(99)))));
}
/**
 * Constructs a sorts of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterSorts a child of the new sorts
 * \param[in] Symbols a child of the new sorts
 * \return A pointer to a sorts, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarSorts(SDF_OptLayout wsAfterSorts, SDF_Symbols Symbols) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun87))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun87)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Symbols), (ATerm) wsAfterSorts), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun87)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(115)))));
}
/**
 * Constructs a kernel-start-symbols of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterStartSymbols a child of the new kernel-start-symbols
 * \param[in] Symbols a child of the new kernel-start-symbols
 * \return A pointer to a kernel-start-symbols, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarKernelStartSymbols(SDF_OptLayout wsAfterStartSymbols, SDF_Symbols Symbols) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun89)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Symbols), (ATerm) wsAfterStartSymbols), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(109)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(98)), (ATerm)ATmakeInt(109)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)))));
}
/**
 * Constructs a lexical-start-symbols of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterLexical a child of the new lexical-start-symbols
 * \param[in] wsAfterStartSymbols a child of the new lexical-start-symbols
 * \param[in] Symbols a child of the new lexical-start-symbols
 * \return A pointer to a lexical-start-symbols, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarLexicalStartSymbols(SDF_OptLayout wsAfterLexical, SDF_OptLayout wsAfterStartSymbols, SDF_Symbols Symbols) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun90)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Symbols), (ATerm) wsAfterStartSymbols), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(109)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(98)), (ATerm)ATmakeInt(109)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)))), (ATerm) wsAfterLexical), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun64)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a context-free-start-symbols of type SDF_Grammar. Like all ATerm types, SDF_Grammars are maximally shared.
 * \param[in] wsAfterContextFree a child of the new context-free-start-symbols
 * \param[in] wsAfterStartSymbols a child of the new context-free-start-symbols
 * \param[in] Symbols a child of the new context-free-start-symbols
 * \return A pointer to a context-free-start-symbols, either newly constructed or shared
 */
SDF_Grammar SDF_makeGrammarContextFreeStartSymbols(SDF_OptLayout wsAfterContextFree, SDF_OptLayout wsAfterStartSymbols, SDF_Symbols Symbols) {
  return (SDF_Grammar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun91)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Symbols), (ATerm) wsAfterStartSymbols), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(109)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(121)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun88)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(98)), (ATerm)ATmakeInt(109)), (ATerm)ATmakeInt(121)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(115)))), (ATerm) wsAfterContextFree), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun66)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(99)))));
}
/**
 * Constructs a alias of type SDF_Alias. Like all ATerm types, SDF_Aliass are maximally shared.
 * \param[in] Symbol a child of the new alias
 * \param[in] wsAfterSymbol a child of the new alias
 * \param[in] wsAfterArrow a child of the new alias
 * \param[in] alias a child of the new alias
 * \return A pointer to a alias, either newly constructed or shared
 */
SDF_Alias SDF_makeAliasAlias(SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_OptLayout wsAfterArrow, SDF_Symbol alias) {
  return (SDF_Alias)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun94))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun95)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) alias), (ATerm) wsAfterArrow), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbol), (ATerm) Symbol));
}
/**
 * Constructs a Default of type SDF_Aliases. Like all ATerm types, SDF_Aliasess are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Aliases SDF_makeAliasesDefault(SDF_AliasList list) {
  return (SDF_Aliases)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun94))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun59))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun94))))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_AliasList. Like all ATerm types, SDF_AliasLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_AliasList SDF_makeAliasListEmpty(void) {
  return (SDF_AliasList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_AliasList. Like all ATerm types, SDF_AliasLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_AliasList SDF_makeAliasListSingle(SDF_Alias head) {
  return (SDF_AliasList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_AliasList. Like all ATerm types, SDF_AliasLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_AliasList SDF_makeAliasListMany(SDF_Alias head, SDF_OptLayout wsAfterHead, SDF_AliasList tail) {
  if (SDF_isAliasListEmpty(tail)) {
    return SDF_makeAliasListSingle(head);
  }
  return (SDF_AliasList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a cf of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterLessThan a child of the new cf
 * \param[in] Symbol a child of the new cf
 * \param[in] wsAfterSymbol a child of the new cf
 * \param[in] wsAfterCF a child of the new cf
 * \return A pointer to a cf, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolCf(SDF_OptLayout wsAfterLessThan, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_OptLayout wsAfterCF) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun97))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun98)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterCF), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(70)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(67)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun97)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(70)), (ATerm)ATmakeInt(67)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a lex of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterLessThan a child of the new lex
 * \param[in] Symbol a child of the new lex
 * \param[in] wsAfterSymbol a child of the new lex
 * \param[in] wsAfterLEX a child of the new lex
 * \return A pointer to a lex, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolLex(SDF_OptLayout wsAfterLessThan, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_OptLayout wsAfterLEX) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun99))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun100)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterLEX), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(88)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(69)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(76)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun99)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(88)), (ATerm)ATmakeInt(69)), (ATerm)ATmakeInt(76)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a varsym of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterLessThan a child of the new varsym
 * \param[in] Symbol a child of the new varsym
 * \param[in] wsAfterSymbol a child of the new varsym
 * \param[in] wsAfterVAR a child of the new varsym
 * \return A pointer to a varsym, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolVarsym(SDF_OptLayout wsAfterLessThan, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_OptLayout wsAfterVAR) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun101))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun102)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterVAR), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(82)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(65)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(86)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun101)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(82)), (ATerm)ATmakeInt(65)), (ATerm)ATmakeInt(86)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a layout of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \return A pointer to a layout, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolLayout(void) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun103))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun104)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(85)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(79)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(89)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(65)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(76)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun103)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(85)), (ATerm)ATmakeInt(79)), (ATerm)ATmakeInt(89)), (ATerm)ATmakeInt(65)), (ATerm)ATmakeInt(76)))));
}
/**
 * Constructs a char-class of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] CharClass a child of the new char-class
 * \return A pointer to a char-class, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolCharClass(SDF_CharClass CharClass) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun106)))))), (ATerm)ATmakeList1((ATerm) CharClass));
}
/**
 * Constructs a label of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Label a child of the new label
 * \param[in] wsAfterLabel a child of the new label
 * \param[in] wsAfterColon a child of the new label
 * \param[in] Symbol a child of the new label
 * \return A pointer to a label, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolLabel(SDF_Label Label, SDF_OptLayout wsAfterLabel, SDF_OptLayout wsAfterColon, SDF_Symbol Symbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun107))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun108)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun109)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Symbol), (ATerm) wsAfterColon), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(58)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun107)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(58)))), (ATerm) wsAfterLabel), (ATerm) Label));
}
/**
 * Constructs a lifting of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterLeftQuote a child of the new lifting
 * \param[in] Symbol a child of the new lifting
 * \param[in] wsAfterSymbol a child of the new lifting
 * \return A pointer to a lifting, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolLifting(SDF_OptLayout wsAfterLeftQuote, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun110))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun110))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun111)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(96)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun110)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(96)))), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterLeftQuote), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(96)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun110)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(96)))));
}
/**
 * Constructs a lit of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] string a child of the new lit
 * \return A pointer to a lit, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolLit(SDF_StrCon string) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun112)))))), (ATerm)ATmakeList1((ATerm) string));
}
/**
 * Constructs a ci-lit of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] ciString a child of the new ci-lit
 * \return A pointer to a ci-lit, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolCiLit(SDF_SingleQuotedStrCon ciString) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun113)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun114)))))), (ATerm)ATmakeList1((ATerm) ciString));
}
/**
 * Constructs a empty of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new empty
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolEmpty(SDF_OptLayout wsAfterParenOpen) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun115)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a seq of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new seq
 * \param[in] head a child of the new seq
 * \param[in] wsAfterHead a child of the new seq
 * \param[in] tail a child of the new seq
 * \param[in] wsAfterTail a child of the new seq
 * \return A pointer to a seq, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolSeq(SDF_OptLayout wsAfterParenOpen, SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_SymbolTail tail, SDF_OptLayout wsAfterTail) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun116)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterTail), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))))), (ATerm) tail)), (ATerm) wsAfterHead), (ATerm) head), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a opt of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Symbol a child of the new opt
 * \param[in] wsAfterSymbol a child of the new opt
 * \return A pointer to a opt, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolOpt(SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun117))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun118)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(63)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun117)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(63)))), (ATerm) wsAfterSymbol), (ATerm) Symbol));
}
/**
 * Constructs a iter of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Symbol a child of the new iter
 * \param[in] wsAfterSymbol a child of the new iter
 * \return A pointer to a iter, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolIter(SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun119)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))), (ATerm) wsAfterSymbol), (ATerm) Symbol));
}
/**
 * Constructs a iter-star of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Symbol a child of the new iter-star
 * \param[in] wsAfterSymbol a child of the new iter-star
 * \return A pointer to a iter-star, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolIterStar(SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun120))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun121)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(42)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun120)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(42)))), (ATerm) wsAfterSymbol), (ATerm) Symbol));
}
/**
 * Constructs a iter-sep of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new iter-sep
 * \param[in] Symbol a child of the new iter-sep
 * \param[in] wsAfterSymbol a child of the new iter-sep
 * \param[in] sep a child of the new iter-sep
 * \param[in] wsAfterSep a child of the new iter-sep
 * \param[in] wsAfterBraceClose a child of the new iter-sep
 * \return A pointer to a iter-sep, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolIterSep(SDF_OptLayout wsAfterBraceOpen, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_Symbol sep, SDF_OptLayout wsAfterSep, SDF_OptLayout wsAfterBraceClose) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun122)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun49)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(43)))), (ATerm) wsAfterBraceClose), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterSep), (ATerm) sep), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a iter-star-sep of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new iter-star-sep
 * \param[in] Symbol a child of the new iter-star-sep
 * \param[in] wsAfterSymbol a child of the new iter-star-sep
 * \param[in] sep a child of the new iter-star-sep
 * \param[in] wsAfterSep a child of the new iter-star-sep
 * \param[in] wsAfterBraceClose a child of the new iter-star-sep
 * \return A pointer to a iter-star-sep, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolIterStarSep(SDF_OptLayout wsAfterBraceOpen, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol, SDF_Symbol sep, SDF_OptLayout wsAfterSep, SDF_OptLayout wsAfterBraceClose) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun120))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun123)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(42)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun120)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(42)))), (ATerm) wsAfterBraceClose), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterSep), (ATerm) sep), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a tuple of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterLessThan a child of the new tuple
 * \param[in] head a child of the new tuple
 * \param[in] wsAfterHead a child of the new tuple
 * \param[in] wsAfterComma a child of the new tuple
 * \param[in] rest a child of the new tuple
 * \param[in] wsAfterRest a child of the new tuple
 * \return A pointer to a tuple, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolTuple(SDF_OptLayout wsAfterLessThan, SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterComma, SDF_SymbolRest rest, SDF_OptLayout wsAfterRest) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun124)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterRest), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) rest)), (ATerm) wsAfterComma), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a func of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new func
 * \param[in] arguments a child of the new func
 * \param[in] wsAfterArguments a child of the new func
 * \param[in] wsAfterEqualsGreaterThan a child of the new func
 * \param[in] results a child of the new func
 * \param[in] wsAfterResults a child of the new func
 * \return A pointer to a func, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolFunc(SDF_OptLayout wsAfterParenOpen, SDF_Symbols arguments, SDF_OptLayout wsAfterArguments, SDF_OptLayout wsAfterEqualsGreaterThan, SDF_Symbol results, SDF_OptLayout wsAfterResults) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun126)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterResults), (ATerm) results), (ATerm) wsAfterEqualsGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(61)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(61)))), (ATerm) wsAfterArguments), (ATerm) arguments), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a alt of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] left a child of the new alt
 * \param[in] wsAfterLeft a child of the new alt
 * \param[in] wsAfterBar a child of the new alt
 * \param[in] right a child of the new alt
 * \return A pointer to a alt, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolAlt(SDF_Symbol left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterBar, SDF_Symbol right) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun127))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun128)))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun129))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterBar), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(124)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun127)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(124)))), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a strategy of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new strategy
 * \param[in] left a child of the new strategy
 * \param[in] wsAfterLeft a child of the new strategy
 * \param[in] wsAfterGreaterThan a child of the new strategy
 * \param[in] right a child of the new strategy
 * \param[in] wsAfterRight a child of the new strategy
 * \return A pointer to a strategy, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolStrategy(SDF_OptLayout wsAfterParenOpen, SDF_Symbol left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterGreaterThan, SDF_Symbol right, SDF_OptLayout wsAfterRight) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun130)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterRight), (ATerm) right), (ATerm) wsAfterGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterLeft), (ATerm) left), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a start of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \return A pointer to a start, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolStart(void) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun44))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun131)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(82)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(65)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(83)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun44)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(82)), (ATerm)ATmakeInt(65)), (ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(83)), (ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a file-start of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \return A pointer to a file-start, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolFileStart(void) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun132))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun133)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(83)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun132)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(83)), (ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a sort of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Sort a child of the new sort
 * \return A pointer to a sort, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolSort(SDF_Sort Sort) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun135)))))), (ATerm)ATmakeList1((ATerm) Sort));
}
/**
 * Constructs a parameterized-sort of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] Sort a child of the new parameterized-sort
 * \param[in] wsAfterSort a child of the new parameterized-sort
 * \param[in] wsAfterBracketOpenBracketOpen a child of the new parameterized-sort
 * \param[in] parameters a child of the new parameterized-sort
 * \param[in] wsAfterParameters a child of the new parameterized-sort
 * \return A pointer to a parameterized-sort, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolParameterizedSort(SDF_Sort Sort, SDF_OptLayout wsAfterSort, SDF_OptLayout wsAfterBracketOpenBracketOpen, SDF_SymbolParameters parameters, SDF_OptLayout wsAfterParameters) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun136))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun137))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun138)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun136)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(93)), (ATerm)ATmakeInt(93)))), (ATerm) wsAfterParameters), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) parameters)), (ATerm) wsAfterBracketOpenBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun137)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(91)), (ATerm)ATmakeInt(91)))), (ATerm) wsAfterSort), (ATerm) Sort));
}
/**
 * Constructs a Bracket of type SDF_Symbol. Like all ATerm types, SDF_Symbols are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] Symbol a child of the new Bracket
 * \param[in] wsAfterSymbol a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_Symbol SDF_makeSymbolBracket(SDF_OptLayout wsAfterParenOpen, SDF_Symbol Symbol, SDF_OptLayout wsAfterSymbol) {
  return (SDF_Symbol)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterSymbol), (ATerm) Symbol), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a Default of type SDF_CharRange. Like all ATerm types, SDF_CharRanges are maximally shared.
 * \param[in] Character a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_CharRange SDF_makeCharRangeDefault(SDF_Character Character) {
  return (SDF_CharRange)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun140))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) Character));
}
/**
 * Constructs a range of type SDF_CharRange. Like all ATerm types, SDF_CharRanges are maximally shared.
 * \param[in] start a child of the new range
 * \param[in] wsAfterStart a child of the new range
 * \param[in] wsAfter a child of the new range
 * \param[in] end a child of the new range
 * \return A pointer to a range, either newly constructed or shared
 */
SDF_CharRange SDF_makeCharRangeRange(SDF_Character start, SDF_OptLayout wsAfterStart, SDF_OptLayout wsAfter, SDF_Character end) {
  return (SDF_CharRange)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun51))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun140))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun141)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) end), (ATerm) wsAfter), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun51)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm) wsAfterStart), (ATerm) start));
}
/**
 * Constructs a Default of type SDF_CharRanges. Like all ATerm types, SDF_CharRangess are maximally shared.
 * \param[in] CharRange a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_CharRanges SDF_makeCharRangesDefault(SDF_CharRange CharRange) {
  return (SDF_CharRanges)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun140)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) CharRange));
}
/**
 * Constructs a conc of type SDF_CharRanges. Like all ATerm types, SDF_CharRangess are maximally shared.
 * \param[in] left a child of the new conc
 * \param[in] wsAfterLeft a child of the new conc
 * \param[in] right a child of the new conc
 * \return A pointer to a conc, either newly constructed or shared
 */
SDF_CharRanges SDF_makeCharRangesConc(SDF_CharRanges left, SDF_OptLayout wsAfterLeft, SDF_CharRanges right) {
  return (SDF_CharRanges)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl0(SDF_afun143))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun129))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun144)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a Bracket of type SDF_CharRanges. Like all ATerm types, SDF_CharRangess are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] CharRanges a child of the new Bracket
 * \param[in] wsAfterCharRanges a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_CharRanges SDF_makeCharRangesBracket(SDF_OptLayout wsAfterParenOpen, SDF_CharRanges CharRanges, SDF_OptLayout wsAfterCharRanges) {
  return (SDF_CharRanges)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterCharRanges), (ATerm) CharRanges), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a absent of type SDF_OptCharRanges. Like all ATerm types, SDF_OptCharRangess are maximally shared.
 * \return A pointer to a absent, either newly constructed or shared
 */
SDF_OptCharRanges SDF_makeOptCharRangesAbsent(void) {
  return (SDF_OptCharRanges)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATempty, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun145))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun56)))))), (ATerm)ATempty);
}
/**
 * Constructs a present of type SDF_OptCharRanges. Like all ATerm types, SDF_OptCharRangess are maximally shared.
 * \param[in] CharRanges a child of the new present
 * \return A pointer to a present, either newly constructed or shared
 */
SDF_OptCharRanges SDF_makeOptCharRangesPresent(SDF_CharRanges CharRanges) {
  return (SDF_OptCharRanges)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun142)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun145))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun55)))))), (ATerm)ATmakeList1((ATerm) CharRanges));
}
/**
 * Constructs a simple-charclass of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] wsAfterBracketOpen a child of the new simple-charclass
 * \param[in] OptCharRanges a child of the new simple-charclass
 * \param[in] wsAfterOptCharRanges a child of the new simple-charclass
 * \return A pointer to a simple-charclass, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassSimpleCharclass(SDF_OptLayout wsAfterBracketOpen, SDF_OptCharRanges OptCharRanges, SDF_OptLayout wsAfterOptCharRanges) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun145)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun146)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm) wsAfterOptCharRanges), (ATerm) OptCharRanges), (ATerm) wsAfterBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))));
}
/**
 * Constructs a comp of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] wsAfterTilde a child of the new comp
 * \param[in] CharClass a child of the new comp
 * \return A pointer to a comp, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassComp(SDF_OptLayout wsAfterTilde, SDF_CharClass CharClass) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun147))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun148)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) CharClass), (ATerm) wsAfterTilde), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(126)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun147)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(126)))));
}
/**
 * Constructs a diff of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] left a child of the new diff
 * \param[in] wsAfterLeft a child of the new diff
 * \param[in] wsAfterSlash a child of the new diff
 * \param[in] right a child of the new diff
 * \return A pointer to a diff, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassDiff(SDF_CharClass left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterSlash, SDF_CharClass right) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl0(SDF_afun143))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun150))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun151)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterSlash), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a isect of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] left a child of the new isect
 * \param[in] wsAfterLeft a child of the new isect
 * \param[in] wsAfterSlashBackslash a child of the new isect
 * \param[in] right a child of the new isect
 * \return A pointer to a isect, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassIsect(SDF_CharClass left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterSlashBackslash, SDF_CharClass right) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun152))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl0(SDF_afun143))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun150))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun153)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterSlashBackslash), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun152)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(92)), (ATerm)ATmakeInt(47)))), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a union of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] left a child of the new union
 * \param[in] wsAfterLeft a child of the new union
 * \param[in] wsAfterBackslashSlash a child of the new union
 * \param[in] right a child of the new union
 * \return A pointer to a union, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassUnion(SDF_CharClass left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterBackslashSlash, SDF_CharClass right) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun154))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun150))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun155)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterBackslashSlash), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun154)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(47)), (ATerm)ATmakeInt(92)))), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a Bracket of type SDF_CharClass. Like all ATerm types, SDF_CharClasss are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] CharClass a child of the new Bracket
 * \param[in] wsAfterCharClass a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_CharClass SDF_makeCharClassBracket(SDF_OptLayout wsAfterParenOpen, SDF_CharClass CharClass, SDF_OptLayout wsAfterCharClass) {
  return (SDF_CharClass)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl0(SDF_afun156)), (ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterCharClass), (ATerm) CharClass), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a digits of type SDF_LexNumChar. Like all ATerm types, SDF_LexNumChars are maximally shared.
 * \param[in] number a child of the new digits
 * \return A pointer to a digits, either newly constructed or shared
 */
SDF_LexNumChar SDF_makeLexNumCharDigits(const char* number) {
  return (SDF_LexNumChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun158))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun159)))))), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))))), (ATerm) ((ATerm) SDF_stringToChars(number)))), (ATerm)ATmakeInt(92)));
}
/**
 * Constructs a Lex-to-cf of type SDF_NumChar. Like all ATerm types, SDF_NumChars are maximally shared.
 * \param[in] NumChar a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_NumChar SDF_makeNumCharLexToCf(SDF_LexNumChar NumChar) {
  return (SDF_NumChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun158)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun158))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) NumChar));
}
/**
 * Constructs a regular of type SDF_LexShortChar. Like all ATerm types, SDF_LexShortChars are maximally shared.
 * \param[in] character a child of the new regular
 * \return A pointer to a regular, either newly constructed or shared
 */
SDF_LexShortChar SDF_makeLexShortCharRegular(char character) {
  return (SDF_LexShortChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun160))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun161)))))), (ATerm)ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(character))));
}
/**
 * Constructs a escaped of type SDF_LexShortChar. Like all ATerm types, SDF_LexShortChars are maximally shared.
 * \param[in] escape a child of the new escaped
 * \return A pointer to a escaped, either newly constructed or shared
 */
SDF_LexShortChar SDF_makeLexShortCharEscaped(char escape) {
  return (SDF_LexShortChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(123), (ATerm)ATmakeInt(255))), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(91), (ATerm)ATmakeInt(96))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(58), (ATerm)ATmakeInt(64))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(32), (ATerm)ATmakeInt(47))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun160))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun162)))))), (ATerm)ATinsert(ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(escape))), (ATerm)ATmakeInt(92)));
}
/**
 * Constructs a Lex-to-cf of type SDF_ShortChar. Like all ATerm types, SDF_ShortChars are maximally shared.
 * \param[in] ShortChar a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_ShortChar SDF_makeShortCharLexToCf(SDF_LexShortChar ShortChar) {
  return (SDF_ShortChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun160)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun160))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) ShortChar));
}
/**
 * Constructs a numeric of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \param[in] NumChar a child of the new numeric
 * \return A pointer to a numeric, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterNumeric(SDF_NumChar NumChar) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun158)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun163)))))), (ATerm)ATmakeList1((ATerm) NumChar));
}
/**
 * Constructs a short of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \param[in] ShortChar a child of the new short
 * \return A pointer to a short, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterShort(SDF_ShortChar ShortChar) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun160)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun164)))))), (ATerm)ATmakeList1((ATerm) ShortChar));
}
/**
 * Constructs a top of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \return A pointer to a top, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterTop(void) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun165))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun166)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(80)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(79)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun165)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(80)), (ATerm)ATmakeInt(79)), (ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a eof of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \return A pointer to a eof, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterEof(void) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun167))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun168)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(70)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(79)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(69)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun167)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(70)), (ATerm)ATmakeInt(79)), (ATerm)ATmakeInt(69)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a bot of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \return A pointer to a bot, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterBot(void) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun169))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun170)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(79)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(66)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun169)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(79)), (ATerm)ATmakeInt(66)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a label_start of type SDF_Character. Like all ATerm types, SDF_Characters are maximally shared.
 * \return A pointer to a label_start, either newly constructed or shared
 */
SDF_Character SDF_makeCharacterLabelUnderscoreStart(void) {
  return (SDF_Character)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun171))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun139))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun172)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(82)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(65)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(84)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(83)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(95)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(76)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(69)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(66)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(65)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(76)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun171)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(82)), (ATerm)ATmakeInt(65)), (ATerm)ATmakeInt(84)), (ATerm)ATmakeInt(83)), (ATerm)ATmakeInt(95)), (ATerm)ATmakeInt(76)), (ATerm)ATmakeInt(69)), (ATerm)ATmakeInt(66)), (ATerm)ATmakeInt(65)), (ATerm)ATmakeInt(76)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a default of type SDF_ATermAttribute. Like all ATerm types, SDF_ATermAttributes are maximally shared.
 * \param[in] aterm a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_ATermAttribute SDF_makeATermAttributeDefault(SDF_ATerm aterm) {
  return (SDF_ATermAttribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun19)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun173))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATmakeList1((ATerm) aterm));
}
/**
 * Constructs a term of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \param[in] ATermAttribute a child of the new term
 * \return A pointer to a term, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeTerm(SDF_ATermAttribute ATermAttribute) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun173)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun175)))))), (ATerm)ATmakeList1((ATerm) ATermAttribute));
}
/**
 * Constructs a id of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \param[in] wsAfterId a child of the new id
 * \param[in] wsAfterParenOpen a child of the new id
 * \param[in] ModuleName a child of the new id
 * \param[in] wsAfterModuleName a child of the new id
 * \return A pointer to a id, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeId(SDF_OptLayout wsAfterId, SDF_OptLayout wsAfterParenOpen, SDF_ModuleName ModuleName, SDF_OptLayout wsAfterModuleName) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun177))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun177)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterModuleName), (ATerm) ModuleName), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm) wsAfterId), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun177)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(100)), (ATerm)ATmakeInt(105)))));
}
/**
 * Constructs a bracket of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \return A pointer to a bracket, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeBracket(void) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun178))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun178)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(107)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(98)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun178)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(107)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(98)))));
}
/**
 * Constructs a assoc of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \param[in] Associativity a child of the new assoc
 * \return A pointer to a assoc, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeAssoc(SDF_Associativity Associativity) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun180)))))), (ATerm)ATmakeList1((ATerm) Associativity));
}
/**
 * Constructs a reject of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \return A pointer to a reject, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeReject(void) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun181))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun181)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(106)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun181)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(106)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)))));
}
/**
 * Constructs a prefer of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \return A pointer to a prefer, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributePrefer(void) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun182))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun182)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun182)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(112)))));
}
/**
 * Constructs a avoid of type SDF_Attribute. Like all ATerm types, SDF_Attributes are maximally shared.
 * \return A pointer to a avoid, either newly constructed or shared
 */
SDF_Attribute SDF_makeAttributeAvoid(void) {
  return (SDF_Attribute)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun183))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun183)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(118)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun183)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(100)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(118)), (ATerm)ATmakeInt(97)))));
}
/**
 * Constructs a attrs of type SDF_Attributes. Like all ATerm types, SDF_Attributess are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new attrs
 * \param[in] list a child of the new attrs
 * \param[in] wsAfterList a child of the new attrs
 * \return A pointer to a attrs, either newly constructed or shared
 */
SDF_Attributes SDF_makeAttributesAttrs(SDF_OptLayout wsAfterBraceOpen, SDF_AttributeList list, SDF_OptLayout wsAfterList) {
  return (SDF_Attributes)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun184))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun185)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterList), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun174)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) list)), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a no-attrs of type SDF_Attributes. Like all ATerm types, SDF_Attributess are maximally shared.
 * \return A pointer to a no-attrs, either newly constructed or shared
 */
SDF_Attributes SDF_makeAttributesNoAttrs(void) {
  return (SDF_Attributes)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATempty, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun184))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun186)))))), (ATerm)ATempty);
}
/**
 * Constructs a prod of type SDF_Production. Like all ATerm types, SDF_Productions are maximally shared.
 * \param[in] Symbols a child of the new prod
 * \param[in] wsAfterSymbols a child of the new prod
 * \param[in] wsAfterGreaterThan a child of the new prod
 * \param[in] result a child of the new prod
 * \param[in] wsAfterResult a child of the new prod
 * \param[in] Attributes a child of the new prod
 * \return A pointer to a prod, either newly constructed or shared
 */
SDF_Production SDF_makeProductionProd(SDF_Symbols Symbols, SDF_OptLayout wsAfterSymbols, SDF_OptLayout wsAfterGreaterThan, SDF_Symbol result, SDF_OptLayout wsAfterResult, SDF_Attributes Attributes) {
  return (SDF_Production)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun184)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun188)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Attributes), (ATerm) wsAfterResult), (ATerm) result), (ATerm) wsAfterGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbols), (ATerm) Symbols));
}
/**
 * Constructs a prefix-fun of type SDF_Production. Like all ATerm types, SDF_Productions are maximally shared.
 * \param[in] fun a child of the new prefix-fun
 * \param[in] wsAfterFun a child of the new prefix-fun
 * \param[in] wsAfterParenOpen a child of the new prefix-fun
 * \param[in] arguments a child of the new prefix-fun
 * \param[in] wsAfterArguments a child of the new prefix-fun
 * \param[in] wsAfterParenClose a child of the new prefix-fun
 * \param[in] wsAfterGreaterThan a child of the new prefix-fun
 * \param[in] result a child of the new prefix-fun
 * \param[in] wsAfterResult a child of the new prefix-fun
 * \param[in] Attributes a child of the new prefix-fun
 * \return A pointer to a prefix-fun, either newly constructed or shared
 */
SDF_Production SDF_makeProductionPrefixFun(SDF_FunctionName fun, SDF_OptLayout wsAfterFun, SDF_OptLayout wsAfterParenOpen, SDF_SymbolArguments arguments, SDF_OptLayout wsAfterArguments, SDF_OptLayout wsAfterParenClose, SDF_OptLayout wsAfterGreaterThan, SDF_Symbol result, SDF_OptLayout wsAfterResult, SDF_Attributes Attributes) {
  return (SDF_Production)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun184)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun189)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun190)))), (ATerm)ATmakeAppl0(SDF_afun156)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Attributes), (ATerm) wsAfterResult), (ATerm) result), (ATerm) wsAfterGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun93)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterParenClose), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterArguments), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) arguments)), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm) wsAfterFun), (ATerm) fun));
}
/**
 * Constructs a Default of type SDF_Productions. Like all ATerm types, SDF_Productionss are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Productions SDF_makeProductionsDefault(SDF_ProductionList list) {
  return (SDF_Productions)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187))))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_AttributeList. Like all ATerm types, SDF_AttributeLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_AttributeList SDF_makeAttributeListEmpty(void) {
  return (SDF_AttributeList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_AttributeList. Like all ATerm types, SDF_AttributeLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_AttributeList SDF_makeAttributeListSingle(SDF_Attribute head) {
  return (SDF_AttributeList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_AttributeList. Like all ATerm types, SDF_AttributeLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_AttributeList SDF_makeAttributeListMany(SDF_Attribute head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_AttributeList tail) {
  if (SDF_isAttributeListEmpty(tail)) {
    return SDF_makeAttributeListSingle(head);
  }
  return (SDF_AttributeList)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_ProductionList. Like all ATerm types, SDF_ProductionLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ProductionList SDF_makeProductionListEmpty(void) {
  return (SDF_ProductionList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ProductionList. Like all ATerm types, SDF_ProductionLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ProductionList SDF_makeProductionListSingle(SDF_Production head) {
  return (SDF_ProductionList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ProductionList. Like all ATerm types, SDF_ProductionLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ProductionList SDF_makeProductionListMany(SDF_Production head, SDF_OptLayout wsAfterHead, SDF_ProductionList tail) {
  if (SDF_isProductionListEmpty(tail)) {
    return SDF_makeProductionListSingle(head);
  }
  return (SDF_ProductionList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a quoted of type SDF_Label. Like all ATerm types, SDF_Labels are maximally shared.
 * \param[in] StrCon a child of the new quoted
 * \return A pointer to a quoted, either newly constructed or shared
 */
SDF_Label SDF_makeLabelQuoted(SDF_StrCon StrCon) {
  return (SDF_Label)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun108))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun15)))))), (ATerm)ATmakeList1((ATerm) StrCon));
}
/**
 * Constructs a unquoted of type SDF_Label. Like all ATerm types, SDF_Labels are maximally shared.
 * \param[in] IdCon a child of the new unquoted
 * \return A pointer to a unquoted, either newly constructed or shared
 */
SDF_Label SDF_makeLabelUnquoted(SDF_IdCon IdCon) {
  return (SDF_Label)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun108))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun17)))))), (ATerm)ATmakeList1((ATerm) IdCon));
}
/**
 * Constructs a newline of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \return A pointer to a newline, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharNewline(void) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun191))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun193)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun191)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a tab of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \return A pointer to a tab, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharTab(void) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun194))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun195)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun194)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a quote of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \return A pointer to a quote, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharQuote(void) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun196))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun197)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(39)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun196)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(39)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a backslash of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \return A pointer to a backslash, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharBackslash(void) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun198))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun199)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun198)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(92)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a decimal of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \param[in] a a child of the new decimal
 * \param[in] b a child of the new decimal
 * \param[in] c a child of the new decimal
 * \return A pointer to a decimal, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharDecimal(char a, char b, char c) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun200))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun201)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(c))), (ATerm) ((ATerm) SDF_byteToChar(b))), (ATerm) ((ATerm) SDF_byteToChar(a))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun200)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a normal of type SDF_LexSingleQuotedStrChar. Like all ATerm types, SDF_LexSingleQuotedStrChars are maximally shared.
 * \param[in] ch a child of the new normal
 * \return A pointer to a normal, either newly constructed or shared
 */
SDF_LexSingleQuotedStrChar SDF_makeLexSingleQuotedStrCharNormal(char ch) {
  return (SDF_LexSingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(93), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(40), (ATerm)ATmakeInt(91))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(32), (ATerm)ATmakeInt(38))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun202)))))), (ATerm)ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(ch))));
}
/**
 * Constructs a Lex-to-cf of type SDF_SingleQuotedStrChar. Like all ATerm types, SDF_SingleQuotedStrChars are maximally shared.
 * \param[in] SingleQuotedStrChar a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_SingleQuotedStrChar SDF_makeSingleQuotedStrCharLexToCf(SDF_LexSingleQuotedStrChar SingleQuotedStrChar) {
  return (SDF_SingleQuotedStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) SingleQuotedStrChar));
}
/**
 * Constructs a default of type SDF_LexSingleQuotedStrCon. Like all ATerm types, SDF_LexSingleQuotedStrCons are maximally shared.
 * \param[in] chars a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_LexSingleQuotedStrCon SDF_makeLexSingleQuotedStrConDefault(SDF_LexSingleQuotedStrCharChars chars) {
  return (SDF_LexSingleQuotedStrCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(39)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(39)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun113))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(39)), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun192))))), (ATerm) chars)), (ATerm)ATmakeInt(39)));
}
/**
 * Constructs a Lex-to-cf of type SDF_SingleQuotedStrCon. Like all ATerm types, SDF_SingleQuotedStrCons are maximally shared.
 * \param[in] SingleQuotedStrCon a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_SingleQuotedStrCon SDF_makeSingleQuotedStrConLexToCf(SDF_LexSingleQuotedStrCon SingleQuotedStrCon) {
  return (SDF_SingleQuotedStrCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun113)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun113))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) SingleQuotedStrCon));
}
/**
 * Constructs a unquoted-fun of type SDF_FunctionName. Like all ATerm types, SDF_FunctionNames are maximally shared.
 * \param[in] IdCon a child of the new unquoted-fun
 * \return A pointer to a unquoted-fun, either newly constructed or shared
 */
SDF_FunctionName SDF_makeFunctionNameUnquotedFun(SDF_IdCon IdCon) {
  return (SDF_FunctionName)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun189))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun203)))))), (ATerm)ATmakeList1((ATerm) IdCon));
}
/**
 * Constructs a quoted-fun of type SDF_FunctionName. Like all ATerm types, SDF_FunctionNames are maximally shared.
 * \param[in] StrCon a child of the new quoted-fun
 * \return A pointer to a quoted-fun, either newly constructed or shared
 */
SDF_FunctionName SDF_makeFunctionNameQuotedFun(SDF_StrCon StrCon) {
  return (SDF_FunctionName)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun189))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun204)))))), (ATerm)ATmakeList1((ATerm) StrCon));
}
/**
 * Constructs a empty of type SDF_LexSingleQuotedStrCharChars. Like all ATerm types, SDF_LexSingleQuotedStrCharCharss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharCharsEmpty(void) {
  return (SDF_LexSingleQuotedStrCharChars)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_LexSingleQuotedStrCharChars. Like all ATerm types, SDF_LexSingleQuotedStrCharCharss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharCharsSingle(SDF_LexSingleQuotedStrChar head) {
  return (SDF_LexSingleQuotedStrCharChars)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_LexSingleQuotedStrCharChars. Like all ATerm types, SDF_LexSingleQuotedStrCharCharss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_LexSingleQuotedStrCharChars SDF_makeLexSingleQuotedStrCharCharsMany(SDF_LexSingleQuotedStrChar head, SDF_LexSingleQuotedStrCharChars tail) {
  return (SDF_LexSingleQuotedStrCharChars)(ATerm)ATinsert((ATermList)tail, (ATerm) head);
}
/**
 * Constructs a empty of type SDF_SymbolArguments. Like all ATerm types, SDF_SymbolArgumentss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SymbolArguments SDF_makeSymbolArgumentsEmpty(void) {
  return (SDF_SymbolArguments)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SymbolArguments. Like all ATerm types, SDF_SymbolArgumentss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SymbolArguments SDF_makeSymbolArgumentsSingle(SDF_Symbol head) {
  return (SDF_SymbolArguments)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SymbolArguments. Like all ATerm types, SDF_SymbolArgumentss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SymbolArguments SDF_makeSymbolArgumentsMany(SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolArguments tail) {
  if (SDF_isSymbolArgumentsEmpty(tail)) {
    return SDF_makeSymbolArgumentsSingle(head);
  }
  return (SDF_SymbolArguments)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a word of type SDF_LexModuleWord. Like all ATerm types, SDF_LexModuleWords are maximally shared.
 * \param[in] letters a child of the new word
 * \return A pointer to a word, either newly constructed or shared
 */
SDF_LexModuleWord SDF_makeLexModuleWordWord(const char* letters) {
  return (SDF_LexModuleWord)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeInt(95)), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun205))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun206)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeInt(95)), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm) ((ATerm) SDF_stringToChars(letters)))));
}
/**
 * Constructs a Lex-to-cf of type SDF_ModuleWord. Like all ATerm types, SDF_ModuleWords are maximally shared.
 * \param[in] ModuleWord a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_ModuleWord SDF_makeModuleWordLexToCf(SDF_LexModuleWord ModuleWord) {
  return (SDF_ModuleWord)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun205)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun205))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) ModuleWord));
}
/**
 * Constructs a leaf of type SDF_LexModuleId. Like all ATerm types, SDF_LexModuleIds are maximally shared.
 * \param[in] ModuleWord a child of the new leaf
 * \return A pointer to a leaf, either newly constructed or shared
 */
SDF_LexModuleId SDF_makeLexModuleIdLeaf(SDF_LexModuleWord ModuleWord) {
  return (SDF_LexModuleId)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun205)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun208)))))), (ATerm)ATmakeList1((ATerm) ModuleWord));
}
/**
 * Constructs a root of type SDF_LexModuleId. Like all ATerm types, SDF_LexModuleIds are maximally shared.
 * \param[in] basename a child of the new root
 * \return A pointer to a root, either newly constructed or shared
 */
SDF_LexModuleId SDF_makeLexModuleIdRoot(SDF_LexModuleId basename) {
  return (SDF_LexModuleId)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun209)))))), (ATerm)ATinsert(ATmakeList1((ATerm) basename), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))));
}
/**
 * Constructs a path of type SDF_LexModuleId. Like all ATerm types, SDF_LexModuleIds are maximally shared.
 * \param[in] dirname a child of the new path
 * \param[in] basename a child of the new path
 * \return A pointer to a path, either newly constructed or shared
 */
SDF_LexModuleId SDF_makeLexModuleIdPath(SDF_LexModuleWord dirname, SDF_LexModuleId basename) {
  return (SDF_LexModuleId)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun205)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun210)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) basename), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun149)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm) dirname));
}
/**
 * Constructs a Lex-to-cf of type SDF_ModuleId. Like all ATerm types, SDF_ModuleIds are maximally shared.
 * \param[in] ModuleId a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_ModuleId SDF_makeModuleIdLexToCf(SDF_LexModuleId ModuleId) {
  return (SDF_ModuleId)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) ModuleId));
}
/**
 * Constructs a Default of type SDF_Definition. Like all ATerm types, SDF_Definitions are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Definition SDF_makeDefinitionDefault(SDF_ModuleList list) {
  return (SDF_Definition)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun45))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun211))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun45))))), (ATerm) list)));
}
/**
 * Constructs a module of type SDF_Module. Like all ATerm types, SDF_Modules are maximally shared.
 * \param[in] wsAfterModule a child of the new module
 * \param[in] ModuleName a child of the new module
 * \param[in] wsAfterModuleName a child of the new module
 * \param[in] list a child of the new module
 * \param[in] wsAfterList a child of the new module
 * \param[in] Sections a child of the new module
 * \return A pointer to a module, either newly constructed or shared
 */
SDF_Module SDF_makeModuleModule(SDF_OptLayout wsAfterModule, SDF_ModuleName ModuleName, SDF_OptLayout wsAfterModuleName, SDF_ImpSectionList list, SDF_OptLayout wsAfterList, SDF_Sections Sections) {
  return (SDF_Module)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun212)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun76))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun213))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun45))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun213)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Sections), (ATerm) wsAfterList), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun76))))), (ATerm) list)), (ATerm) wsAfterModuleName), (ATerm) ModuleName), (ATerm) wsAfterModule), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(117)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(109)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun213)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)), (ATerm)ATmakeInt(117)), (ATerm)ATmakeInt(100)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(109)))));
}
/**
 * Constructs a exports of type SDF_Section. Like all ATerm types, SDF_Sections are maximally shared.
 * \param[in] wsAfterExports a child of the new exports
 * \param[in] Grammar a child of the new exports
 * \return A pointer to a exports, either newly constructed or shared
 */
SDF_Section SDF_makeSectionExports(SDF_OptLayout wsAfterExports, SDF_Grammar Grammar) {
  return (SDF_Section)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun214))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun215))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun214)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Grammar), (ATerm) wsAfterExports), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(120)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun214)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(112)), (ATerm)ATmakeInt(120)), (ATerm)ATmakeInt(101)))));
}
/**
 * Constructs a hiddens of type SDF_Section. Like all ATerm types, SDF_Sections are maximally shared.
 * \param[in] wsAfterHiddens a child of the new hiddens
 * \param[in] Grammar a child of the new hiddens
 * \return A pointer to a hiddens, either newly constructed or shared
 */
SDF_Section SDF_makeSectionHiddens(SDF_OptLayout wsAfterHiddens, SDF_Grammar Grammar) {
  return (SDF_Section)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun61)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun216))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun215))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun216)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Grammar), (ATerm) wsAfterHiddens), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(104)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun216)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(100)), (ATerm)ATmakeInt(100)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(104)))));
}
/**
 * Constructs a Default of type SDF_Sections. Like all ATerm types, SDF_Sectionss are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Sections SDF_makeSectionsDefault(SDF_SectionList list) {
  return (SDF_Sections)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun215))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun212))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun215))))), (ATerm) list)));
}
/**
 * Constructs a unparameterized of type SDF_ModuleName. Like all ATerm types, SDF_ModuleNames are maximally shared.
 * \param[in] ModuleId a child of the new unparameterized
 * \return A pointer to a unparameterized, either newly constructed or shared
 */
SDF_ModuleName SDF_makeModuleNameUnparameterized(SDF_ModuleId ModuleId) {
  return (SDF_ModuleName)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun217)))))), (ATerm)ATmakeList1((ATerm) ModuleId));
}
/**
 * Constructs a parameterized of type SDF_ModuleName. Like all ATerm types, SDF_ModuleNames are maximally shared.
 * \param[in] ModuleId a child of the new parameterized
 * \param[in] wsAfterModuleId a child of the new parameterized
 * \param[in] wsAfterBracketOpen a child of the new parameterized
 * \param[in] params a child of the new parameterized
 * \param[in] wsAfterParams a child of the new parameterized
 * \return A pointer to a parameterized, either newly constructed or shared
 */
SDF_ModuleName SDF_makeModuleNameParameterized(SDF_ModuleId ModuleId, SDF_OptLayout wsAfterModuleId, SDF_OptLayout wsAfterBracketOpen, SDF_Symbols params, SDF_OptLayout wsAfterParams) {
  return (SDF_ModuleName)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun207)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun218)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm) wsAfterParams), (ATerm) params), (ATerm) wsAfterBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm) wsAfterModuleId), (ATerm) ModuleId));
}
/**
 * Constructs a imports of type SDF_ImpSection. Like all ATerm types, SDF_ImpSections are maximally shared.
 * \param[in] wsAfterImports a child of the new imports
 * \param[in] list a child of the new imports
 * \return A pointer to a imports, either newly constructed or shared
 */
SDF_ImpSection SDF_makeImpSectionImports(SDF_OptLayout wsAfterImports, SDF_Imports list) {
  return (SDF_ImpSection)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun219)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun220))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun76))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun220)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) list), (ATerm) wsAfterImports), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(112)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(109)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun220)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(114)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(112)), (ATerm)ATmakeInt(109)), (ATerm)ATmakeInt(105)))));
}
/**
 * Constructs a Default of type SDF_Imports. Like all ATerm types, SDF_Importss are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Imports SDF_makeImportsDefault(SDF_ImportList list) {
  return (SDF_Imports)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun219))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221))))), (ATerm) list)));
}
/**
 * Constructs a module of type SDF_Import. Like all ATerm types, SDF_Imports are maximally shared.
 * \param[in] ModuleName a child of the new module
 * \return A pointer to a module, either newly constructed or shared
 */
SDF_Import SDF_makeImportModule(SDF_ModuleName ModuleName) {
  return (SDF_Import)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun213)))))), (ATerm)ATmakeList1((ATerm) ModuleName));
}
/**
 * Constructs a renamed-module of type SDF_Import. Like all ATerm types, SDF_Imports are maximally shared.
 * \param[in] ModuleName a child of the new renamed-module
 * \param[in] wsAfterModuleName a child of the new renamed-module
 * \param[in] Renamings a child of the new renamed-module
 * \return A pointer to a renamed-module, either newly constructed or shared
 */
SDF_Import SDF_makeImportRenamedModule(SDF_ModuleName ModuleName, SDF_OptLayout wsAfterModuleName, SDF_Renamings Renamings) {
  return (SDF_Import)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun222)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun176)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun223)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Renamings), (ATerm) wsAfterModuleName), (ATerm) ModuleName));
}
/**
 * Constructs a Bracket of type SDF_Import. Like all ATerm types, SDF_Imports are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] Import a child of the new Bracket
 * \param[in] wsAfterImport a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_Import SDF_makeImportBracket(SDF_OptLayout wsAfterParenOpen, SDF_Import Import, SDF_OptLayout wsAfterImport) {
  return (SDF_Import)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun221))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterImport), (ATerm) Import), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a empty of type SDF_ModuleList. Like all ATerm types, SDF_ModuleLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ModuleList SDF_makeModuleListEmpty(void) {
  return (SDF_ModuleList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ModuleList. Like all ATerm types, SDF_ModuleLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ModuleList SDF_makeModuleListSingle(SDF_Module head) {
  return (SDF_ModuleList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ModuleList. Like all ATerm types, SDF_ModuleLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ModuleList SDF_makeModuleListMany(SDF_Module head, SDF_OptLayout wsAfterHead, SDF_ModuleList tail) {
  if (SDF_isModuleListEmpty(tail)) {
    return SDF_makeModuleListSingle(head);
  }
  return (SDF_ModuleList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_ImpSectionList. Like all ATerm types, SDF_ImpSectionLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ImpSectionList SDF_makeImpSectionListEmpty(void) {
  return (SDF_ImpSectionList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ImpSectionList. Like all ATerm types, SDF_ImpSectionLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ImpSectionList SDF_makeImpSectionListSingle(SDF_ImpSection head) {
  return (SDF_ImpSectionList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ImpSectionList. Like all ATerm types, SDF_ImpSectionLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ImpSectionList SDF_makeImpSectionListMany(SDF_ImpSection head, SDF_OptLayout wsAfterHead, SDF_ImpSectionList tail) {
  if (SDF_isImpSectionListEmpty(tail)) {
    return SDF_makeImpSectionListSingle(head);
  }
  return (SDF_ImpSectionList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_SectionList. Like all ATerm types, SDF_SectionLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SectionList SDF_makeSectionListEmpty(void) {
  return (SDF_SectionList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SectionList. Like all ATerm types, SDF_SectionLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SectionList SDF_makeSectionListSingle(SDF_Section head) {
  return (SDF_SectionList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SectionList. Like all ATerm types, SDF_SectionLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SectionList SDF_makeSectionListMany(SDF_Section head, SDF_OptLayout wsAfterHead, SDF_SectionList tail) {
  if (SDF_isSectionListEmpty(tail)) {
    return SDF_makeSectionListSingle(head);
  }
  return (SDF_SectionList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_ImportList. Like all ATerm types, SDF_ImportLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_ImportList SDF_makeImportListEmpty(void) {
  return (SDF_ImportList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_ImportList. Like all ATerm types, SDF_ImportLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_ImportList SDF_makeImportListSingle(SDF_Import head) {
  return (SDF_ImportList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_ImportList. Like all ATerm types, SDF_ImportLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_ImportList SDF_makeImportListMany(SDF_Import head, SDF_OptLayout wsAfterHead, SDF_ImportList tail) {
  if (SDF_isImportListEmpty(tail)) {
    return SDF_makeImportListSingle(head);
  }
  return (SDF_ImportList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a left of type SDF_Associativity. Like all ATerm types, SDF_Associativitys are maximally shared.
 * \return A pointer to a left, either newly constructed or shared
 */
SDF_Associativity SDF_makeAssociativityLeft(void) {
  return (SDF_Associativity)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun224))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun224)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(108)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun224)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(108)))));
}
/**
 * Constructs a right of type SDF_Associativity. Like all ATerm types, SDF_Associativitys are maximally shared.
 * \return A pointer to a right, either newly constructed or shared
 */
SDF_Associativity SDF_makeAssociativityRight(void) {
  return (SDF_Associativity)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun225))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun225)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(104)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(103)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(114)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun225)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(104)), (ATerm)ATmakeInt(103)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(114)))));
}
/**
 * Constructs a non-assoc of type SDF_Associativity. Like all ATerm types, SDF_Associativitys are maximally shared.
 * \return A pointer to a non-assoc, either newly constructed or shared
 */
SDF_Associativity SDF_makeAssociativityNonAssoc(void) {
  return (SDF_Associativity)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun226))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun226)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun226)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(97)), (ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(110)))));
}
/**
 * Constructs a assoc of type SDF_Associativity. Like all ATerm types, SDF_Associativitys are maximally shared.
 * \return A pointer to a assoc, either newly constructed or shared
 */
SDF_Associativity SDF_makeAssociativityAssoc(void) {
  return (SDF_Associativity)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun180))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun180)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(99)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(115)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(97)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun180)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(99)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(115)), (ATerm)ATmakeInt(97)))));
}
/**
 * Constructs a default of type SDF_ArgumentIndicator. Like all ATerm types, SDF_ArgumentIndicators are maximally shared.
 * \param[in] wsAfterLessThan a child of the new default
 * \param[in] arguments a child of the new default
 * \param[in] wsAfterArguments a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_ArgumentIndicator SDF_makeArgumentIndicatorDefault(SDF_OptLayout wsAfterLessThan, SDF_NatConArguments arguments, SDF_OptLayout wsAfterArguments) {
  return (SDF_ArgumentIndicator)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun227))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterArguments), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) arguments)), (ATerm) wsAfterLessThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun32)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(60)))));
}
/**
 * Constructs a with-arguments of type SDF_Group. Like all ATerm types, SDF_Groups are maximally shared.
 * \param[in] Group a child of the new with-arguments
 * \param[in] wsAfterGroup a child of the new with-arguments
 * \param[in] ArgumentIndicator a child of the new with-arguments
 * \return A pointer to a with-arguments, either newly constructed or shared
 */
SDF_Group SDF_makeGroupWithArguments(SDF_Group Group, SDF_OptLayout wsAfterGroup, SDF_ArgumentIndicator ArgumentIndicator) {
  return (SDF_Group)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun227)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun229)))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun230))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) ArgumentIndicator), (ATerm) wsAfterGroup), (ATerm) Group));
}
/**
 * Constructs a non-transitive of type SDF_Group. Like all ATerm types, SDF_Groups are maximally shared.
 * \param[in] Group a child of the new non-transitive
 * \param[in] wsAfterGroup a child of the new non-transitive
 * \return A pointer to a non-transitive, either newly constructed or shared
 */
SDF_Group SDF_makeGroupNonTransitive(SDF_Group Group, SDF_OptLayout wsAfterGroup) {
  return (SDF_Group)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun231)))), (ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun230))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm) wsAfterGroup), (ATerm) Group));
}
/**
 * Constructs a simple-group of type SDF_Group. Like all ATerm types, SDF_Groups are maximally shared.
 * \param[in] Production a child of the new simple-group
 * \return A pointer to a simple-group, either newly constructed or shared
 */
SDF_Group SDF_makeGroupSimpleGroup(SDF_Production Production) {
  return (SDF_Group)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun232)))))), (ATerm)ATmakeList1((ATerm) Production));
}
/**
 * Constructs a prods-group of type SDF_Group. Like all ATerm types, SDF_Groups are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new prods-group
 * \param[in] Productions a child of the new prods-group
 * \param[in] wsAfterProductions a child of the new prods-group
 * \return A pointer to a prods-group, either newly constructed or shared
 */
SDF_Group SDF_makeGroupProdsGroup(SDF_OptLayout wsAfterBraceOpen, SDF_Productions Productions, SDF_OptLayout wsAfterProductions) {
  return (SDF_Group)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun233)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterProductions), (ATerm) Productions), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a assoc-group of type SDF_Group. Like all ATerm types, SDF_Groups are maximally shared.
 * \param[in] wsAfterBraceOpen a child of the new assoc-group
 * \param[in] Associativity a child of the new assoc-group
 * \param[in] wsAfterAssociativity a child of the new assoc-group
 * \param[in] wsAfterColon a child of the new assoc-group
 * \param[in] Productions a child of the new assoc-group
 * \param[in] wsAfterProductions a child of the new assoc-group
 * \return A pointer to a assoc-group, either newly constructed or shared
 */
SDF_Group SDF_makeGroupAssocGroup(SDF_OptLayout wsAfterBraceOpen, SDF_Associativity Associativity, SDF_OptLayout wsAfterAssociativity, SDF_OptLayout wsAfterColon, SDF_Productions Productions, SDF_OptLayout wsAfterProductions) {
  return (SDF_Group)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun62)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun107))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun234)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun40)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(125)))), (ATerm) wsAfterProductions), (ATerm) Productions), (ATerm) wsAfterColon), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(58)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun107)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(58)))), (ATerm) wsAfterAssociativity), (ATerm) Associativity), (ATerm) wsAfterBraceOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun41)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(123)))));
}
/**
 * Constructs a chain of type SDF_Priority. Like all ATerm types, SDF_Prioritys are maximally shared.
 * \param[in] list a child of the new chain
 * \return A pointer to a chain, either newly constructed or shared
 */
SDF_Priority SDF_makePriorityChain(SDF_GroupList list) {
  return (SDF_Priority)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun235))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun236)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun26, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31))))), (ATerm) list)));
}
/**
 * Constructs a assoc of type SDF_Priority. Like all ATerm types, SDF_Prioritys are maximally shared.
 * \param[in] left a child of the new assoc
 * \param[in] wsAfterLeft a child of the new assoc
 * \param[in] Associativity a child of the new assoc
 * \param[in] wsAfterAssociativity a child of the new assoc
 * \param[in] right a child of the new assoc
 * \return A pointer to a assoc, either newly constructed or shared
 */
SDF_Priority SDF_makePriorityAssoc(SDF_Group left, SDF_OptLayout wsAfterLeft, SDF_Associativity Associativity, SDF_OptLayout wsAfterAssociativity, SDF_Group right) {
  return (SDF_Priority)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun179)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun228)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun235))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun180)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterAssociativity), (ATerm) Associativity), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a Default of type SDF_Priorities. Like all ATerm types, SDF_Prioritiess are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Priorities SDF_makePrioritiesDefault(SDF_PriorityList list) {
  return (SDF_Priorities)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun235)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun78))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun235)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_NatConArguments. Like all ATerm types, SDF_NatConArgumentss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_NatConArguments SDF_makeNatConArgumentsEmpty(void) {
  return (SDF_NatConArguments)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_NatConArguments. Like all ATerm types, SDF_NatConArgumentss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_NatConArguments SDF_makeNatConArgumentsSingle(SDF_NatCon head) {
  return (SDF_NatConArguments)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_NatConArguments. Like all ATerm types, SDF_NatConArgumentss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_NatConArguments SDF_makeNatConArgumentsMany(SDF_NatCon head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_NatConArguments tail) {
  if (SDF_isNatConArgumentsEmpty(tail)) {
    return SDF_makeNatConArgumentsSingle(head);
  }
  return (SDF_NatConArguments)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_GroupList. Like all ATerm types, SDF_GroupLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_GroupList SDF_makeGroupListEmpty(void) {
  return (SDF_GroupList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_GroupList. Like all ATerm types, SDF_GroupLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_GroupList SDF_makeGroupListSingle(SDF_Group head) {
  return (SDF_GroupList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_GroupList. Like all ATerm types, SDF_GroupLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_GroupList SDF_makeGroupListMany(SDF_Group head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_GroupList tail) {
  if (SDF_isGroupListEmpty(tail)) {
    return SDF_makeGroupListSingle(head);
  }
  return (SDF_GroupList)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun31)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_PriorityList. Like all ATerm types, SDF_PriorityLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_PriorityList SDF_makePriorityListEmpty(void) {
  return (SDF_PriorityList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_PriorityList. Like all ATerm types, SDF_PriorityLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_PriorityList SDF_makePriorityListSingle(SDF_Priority head) {
  return (SDF_PriorityList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_PriorityList. Like all ATerm types, SDF_PriorityLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_PriorityList SDF_makePriorityListMany(SDF_Priority head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_PriorityList tail) {
  if (SDF_isPriorityListEmpty(tail)) {
    return SDF_makePriorityListSingle(head);
  }
  return (SDF_PriorityList)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_SymbolTail. Like all ATerm types, SDF_SymbolTails are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SymbolTail SDF_makeSymbolTailEmpty(void) {
  return (SDF_SymbolTail)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SymbolTail. Like all ATerm types, SDF_SymbolTails are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SymbolTail SDF_makeSymbolTailSingle(SDF_Symbol head) {
  return (SDF_SymbolTail)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SymbolTail. Like all ATerm types, SDF_SymbolTails are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SymbolTail SDF_makeSymbolTailMany(SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_SymbolTail tail) {
  if (SDF_isSymbolTailEmpty(tail)) {
    return SDF_makeSymbolTailSingle(head);
  }
  return (SDF_SymbolTail)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_SymbolRest. Like all ATerm types, SDF_SymbolRests are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SymbolRest SDF_makeSymbolRestEmpty(void) {
  return (SDF_SymbolRest)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SymbolRest. Like all ATerm types, SDF_SymbolRests are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SymbolRest SDF_makeSymbolRestSingle(SDF_Symbol head) {
  return (SDF_SymbolRest)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SymbolRest. Like all ATerm types, SDF_SymbolRests are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SymbolRest SDF_makeSymbolRestMany(SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolRest tail) {
  if (SDF_isSymbolRestEmpty(tail)) {
    return SDF_makeSymbolRestSingle(head);
  }
  return (SDF_SymbolRest)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a renamings of type SDF_Renamings. Like all ATerm types, SDF_Renamingss are maximally shared.
 * \param[in] wsAfterBracketOpen a child of the new renamings
 * \param[in] list a child of the new renamings
 * \param[in] wsAfterList a child of the new renamings
 * \return A pointer to a renamings, either newly constructed or shared
 */
SDF_Renamings SDF_makeRenamingsRenamings(SDF_OptLayout wsAfterBracketOpen, SDF_RenamingList list, SDF_OptLayout wsAfterList) {
  return (SDF_Renamings)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun237))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun222))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun238)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun34)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm) wsAfterList), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun237))))), (ATerm) list)), (ATerm) wsAfterBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun36)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))));
}
/**
 * Constructs a symbol of type SDF_Renaming. Like all ATerm types, SDF_Renamings are maximally shared.
 * \param[in] from a child of the new symbol
 * \param[in] wsAfterFrom a child of the new symbol
 * \param[in] wsAfterEqualsGreaterThan a child of the new symbol
 * \param[in] to a child of the new symbol
 * \return A pointer to a symbol, either newly constructed or shared
 */
SDF_Renaming SDF_makeRenamingSymbol(SDF_Symbol from, SDF_OptLayout wsAfterFrom, SDF_OptLayout wsAfterEqualsGreaterThan, SDF_Symbol to) {
  return (SDF_Renaming)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun237))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun239)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) to), (ATerm) wsAfterEqualsGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(61)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(61)))), (ATerm) wsAfterFrom), (ATerm) from));
}
/**
 * Constructs a production of type SDF_Renaming. Like all ATerm types, SDF_Renamings are maximally shared.
 * \param[in] fromProd a child of the new production
 * \param[in] wsAfterFromProd a child of the new production
 * \param[in] wsAfterEqualsGreaterThan a child of the new production
 * \param[in] toProd a child of the new production
 * \return A pointer to a production, either newly constructed or shared
 */
SDF_Renaming SDF_makeRenamingProduction(SDF_Production fromProd, SDF_OptLayout wsAfterFromProd, SDF_OptLayout wsAfterEqualsGreaterThan, SDF_Production toProd) {
  return (SDF_Renaming)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun187)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun237))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun240)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) toProd), (ATerm) wsAfterEqualsGreaterThan), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(62)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(61)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun125)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(62)), (ATerm)ATmakeInt(61)))), (ATerm) wsAfterFromProd), (ATerm) fromProd));
}
/**
 * Constructs a empty of type SDF_RenamingList. Like all ATerm types, SDF_RenamingLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_RenamingList SDF_makeRenamingListEmpty(void) {
  return (SDF_RenamingList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_RenamingList. Like all ATerm types, SDF_RenamingLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_RenamingList SDF_makeRenamingListSingle(SDF_Renaming head) {
  return (SDF_RenamingList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_RenamingList. Like all ATerm types, SDF_RenamingLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_RenamingList SDF_makeRenamingListMany(SDF_Renaming head, SDF_OptLayout wsAfterHead, SDF_RenamingList tail) {
  if (SDF_isRenamingListEmpty(tail)) {
    return SDF_makeRenamingListSingle(head);
  }
  return (SDF_RenamingList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a char-class of type SDF_Lookahead. Like all ATerm types, SDF_Lookaheads are maximally shared.
 * \param[in] CharClass a child of the new char-class
 * \return A pointer to a char-class, either newly constructed or shared
 */
SDF_Lookahead SDF_makeLookaheadCharClass(SDF_CharClass CharClass) {
  return (SDF_Lookahead)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun241))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun106)))))), (ATerm)ATmakeList1((ATerm) CharClass));
}
/**
 * Constructs a seq of type SDF_Lookahead. Like all ATerm types, SDF_Lookaheads are maximally shared.
 * \param[in] head a child of the new seq
 * \param[in] wsAfterHead a child of the new seq
 * \param[in] wsAfterPeriod a child of the new seq
 * \param[in] tail a child of the new seq
 * \return A pointer to a seq, either newly constructed or shared
 */
SDF_Lookahead SDF_makeLookaheadSeq(SDF_CharClass head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterPeriod, SDF_Lookaheads tail) {
  return (SDF_Lookahead)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun105)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun241))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun116)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) tail), (ATerm) wsAfterPeriod), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun57)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(46)))), (ATerm) wsAfterHead), (ATerm) head));
}
/**
 * Constructs a single of type SDF_Lookaheads. Like all ATerm types, SDF_Lookaheadss are maximally shared.
 * \param[in] Lookahead a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_Lookaheads SDF_makeLookaheadsSingle(SDF_Lookahead Lookahead) {
  return (SDF_Lookaheads)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun241)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun243)))))), (ATerm)ATmakeList1((ATerm) Lookahead));
}
/**
 * Constructs a alt of type SDF_Lookaheads. Like all ATerm types, SDF_Lookaheadss are maximally shared.
 * \param[in] left a child of the new alt
 * \param[in] wsAfterLeft a child of the new alt
 * \param[in] wsAfterBar a child of the new alt
 * \param[in] right a child of the new alt
 * \return A pointer to a alt, either newly constructed or shared
 */
SDF_Lookaheads SDF_makeLookaheadsAlt(SDF_Lookaheads left, SDF_OptLayout wsAfterLeft, SDF_OptLayout wsAfterBar, SDF_Lookaheads right) {
  return (SDF_Lookaheads)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun127))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun73, (ATerm)ATmakeAppl0(SDF_afun129))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun128)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) right), (ATerm) wsAfterBar), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(124)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun127)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(124)))), (ATerm) wsAfterLeft), (ATerm) left));
}
/**
 * Constructs a Bracket of type SDF_Lookaheads. Like all ATerm types, SDF_Lookaheadss are maximally shared.
 * \param[in] wsAfterParenOpen a child of the new Bracket
 * \param[in] Lookaheads a child of the new Bracket
 * \param[in] wsAfterLookaheads a child of the new Bracket
 * \return A pointer to a Bracket, either newly constructed or shared
 */
SDF_Lookaheads SDF_makeLookaheadsBracket(SDF_OptLayout wsAfterParenOpen, SDF_Lookaheads Lookaheads, SDF_OptLayout wsAfterLookaheads) {
  return (SDF_Lookaheads)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl0(SDF_afun75)))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun25)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(41)))), (ATerm) wsAfterLookaheads), (ATerm) Lookaheads), (ATerm) wsAfterParenOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun28)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(40)))));
}
/**
 * Constructs a list of type SDF_Lookaheads. Like all ATerm types, SDF_Lookaheadss are maximally shared.
 * \param[in] wsAfterBracketOpenBracketOpen a child of the new list
 * \param[in] list a child of the new list
 * \param[in] wsAfterList a child of the new list
 * \return A pointer to a list, either newly constructed or shared
 */
SDF_Lookaheads SDF_makeLookaheadsList(SDF_OptLayout wsAfterBracketOpenBracketOpen, SDF_LookaheadList list, SDF_OptLayout wsAfterList) {
  return (SDF_Lookaheads)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun136))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun241)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun137))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun37)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(93)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun136)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(93)), (ATerm)ATmakeInt(93)))), (ATerm) wsAfterList), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl2(SDF_afun35, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun241)), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27))))), (ATerm) list)), (ATerm) wsAfterBracketOpenBracketOpen), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(91)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun137)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(91)), (ATerm)ATmakeInt(91)))));
}
/**
 * Constructs a follow of type SDF_Restriction. Like all ATerm types, SDF_Restrictions are maximally shared.
 * \param[in] Symbols a child of the new follow
 * \param[in] wsAfterSymbols a child of the new follow
 * \param[in] wsAfterSlash a child of the new follow
 * \param[in] Lookaheads a child of the new follow
 * \return A pointer to a follow, either newly constructed or shared
 */
SDF_Restriction SDF_makeRestrictionFollow(SDF_Symbols Symbols, SDF_OptLayout wsAfterSymbols, SDF_OptLayout wsAfterSlash, SDF_Lookaheads Lookaheads) {
  return (SDF_Restriction)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun242)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun244))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun245))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun246)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) Lookaheads), (ATerm) wsAfterSlash), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(47)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(45)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun244)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(45)), (ATerm)ATmakeInt(47)), (ATerm)ATmakeInt(45)))), (ATerm) wsAfterSymbols), (ATerm) Symbols));
}
/**
 * Constructs a Default of type SDF_Restrictions. Like all ATerm types, SDF_Restrictionss are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Restrictions SDF_makeRestrictionsDefault(SDF_RestrictionList list) {
  return (SDF_Restrictions)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun245))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun80))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun245))))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_LookaheadList. Like all ATerm types, SDF_LookaheadLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_LookaheadList SDF_makeLookaheadListEmpty(void) {
  return (SDF_LookaheadList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_LookaheadList. Like all ATerm types, SDF_LookaheadLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_LookaheadList SDF_makeLookaheadListSingle(SDF_Lookahead head) {
  return (SDF_LookaheadList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_LookaheadList. Like all ATerm types, SDF_LookaheadLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_LookaheadList SDF_makeLookaheadListMany(SDF_Lookahead head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_LookaheadList tail) {
  if (SDF_isLookaheadListEmpty(tail)) {
    return SDF_makeLookaheadListSingle(head);
  }
  return (SDF_LookaheadList)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a empty of type SDF_RestrictionList. Like all ATerm types, SDF_RestrictionLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_RestrictionList SDF_makeRestrictionListEmpty(void) {
  return (SDF_RestrictionList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_RestrictionList. Like all ATerm types, SDF_RestrictionLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_RestrictionList SDF_makeRestrictionListSingle(SDF_Restriction head) {
  return (SDF_RestrictionList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_RestrictionList. Like all ATerm types, SDF_RestrictionLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_RestrictionList SDF_makeRestrictionListMany(SDF_Restriction head, SDF_OptLayout wsAfterHead, SDF_RestrictionList tail) {
  if (SDF_isRestrictionListEmpty(tail)) {
    return SDF_makeRestrictionListSingle(head);
  }
  return (SDF_RestrictionList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a Lex-to-cf of type SDF_Sort. Like all ATerm types, SDF_Sorts are maximally shared.
 * \param[in] Sort a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_Sort SDF_makeSortLexToCf(SDF_LexSort Sort) {
  return (SDF_Sort)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) Sort));
}
/**
 * Constructs a definition of type SDF_SDF. Like all ATerm types, SDF_SDFs are maximally shared.
 * \param[in] wsAfterDefinition a child of the new definition
 * \param[in] Definition a child of the new definition
 * \return A pointer to a definition, either newly constructed or shared
 */
SDF_SDF SDF_makeSDFDefinition(SDF_OptLayout wsAfterDefinition, SDF_Definition Definition) {
  return (SDF_SDF)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun211)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun3, (ATerm)ATmakeAppl0(SDF_afun4)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun247))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun46))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun247)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) Definition), (ATerm) wsAfterDefinition), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(111)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(105)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(102)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(101)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(100)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun247)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(111)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(105)), (ATerm)ATmakeInt(102)), (ATerm)ATmakeInt(101)), (ATerm)ATmakeInt(100)))));
}
/**
 * Constructs a one-char of type SDF_LexSort. Like all ATerm types, SDF_LexSorts are maximally shared.
 * \param[in] head a child of the new one-char
 * \return A pointer to a one-char, either newly constructed or shared
 */
SDF_LexSort SDF_makeLexSortOneChar(char head) {
  return (SDF_LexSort)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun248)))))), (ATerm)ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(head))));
}
/**
 * Constructs a more-chars of type SDF_LexSort. Like all ATerm types, SDF_LexSorts are maximally shared.
 * \param[in] head a child of the new more-chars
 * \param[in] middle a child of the new more-chars
 * \param[in] last a child of the new more-chars
 * \return A pointer to a more-chars, either newly constructed or shared
 */
SDF_LexSort SDF_makeLexSortMoreChars(char head, const char* middle, char last) {
  return (SDF_LexSort)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun134))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun249)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(last))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm) ((ATerm) SDF_stringToChars(middle)))), (ATerm) ((ATerm) SDF_byteToChar(head))));
}
/**
 * Constructs a empty of type SDF_SymbolParameters. Like all ATerm types, SDF_SymbolParameterss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SymbolParameters SDF_makeSymbolParametersEmpty(void) {
  return (SDF_SymbolParameters)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SymbolParameters. Like all ATerm types, SDF_SymbolParameterss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SymbolParameters SDF_makeSymbolParametersSingle(SDF_Symbol head) {
  return (SDF_SymbolParameters)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SymbolParameters. Like all ATerm types, SDF_SymbolParameterss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] wsAfterSep a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SymbolParameters SDF_makeSymbolParametersMany(SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_OptLayout wsAfterSep, SDF_SymbolParameters tail) {
  if (SDF_isSymbolParametersEmpty(tail)) {
    return SDF_makeSymbolParametersSingle(head);
  }
  return (SDF_SymbolParameters)(ATerm)ATinsert(ATinsert(ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterSep), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun27)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(44)))), (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a Default of type SDF_Symbols. Like all ATerm types, SDF_Symbolss are maximally shared.
 * \param[in] list a child of the new Default
 * \return A pointer to a Default, either newly constructed or shared
 */
SDF_Symbols SDF_makeSymbolsDefault(SDF_SymbolList list) {
  return (SDF_Symbols)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun86))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun92))))), (ATerm) list)));
}
/**
 * Constructs a empty of type SDF_SymbolList. Like all ATerm types, SDF_SymbolLists are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_SymbolList SDF_makeSymbolListEmpty(void) {
  return (SDF_SymbolList)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_SymbolList. Like all ATerm types, SDF_SymbolLists are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_SymbolList SDF_makeSymbolListSingle(SDF_Symbol head) {
  return (SDF_SymbolList)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_SymbolList. Like all ATerm types, SDF_SymbolLists are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] wsAfterHead a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_SymbolList SDF_makeSymbolListMany(SDF_Symbol head, SDF_OptLayout wsAfterHead, SDF_SymbolList tail) {
  if (SDF_isSymbolListEmpty(tail)) {
    return SDF_makeSymbolListSingle(head);
  }
  return (SDF_SymbolList)(ATerm)ATinsert(ATinsert((ATermList)tail, (ATerm) wsAfterHead), (ATerm) head);
}
/**
 * Constructs a whitespace of type SDF_LexLayout. Like all ATerm types, SDF_LexLayouts are maximally shared.
 * \param[in] ch a child of the new whitespace
 * \return A pointer to a whitespace, either newly constructed or shared
 */
SDF_LexLayout SDF_makeLexLayoutWhitespace(char ch) {
  return (SDF_LexLayout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(32)), (ATerm)ATmakeInt(13)), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(9), (ATerm)ATmakeInt(10))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl0(SDF_afun4)), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun250)))))), (ATerm)ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(ch))));
}
/**
 * Constructs a line of type SDF_LexLayout. Like all ATerm types, SDF_LexLayouts are maximally shared.
 * \param[in] line a child of the new line
 * \return A pointer to a line, either newly constructed or shared
 */
SDF_LexLayout SDF_makeLexLayoutLine(const char* line) {
  return (SDF_LexLayout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun251))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(11), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(0), (ATerm)ATmakeInt(9))))))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun252))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl0(SDF_afun4)), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun253, (ATerm)ATmakeAppl0(SDF_afun254)))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun255)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(10)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun251)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(10)))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(11), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(0), (ATerm)ATmakeInt(9))))))), (ATerm) ((ATerm) SDF_stringToChars(line)))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun252)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(37)), (ATerm)ATmakeInt(37)))));
}
/**
 * Constructs a nested of type SDF_LexLayout. Like all ATerm types, SDF_LexLayouts are maximally shared.
 * \param[in] content a child of the new nested
 * \return A pointer to a nested, either newly constructed or shared
 */
SDF_LexLayout SDF_makeLexLayoutNested(const char* content) {
  return (SDF_LexLayout)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun256))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(38), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(11), (ATerm)ATmakeInt(36))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(0), (ATerm)ATmakeInt(9))))))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun256))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl0(SDF_afun4)), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun253, (ATerm)ATmakeAppl0(SDF_afun254)))), (ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun257)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun256)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(38), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(11), (ATerm)ATmakeInt(36))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(0), (ATerm)ATmakeInt(9))))))), (ATerm) ((ATerm) SDF_stringToChars(content)))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun256)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(37)))));
}
/**
 * Constructs a newline of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \return A pointer to a newline, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharNewline(void) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun191))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun193)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(110)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun191)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(110)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a tab of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \return A pointer to a tab, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharTab(void) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun194))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun195)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(116)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun194)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(116)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a quote of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \return A pointer to a quote, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharQuote(void) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun259))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun197)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(34)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun259)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(34)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a backslash of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \return A pointer to a backslash, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharBackslash(void) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun198))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun199)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun198)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeInt(92)), (ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a decimal of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \param[in] a a child of the new decimal
 * \param[in] b a child of the new decimal
 * \param[in] c a child of the new decimal
 * \return A pointer to a decimal, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharDecimal(char a, char b, char c) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun200))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun201)))))), (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(c))), (ATerm) ((ATerm) SDF_byteToChar(b))), (ATerm) ((ATerm) SDF_byteToChar(a))), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))), (ATerm)ATmakeAppl1(SDF_afun24, (ATerm)ATmakeAppl0(SDF_afun200)), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm)ATmakeInt(92)))));
}
/**
 * Constructs a normal of type SDF_LexStrChar. Like all ATerm types, SDF_LexStrChars are maximally shared.
 * \param[in] ch a child of the new normal
 * \return A pointer to a normal, either newly constructed or shared
 */
SDF_LexStrChar SDF_makeLexStrCharNormal(char ch) {
  return (SDF_LexStrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(93), (ATerm)ATmakeInt(255))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(35), (ATerm)ATmakeInt(91))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(32), (ATerm)ATmakeInt(33))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun202)))))), (ATerm)ATmakeList1((ATerm) ((ATerm) SDF_byteToChar(ch))));
}
/**
 * Constructs a Lex-to-cf of type SDF_StrChar. Like all ATerm types, SDF_StrChars are maximally shared.
 * \param[in] StrChar a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_StrChar SDF_makeStrCharLexToCf(SDF_LexStrChar StrChar) {
  return (SDF_StrChar)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) StrChar));
}
/**
 * Constructs a default of type SDF_LexStrCon. Like all ATerm types, SDF_LexStrCons are maximally shared.
 * \param[in] chars a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_LexStrCon SDF_makeLexStrConDefault(SDF_LexStrCharChars chars) {
  return (SDF_LexStrCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(34)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeInt(34)))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeInt(34)), (ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun258))))), (ATerm) chars)), (ATerm)ATmakeInt(34)));
}
/**
 * Constructs a Lex-to-cf of type SDF_StrCon. Like all ATerm types, SDF_StrCons are maximally shared.
 * \param[in] StrCon a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_StrCon SDF_makeStrConLexToCf(SDF_LexStrCon StrCon) {
  return (SDF_StrCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun10))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) StrCon));
}
/**
 * Constructs a empty of type SDF_LexStrCharChars. Like all ATerm types, SDF_LexStrCharCharss are maximally shared.
 * \return A pointer to a empty, either newly constructed or shared
 */
SDF_LexStrCharChars SDF_makeLexStrCharCharsEmpty(void) {
  return (SDF_LexStrCharChars)(ATerm)ATempty;
}
/**
 * Constructs a single of type SDF_LexStrCharChars. Like all ATerm types, SDF_LexStrCharCharss are maximally shared.
 * \param[in] head a child of the new single
 * \return A pointer to a single, either newly constructed or shared
 */
SDF_LexStrCharChars SDF_makeLexStrCharCharsSingle(SDF_LexStrChar head) {
  return (SDF_LexStrCharChars)(ATerm)ATmakeList1((ATerm) head);
}
/**
 * Constructs a many of type SDF_LexStrCharChars. Like all ATerm types, SDF_LexStrCharCharss are maximally shared.
 * \param[in] head a child of the new many
 * \param[in] tail a child of the new many
 * \return A pointer to a many, either newly constructed or shared
 */
SDF_LexStrCharChars SDF_makeLexStrCharCharsMany(SDF_LexStrChar head, SDF_LexStrCharChars tail) {
  return (SDF_LexStrCharChars)(ATerm)ATinsert((ATermList)tail, (ATerm) head);
}
/**
 * Constructs a digits of type SDF_LexNatCon. Like all ATerm types, SDF_LexNatCons are maximally shared.
 * \param[in] list a child of the new digits
 * \return A pointer to a digits, either newly constructed or shared
 */
SDF_LexNatCon SDF_makeLexNatConDigits(const char* list) {
  return (SDF_LexNatCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun159)))))), (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun7, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))))))), (ATerm) ((ATerm) SDF_stringToChars(list)))));
}
/**
 * Constructs a Lex-to-cf of type SDF_NatCon. Like all ATerm types, SDF_NatCons are maximally shared.
 * \param[in] NatCon a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_NatCon SDF_makeNatConLexToCf(SDF_LexNatCon NatCon) {
  return (SDF_NatCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun47))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) NatCon));
}
/**
 * Constructs a default of type SDF_LexIdCon. Like all ATerm types, SDF_LexIdCons are maximally shared.
 * \param[in] head a child of the new default
 * \param[in] tail a child of the new default
 * \return A pointer to a default, either newly constructed or shared
 */
SDF_LexIdCon SDF_makeLexIdConDefault(char head, const char* tail) {
  return (SDF_LexIdCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))))), (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16))), (ATerm)ATmakeAppl1(SDF_afun12, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun13, (ATerm)ATmakeAppl1(SDF_afun14, (ATerm)ATmakeAppl0(SDF_afun42)))))), (ATerm)ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl1(SDF_afun8, (ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun96, (ATerm)ATmakeAppl1(SDF_afun30, (ATerm)ATinsert(ATinsert(ATinsert(ATmakeList1((ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(97), (ATerm)ATmakeInt(122))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(65), (ATerm)ATmakeInt(90))), (ATerm)ATmakeAppl2(SDF_afun157, (ATerm)ATmakeInt(48), (ATerm)ATmakeInt(57))), (ATerm)ATmakeInt(45)))))), (ATerm) ((ATerm) SDF_stringToChars(tail)))), (ATerm) ((ATerm) SDF_byteToChar(head))));
}
/**
 * Constructs a Lex-to-cf of type SDF_IdCon. Like all ATerm types, SDF_IdCons are maximally shared.
 * \param[in] IdCon a child of the new Lex-to-cf
 * \return A pointer to a Lex-to-cf, either newly constructed or shared
 */
SDF_IdCon SDF_makeIdConLexToCf(SDF_LexIdCon IdCon) {
  return (SDF_IdCon)(ATerm)ATmakeAppl2(SDF_afun0, (ATerm)ATmakeAppl3(SDF_afun1, (ATerm)ATmakeList1((ATerm)ATmakeAppl1(SDF_afun6, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16)))), (ATerm)ATmakeAppl1(SDF_afun2, (ATerm)ATmakeAppl1(SDF_afun9, (ATerm)ATmakeAppl0(SDF_afun16))), (ATerm)ATmakeAppl0(SDF_afun5)), (ATerm)ATmakeList1((ATerm) IdCon));
}

/**
 * Tests equality of two SDF_OptLayouts. A constant time operation.
 * \param[in] arg0 first SDF_OptLayout to be compared
 * \param[in] arg1 second SDF_OptLayout to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualOptLayout(SDF_OptLayout arg0, SDF_OptLayout arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Layouts. A constant time operation.
 * \param[in] arg0 first SDF_Layout to be compared
 * \param[in] arg1 second SDF_Layout to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLayout(SDF_Layout arg0, SDF_Layout arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexLayoutLists. A constant time operation.
 * \param[in] arg0 first SDF_LexLayoutList to be compared
 * \param[in] arg1 second SDF_LexLayoutList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexLayoutList(SDF_LexLayoutList arg0, SDF_LexLayoutList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_AFuns. A constant time operation.
 * \param[in] arg0 first SDF_AFun to be compared
 * \param[in] arg1 second SDF_AFun to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAFun(SDF_AFun arg0, SDF_AFun arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ATerms. A constant time operation.
 * \param[in] arg0 first SDF_ATerm to be compared
 * \param[in] arg1 second SDF_ATerm to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualATerm(SDF_ATerm arg0, SDF_ATerm arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Annotations. A constant time operation.
 * \param[in] arg0 first SDF_Annotation to be compared
 * \param[in] arg1 second SDF_Annotation to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAnnotation(SDF_Annotation arg0, SDF_Annotation arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Starts. A constant time operation.
 * \param[in] arg0 first SDF_Start to be compared
 * \param[in] arg1 second SDF_Start to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualStart(SDF_Start arg0, SDF_Start arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ATermArgss. A constant time operation.
 * \param[in] arg0 first SDF_ATermArgs to be compared
 * \param[in] arg1 second SDF_ATermArgs to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualATermArgs(SDF_ATermArgs arg0, SDF_ATermArgs arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ATermElemss. A constant time operation.
 * \param[in] arg0 first SDF_ATermElems to be compared
 * \param[in] arg1 second SDF_ATermElems to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualATermElems(SDF_ATermElems arg0, SDF_ATermElems arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ATermAnnoss. A constant time operation.
 * \param[in] arg0 first SDF_ATermAnnos to be compared
 * \param[in] arg1 second SDF_ATermAnnos to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualATermAnnos(SDF_ATermAnnos arg0, SDF_ATermAnnos arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_IntCons. A constant time operation.
 * \param[in] arg0 first SDF_IntCon to be compared
 * \param[in] arg1 second SDF_IntCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualIntCon(SDF_IntCon arg0, SDF_IntCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_OptExps. A constant time operation.
 * \param[in] arg0 first SDF_OptExp to be compared
 * \param[in] arg1 second SDF_OptExp to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualOptExp(SDF_OptExp arg0, SDF_OptExp arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_RealCons. A constant time operation.
 * \param[in] arg0 first SDF_RealCon to be compared
 * \param[in] arg1 second SDF_RealCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRealCon(SDF_RealCon arg0, SDF_RealCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Grammars. A constant time operation.
 * \param[in] arg0 first SDF_Grammar to be compared
 * \param[in] arg1 second SDF_Grammar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualGrammar(SDF_Grammar arg0, SDF_Grammar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Aliass. A constant time operation.
 * \param[in] arg0 first SDF_Alias to be compared
 * \param[in] arg1 second SDF_Alias to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAlias(SDF_Alias arg0, SDF_Alias arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Aliasess. A constant time operation.
 * \param[in] arg0 first SDF_Aliases to be compared
 * \param[in] arg1 second SDF_Aliases to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAliases(SDF_Aliases arg0, SDF_Aliases arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_AliasLists. A constant time operation.
 * \param[in] arg0 first SDF_AliasList to be compared
 * \param[in] arg1 second SDF_AliasList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAliasList(SDF_AliasList arg0, SDF_AliasList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Symbols. A constant time operation.
 * \param[in] arg0 first SDF_Symbol to be compared
 * \param[in] arg1 second SDF_Symbol to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbol(SDF_Symbol arg0, SDF_Symbol arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_CharRanges. A constant time operation.
 * \param[in] arg0 first SDF_CharRange to be compared
 * \param[in] arg1 second SDF_CharRange to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualCharRange(SDF_CharRange arg0, SDF_CharRange arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_CharRangess. A constant time operation.
 * \param[in] arg0 first SDF_CharRanges to be compared
 * \param[in] arg1 second SDF_CharRanges to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualCharRanges(SDF_CharRanges arg0, SDF_CharRanges arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_OptCharRangess. A constant time operation.
 * \param[in] arg0 first SDF_OptCharRanges to be compared
 * \param[in] arg1 second SDF_OptCharRanges to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualOptCharRanges(SDF_OptCharRanges arg0, SDF_OptCharRanges arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_CharClasss. A constant time operation.
 * \param[in] arg0 first SDF_CharClass to be compared
 * \param[in] arg1 second SDF_CharClass to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualCharClass(SDF_CharClass arg0, SDF_CharClass arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexNumChars. A constant time operation.
 * \param[in] arg0 first SDF_LexNumChar to be compared
 * \param[in] arg1 second SDF_LexNumChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexNumChar(SDF_LexNumChar arg0, SDF_LexNumChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_NumChars. A constant time operation.
 * \param[in] arg0 first SDF_NumChar to be compared
 * \param[in] arg1 second SDF_NumChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualNumChar(SDF_NumChar arg0, SDF_NumChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexShortChars. A constant time operation.
 * \param[in] arg0 first SDF_LexShortChar to be compared
 * \param[in] arg1 second SDF_LexShortChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexShortChar(SDF_LexShortChar arg0, SDF_LexShortChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ShortChars. A constant time operation.
 * \param[in] arg0 first SDF_ShortChar to be compared
 * \param[in] arg1 second SDF_ShortChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualShortChar(SDF_ShortChar arg0, SDF_ShortChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Characters. A constant time operation.
 * \param[in] arg0 first SDF_Character to be compared
 * \param[in] arg1 second SDF_Character to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualCharacter(SDF_Character arg0, SDF_Character arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ATermAttributes. A constant time operation.
 * \param[in] arg0 first SDF_ATermAttribute to be compared
 * \param[in] arg1 second SDF_ATermAttribute to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualATermAttribute(SDF_ATermAttribute arg0, SDF_ATermAttribute arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Attributes. A constant time operation.
 * \param[in] arg0 first SDF_Attribute to be compared
 * \param[in] arg1 second SDF_Attribute to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAttribute(SDF_Attribute arg0, SDF_Attribute arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Attributess. A constant time operation.
 * \param[in] arg0 first SDF_Attributes to be compared
 * \param[in] arg1 second SDF_Attributes to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAttributes(SDF_Attributes arg0, SDF_Attributes arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Productions. A constant time operation.
 * \param[in] arg0 first SDF_Production to be compared
 * \param[in] arg1 second SDF_Production to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualProduction(SDF_Production arg0, SDF_Production arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Productionss. A constant time operation.
 * \param[in] arg0 first SDF_Productions to be compared
 * \param[in] arg1 second SDF_Productions to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualProductions(SDF_Productions arg0, SDF_Productions arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_AttributeLists. A constant time operation.
 * \param[in] arg0 first SDF_AttributeList to be compared
 * \param[in] arg1 second SDF_AttributeList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAttributeList(SDF_AttributeList arg0, SDF_AttributeList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ProductionLists. A constant time operation.
 * \param[in] arg0 first SDF_ProductionList to be compared
 * \param[in] arg1 second SDF_ProductionList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualProductionList(SDF_ProductionList arg0, SDF_ProductionList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Labels. A constant time operation.
 * \param[in] arg0 first SDF_Label to be compared
 * \param[in] arg1 second SDF_Label to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLabel(SDF_Label arg0, SDF_Label arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexSingleQuotedStrChars. A constant time operation.
 * \param[in] arg0 first SDF_LexSingleQuotedStrChar to be compared
 * \param[in] arg1 second SDF_LexSingleQuotedStrChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexSingleQuotedStrChar(SDF_LexSingleQuotedStrChar arg0, SDF_LexSingleQuotedStrChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SingleQuotedStrChars. A constant time operation.
 * \param[in] arg0 first SDF_SingleQuotedStrChar to be compared
 * \param[in] arg1 second SDF_SingleQuotedStrChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSingleQuotedStrChar(SDF_SingleQuotedStrChar arg0, SDF_SingleQuotedStrChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexSingleQuotedStrCons. A constant time operation.
 * \param[in] arg0 first SDF_LexSingleQuotedStrCon to be compared
 * \param[in] arg1 second SDF_LexSingleQuotedStrCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexSingleQuotedStrCon(SDF_LexSingleQuotedStrCon arg0, SDF_LexSingleQuotedStrCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SingleQuotedStrCons. A constant time operation.
 * \param[in] arg0 first SDF_SingleQuotedStrCon to be compared
 * \param[in] arg1 second SDF_SingleQuotedStrCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSingleQuotedStrCon(SDF_SingleQuotedStrCon arg0, SDF_SingleQuotedStrCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_FunctionNames. A constant time operation.
 * \param[in] arg0 first SDF_FunctionName to be compared
 * \param[in] arg1 second SDF_FunctionName to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualFunctionName(SDF_FunctionName arg0, SDF_FunctionName arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexSingleQuotedStrCharCharss. A constant time operation.
 * \param[in] arg0 first SDF_LexSingleQuotedStrCharChars to be compared
 * \param[in] arg1 second SDF_LexSingleQuotedStrCharChars to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexSingleQuotedStrCharChars(SDF_LexSingleQuotedStrCharChars arg0, SDF_LexSingleQuotedStrCharChars arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SymbolArgumentss. A constant time operation.
 * \param[in] arg0 first SDF_SymbolArguments to be compared
 * \param[in] arg1 second SDF_SymbolArguments to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbolArguments(SDF_SymbolArguments arg0, SDF_SymbolArguments arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexModuleWords. A constant time operation.
 * \param[in] arg0 first SDF_LexModuleWord to be compared
 * \param[in] arg1 second SDF_LexModuleWord to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexModuleWord(SDF_LexModuleWord arg0, SDF_LexModuleWord arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ModuleWords. A constant time operation.
 * \param[in] arg0 first SDF_ModuleWord to be compared
 * \param[in] arg1 second SDF_ModuleWord to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualModuleWord(SDF_ModuleWord arg0, SDF_ModuleWord arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexModuleIds. A constant time operation.
 * \param[in] arg0 first SDF_LexModuleId to be compared
 * \param[in] arg1 second SDF_LexModuleId to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexModuleId(SDF_LexModuleId arg0, SDF_LexModuleId arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ModuleIds. A constant time operation.
 * \param[in] arg0 first SDF_ModuleId to be compared
 * \param[in] arg1 second SDF_ModuleId to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualModuleId(SDF_ModuleId arg0, SDF_ModuleId arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Definitions. A constant time operation.
 * \param[in] arg0 first SDF_Definition to be compared
 * \param[in] arg1 second SDF_Definition to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualDefinition(SDF_Definition arg0, SDF_Definition arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Modules. A constant time operation.
 * \param[in] arg0 first SDF_Module to be compared
 * \param[in] arg1 second SDF_Module to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualModule(SDF_Module arg0, SDF_Module arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Sections. A constant time operation.
 * \param[in] arg0 first SDF_Section to be compared
 * \param[in] arg1 second SDF_Section to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSection(SDF_Section arg0, SDF_Section arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Sectionss. A constant time operation.
 * \param[in] arg0 first SDF_Sections to be compared
 * \param[in] arg1 second SDF_Sections to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSections(SDF_Sections arg0, SDF_Sections arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ModuleNames. A constant time operation.
 * \param[in] arg0 first SDF_ModuleName to be compared
 * \param[in] arg1 second SDF_ModuleName to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualModuleName(SDF_ModuleName arg0, SDF_ModuleName arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ImpSections. A constant time operation.
 * \param[in] arg0 first SDF_ImpSection to be compared
 * \param[in] arg1 second SDF_ImpSection to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualImpSection(SDF_ImpSection arg0, SDF_ImpSection arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Importss. A constant time operation.
 * \param[in] arg0 first SDF_Imports to be compared
 * \param[in] arg1 second SDF_Imports to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualImports(SDF_Imports arg0, SDF_Imports arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Imports. A constant time operation.
 * \param[in] arg0 first SDF_Import to be compared
 * \param[in] arg1 second SDF_Import to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualImport(SDF_Import arg0, SDF_Import arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ModuleLists. A constant time operation.
 * \param[in] arg0 first SDF_ModuleList to be compared
 * \param[in] arg1 second SDF_ModuleList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualModuleList(SDF_ModuleList arg0, SDF_ModuleList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ImpSectionLists. A constant time operation.
 * \param[in] arg0 first SDF_ImpSectionList to be compared
 * \param[in] arg1 second SDF_ImpSectionList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualImpSectionList(SDF_ImpSectionList arg0, SDF_ImpSectionList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SectionLists. A constant time operation.
 * \param[in] arg0 first SDF_SectionList to be compared
 * \param[in] arg1 second SDF_SectionList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSectionList(SDF_SectionList arg0, SDF_SectionList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ImportLists. A constant time operation.
 * \param[in] arg0 first SDF_ImportList to be compared
 * \param[in] arg1 second SDF_ImportList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualImportList(SDF_ImportList arg0, SDF_ImportList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Associativitys. A constant time operation.
 * \param[in] arg0 first SDF_Associativity to be compared
 * \param[in] arg1 second SDF_Associativity to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualAssociativity(SDF_Associativity arg0, SDF_Associativity arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_ArgumentIndicators. A constant time operation.
 * \param[in] arg0 first SDF_ArgumentIndicator to be compared
 * \param[in] arg1 second SDF_ArgumentIndicator to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualArgumentIndicator(SDF_ArgumentIndicator arg0, SDF_ArgumentIndicator arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Groups. A constant time operation.
 * \param[in] arg0 first SDF_Group to be compared
 * \param[in] arg1 second SDF_Group to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualGroup(SDF_Group arg0, SDF_Group arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Prioritys. A constant time operation.
 * \param[in] arg0 first SDF_Priority to be compared
 * \param[in] arg1 second SDF_Priority to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualPriority(SDF_Priority arg0, SDF_Priority arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Prioritiess. A constant time operation.
 * \param[in] arg0 first SDF_Priorities to be compared
 * \param[in] arg1 second SDF_Priorities to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualPriorities(SDF_Priorities arg0, SDF_Priorities arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_NatConArgumentss. A constant time operation.
 * \param[in] arg0 first SDF_NatConArguments to be compared
 * \param[in] arg1 second SDF_NatConArguments to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualNatConArguments(SDF_NatConArguments arg0, SDF_NatConArguments arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_GroupLists. A constant time operation.
 * \param[in] arg0 first SDF_GroupList to be compared
 * \param[in] arg1 second SDF_GroupList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualGroupList(SDF_GroupList arg0, SDF_GroupList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_PriorityLists. A constant time operation.
 * \param[in] arg0 first SDF_PriorityList to be compared
 * \param[in] arg1 second SDF_PriorityList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualPriorityList(SDF_PriorityList arg0, SDF_PriorityList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SymbolTails. A constant time operation.
 * \param[in] arg0 first SDF_SymbolTail to be compared
 * \param[in] arg1 second SDF_SymbolTail to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbolTail(SDF_SymbolTail arg0, SDF_SymbolTail arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SymbolRests. A constant time operation.
 * \param[in] arg0 first SDF_SymbolRest to be compared
 * \param[in] arg1 second SDF_SymbolRest to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbolRest(SDF_SymbolRest arg0, SDF_SymbolRest arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Renamingss. A constant time operation.
 * \param[in] arg0 first SDF_Renamings to be compared
 * \param[in] arg1 second SDF_Renamings to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRenamings(SDF_Renamings arg0, SDF_Renamings arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Renamings. A constant time operation.
 * \param[in] arg0 first SDF_Renaming to be compared
 * \param[in] arg1 second SDF_Renaming to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRenaming(SDF_Renaming arg0, SDF_Renaming arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_RenamingLists. A constant time operation.
 * \param[in] arg0 first SDF_RenamingList to be compared
 * \param[in] arg1 second SDF_RenamingList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRenamingList(SDF_RenamingList arg0, SDF_RenamingList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Lookaheads. A constant time operation.
 * \param[in] arg0 first SDF_Lookahead to be compared
 * \param[in] arg1 second SDF_Lookahead to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLookahead(SDF_Lookahead arg0, SDF_Lookahead arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Lookaheadss. A constant time operation.
 * \param[in] arg0 first SDF_Lookaheads to be compared
 * \param[in] arg1 second SDF_Lookaheads to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLookaheads(SDF_Lookaheads arg0, SDF_Lookaheads arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Restrictions. A constant time operation.
 * \param[in] arg0 first SDF_Restriction to be compared
 * \param[in] arg1 second SDF_Restriction to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRestriction(SDF_Restriction arg0, SDF_Restriction arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Restrictionss. A constant time operation.
 * \param[in] arg0 first SDF_Restrictions to be compared
 * \param[in] arg1 second SDF_Restrictions to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRestrictions(SDF_Restrictions arg0, SDF_Restrictions arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LookaheadLists. A constant time operation.
 * \param[in] arg0 first SDF_LookaheadList to be compared
 * \param[in] arg1 second SDF_LookaheadList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLookaheadList(SDF_LookaheadList arg0, SDF_LookaheadList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_RestrictionLists. A constant time operation.
 * \param[in] arg0 first SDF_RestrictionList to be compared
 * \param[in] arg1 second SDF_RestrictionList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualRestrictionList(SDF_RestrictionList arg0, SDF_RestrictionList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Sorts. A constant time operation.
 * \param[in] arg0 first SDF_Sort to be compared
 * \param[in] arg1 second SDF_Sort to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSort(SDF_Sort arg0, SDF_Sort arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SDFs. A constant time operation.
 * \param[in] arg0 first SDF_SDF to be compared
 * \param[in] arg1 second SDF_SDF to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSDF(SDF_SDF arg0, SDF_SDF arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexSorts. A constant time operation.
 * \param[in] arg0 first SDF_LexSort to be compared
 * \param[in] arg1 second SDF_LexSort to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexSort(SDF_LexSort arg0, SDF_LexSort arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SymbolParameterss. A constant time operation.
 * \param[in] arg0 first SDF_SymbolParameters to be compared
 * \param[in] arg1 second SDF_SymbolParameters to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbolParameters(SDF_SymbolParameters arg0, SDF_SymbolParameters arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_Symbolss. A constant time operation.
 * \param[in] arg0 first SDF_Symbols to be compared
 * \param[in] arg1 second SDF_Symbols to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbols(SDF_Symbols arg0, SDF_Symbols arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_SymbolLists. A constant time operation.
 * \param[in] arg0 first SDF_SymbolList to be compared
 * \param[in] arg1 second SDF_SymbolList to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualSymbolList(SDF_SymbolList arg0, SDF_SymbolList arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexLayouts. A constant time operation.
 * \param[in] arg0 first SDF_LexLayout to be compared
 * \param[in] arg1 second SDF_LexLayout to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexLayout(SDF_LexLayout arg0, SDF_LexLayout arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexStrChars. A constant time operation.
 * \param[in] arg0 first SDF_LexStrChar to be compared
 * \param[in] arg1 second SDF_LexStrChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexStrChar(SDF_LexStrChar arg0, SDF_LexStrChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_StrChars. A constant time operation.
 * \param[in] arg0 first SDF_StrChar to be compared
 * \param[in] arg1 second SDF_StrChar to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualStrChar(SDF_StrChar arg0, SDF_StrChar arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexStrCons. A constant time operation.
 * \param[in] arg0 first SDF_LexStrCon to be compared
 * \param[in] arg1 second SDF_LexStrCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexStrCon(SDF_LexStrCon arg0, SDF_LexStrCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_StrCons. A constant time operation.
 * \param[in] arg0 first SDF_StrCon to be compared
 * \param[in] arg1 second SDF_StrCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualStrCon(SDF_StrCon arg0, SDF_StrCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexStrCharCharss. A constant time operation.
 * \param[in] arg0 first SDF_LexStrCharChars to be compared
 * \param[in] arg1 second SDF_LexStrCharChars to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexStrCharChars(SDF_LexStrCharChars arg0, SDF_LexStrCharChars arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexNatCons. A constant time operation.
 * \param[in] arg0 first SDF_LexNatCon to be compared
 * \param[in] arg1 second SDF_LexNatCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexNatCon(SDF_LexNatCon arg0, SDF_LexNatCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_NatCons. A constant time operation.
 * \param[in] arg0 first SDF_NatCon to be compared
 * \param[in] arg1 second SDF_NatCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualNatCon(SDF_NatCon arg0, SDF_NatCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_LexIdCons. A constant time operation.
 * \param[in] arg0 first SDF_LexIdCon to be compared
 * \param[in] arg1 second SDF_LexIdCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualLexIdCon(SDF_LexIdCon arg0, SDF_LexIdCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Tests equality of two SDF_IdCons. A constant time operation.
 * \param[in] arg0 first SDF_IdCon to be compared
 * \param[in] arg1 second SDF_IdCon to be compared
 * \return ATtrue if #arg0 was equal to #arg1, ATfalse otherwise
 */
ATbool SDF_isEqualIdCon(SDF_IdCon arg0, SDF_IdCon arg1) {
  return ATisEqual((ATerm)arg0, (ATerm)arg1);
}

/**
 * Assert whether a SDF_OptLayout is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_OptLayout
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidOptLayout(SDF_OptLayout arg) {
  if (SDF_isOptLayoutAbsent(arg)) {
    return ATtrue;
  }
  else if (SDF_isOptLayoutPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_OptLayout is a Absent. . May not be used to assert correctness of the SDF_OptLayout
 * \param[in] arg input SDF_OptLayout
 * \return ATtrue if #arg corresponds to the signature of a Absent, or ATfalse otherwise
 */
inline ATbool SDF_isOptLayoutAbsent(SDF_OptLayout arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptLayoutAbsent);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptLayout is a Present. . May not be used to assert correctness of the SDF_OptLayout
 * \param[in] arg input SDF_OptLayout
 * \return ATtrue if #arg corresponds to the signature of a Present, or ATfalse otherwise
 */
inline ATbool SDF_isOptLayoutPresent(SDF_OptLayout arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptLayoutPresent, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptLayout has a layout. 
 * \param[in] arg input SDF_OptLayout
 * \return ATtrue if the SDF_OptLayout had a layout, or ATfalse otherwise
 */
ATbool SDF_hasOptLayoutLayout(SDF_OptLayout arg) {
  if (SDF_isOptLayoutPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the layout SDF_Layout of a SDF_OptLayout. Note that the precondition is that this SDF_OptLayout actually has a layout
 * \param[in] arg input SDF_OptLayout
 * \return the layout of #arg, if it exist or an undefined value if it does not
 */
SDF_Layout SDF_getOptLayoutLayout(SDF_OptLayout arg) {
  
    return (SDF_Layout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Set the layout of a SDF_OptLayout. The precondition being that this SDF_OptLayout actually has a layout
 * \param[in] arg input SDF_OptLayout
 * \param[in] layout new SDF_Layout to set in #arg
 * \return A new SDF_OptLayout with layout at the right place, or a core dump if #arg did not have a layout
 */
SDF_OptLayout SDF_setOptLayoutLayout(SDF_OptLayout arg, SDF_Layout layout) {
  if (SDF_isOptLayoutPresent(arg)) {
    return (SDF_OptLayout)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) layout), 0), 1);
  }

  ATabort("OptLayout has no Layout: %t\n", arg);
  return (SDF_OptLayout)NULL;
}

/**
 * Assert whether a SDF_Layout is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Layout
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidLayout(SDF_Layout arg) {
  if (SDF_isLayoutLexToCf(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Layout is a Lex-to-cf. Always returns ATtrue
 * \param[in] arg input SDF_Layout
 * \return ATtrue if #arg corresponds to the signature of a Lex-to-cf, or ATfalse otherwise
 */
inline ATbool SDF_isLayoutLexToCf(SDF_Layout arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternLayoutLexToCf, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_Layout has a list. 
 * \param[in] arg input SDF_Layout
 * \return ATtrue if the SDF_Layout had a list, or ATfalse otherwise
 */
ATbool SDF_hasLayoutList(SDF_Layout arg) {
  if (SDF_isLayoutLexToCf(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the list SDF_LexLayoutList of a SDF_Layout. Note that the precondition is that this SDF_Layout actually has a list
 * \param[in] arg input SDF_Layout
 * \return the list of #arg, if it exist or an undefined value if it does not
 */
SDF_LexLayoutList SDF_getLayoutList(SDF_Layout arg) {
  
    return (SDF_LexLayoutList)ATgetArgument((ATermAppl)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1)), 1);
}

/**
 * Set the list of a SDF_Layout. The precondition being that this SDF_Layout actually has a list
 * \param[in] arg input SDF_Layout
 * \param[in] list new SDF_LexLayoutList to set in #arg
 * \return A new SDF_Layout with list at the right place, or a core dump if #arg did not have a list
 */
SDF_Layout SDF_setLayoutList(SDF_Layout arg, SDF_LexLayoutList list) {
  if (SDF_isLayoutLexToCf(arg)) {
    return (SDF_Layout)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1)), (ATerm)((ATerm) list), 1), 0), 1);
  }

  ATabort("Layout has no List: %t\n", arg);
  return (SDF_Layout)NULL;
}

/**
 * Assert whether a SDF_LexLayoutList is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidLexLayoutList(SDF_LexLayoutList arg) {
  if (SDF_isLexLayoutListEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isLexLayoutListSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isLexLayoutListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_LexLayoutList is a empty. . May not be used to assert correctness of the SDF_LexLayoutList
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isLexLayoutListEmpty(SDF_LexLayoutList arg) {
  if (!ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternLexLayoutListEmpty));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_LexLayoutList is a single. . May not be used to assert correctness of the SDF_LexLayoutList
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if #arg corresponds to the signature of a single, or ATfalse otherwise
 */
inline ATbool SDF_isLexLayoutListSingle(SDF_LexLayoutList arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternLexLayoutListSingle, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_LexLayoutList is a many. . May not be used to assert correctness of the SDF_LexLayoutList
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if #arg corresponds to the signature of a many, or ATfalse otherwise
 */
inline ATbool SDF_isLexLayoutListMany(SDF_LexLayoutList arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternLexLayoutListMany, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_LexLayoutList has a head. 
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if the SDF_LexLayoutList had a head, or ATfalse otherwise
 */
ATbool SDF_hasLexLayoutListHead(SDF_LexLayoutList arg) {
  if (SDF_isLexLayoutListSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isLexLayoutListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_LexLayoutList has a tail. 
 * \param[in] arg input SDF_LexLayoutList
 * \return ATtrue if the SDF_LexLayoutList had a tail, or ATfalse otherwise
 */
ATbool SDF_hasLexLayoutListTail(SDF_LexLayoutList arg) {
  if (SDF_isLexLayoutListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the head SDF_LexLayout of a SDF_LexLayoutList. Note that the precondition is that this SDF_LexLayoutList actually has a head
 * \param[in] arg input SDF_LexLayoutList
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_LexLayout SDF_getLexLayoutListHead(SDF_LexLayoutList arg) {
  if (SDF_isLexLayoutListSingle(arg)) {
    return (SDF_LexLayout)ATgetFirst((ATermList)arg);
  }
  else 
    return (SDF_LexLayout)ATgetFirst((ATermList)arg);
}

/**
 * Get the tail SDF_LexLayoutList of a SDF_LexLayoutList. Note that the precondition is that this SDF_LexLayoutList actually has a tail
 * \param[in] arg input SDF_LexLayoutList
 * \return the tail of #arg, if it exist or an undefined value if it does not
 */
SDF_LexLayoutList SDF_getLexLayoutListTail(SDF_LexLayoutList arg) {
  
    return (SDF_LexLayoutList)ATgetNext((ATermList)arg);
}

/**
 * Set the head of a SDF_LexLayoutList. The precondition being that this SDF_LexLayoutList actually has a head
 * \param[in] arg input SDF_LexLayoutList
 * \param[in] head new SDF_LexLayout to set in #arg
 * \return A new SDF_LexLayoutList with head at the right place, or a core dump if #arg did not have a head
 */
SDF_LexLayoutList SDF_setLexLayoutListHead(SDF_LexLayoutList arg, SDF_LexLayout head) {
  if (SDF_isLexLayoutListSingle(arg)) {
    return (SDF_LexLayoutList)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }
  else if (SDF_isLexLayoutListMany(arg)) {
    return (SDF_LexLayoutList)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }

  ATabort("LexLayoutList has no Head: %t\n", arg);
  return (SDF_LexLayoutList)NULL;
}

/**
 * Set the tail of a SDF_LexLayoutList. The precondition being that this SDF_LexLayoutList actually has a tail
 * \param[in] arg input SDF_LexLayoutList
 * \param[in] tail new SDF_LexLayoutList to set in #arg
 * \return A new SDF_LexLayoutList with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_LexLayoutList SDF_setLexLayoutListTail(SDF_LexLayoutList arg, SDF_LexLayoutList tail) {
  if (SDF_isLexLayoutListMany(arg)) {
    return (SDF_LexLayoutList)ATreplaceTail((ATermList)arg, (ATermList)((ATerm) tail), 1);
  }

  ATabort("LexLayoutList has no Tail: %t\n", arg);
  return (SDF_LexLayoutList)NULL;
}

/**
 * Assert whether a SDF_AFun is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_AFun
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidAFun(SDF_AFun arg) {
  if (SDF_isAFunQuoted(arg)) {
    return ATtrue;
  }
  else if (SDF_isAFunUnquoted(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_AFun is a quoted. . May not be used to assert correctness of the SDF_AFun
 * \param[in] arg input SDF_AFun
 * \return ATtrue if #arg corresponds to the signature of a quoted, or ATfalse otherwise
 */
inline ATbool SDF_isAFunQuoted(SDF_AFun arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternAFunQuoted, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_AFun is a unquoted. . May not be used to assert correctness of the SDF_AFun
 * \param[in] arg input SDF_AFun
 * \return ATtrue if #arg corresponds to the signature of a unquoted, or ATfalse otherwise
 */
inline ATbool SDF_isAFunUnquoted(SDF_AFun arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternAFunUnquoted, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_AFun has a StrCon. 
 * \param[in] arg input SDF_AFun
 * \return ATtrue if the SDF_AFun had a StrCon, or ATfalse otherwise
 */
ATbool SDF_hasAFunStrCon(SDF_AFun arg) {
  if (SDF_isAFunQuoted(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_AFun has a IdCon. 
 * \param[in] arg input SDF_AFun
 * \return ATtrue if the SDF_AFun had a IdCon, or ATfalse otherwise
 */
ATbool SDF_hasAFunIdCon(SDF_AFun arg) {
  if (SDF_isAFunUnquoted(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the StrCon SDF_StrCon of a SDF_AFun. Note that the precondition is that this SDF_AFun actually has a StrCon
 * \param[in] arg input SDF_AFun
 * \return the StrCon of #arg, if it exist or an undefined value if it does not
 */
SDF_StrCon SDF_getAFunStrCon(SDF_AFun arg) {
  
    return (SDF_StrCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the IdCon SDF_IdCon of a SDF_AFun. Note that the precondition is that this SDF_AFun actually has a IdCon
 * \param[in] arg input SDF_AFun
 * \return the IdCon of #arg, if it exist or an undefined value if it does not
 */
SDF_IdCon SDF_getAFunIdCon(SDF_AFun arg) {
  
    return (SDF_IdCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Set the StrCon of a SDF_AFun. The precondition being that this SDF_AFun actually has a StrCon
 * \param[in] arg input SDF_AFun
 * \param[in] StrCon new SDF_StrCon to set in #arg
 * \return A new SDF_AFun with StrCon at the right place, or a core dump if #arg did not have a StrCon
 */
SDF_AFun SDF_setAFunStrCon(SDF_AFun arg, SDF_StrCon StrCon) {
  if (SDF_isAFunQuoted(arg)) {
    return (SDF_AFun)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) StrCon), 0), 1);
  }

  ATabort("AFun has no StrCon: %t\n", arg);
  return (SDF_AFun)NULL;
}

/**
 * Set the IdCon of a SDF_AFun. The precondition being that this SDF_AFun actually has a IdCon
 * \param[in] arg input SDF_AFun
 * \param[in] IdCon new SDF_IdCon to set in #arg
 * \return A new SDF_AFun with IdCon at the right place, or a core dump if #arg did not have a IdCon
 */
SDF_AFun SDF_setAFunIdCon(SDF_AFun arg, SDF_IdCon IdCon) {
  if (SDF_isAFunUnquoted(arg)) {
    return (SDF_AFun)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) IdCon), 0), 1);
  }

  ATabort("AFun has no IdCon: %t\n", arg);
  return (SDF_AFun)NULL;
}

/**
 * Assert whether a SDF_ATerm is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidATerm(SDF_ATerm arg) {
  if (SDF_isATermInt(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermReal(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermFun(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermPlaceholder(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermList(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAnnotated(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm is a int. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a int, or ATfalse otherwise
 */
inline ATbool SDF_isATermInt(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermInt, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a real. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a real, or ATfalse otherwise
 */
inline ATbool SDF_isATermReal(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermReal, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a fun. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a fun, or ATfalse otherwise
 */
inline ATbool SDF_isATermFun(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermFun, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a appl. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a appl, or ATfalse otherwise
 */
inline ATbool SDF_isATermAppl(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermAppl, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a placeholder. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a placeholder, or ATfalse otherwise
 */
inline ATbool SDF_isATermPlaceholder(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermPlaceholder, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a list. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a list, or ATfalse otherwise
 */
inline ATbool SDF_isATermList(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermList, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm is a annotated. . May not be used to assert correctness of the SDF_ATerm
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if #arg corresponds to the signature of a annotated, or ATfalse otherwise
 */
inline ATbool SDF_isATermAnnotated(SDF_ATerm arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermAnnotated, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATerm has a IntCon. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a IntCon, or ATfalse otherwise
 */
ATbool SDF_hasATermIntCon(SDF_ATerm arg) {
  if (SDF_isATermInt(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a RealCon. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a RealCon, or ATfalse otherwise
 */
ATbool SDF_hasATermRealCon(SDF_ATerm arg) {
  if (SDF_isATermReal(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a fun. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a fun, or ATfalse otherwise
 */
ATbool SDF_hasATermFun(SDF_ATerm arg) {
  if (SDF_isATermFun(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-fun. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-fun, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterFun(SDF_ATerm arg) {
  if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-(. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-(, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterParenOpen(SDF_ATerm arg) {
  if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a args. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a args, or ATfalse otherwise
 */
ATbool SDF_hasATermArgs(SDF_ATerm arg) {
  if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-args. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-args, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterArgs(SDF_ATerm arg) {
  if (SDF_isATermAppl(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-<. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-<, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterLessThan(SDF_ATerm arg) {
  if (SDF_isATermPlaceholder(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a type. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a type, or ATfalse otherwise
 */
ATbool SDF_hasATermType(SDF_ATerm arg) {
  if (SDF_isATermPlaceholder(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-type. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-type, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterType(SDF_ATerm arg) {
  if (SDF_isATermPlaceholder(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-[. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-[, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterBracketOpen(SDF_ATerm arg) {
  if (SDF_isATermList(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a elems. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a elems, or ATfalse otherwise
 */
ATbool SDF_hasATermElems(SDF_ATerm arg) {
  if (SDF_isATermList(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-elems. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-elems, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterElems(SDF_ATerm arg) {
  if (SDF_isATermList(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a trm. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a trm, or ATfalse otherwise
 */
ATbool SDF_hasATermTrm(SDF_ATerm arg) {
  if (SDF_isATermAnnotated(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a ws-after-trm. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a ws-after-trm, or ATfalse otherwise
 */
ATbool SDF_hasATermWsAfterTrm(SDF_ATerm arg) {
  if (SDF_isATermAnnotated(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATerm has a Annotation. 
 * \param[in] arg input SDF_ATerm
 * \return ATtrue if the SDF_ATerm had a Annotation, or ATfalse otherwise
 */
ATbool SDF_hasATermAnnotation(SDF_ATerm arg) {
  if (SDF_isATermAnnotated(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the IntCon SDF_IntCon of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a IntCon
 * \param[in] arg input SDF_ATerm
 * \return the IntCon of #arg, if it exist or an undefined value if it does not
 */
SDF_IntCon SDF_getATermIntCon(SDF_ATerm arg) {
  
    return (SDF_IntCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the RealCon SDF_RealCon of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a RealCon
 * \param[in] arg input SDF_ATerm
 * \return the RealCon of #arg, if it exist or an undefined value if it does not
 */
SDF_RealCon SDF_getATermRealCon(SDF_ATerm arg) {
  
    return (SDF_RealCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the fun SDF_AFun of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a fun
 * \param[in] arg input SDF_ATerm
 * \return the fun of #arg, if it exist or an undefined value if it does not
 */
SDF_AFun SDF_getATermFun(SDF_ATerm arg) {
  if (SDF_isATermFun(arg)) {
    return (SDF_AFun)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else 
    return (SDF_AFun)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-fun SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-fun
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-fun of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterFun(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-( SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-(
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-( of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterParenOpen(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the args SDF_ATermArgs of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a args
 * \param[in] arg input SDF_ATerm
 * \return the args of #arg, if it exist or an undefined value if it does not
 */
SDF_ATermArgs SDF_getATermArgs(SDF_ATerm arg) {
  
    return (SDF_ATermArgs)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), 1);
}

/**
 * Get the ws-after-args SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-args
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-args of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterArgs(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after-< SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-<
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-< of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterLessThan(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the type SDF_ATerm of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a type
 * \param[in] arg input SDF_ATerm
 * \return the type of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getATermType(SDF_ATerm arg) {
  
    return (SDF_ATerm)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-type SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-type
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-type of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterType(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-[ SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-[
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-[ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterBracketOpen(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the elems SDF_ATermElems of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a elems
 * \param[in] arg input SDF_ATerm
 * \return the elems of #arg, if it exist or an undefined value if it does not
 */
SDF_ATermElems SDF_getATermElems(SDF_ATerm arg) {
  
    return (SDF_ATermElems)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2), 1);
}

/**
 * Get the ws-after-elems SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-elems
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-elems of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterElems(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the trm SDF_ATerm of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a trm
 * \param[in] arg input SDF_ATerm
 * \return the trm of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getATermTrm(SDF_ATerm arg) {
  
    return (SDF_ATerm)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-trm SDF_OptLayout of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a ws-after-trm
 * \param[in] arg input SDF_ATerm
 * \return the ws-after-trm of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermWsAfterTrm(SDF_ATerm arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Annotation SDF_Annotation of a SDF_ATerm. Note that the precondition is that this SDF_ATerm actually has a Annotation
 * \param[in] arg input SDF_ATerm
 * \return the Annotation of #arg, if it exist or an undefined value if it does not
 */
SDF_Annotation SDF_getATermAnnotation(SDF_ATerm arg) {
  
    return (SDF_Annotation)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Set the IntCon of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a IntCon
 * \param[in] arg input SDF_ATerm
 * \param[in] IntCon new SDF_IntCon to set in #arg
 * \return A new SDF_ATerm with IntCon at the right place, or a core dump if #arg did not have a IntCon
 */
SDF_ATerm SDF_setATermIntCon(SDF_ATerm arg, SDF_IntCon IntCon) {
  if (SDF_isATermInt(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) IntCon), 0), 1);
  }

  ATabort("ATerm has no IntCon: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the RealCon of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a RealCon
 * \param[in] arg input SDF_ATerm
 * \param[in] RealCon new SDF_RealCon to set in #arg
 * \return A new SDF_ATerm with RealCon at the right place, or a core dump if #arg did not have a RealCon
 */
SDF_ATerm SDF_setATermRealCon(SDF_ATerm arg, SDF_RealCon RealCon) {
  if (SDF_isATermReal(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) RealCon), 0), 1);
  }

  ATabort("ATerm has no RealCon: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the fun of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a fun
 * \param[in] arg input SDF_ATerm
 * \param[in] fun new SDF_AFun to set in #arg
 * \return A new SDF_ATerm with fun at the right place, or a core dump if #arg did not have a fun
 */
SDF_ATerm SDF_setATermFun(SDF_ATerm arg, SDF_AFun fun) {
  if (SDF_isATermFun(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) fun), 0), 1);
  }
  else if (SDF_isATermAppl(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) fun), 0), 1);
  }

  ATabort("ATerm has no Fun: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-fun of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-fun
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterFun new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterFun at the right place, or a core dump if #arg did not have a wsAfterFun
 */
SDF_ATerm SDF_setATermWsAfterFun(SDF_ATerm arg, SDF_OptLayout wsAfterFun) {
  if (SDF_isATermAppl(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterFun), 1), 1);
  }

  ATabort("ATerm has no WsAfterFun: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-( of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-(
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterParenOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterParenOpen at the right place, or a core dump if #arg did not have a wsAfterParenOpen
 */
SDF_ATerm SDF_setATermWsAfterParenOpen(SDF_ATerm arg, SDF_OptLayout wsAfterParenOpen) {
  if (SDF_isATermAppl(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 3), 1);
  }

  ATabort("ATerm has no WsAfterParenOpen: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the args of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a args
 * \param[in] arg input SDF_ATerm
 * \param[in] args new SDF_ATermArgs to set in #arg
 * \return A new SDF_ATerm with args at the right place, or a core dump if #arg did not have a args
 */
SDF_ATerm SDF_setATermArgs(SDF_ATerm arg, SDF_ATermArgs args) {
  if (SDF_isATermAppl(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), (ATerm)((ATerm) args), 1), 4), 1);
  }

  ATabort("ATerm has no Args: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-args of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-args
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterArgs new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterArgs at the right place, or a core dump if #arg did not have a wsAfterArgs
 */
SDF_ATerm SDF_setATermWsAfterArgs(SDF_ATerm arg, SDF_OptLayout wsAfterArgs) {
  if (SDF_isATermAppl(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterArgs), 5), 1);
  }

  ATabort("ATerm has no WsAfterArgs: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-< of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-<
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterLessThan new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterLessThan at the right place, or a core dump if #arg did not have a wsAfterLessThan
 */
SDF_ATerm SDF_setATermWsAfterLessThan(SDF_ATerm arg, SDF_OptLayout wsAfterLessThan) {
  if (SDF_isATermPlaceholder(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLessThan), 1), 1);
  }

  ATabort("ATerm has no WsAfterLessThan: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the type of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a type
 * \param[in] arg input SDF_ATerm
 * \param[in] type new SDF_ATerm to set in #arg
 * \return A new SDF_ATerm with type at the right place, or a core dump if #arg did not have a type
 */
SDF_ATerm SDF_setATermType(SDF_ATerm arg, SDF_ATerm type) {
  if (SDF_isATermPlaceholder(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) type), 2), 1);
  }

  ATabort("ATerm has no Type: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-type of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-type
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterType new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterType at the right place, or a core dump if #arg did not have a wsAfterType
 */
SDF_ATerm SDF_setATermWsAfterType(SDF_ATerm arg, SDF_OptLayout wsAfterType) {
  if (SDF_isATermPlaceholder(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterType), 3), 1);
  }

  ATabort("ATerm has no WsAfterType: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-[ of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-[
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterBracketOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterBracketOpen at the right place, or a core dump if #arg did not have a wsAfterBracketOpen
 */
SDF_ATerm SDF_setATermWsAfterBracketOpen(SDF_ATerm arg, SDF_OptLayout wsAfterBracketOpen) {
  if (SDF_isATermList(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBracketOpen), 1), 1);
  }

  ATabort("ATerm has no WsAfterBracketOpen: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the elems of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a elems
 * \param[in] arg input SDF_ATerm
 * \param[in] elems new SDF_ATermElems to set in #arg
 * \return A new SDF_ATerm with elems at the right place, or a core dump if #arg did not have a elems
 */
SDF_ATerm SDF_setATermElems(SDF_ATerm arg, SDF_ATermElems elems) {
  if (SDF_isATermList(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2), (ATerm)((ATerm) elems), 1), 2), 1);
  }

  ATabort("ATerm has no Elems: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-elems of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-elems
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterElems new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterElems at the right place, or a core dump if #arg did not have a wsAfterElems
 */
SDF_ATerm SDF_setATermWsAfterElems(SDF_ATerm arg, SDF_OptLayout wsAfterElems) {
  if (SDF_isATermList(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterElems), 3), 1);
  }

  ATabort("ATerm has no WsAfterElems: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the trm of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a trm
 * \param[in] arg input SDF_ATerm
 * \param[in] trm new SDF_ATerm to set in #arg
 * \return A new SDF_ATerm with trm at the right place, or a core dump if #arg did not have a trm
 */
SDF_ATerm SDF_setATermTrm(SDF_ATerm arg, SDF_ATerm trm) {
  if (SDF_isATermAnnotated(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) trm), 0), 1);
  }

  ATabort("ATerm has no Trm: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the ws-after-trm of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a ws-after-trm
 * \param[in] arg input SDF_ATerm
 * \param[in] wsAfterTrm new SDF_OptLayout to set in #arg
 * \return A new SDF_ATerm with wsAfterTrm at the right place, or a core dump if #arg did not have a wsAfterTrm
 */
SDF_ATerm SDF_setATermWsAfterTrm(SDF_ATerm arg, SDF_OptLayout wsAfterTrm) {
  if (SDF_isATermAnnotated(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterTrm), 1), 1);
  }

  ATabort("ATerm has no WsAfterTrm: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Set the Annotation of a SDF_ATerm. The precondition being that this SDF_ATerm actually has a Annotation
 * \param[in] arg input SDF_ATerm
 * \param[in] Annotation new SDF_Annotation to set in #arg
 * \return A new SDF_ATerm with Annotation at the right place, or a core dump if #arg did not have a Annotation
 */
SDF_ATerm SDF_setATermAnnotation(SDF_ATerm arg, SDF_Annotation Annotation) {
  if (SDF_isATermAnnotated(arg)) {
    return (SDF_ATerm)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Annotation), 2), 1);
  }

  ATabort("ATerm has no Annotation: %t\n", arg);
  return (SDF_ATerm)NULL;
}

/**
 * Assert whether a SDF_Annotation is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Annotation
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidAnnotation(SDF_Annotation arg) {
  if (SDF_isAnnotationDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Annotation is a default. Always returns ATtrue
 * \param[in] arg input SDF_Annotation
 * \return ATtrue if #arg corresponds to the signature of a default, or ATfalse otherwise
 */
inline ATbool SDF_isAnnotationDefault(SDF_Annotation arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternAnnotationDefault, NULL, NULL, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_Annotation has a ws-after-{. 
 * \param[in] arg input SDF_Annotation
 * \return ATtrue if the SDF_Annotation had a ws-after-{, or ATfalse otherwise
 */
ATbool SDF_hasAnnotationWsAfterBraceOpen(SDF_Annotation arg) {
  if (SDF_isAnnotationDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Annotation has a annos. 
 * \param[in] arg input SDF_Annotation
 * \return ATtrue if the SDF_Annotation had a annos, or ATfalse otherwise
 */
ATbool SDF_hasAnnotationAnnos(SDF_Annotation arg) {
  if (SDF_isAnnotationDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Annotation has a ws-after-annos. 
 * \param[in] arg input SDF_Annotation
 * \return ATtrue if the SDF_Annotation had a ws-after-annos, or ATfalse otherwise
 */
ATbool SDF_hasAnnotationWsAfterAnnos(SDF_Annotation arg) {
  if (SDF_isAnnotationDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-after-{ SDF_OptLayout of a SDF_Annotation. Note that the precondition is that this SDF_Annotation actually has a ws-after-{
 * \param[in] arg input SDF_Annotation
 * \return the ws-after-{ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getAnnotationWsAfterBraceOpen(SDF_Annotation arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the annos SDF_ATermAnnos of a SDF_Annotation. Note that the precondition is that this SDF_Annotation actually has a annos
 * \param[in] arg input SDF_Annotation
 * \return the annos of #arg, if it exist or an undefined value if it does not
 */
SDF_ATermAnnos SDF_getAnnotationAnnos(SDF_Annotation arg) {
  
    return (SDF_ATermAnnos)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2), 1);
}

/**
 * Get the ws-after-annos SDF_OptLayout of a SDF_Annotation. Note that the precondition is that this SDF_Annotation actually has a ws-after-annos
 * \param[in] arg input SDF_Annotation
 * \return the ws-after-annos of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getAnnotationWsAfterAnnos(SDF_Annotation arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Set the ws-after-{ of a SDF_Annotation. The precondition being that this SDF_Annotation actually has a ws-after-{
 * \param[in] arg input SDF_Annotation
 * \param[in] wsAfterBraceOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_Annotation with wsAfterBraceOpen at the right place, or a core dump if #arg did not have a wsAfterBraceOpen
 */
SDF_Annotation SDF_setAnnotationWsAfterBraceOpen(SDF_Annotation arg, SDF_OptLayout wsAfterBraceOpen) {
  if (SDF_isAnnotationDefault(arg)) {
    return (SDF_Annotation)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBraceOpen), 1), 1);
  }

  ATabort("Annotation has no WsAfterBraceOpen: %t\n", arg);
  return (SDF_Annotation)NULL;
}

/**
 * Set the annos of a SDF_Annotation. The precondition being that this SDF_Annotation actually has a annos
 * \param[in] arg input SDF_Annotation
 * \param[in] annos new SDF_ATermAnnos to set in #arg
 * \return A new SDF_Annotation with annos at the right place, or a core dump if #arg did not have a annos
 */
SDF_Annotation SDF_setAnnotationAnnos(SDF_Annotation arg, SDF_ATermAnnos annos) {
  if (SDF_isAnnotationDefault(arg)) {
    return (SDF_Annotation)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2), (ATerm)((ATerm) annos), 1), 2), 1);
  }

  ATabort("Annotation has no Annos: %t\n", arg);
  return (SDF_Annotation)NULL;
}

/**
 * Set the ws-after-annos of a SDF_Annotation. The precondition being that this SDF_Annotation actually has a ws-after-annos
 * \param[in] arg input SDF_Annotation
 * \param[in] wsAfterAnnos new SDF_OptLayout to set in #arg
 * \return A new SDF_Annotation with wsAfterAnnos at the right place, or a core dump if #arg did not have a wsAfterAnnos
 */
SDF_Annotation SDF_setAnnotationWsAfterAnnos(SDF_Annotation arg, SDF_OptLayout wsAfterAnnos) {
  if (SDF_isAnnotationDefault(arg)) {
    return (SDF_Annotation)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterAnnos), 3), 1);
  }

  ATabort("Annotation has no WsAfterAnnos: %t\n", arg);
  return (SDF_Annotation)NULL;
}

/**
 * Assert whether a SDF_Start is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidStart(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartIntCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartRealCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartModule(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartSDF(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start is a ATerm. . May not be used to assert correctness of the SDF_Start
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the signature of a ATerm, or ATfalse otherwise
 */
inline ATbool SDF_isStartATerm(SDF_Start arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternStartATerm, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Start is a IntCon. . May not be used to assert correctness of the SDF_Start
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the signature of a IntCon, or ATfalse otherwise
 */
inline ATbool SDF_isStartIntCon(SDF_Start arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternStartIntCon, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Start is a RealCon. . May not be used to assert correctness of the SDF_Start
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the signature of a RealCon, or ATfalse otherwise
 */
inline ATbool SDF_isStartRealCon(SDF_Start arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternStartRealCon, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Start is a Module. . May not be used to assert correctness of the SDF_Start
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the signature of a Module, or ATfalse otherwise
 */
inline ATbool SDF_isStartModule(SDF_Start arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternStartModule, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Start is a SDF. . May not be used to assert correctness of the SDF_Start
 * \param[in] arg input SDF_Start
 * \return ATtrue if #arg corresponds to the signature of a SDF, or ATfalse otherwise
 */
inline ATbool SDF_isStartSDF(SDF_Start arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternStartSDF, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Start has a ws-before. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a ws-before, or ATfalse otherwise
 */
ATbool SDF_hasStartWsBefore(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartIntCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartRealCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartModule(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartSDF(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a top-ATerm. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a top-ATerm, or ATfalse otherwise
 */
ATbool SDF_hasStartTopATerm(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a ws-after. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a ws-after, or ATfalse otherwise
 */
ATbool SDF_hasStartWsAfter(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartIntCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartRealCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartModule(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartSDF(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a amb-cnt. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a amb-cnt, or ATfalse otherwise
 */
ATbool SDF_hasStartAmbCnt(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartIntCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartRealCon(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartModule(arg)) {
    return ATtrue;
  }
  else if (SDF_isStartSDF(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a top-IntCon. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a top-IntCon, or ATfalse otherwise
 */
ATbool SDF_hasStartTopIntCon(SDF_Start arg) {
  if (SDF_isStartIntCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a top-RealCon. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a top-RealCon, or ATfalse otherwise
 */
ATbool SDF_hasStartTopRealCon(SDF_Start arg) {
  if (SDF_isStartRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a top-Module. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a top-Module, or ATfalse otherwise
 */
ATbool SDF_hasStartTopModule(SDF_Start arg) {
  if (SDF_isStartModule(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Start has a top-SDF. 
 * \param[in] arg input SDF_Start
 * \return ATtrue if the SDF_Start had a top-SDF, or ATfalse otherwise
 */
ATbool SDF_hasStartTopSDF(SDF_Start arg) {
  if (SDF_isStartSDF(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-before SDF_OptLayout of a SDF_Start. Note that the precondition is that this SDF_Start actually has a ws-before
 * \param[in] arg input SDF_Start
 * \return the ws-before of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getStartWsBefore(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_OptLayout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1));
  }
  else if (SDF_isStartIntCon(arg)) {
    return (SDF_OptLayout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1));
  }
  else if (SDF_isStartRealCon(arg)) {
    return (SDF_OptLayout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1));
  }
  else if (SDF_isStartModule(arg)) {
    return (SDF_OptLayout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1));
  }
  else 
    return (SDF_OptLayout)ATgetFirst((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1));
}

/**
 * Get the top-ATerm SDF_ATerm of a SDF_Start. Note that the precondition is that this SDF_Start actually has a top-ATerm
 * \param[in] arg input SDF_Start
 * \return the top-ATerm of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getStartTopATerm(SDF_Start arg) {
  
    return (SDF_ATerm)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 1);
}

/**
 * Get the ws-after SDF_OptLayout of a SDF_Start. Note that the precondition is that this SDF_Start actually has a ws-after
 * \param[in] arg input SDF_Start
 * \return the ws-after of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getStartWsAfter(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 2);
  }
  else if (SDF_isStartIntCon(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 2);
  }
  else if (SDF_isStartRealCon(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 2);
  }
  else if (SDF_isStartModule(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 2);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 2);
}

/**
 * Get the amb-cnt int of a SDF_Start. Note that the precondition is that this SDF_Start actually has a amb-cnt
 * \param[in] arg input SDF_Start
 * \return the amb-cnt of #arg, if it exist or an undefined value if it does not
 */
int SDF_getStartAmbCnt(SDF_Start arg) {
  if (SDF_isStartATerm(arg)) {
    return (int)ATgetInt((ATermInt) ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isStartIntCon(arg)) {
    return (int)ATgetInt((ATermInt) ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isStartRealCon(arg)) {
    return (int)ATgetInt((ATermInt) ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isStartModule(arg)) {
    return (int)ATgetInt((ATermInt) ATgetArgument((ATermAppl)arg, 1));
  }
  else 
    return (int)ATgetInt((ATermInt) ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the top-IntCon SDF_IntCon of a SDF_Start. Note that the precondition is that this SDF_Start actually has a top-IntCon
 * \param[in] arg input SDF_Start
 * \return the top-IntCon of #arg, if it exist or an undefined value if it does not
 */
SDF_IntCon SDF_getStartTopIntCon(SDF_Start arg) {
  
    return (SDF_IntCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 1);
}

/**
 * Get the top-RealCon SDF_RealCon of a SDF_Start. Note that the precondition is that this SDF_Start actually has a top-RealCon
 * \param[in] arg input SDF_Start
 * \return the top-RealCon of #arg, if it exist or an undefined value if it does not
 */
SDF_RealCon SDF_getStartTopRealCon(SDF_Start arg) {
  
    return (SDF_RealCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 1);
}

/**
 * Get the top-Module SDF_Module of a SDF_Start. Note that the precondition is that this SDF_Start actually has a top-Module
 * \param[in] arg input SDF_Start
 * \return the top-Module of #arg, if it exist or an undefined value if it does not
 */
SDF_Module SDF_getStartTopModule(SDF_Start arg) {
  
    return (SDF_Module)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 1);
}

/**
 * Get the top-SDF SDF_SDF of a SDF_Start. Note that the precondition is that this SDF_Start actually has a top-SDF
 * \param[in] arg input SDF_Start
 * \return the top-SDF of #arg, if it exist or an undefined value if it does not
 */
SDF_SDF SDF_getStartTopSDF(SDF_Start arg) {
  
    return (SDF_SDF)ATelementAt((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), 1);
}

/**
 * Set the ws-before of a SDF_Start. The precondition being that this SDF_Start actually has a ws-before
 * \param[in] arg input SDF_Start
 * \param[in] wsBefore new SDF_OptLayout to set in #arg
 * \return A new SDF_Start with wsBefore at the right place, or a core dump if #arg did not have a wsBefore
 */
SDF_Start SDF_setStartWsBefore(SDF_Start arg, SDF_OptLayout wsBefore) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsBefore), 0), 1), 0);
  }
  else if (SDF_isStartIntCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsBefore), 0), 1), 0);
  }
  else if (SDF_isStartRealCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsBefore), 0), 1), 0);
  }
  else if (SDF_isStartModule(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsBefore), 0), 1), 0);
  }
  else if (SDF_isStartSDF(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsBefore), 0), 1), 0);
  }

  ATabort("Start has no WsBefore: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the top-ATerm of a SDF_Start. The precondition being that this SDF_Start actually has a top-ATerm
 * \param[in] arg input SDF_Start
 * \param[in] topATerm new SDF_ATerm to set in #arg
 * \return A new SDF_Start with topATerm at the right place, or a core dump if #arg did not have a topATerm
 */
SDF_Start SDF_setStartTopATerm(SDF_Start arg, SDF_ATerm topATerm) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) topATerm), 1), 1), 0);
  }

  ATabort("Start has no TopATerm: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the ws-after of a SDF_Start. The precondition being that this SDF_Start actually has a ws-after
 * \param[in] arg input SDF_Start
 * \param[in] wsAfter new SDF_OptLayout to set in #arg
 * \return A new SDF_Start with wsAfter at the right place, or a core dump if #arg did not have a wsAfter
 */
SDF_Start SDF_setStartWsAfter(SDF_Start arg, SDF_OptLayout wsAfter) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsAfter), 2), 1), 0);
  }
  else if (SDF_isStartIntCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsAfter), 2), 1), 0);
  }
  else if (SDF_isStartRealCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsAfter), 2), 1), 0);
  }
  else if (SDF_isStartModule(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsAfter), 2), 1), 0);
  }
  else if (SDF_isStartSDF(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) wsAfter), 2), 1), 0);
  }

  ATabort("Start has no WsAfter: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the amb-cnt of a SDF_Start. The precondition being that this SDF_Start actually has a amb-cnt
 * \param[in] arg input SDF_Start
 * \param[in] ambCnt new int to set in #arg
 * \return A new SDF_Start with ambCnt at the right place, or a core dump if #arg did not have a ambCnt
 */
SDF_Start SDF_setStartAmbCnt(SDF_Start arg, int ambCnt) {
  if (SDF_isStartATerm(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)((ATerm) (ATerm) ATmakeInt(ambCnt)), 1);
  }
  else if (SDF_isStartIntCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)((ATerm) (ATerm) ATmakeInt(ambCnt)), 1);
  }
  else if (SDF_isStartRealCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)((ATerm) (ATerm) ATmakeInt(ambCnt)), 1);
  }
  else if (SDF_isStartModule(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)((ATerm) (ATerm) ATmakeInt(ambCnt)), 1);
  }
  else if (SDF_isStartSDF(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)((ATerm) (ATerm) ATmakeInt(ambCnt)), 1);
  }

  ATabort("Start has no AmbCnt: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the top-IntCon of a SDF_Start. The precondition being that this SDF_Start actually has a top-IntCon
 * \param[in] arg input SDF_Start
 * \param[in] topIntCon new SDF_IntCon to set in #arg
 * \return A new SDF_Start with topIntCon at the right place, or a core dump if #arg did not have a topIntCon
 */
SDF_Start SDF_setStartTopIntCon(SDF_Start arg, SDF_IntCon topIntCon) {
  if (SDF_isStartIntCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) topIntCon), 1), 1), 0);
  }

  ATabort("Start has no TopIntCon: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the top-RealCon of a SDF_Start. The precondition being that this SDF_Start actually has a top-RealCon
 * \param[in] arg input SDF_Start
 * \param[in] topRealCon new SDF_RealCon to set in #arg
 * \return A new SDF_Start with topRealCon at the right place, or a core dump if #arg did not have a topRealCon
 */
SDF_Start SDF_setStartTopRealCon(SDF_Start arg, SDF_RealCon topRealCon) {
  if (SDF_isStartRealCon(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) topRealCon), 1), 1), 0);
  }

  ATabort("Start has no TopRealCon: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the top-Module of a SDF_Start. The precondition being that this SDF_Start actually has a top-Module
 * \param[in] arg input SDF_Start
 * \param[in] topModule new SDF_Module to set in #arg
 * \return A new SDF_Start with topModule at the right place, or a core dump if #arg did not have a topModule
 */
SDF_Start SDF_setStartTopModule(SDF_Start arg, SDF_Module topModule) {
  if (SDF_isStartModule(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) topModule), 1), 1), 0);
  }

  ATabort("Start has no TopModule: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Set the top-SDF of a SDF_Start. The precondition being that this SDF_Start actually has a top-SDF
 * \param[in] arg input SDF_Start
 * \param[in] topSDF new SDF_SDF to set in #arg
 * \return A new SDF_Start with topSDF at the right place, or a core dump if #arg did not have a topSDF
 */
SDF_Start SDF_setStartTopSDF(SDF_Start arg, SDF_SDF topSDF) {
  if (SDF_isStartSDF(arg)) {
    return (SDF_Start)ATsetArgument((ATermAppl)arg, (ATerm)ATsetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)ATgetArgument((ATermAppl)arg, 0), 1), (ATerm)((ATerm) topSDF), 1), 1), 0);
  }

  ATabort("Start has no TopSDF: %t\n", arg);
  return (SDF_Start)NULL;
}

/**
 * Assert whether a SDF_ATermArgs is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidATermArgs(SDF_ATermArgs arg) {
  if (SDF_isATermArgsEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermArgsSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermArgsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermArgs is a empty. . May not be used to assert correctness of the SDF_ATermArgs
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isATermArgsEmpty(SDF_ATermArgs arg) {
  if (!ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternATermArgsEmpty));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_ATermArgs is a single. . May not be used to assert correctness of the SDF_ATermArgs
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if #arg corresponds to the signature of a single, or ATfalse otherwise
 */
inline ATbool SDF_isATermArgsSingle(SDF_ATermArgs arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermArgsSingle, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermArgs is a many. . May not be used to assert correctness of the SDF_ATermArgs
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if #arg corresponds to the signature of a many, or ATfalse otherwise
 */
inline ATbool SDF_isATermArgsMany(SDF_ATermArgs arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermArgsMany, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermArgs has a head. 
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if the SDF_ATermArgs had a head, or ATfalse otherwise
 */
ATbool SDF_hasATermArgsHead(SDF_ATermArgs arg) {
  if (SDF_isATermArgsSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermArgsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermArgs has a ws-after-head. 
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if the SDF_ATermArgs had a ws-after-head, or ATfalse otherwise
 */
ATbool SDF_hasATermArgsWsAfterHead(SDF_ATermArgs arg) {
  if (SDF_isATermArgsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermArgs has a ws-after-sep. 
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if the SDF_ATermArgs had a ws-after-sep, or ATfalse otherwise
 */
ATbool SDF_hasATermArgsWsAfterSep(SDF_ATermArgs arg) {
  if (SDF_isATermArgsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermArgs has a tail. 
 * \param[in] arg input SDF_ATermArgs
 * \return ATtrue if the SDF_ATermArgs had a tail, or ATfalse otherwise
 */
ATbool SDF_hasATermArgsTail(SDF_ATermArgs arg) {
  if (SDF_isATermArgsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Returns a list of all but the first element of a SDF_ATermArgs. 
 * \param[in] arg input SDF_ATermArgs
 * \return A new SDF_ATermArgs, without the first element and the separator(s) just after it.)
 */
SDF_ATermArgs SDF_getATermArgsTail(SDF_ATermArgs arg) {
  assert(!SDF_isATermArgsEmpty(arg) && "getTail on an empty list");
  if (SDF_isATermArgsSingle(arg)) {
    return (SDF_ATermArgs) SDF_makeATermArgsEmpty();
  }
  else {
  
    return (SDF_ATermArgs)ATgetTail((ATermList)arg, 4);
  }
}

/**
 * Get the head SDF_ATerm of a SDF_ATermArgs. Note that the precondition is that this SDF_ATermArgs actually has a head
 * \param[in] arg input SDF_ATermArgs
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getATermArgsHead(SDF_ATermArgs arg) {
  if (SDF_isATermArgsSingle(arg)) {
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
  }
  else 
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
}

/**
 * Get the ws-after-head SDF_OptLayout of a SDF_ATermArgs. Note that the precondition is that this SDF_ATermArgs actually has a ws-after-head
 * \param[in] arg input SDF_ATermArgs
 * \return the ws-after-head of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermArgsWsAfterHead(SDF_ATermArgs arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 1);
}

/**
 * Get the ws-after-sep SDF_OptLayout of a SDF_ATermArgs. Note that the precondition is that this SDF_ATermArgs actually has a ws-after-sep
 * \param[in] arg input SDF_ATermArgs
 * \return the ws-after-sep of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermArgsWsAfterSep(SDF_ATermArgs arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 3);
}

/**
 * Set the head of a SDF_ATermArgs. The precondition being that this SDF_ATermArgs actually has a head
 * \param[in] arg input SDF_ATermArgs
 * \param[in] head new SDF_ATerm to set in #arg
 * \return A new SDF_ATermArgs with head at the right place, or a core dump if #arg did not have a head
 */
SDF_ATermArgs SDF_setATermArgsHead(SDF_ATermArgs arg, SDF_ATerm head) {
  if (SDF_isATermArgsSingle(arg)) {
    return (SDF_ATermArgs)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }
  else if (SDF_isATermArgsMany(arg)) {
    return (SDF_ATermArgs)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }

  ATabort("ATermArgs has no Head: %t\n", arg);
  return (SDF_ATermArgs)NULL;
}

/**
 * Set the ws-after-head of a SDF_ATermArgs. The precondition being that this SDF_ATermArgs actually has a ws-after-head
 * \param[in] arg input SDF_ATermArgs
 * \param[in] wsAfterHead new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermArgs with wsAfterHead at the right place, or a core dump if #arg did not have a wsAfterHead
 */
SDF_ATermArgs SDF_setATermArgsWsAfterHead(SDF_ATermArgs arg, SDF_OptLayout wsAfterHead) {
  if (SDF_isATermArgsMany(arg)) {
    return (SDF_ATermArgs)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterHead), 1);
  }

  ATabort("ATermArgs has no WsAfterHead: %t\n", arg);
  return (SDF_ATermArgs)NULL;
}

/**
 * Set the ws-after-sep of a SDF_ATermArgs. The precondition being that this SDF_ATermArgs actually has a ws-after-sep
 * \param[in] arg input SDF_ATermArgs
 * \param[in] wsAfterSep new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermArgs with wsAfterSep at the right place, or a core dump if #arg did not have a wsAfterSep
 */
SDF_ATermArgs SDF_setATermArgsWsAfterSep(SDF_ATermArgs arg, SDF_OptLayout wsAfterSep) {
  if (SDF_isATermArgsMany(arg)) {
    return (SDF_ATermArgs)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterSep), 3);
  }

  ATabort("ATermArgs has no WsAfterSep: %t\n", arg);
  return (SDF_ATermArgs)NULL;
}

/**
 * Set the tail of a SDF_ATermArgs. The precondition being that this SDF_ATermArgs actually has a tail
 * \param[in] arg input SDF_ATermArgs
 * \param[in] tail new SDF_ATermArgs to set in #arg
 * \return A new SDF_ATermArgs with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_ATermArgs SDF_setATermArgsTail(SDF_ATermArgs arg, SDF_ATermArgs tail) {
  if (SDF_isATermArgsMany(arg)) {
    return (SDF_ATermArgs)ATreplaceTail((ATermList)arg, (ATermList)((ATerm) tail), 4);
  }

  ATabort("ATermArgs has no Tail: %t\n", arg);
  return (SDF_ATermArgs)NULL;
}

/**
 * Assert whether a SDF_ATermElems is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidATermElems(SDF_ATermElems arg) {
  if (SDF_isATermElemsEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermElemsSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermElemsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermElems is a empty. . May not be used to assert correctness of the SDF_ATermElems
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isATermElemsEmpty(SDF_ATermElems arg) {
  if (!ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternATermElemsEmpty));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_ATermElems is a single. . May not be used to assert correctness of the SDF_ATermElems
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if #arg corresponds to the signature of a single, or ATfalse otherwise
 */
inline ATbool SDF_isATermElemsSingle(SDF_ATermElems arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermElemsSingle, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermElems is a many. . May not be used to assert correctness of the SDF_ATermElems
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if #arg corresponds to the signature of a many, or ATfalse otherwise
 */
inline ATbool SDF_isATermElemsMany(SDF_ATermElems arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermElemsMany, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermElems has a head. 
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if the SDF_ATermElems had a head, or ATfalse otherwise
 */
ATbool SDF_hasATermElemsHead(SDF_ATermElems arg) {
  if (SDF_isATermElemsSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermElemsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermElems has a ws-after-head. 
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if the SDF_ATermElems had a ws-after-head, or ATfalse otherwise
 */
ATbool SDF_hasATermElemsWsAfterHead(SDF_ATermElems arg) {
  if (SDF_isATermElemsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermElems has a ws-after-sep. 
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if the SDF_ATermElems had a ws-after-sep, or ATfalse otherwise
 */
ATbool SDF_hasATermElemsWsAfterSep(SDF_ATermElems arg) {
  if (SDF_isATermElemsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermElems has a tail. 
 * \param[in] arg input SDF_ATermElems
 * \return ATtrue if the SDF_ATermElems had a tail, or ATfalse otherwise
 */
ATbool SDF_hasATermElemsTail(SDF_ATermElems arg) {
  if (SDF_isATermElemsMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Returns a list of all but the first element of a SDF_ATermElems. 
 * \param[in] arg input SDF_ATermElems
 * \return A new SDF_ATermElems, without the first element and the separator(s) just after it.)
 */
SDF_ATermElems SDF_getATermElemsTail(SDF_ATermElems arg) {
  assert(!SDF_isATermElemsEmpty(arg) && "getTail on an empty list");
  if (SDF_isATermElemsSingle(arg)) {
    return (SDF_ATermElems) SDF_makeATermElemsEmpty();
  }
  else {
  
    return (SDF_ATermElems)ATgetTail((ATermList)arg, 4);
  }
}

/**
 * Get the head SDF_ATerm of a SDF_ATermElems. Note that the precondition is that this SDF_ATermElems actually has a head
 * \param[in] arg input SDF_ATermElems
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getATermElemsHead(SDF_ATermElems arg) {
  if (SDF_isATermElemsSingle(arg)) {
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
  }
  else 
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
}

/**
 * Get the ws-after-head SDF_OptLayout of a SDF_ATermElems. Note that the precondition is that this SDF_ATermElems actually has a ws-after-head
 * \param[in] arg input SDF_ATermElems
 * \return the ws-after-head of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermElemsWsAfterHead(SDF_ATermElems arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 1);
}

/**
 * Get the ws-after-sep SDF_OptLayout of a SDF_ATermElems. Note that the precondition is that this SDF_ATermElems actually has a ws-after-sep
 * \param[in] arg input SDF_ATermElems
 * \return the ws-after-sep of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermElemsWsAfterSep(SDF_ATermElems arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 3);
}

/**
 * Set the head of a SDF_ATermElems. The precondition being that this SDF_ATermElems actually has a head
 * \param[in] arg input SDF_ATermElems
 * \param[in] head new SDF_ATerm to set in #arg
 * \return A new SDF_ATermElems with head at the right place, or a core dump if #arg did not have a head
 */
SDF_ATermElems SDF_setATermElemsHead(SDF_ATermElems arg, SDF_ATerm head) {
  if (SDF_isATermElemsSingle(arg)) {
    return (SDF_ATermElems)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }
  else if (SDF_isATermElemsMany(arg)) {
    return (SDF_ATermElems)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }

  ATabort("ATermElems has no Head: %t\n", arg);
  return (SDF_ATermElems)NULL;
}

/**
 * Set the ws-after-head of a SDF_ATermElems. The precondition being that this SDF_ATermElems actually has a ws-after-head
 * \param[in] arg input SDF_ATermElems
 * \param[in] wsAfterHead new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermElems with wsAfterHead at the right place, or a core dump if #arg did not have a wsAfterHead
 */
SDF_ATermElems SDF_setATermElemsWsAfterHead(SDF_ATermElems arg, SDF_OptLayout wsAfterHead) {
  if (SDF_isATermElemsMany(arg)) {
    return (SDF_ATermElems)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterHead), 1);
  }

  ATabort("ATermElems has no WsAfterHead: %t\n", arg);
  return (SDF_ATermElems)NULL;
}

/**
 * Set the ws-after-sep of a SDF_ATermElems. The precondition being that this SDF_ATermElems actually has a ws-after-sep
 * \param[in] arg input SDF_ATermElems
 * \param[in] wsAfterSep new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermElems with wsAfterSep at the right place, or a core dump if #arg did not have a wsAfterSep
 */
SDF_ATermElems SDF_setATermElemsWsAfterSep(SDF_ATermElems arg, SDF_OptLayout wsAfterSep) {
  if (SDF_isATermElemsMany(arg)) {
    return (SDF_ATermElems)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterSep), 3);
  }

  ATabort("ATermElems has no WsAfterSep: %t\n", arg);
  return (SDF_ATermElems)NULL;
}

/**
 * Set the tail of a SDF_ATermElems. The precondition being that this SDF_ATermElems actually has a tail
 * \param[in] arg input SDF_ATermElems
 * \param[in] tail new SDF_ATermElems to set in #arg
 * \return A new SDF_ATermElems with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_ATermElems SDF_setATermElemsTail(SDF_ATermElems arg, SDF_ATermElems tail) {
  if (SDF_isATermElemsMany(arg)) {
    return (SDF_ATermElems)ATreplaceTail((ATermList)arg, (ATermList)((ATerm) tail), 4);
  }

  ATabort("ATermElems has no Tail: %t\n", arg);
  return (SDF_ATermElems)NULL;
}

/**
 * Assert whether a SDF_ATermAnnos is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidATermAnnos(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAnnosSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAnnosMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermAnnos is a empty. . May not be used to assert correctness of the SDF_ATermAnnos
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isATermAnnosEmpty(SDF_ATermAnnos arg) {
  if (!ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternATermAnnosEmpty));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_ATermAnnos is a single. . May not be used to assert correctness of the SDF_ATermAnnos
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if #arg corresponds to the signature of a single, or ATfalse otherwise
 */
inline ATbool SDF_isATermAnnosSingle(SDF_ATermAnnos arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermAnnosSingle, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermAnnos is a many. . May not be used to assert correctness of the SDF_ATermAnnos
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if #arg corresponds to the signature of a many, or ATfalse otherwise
 */
inline ATbool SDF_isATermAnnosMany(SDF_ATermAnnos arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternATermAnnosMany, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_ATermAnnos has a head. 
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if the SDF_ATermAnnos had a head, or ATfalse otherwise
 */
ATbool SDF_hasATermAnnosHead(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isATermAnnosMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermAnnos has a ws-after-head. 
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if the SDF_ATermAnnos had a ws-after-head, or ATfalse otherwise
 */
ATbool SDF_hasATermAnnosWsAfterHead(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermAnnos has a ws-after-sep. 
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if the SDF_ATermAnnos had a ws-after-sep, or ATfalse otherwise
 */
ATbool SDF_hasATermAnnosWsAfterSep(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_ATermAnnos has a tail. 
 * \param[in] arg input SDF_ATermAnnos
 * \return ATtrue if the SDF_ATermAnnos had a tail, or ATfalse otherwise
 */
ATbool SDF_hasATermAnnosTail(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Returns a list of all but the first element of a SDF_ATermAnnos. 
 * \param[in] arg input SDF_ATermAnnos
 * \return A new SDF_ATermAnnos, without the first element and the separator(s) just after it.)
 */
SDF_ATermAnnos SDF_getATermAnnosTail(SDF_ATermAnnos arg) {
  assert(!SDF_isATermAnnosEmpty(arg) && "getTail on an empty list");
  if (SDF_isATermAnnosSingle(arg)) {
    return (SDF_ATermAnnos) SDF_makeATermAnnosEmpty();
  }
  else {
  
    return (SDF_ATermAnnos)ATgetTail((ATermList)arg, 4);
  }
}

/**
 * Get the head SDF_ATerm of a SDF_ATermAnnos. Note that the precondition is that this SDF_ATermAnnos actually has a head
 * \param[in] arg input SDF_ATermAnnos
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_ATerm SDF_getATermAnnosHead(SDF_ATermAnnos arg) {
  if (SDF_isATermAnnosSingle(arg)) {
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
  }
  else 
    return (SDF_ATerm)ATgetFirst((ATermList)arg);
}

/**
 * Get the ws-after-head SDF_OptLayout of a SDF_ATermAnnos. Note that the precondition is that this SDF_ATermAnnos actually has a ws-after-head
 * \param[in] arg input SDF_ATermAnnos
 * \return the ws-after-head of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermAnnosWsAfterHead(SDF_ATermAnnos arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 1);
}

/**
 * Get the ws-after-sep SDF_OptLayout of a SDF_ATermAnnos. Note that the precondition is that this SDF_ATermAnnos actually has a ws-after-sep
 * \param[in] arg input SDF_ATermAnnos
 * \return the ws-after-sep of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getATermAnnosWsAfterSep(SDF_ATermAnnos arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 3);
}

/**
 * Set the head of a SDF_ATermAnnos. The precondition being that this SDF_ATermAnnos actually has a head
 * \param[in] arg input SDF_ATermAnnos
 * \param[in] head new SDF_ATerm to set in #arg
 * \return A new SDF_ATermAnnos with head at the right place, or a core dump if #arg did not have a head
 */
SDF_ATermAnnos SDF_setATermAnnosHead(SDF_ATermAnnos arg, SDF_ATerm head) {
  if (SDF_isATermAnnosSingle(arg)) {
    return (SDF_ATermAnnos)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }
  else if (SDF_isATermAnnosMany(arg)) {
    return (SDF_ATermAnnos)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }

  ATabort("ATermAnnos has no Head: %t\n", arg);
  return (SDF_ATermAnnos)NULL;
}

/**
 * Set the ws-after-head of a SDF_ATermAnnos. The precondition being that this SDF_ATermAnnos actually has a ws-after-head
 * \param[in] arg input SDF_ATermAnnos
 * \param[in] wsAfterHead new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermAnnos with wsAfterHead at the right place, or a core dump if #arg did not have a wsAfterHead
 */
SDF_ATermAnnos SDF_setATermAnnosWsAfterHead(SDF_ATermAnnos arg, SDF_OptLayout wsAfterHead) {
  if (SDF_isATermAnnosMany(arg)) {
    return (SDF_ATermAnnos)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterHead), 1);
  }

  ATabort("ATermAnnos has no WsAfterHead: %t\n", arg);
  return (SDF_ATermAnnos)NULL;
}

/**
 * Set the ws-after-sep of a SDF_ATermAnnos. The precondition being that this SDF_ATermAnnos actually has a ws-after-sep
 * \param[in] arg input SDF_ATermAnnos
 * \param[in] wsAfterSep new SDF_OptLayout to set in #arg
 * \return A new SDF_ATermAnnos with wsAfterSep at the right place, or a core dump if #arg did not have a wsAfterSep
 */
SDF_ATermAnnos SDF_setATermAnnosWsAfterSep(SDF_ATermAnnos arg, SDF_OptLayout wsAfterSep) {
  if (SDF_isATermAnnosMany(arg)) {
    return (SDF_ATermAnnos)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterSep), 3);
  }

  ATabort("ATermAnnos has no WsAfterSep: %t\n", arg);
  return (SDF_ATermAnnos)NULL;
}

/**
 * Set the tail of a SDF_ATermAnnos. The precondition being that this SDF_ATermAnnos actually has a tail
 * \param[in] arg input SDF_ATermAnnos
 * \param[in] tail new SDF_ATermAnnos to set in #arg
 * \return A new SDF_ATermAnnos with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_ATermAnnos SDF_setATermAnnosTail(SDF_ATermAnnos arg, SDF_ATermAnnos tail) {
  if (SDF_isATermAnnosMany(arg)) {
    return (SDF_ATermAnnos)ATreplaceTail((ATermList)arg, (ATermList)((ATerm) tail), 4);
  }

  ATabort("ATermAnnos has no Tail: %t\n", arg);
  return (SDF_ATermAnnos)NULL;
}

/**
 * Assert whether a SDF_IntCon is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidIntCon(SDF_IntCon arg) {
  if (SDF_isIntConNatural(arg)) {
    return ATtrue;
  }
  else if (SDF_isIntConPositive(arg)) {
    return ATtrue;
  }
  else if (SDF_isIntConNegative(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_IntCon is a natural. . May not be used to assert correctness of the SDF_IntCon
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if #arg corresponds to the signature of a natural, or ATfalse otherwise
 */
inline ATbool SDF_isIntConNatural(SDF_IntCon arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternIntConNatural, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_IntCon is a positive. . May not be used to assert correctness of the SDF_IntCon
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if #arg corresponds to the signature of a positive, or ATfalse otherwise
 */
inline ATbool SDF_isIntConPositive(SDF_IntCon arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternIntConPositive, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_IntCon is a negative. . May not be used to assert correctness of the SDF_IntCon
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if #arg corresponds to the signature of a negative, or ATfalse otherwise
 */
inline ATbool SDF_isIntConNegative(SDF_IntCon arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternIntConNegative, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_IntCon has a NatCon. 
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if the SDF_IntCon had a NatCon, or ATfalse otherwise
 */
ATbool SDF_hasIntConNatCon(SDF_IntCon arg) {
  if (SDF_isIntConNatural(arg)) {
    return ATtrue;
  }
  else if (SDF_isIntConPositive(arg)) {
    return ATtrue;
  }
  else if (SDF_isIntConNegative(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_IntCon has a ws-after-pos. 
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if the SDF_IntCon had a ws-after-pos, or ATfalse otherwise
 */
ATbool SDF_hasIntConWsAfterPos(SDF_IntCon arg) {
  if (SDF_isIntConPositive(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_IntCon has a ws-after-neg. 
 * \param[in] arg input SDF_IntCon
 * \return ATtrue if the SDF_IntCon had a ws-after-neg, or ATfalse otherwise
 */
ATbool SDF_hasIntConWsAfterNeg(SDF_IntCon arg) {
  if (SDF_isIntConNegative(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the NatCon SDF_NatCon of a SDF_IntCon. Note that the precondition is that this SDF_IntCon actually has a NatCon
 * \param[in] arg input SDF_IntCon
 * \return the NatCon of #arg, if it exist or an undefined value if it does not
 */
SDF_NatCon SDF_getIntConNatCon(SDF_IntCon arg) {
  if (SDF_isIntConNatural(arg)) {
    return (SDF_NatCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isIntConPositive(arg)) {
    return (SDF_NatCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else 
    return (SDF_NatCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-pos SDF_OptLayout of a SDF_IntCon. Note that the precondition is that this SDF_IntCon actually has a ws-after-pos
 * \param[in] arg input SDF_IntCon
 * \return the ws-after-pos of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getIntConWsAfterPos(SDF_IntCon arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-neg SDF_OptLayout of a SDF_IntCon. Note that the precondition is that this SDF_IntCon actually has a ws-after-neg
 * \param[in] arg input SDF_IntCon
 * \return the ws-after-neg of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getIntConWsAfterNeg(SDF_IntCon arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Set the NatCon of a SDF_IntCon. The precondition being that this SDF_IntCon actually has a NatCon
 * \param[in] arg input SDF_IntCon
 * \param[in] NatCon new SDF_NatCon to set in #arg
 * \return A new SDF_IntCon with NatCon at the right place, or a core dump if #arg did not have a NatCon
 */
SDF_IntCon SDF_setIntConNatCon(SDF_IntCon arg, SDF_NatCon NatCon) {
  if (SDF_isIntConNatural(arg)) {
    return (SDF_IntCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) NatCon), 0), 1);
  }
  else if (SDF_isIntConPositive(arg)) {
    return (SDF_IntCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) NatCon), 2), 1);
  }
  else if (SDF_isIntConNegative(arg)) {
    return (SDF_IntCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) NatCon), 2), 1);
  }

  ATabort("IntCon has no NatCon: %t\n", arg);
  return (SDF_IntCon)NULL;
}

/**
 * Set the ws-after-pos of a SDF_IntCon. The precondition being that this SDF_IntCon actually has a ws-after-pos
 * \param[in] arg input SDF_IntCon
 * \param[in] wsAfterPos new SDF_OptLayout to set in #arg
 * \return A new SDF_IntCon with wsAfterPos at the right place, or a core dump if #arg did not have a wsAfterPos
 */
SDF_IntCon SDF_setIntConWsAfterPos(SDF_IntCon arg, SDF_OptLayout wsAfterPos) {
  if (SDF_isIntConPositive(arg)) {
    return (SDF_IntCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterPos), 1), 1);
  }

  ATabort("IntCon has no WsAfterPos: %t\n", arg);
  return (SDF_IntCon)NULL;
}

/**
 * Set the ws-after-neg of a SDF_IntCon. The precondition being that this SDF_IntCon actually has a ws-after-neg
 * \param[in] arg input SDF_IntCon
 * \param[in] wsAfterNeg new SDF_OptLayout to set in #arg
 * \return A new SDF_IntCon with wsAfterNeg at the right place, or a core dump if #arg did not have a wsAfterNeg
 */
SDF_IntCon SDF_setIntConWsAfterNeg(SDF_IntCon arg, SDF_OptLayout wsAfterNeg) {
  if (SDF_isIntConNegative(arg)) {
    return (SDF_IntCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterNeg), 1), 1);
  }

  ATabort("IntCon has no WsAfterNeg: %t\n", arg);
  return (SDF_IntCon)NULL;
}

/**
 * Assert whether a SDF_OptExp is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_OptExp
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidOptExp(SDF_OptExp arg) {
  if (SDF_isOptExpPresent(arg)) {
    return ATtrue;
  }
  else if (SDF_isOptExpAbsent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_OptExp is a present. . May not be used to assert correctness of the SDF_OptExp
 * \param[in] arg input SDF_OptExp
 * \return ATtrue if #arg corresponds to the signature of a present, or ATfalse otherwise
 */
inline ATbool SDF_isOptExpPresent(SDF_OptExp arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptExpPresent, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptExp is a absent. . May not be used to assert correctness of the SDF_OptExp
 * \param[in] arg input SDF_OptExp
 * \return ATtrue if #arg corresponds to the signature of a absent, or ATfalse otherwise
 */
inline ATbool SDF_isOptExpAbsent(SDF_OptExp arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptExpAbsent);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptExp has a ws-after-e. 
 * \param[in] arg input SDF_OptExp
 * \return ATtrue if the SDF_OptExp had a ws-after-e, or ATfalse otherwise
 */
ATbool SDF_hasOptExpWsAfterE(SDF_OptExp arg) {
  if (SDF_isOptExpPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_OptExp has a IntCon. 
 * \param[in] arg input SDF_OptExp
 * \return ATtrue if the SDF_OptExp had a IntCon, or ATfalse otherwise
 */
ATbool SDF_hasOptExpIntCon(SDF_OptExp arg) {
  if (SDF_isOptExpPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-after-e SDF_OptLayout of a SDF_OptExp. Note that the precondition is that this SDF_OptExp actually has a ws-after-e
 * \param[in] arg input SDF_OptExp
 * \return the ws-after-e of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getOptExpWsAfterE(SDF_OptExp arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the IntCon SDF_IntCon of a SDF_OptExp. Note that the precondition is that this SDF_OptExp actually has a IntCon
 * \param[in] arg input SDF_OptExp
 * \return the IntCon of #arg, if it exist or an undefined value if it does not
 */
SDF_IntCon SDF_getOptExpIntCon(SDF_OptExp arg) {
  
    return (SDF_IntCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Set the ws-after-e of a SDF_OptExp. The precondition being that this SDF_OptExp actually has a ws-after-e
 * \param[in] arg input SDF_OptExp
 * \param[in] wsAfterE new SDF_OptLayout to set in #arg
 * \return A new SDF_OptExp with wsAfterE at the right place, or a core dump if #arg did not have a wsAfterE
 */
SDF_OptExp SDF_setOptExpWsAfterE(SDF_OptExp arg, SDF_OptLayout wsAfterE) {
  if (SDF_isOptExpPresent(arg)) {
    return (SDF_OptExp)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterE), 1), 1);
  }

  ATabort("OptExp has no WsAfterE: %t\n", arg);
  return (SDF_OptExp)NULL;
}

/**
 * Set the IntCon of a SDF_OptExp. The precondition being that this SDF_OptExp actually has a IntCon
 * \param[in] arg input SDF_OptExp
 * \param[in] IntCon new SDF_IntCon to set in #arg
 * \return A new SDF_OptExp with IntCon at the right place, or a core dump if #arg did not have a IntCon
 */
SDF_OptExp SDF_setOptExpIntCon(SDF_OptExp arg, SDF_IntCon IntCon) {
  if (SDF_isOptExpPresent(arg)) {
    return (SDF_OptExp)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) IntCon), 2), 1);
  }

  ATabort("OptExp has no IntCon: %t\n", arg);
  return (SDF_OptExp)NULL;
}

/**
 * Assert whether a SDF_RealCon is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidRealCon(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon is a real-con. Always returns ATtrue
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if #arg corresponds to the signature of a real-con, or ATfalse otherwise
 */
inline ATbool SDF_isRealConRealCon(SDF_RealCon arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternRealConRealCon, NULL, NULL, NULL, NULL, NULL, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_RealCon has a base. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a base, or ATfalse otherwise
 */
ATbool SDF_hasRealConBase(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon has a ws-after-base. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a ws-after-base, or ATfalse otherwise
 */
ATbool SDF_hasRealConWsAfterBase(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon has a ws-after-.. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a ws-after-., or ATfalse otherwise
 */
ATbool SDF_hasRealConWsAfterPeriod(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon has a decimal. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a decimal, or ATfalse otherwise
 */
ATbool SDF_hasRealConDecimal(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon has a ws-after-decimal. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a ws-after-decimal, or ATfalse otherwise
 */
ATbool SDF_hasRealConWsAfterDecimal(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_RealCon has a exp. 
 * \param[in] arg input SDF_RealCon
 * \return ATtrue if the SDF_RealCon had a exp, or ATfalse otherwise
 */
ATbool SDF_hasRealConExp(SDF_RealCon arg) {
  if (SDF_isRealConRealCon(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the base SDF_IntCon of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a base
 * \param[in] arg input SDF_RealCon
 * \return the base of #arg, if it exist or an undefined value if it does not
 */
SDF_IntCon SDF_getRealConBase(SDF_RealCon arg) {
  
    return (SDF_IntCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-base SDF_OptLayout of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a ws-after-base
 * \param[in] arg input SDF_RealCon
 * \return the ws-after-base of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getRealConWsAfterBase(SDF_RealCon arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-. SDF_OptLayout of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a ws-after-.
 * \param[in] arg input SDF_RealCon
 * \return the ws-after-. of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getRealConWsAfterPeriod(SDF_RealCon arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the decimal SDF_NatCon of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a decimal
 * \param[in] arg input SDF_RealCon
 * \return the decimal of #arg, if it exist or an undefined value if it does not
 */
SDF_NatCon SDF_getRealConDecimal(SDF_RealCon arg) {
  
    return (SDF_NatCon)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-decimal SDF_OptLayout of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a ws-after-decimal
 * \param[in] arg input SDF_RealCon
 * \return the ws-after-decimal of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getRealConWsAfterDecimal(SDF_RealCon arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the exp SDF_OptExp of a SDF_RealCon. Note that the precondition is that this SDF_RealCon actually has a exp
 * \param[in] arg input SDF_RealCon
 * \return the exp of #arg, if it exist or an undefined value if it does not
 */
SDF_OptExp SDF_getRealConExp(SDF_RealCon arg) {
  
    return (SDF_OptExp)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 6);
}

/**
 * Set the base of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a base
 * \param[in] arg input SDF_RealCon
 * \param[in] base new SDF_IntCon to set in #arg
 * \return A new SDF_RealCon with base at the right place, or a core dump if #arg did not have a base
 */
SDF_RealCon SDF_setRealConBase(SDF_RealCon arg, SDF_IntCon base) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) base), 0), 1);
  }

  ATabort("RealCon has no Base: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Set the ws-after-base of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a ws-after-base
 * \param[in] arg input SDF_RealCon
 * \param[in] wsAfterBase new SDF_OptLayout to set in #arg
 * \return A new SDF_RealCon with wsAfterBase at the right place, or a core dump if #arg did not have a wsAfterBase
 */
SDF_RealCon SDF_setRealConWsAfterBase(SDF_RealCon arg, SDF_OptLayout wsAfterBase) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBase), 1), 1);
  }

  ATabort("RealCon has no WsAfterBase: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Set the ws-after-. of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a ws-after-.
 * \param[in] arg input SDF_RealCon
 * \param[in] wsAfterPeriod new SDF_OptLayout to set in #arg
 * \return A new SDF_RealCon with wsAfterPeriod at the right place, or a core dump if #arg did not have a wsAfterPeriod
 */
SDF_RealCon SDF_setRealConWsAfterPeriod(SDF_RealCon arg, SDF_OptLayout wsAfterPeriod) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterPeriod), 3), 1);
  }

  ATabort("RealCon has no WsAfterPeriod: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Set the decimal of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a decimal
 * \param[in] arg input SDF_RealCon
 * \param[in] decimal new SDF_NatCon to set in #arg
 * \return A new SDF_RealCon with decimal at the right place, or a core dump if #arg did not have a decimal
 */
SDF_RealCon SDF_setRealConDecimal(SDF_RealCon arg, SDF_NatCon decimal) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) decimal), 4), 1);
  }

  ATabort("RealCon has no Decimal: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Set the ws-after-decimal of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a ws-after-decimal
 * \param[in] arg input SDF_RealCon
 * \param[in] wsAfterDecimal new SDF_OptLayout to set in #arg
 * \return A new SDF_RealCon with wsAfterDecimal at the right place, or a core dump if #arg did not have a wsAfterDecimal
 */
SDF_RealCon SDF_setRealConWsAfterDecimal(SDF_RealCon arg, SDF_OptLayout wsAfterDecimal) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterDecimal), 5), 1);
  }

  ATabort("RealCon has no WsAfterDecimal: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Set the exp of a SDF_RealCon. The precondition being that this SDF_RealCon actually has a exp
 * \param[in] arg input SDF_RealCon
 * \param[in] exp new SDF_OptExp to set in #arg
 * \return A new SDF_RealCon with exp at the right place, or a core dump if #arg did not have a exp
 */
SDF_RealCon SDF_setRealConExp(SDF_RealCon arg, SDF_OptExp exp) {
  if (SDF_isRealConRealCon(arg)) {
    return (SDF_RealCon)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) exp), 6), 1);
  }

  ATabort("RealCon has no Exp: %t\n", arg);
  return (SDF_RealCon)NULL;
}

/**
 * Assert whether a SDF_Grammar is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidGrammar(SDF_Grammar arg) {
  if (SDF_isGrammarAliases(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarEmptyGrammar(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarConcGrammars(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarBracket(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarImpSection(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarSorts(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarKernelStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar is a aliases. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a aliases, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarAliases(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarAliases, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a lexical-syntax. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a lexical-syntax, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarLexicalSyntax(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarLexicalSyntax, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a context-free-syntax. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a context-free-syntax, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarContextFreeSyntax(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarContextFreeSyntax, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a variables. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a variables, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarVariables(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarVariables, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a lexical-variables. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a lexical-variables, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarLexicalVariables(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarLexicalVariables, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a empty-grammar. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a empty-grammar, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarEmptyGrammar(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarEmptyGrammar);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a conc-grammars. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a conc-grammars, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarConcGrammars(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarConcGrammars, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a Bracket. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a Bracket, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarBracket(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarBracket, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a syntax. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a syntax, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarSyntax(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarSyntax, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a imp-section. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a imp-section, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarImpSection(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarImpSection, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a priorities. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a priorities, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarPriorities(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarPriorities, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a restrictions. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a restrictions, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarRestrictions(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarRestrictions, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a lexical-priorities. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a lexical-priorities, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarLexicalPriorities(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarLexicalPriorities, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a context-free-priorities. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a context-free-priorities, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarContextFreePriorities(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarContextFreePriorities, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a lexical-restrictions. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a lexical-restrictions, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarLexicalRestrictions(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarLexicalRestrictions, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a context-free-restrictions. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a context-free-restrictions, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarContextFreeRestrictions(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarContextFreeRestrictions, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a sorts. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a sorts, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarSorts(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarSorts, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a kernel-start-symbols. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a kernel-start-symbols, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarKernelStartSymbols(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarKernelStartSymbols, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a lexical-start-symbols. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a lexical-start-symbols, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarLexicalStartSymbols(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarLexicalStartSymbols, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar is a context-free-start-symbols. . May not be used to assert correctness of the SDF_Grammar
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if #arg corresponds to the signature of a context-free-start-symbols, or ATfalse otherwise
 */
inline ATbool SDF_isGrammarContextFreeStartSymbols(SDF_Grammar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternGrammarContextFreeStartSymbols, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Grammar has a ws-after-aliases. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-aliases, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterAliases(SDF_Grammar arg) {
  if (SDF_isGrammarAliases(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Aliases. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Aliases, or ATfalse otherwise
 */
ATbool SDF_hasGrammarAliases(SDF_Grammar arg) {
  if (SDF_isGrammarAliases(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-lexical. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-lexical, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterLexical(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-syntax. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-syntax, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterSyntax(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarSyntax(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Productions. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Productions, or ATfalse otherwise
 */
ATbool SDF_hasGrammarProductions(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarSyntax(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-context-free. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-context-free, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterContextFree(SDF_Grammar arg) {
  if (SDF_isGrammarContextFreeSyntax(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-variables. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-variables, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterVariables(SDF_Grammar arg) {
  if (SDF_isGrammarVariables(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a left. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a left, or ATfalse otherwise
 */
ATbool SDF_hasGrammarLeft(SDF_Grammar arg) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-left. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-left, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterLeft(SDF_Grammar arg) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a right. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a right, or ATfalse otherwise
 */
ATbool SDF_hasGrammarRight(SDF_Grammar arg) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-(. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-(, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterParenOpen(SDF_Grammar arg) {
  if (SDF_isGrammarBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Grammar. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Grammar, or ATfalse otherwise
 */
ATbool SDF_hasGrammarGrammar(SDF_Grammar arg) {
  if (SDF_isGrammarBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-Grammar. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-Grammar, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterGrammar(SDF_Grammar arg) {
  if (SDF_isGrammarBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ImpSection. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ImpSection, or ATfalse otherwise
 */
ATbool SDF_hasGrammarImpSection(SDF_Grammar arg) {
  if (SDF_isGrammarImpSection(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-priorities. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-priorities, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterPriorities(SDF_Grammar arg) {
  if (SDF_isGrammarPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Priorities. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Priorities, or ATfalse otherwise
 */
ATbool SDF_hasGrammarPriorities(SDF_Grammar arg) {
  if (SDF_isGrammarPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-restrictions. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-restrictions, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterRestrictions(SDF_Grammar arg) {
  if (SDF_isGrammarRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Restrictions. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Restrictions, or ATfalse otherwise
 */
ATbool SDF_hasGrammarRestrictions(SDF_Grammar arg) {
  if (SDF_isGrammarRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-sorts. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-sorts, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterSorts(SDF_Grammar arg) {
  if (SDF_isGrammarSorts(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a Symbols. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a Symbols, or ATfalse otherwise
 */
ATbool SDF_hasGrammarSymbols(SDF_Grammar arg) {
  if (SDF_isGrammarSorts(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarKernelStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Grammar has a ws-after-start-symbols. 
 * \param[in] arg input SDF_Grammar
 * \return ATtrue if the SDF_Grammar had a ws-after-start-symbols, or ATfalse otherwise
 */
ATbool SDF_hasGrammarWsAfterStartSymbols(SDF_Grammar arg) {
  if (SDF_isGrammarKernelStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return ATtrue;
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-after-aliases SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-aliases
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-aliases of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterAliases(SDF_Grammar arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Aliases SDF_Aliases of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Aliases
 * \param[in] arg input SDF_Grammar
 * \return the Aliases of #arg, if it exist or an undefined value if it does not
 */
SDF_Aliases SDF_getGrammarAliases(SDF_Grammar arg) {
  
    return (SDF_Aliases)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-lexical SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-lexical
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-lexical of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterLexical(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-syntax SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-syntax
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-syntax of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterSyntax(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Productions SDF_Productions of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Productions
 * \param[in] arg input SDF_Grammar
 * \return the Productions of #arg, if it exist or an undefined value if it does not
 */
SDF_Productions SDF_getGrammarProductions(SDF_Grammar arg) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_Productions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_Productions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else if (SDF_isGrammarVariables(arg)) {
    return (SDF_Productions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return (SDF_Productions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Productions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-context-free SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-context-free
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-context-free of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterContextFree(SDF_Grammar arg) {
  if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-variables SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-variables
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-variables of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterVariables(SDF_Grammar arg) {
  if (SDF_isGrammarVariables(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the left SDF_Grammar of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a left
 * \param[in] arg input SDF_Grammar
 * \return the left of #arg, if it exist or an undefined value if it does not
 */
SDF_Grammar SDF_getGrammarLeft(SDF_Grammar arg) {
  
    return (SDF_Grammar)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-left SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-left
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-left of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterLeft(SDF_Grammar arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the right SDF_Grammar of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a right
 * \param[in] arg input SDF_Grammar
 * \return the right of #arg, if it exist or an undefined value if it does not
 */
SDF_Grammar SDF_getGrammarRight(SDF_Grammar arg) {
  
    return (SDF_Grammar)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-( SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-(
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-( of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterParenOpen(SDF_Grammar arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Grammar SDF_Grammar of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Grammar
 * \param[in] arg input SDF_Grammar
 * \return the Grammar of #arg, if it exist or an undefined value if it does not
 */
SDF_Grammar SDF_getGrammarGrammar(SDF_Grammar arg) {
  
    return (SDF_Grammar)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-Grammar SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-Grammar
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-Grammar of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterGrammar(SDF_Grammar arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ImpSection SDF_ImpSection of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ImpSection
 * \param[in] arg input SDF_Grammar
 * \return the ImpSection of #arg, if it exist or an undefined value if it does not
 */
SDF_ImpSection SDF_getGrammarImpSection(SDF_Grammar arg) {
  
    return (SDF_ImpSection)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-priorities SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-priorities
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-priorities of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterPriorities(SDF_Grammar arg) {
  if (SDF_isGrammarPriorities(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the Priorities SDF_Priorities of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Priorities
 * \param[in] arg input SDF_Grammar
 * \return the Priorities of #arg, if it exist or an undefined value if it does not
 */
SDF_Priorities SDF_getGrammarPriorities(SDF_Grammar arg) {
  if (SDF_isGrammarPriorities(arg)) {
    return (SDF_Priorities)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_Priorities)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Priorities)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-restrictions SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-restrictions
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-restrictions of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterRestrictions(SDF_Grammar arg) {
  if (SDF_isGrammarRestrictions(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the Restrictions SDF_Restrictions of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Restrictions
 * \param[in] arg input SDF_Grammar
 * \return the Restrictions of #arg, if it exist or an undefined value if it does not
 */
SDF_Restrictions SDF_getGrammarRestrictions(SDF_Grammar arg) {
  if (SDF_isGrammarRestrictions(arg)) {
    return (SDF_Restrictions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_Restrictions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Restrictions)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-sorts SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-sorts
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-sorts of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterSorts(SDF_Grammar arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Symbols SDF_Symbols of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a Symbols
 * \param[in] arg input SDF_Grammar
 * \return the Symbols of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbols SDF_getGrammarSymbols(SDF_Grammar arg) {
  if (SDF_isGrammarSorts(arg)) {
    return (SDF_Symbols)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isGrammarKernelStartSymbols(arg)) {
    return (SDF_Symbols)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return (SDF_Symbols)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Symbols)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-start-symbols SDF_OptLayout of a SDF_Grammar. Note that the precondition is that this SDF_Grammar actually has a ws-after-start-symbols
 * \param[in] arg input SDF_Grammar
 * \return the ws-after-start-symbols of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getGrammarWsAfterStartSymbols(SDF_Grammar arg) {
  if (SDF_isGrammarKernelStartSymbols(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Set the ws-after-aliases of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-aliases
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterAliases new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterAliases at the right place, or a core dump if #arg did not have a wsAfterAliases
 */
SDF_Grammar SDF_setGrammarWsAfterAliases(SDF_Grammar arg, SDF_OptLayout wsAfterAliases) {
  if (SDF_isGrammarAliases(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterAliases), 1), 1);
  }

  ATabort("Grammar has no WsAfterAliases: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Aliases of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Aliases
 * \param[in] arg input SDF_Grammar
 * \param[in] Aliases new SDF_Aliases to set in #arg
 * \return A new SDF_Grammar with Aliases at the right place, or a core dump if #arg did not have a Aliases
 */
SDF_Grammar SDF_setGrammarAliases(SDF_Grammar arg, SDF_Aliases Aliases) {
  if (SDF_isGrammarAliases(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Aliases), 2), 1);
  }

  ATabort("Grammar has no Aliases: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-lexical of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-lexical
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterLexical new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterLexical at the right place, or a core dump if #arg did not have a wsAfterLexical
 */
SDF_Grammar SDF_setGrammarWsAfterLexical(SDF_Grammar arg, SDF_OptLayout wsAfterLexical) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLexical), 1), 1);
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLexical), 1), 1);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLexical), 1), 1);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLexical), 1), 1);
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLexical), 1), 1);
  }

  ATabort("Grammar has no WsAfterLexical: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-syntax of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-syntax
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterSyntax new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterSyntax at the right place, or a core dump if #arg did not have a wsAfterSyntax
 */
SDF_Grammar SDF_setGrammarWsAfterSyntax(SDF_Grammar arg, SDF_OptLayout wsAfterSyntax) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSyntax), 3), 1);
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSyntax), 3), 1);
  }
  else if (SDF_isGrammarSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSyntax), 1), 1);
  }

  ATabort("Grammar has no WsAfterSyntax: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Productions of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Productions
 * \param[in] arg input SDF_Grammar
 * \param[in] Productions new SDF_Productions to set in #arg
 * \return A new SDF_Grammar with Productions at the right place, or a core dump if #arg did not have a Productions
 */
SDF_Grammar SDF_setGrammarProductions(SDF_Grammar arg, SDF_Productions Productions) {
  if (SDF_isGrammarLexicalSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Productions), 4), 1);
  }
  else if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Productions), 4), 1);
  }
  else if (SDF_isGrammarVariables(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Productions), 2), 1);
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Productions), 4), 1);
  }
  else if (SDF_isGrammarSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Productions), 2), 1);
  }

  ATabort("Grammar has no Productions: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-context-free of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-context-free
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterContextFree new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterContextFree at the right place, or a core dump if #arg did not have a wsAfterContextFree
 */
SDF_Grammar SDF_setGrammarWsAfterContextFree(SDF_Grammar arg, SDF_OptLayout wsAfterContextFree) {
  if (SDF_isGrammarContextFreeSyntax(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterContextFree), 1), 1);
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterContextFree), 1), 1);
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterContextFree), 1), 1);
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterContextFree), 1), 1);
  }

  ATabort("Grammar has no WsAfterContextFree: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-variables of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-variables
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterVariables new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterVariables at the right place, or a core dump if #arg did not have a wsAfterVariables
 */
SDF_Grammar SDF_setGrammarWsAfterVariables(SDF_Grammar arg, SDF_OptLayout wsAfterVariables) {
  if (SDF_isGrammarVariables(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterVariables), 1), 1);
  }
  else if (SDF_isGrammarLexicalVariables(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterVariables), 3), 1);
  }

  ATabort("Grammar has no WsAfterVariables: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the left of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a left
 * \param[in] arg input SDF_Grammar
 * \param[in] left new SDF_Grammar to set in #arg
 * \return A new SDF_Grammar with left at the right place, or a core dump if #arg did not have a left
 */
SDF_Grammar SDF_setGrammarLeft(SDF_Grammar arg, SDF_Grammar left) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }

  ATabort("Grammar has no Left: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-left of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-left
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterLeft new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterLeft at the right place, or a core dump if #arg did not have a wsAfterLeft
 */
SDF_Grammar SDF_setGrammarWsAfterLeft(SDF_Grammar arg, SDF_OptLayout wsAfterLeft) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }

  ATabort("Grammar has no WsAfterLeft: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the right of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a right
 * \param[in] arg input SDF_Grammar
 * \param[in] right new SDF_Grammar to set in #arg
 * \return A new SDF_Grammar with right at the right place, or a core dump if #arg did not have a right
 */
SDF_Grammar SDF_setGrammarRight(SDF_Grammar arg, SDF_Grammar right) {
  if (SDF_isGrammarConcGrammars(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 2), 1);
  }

  ATabort("Grammar has no Right: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-( of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-(
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterParenOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterParenOpen at the right place, or a core dump if #arg did not have a wsAfterParenOpen
 */
SDF_Grammar SDF_setGrammarWsAfterParenOpen(SDF_Grammar arg, SDF_OptLayout wsAfterParenOpen) {
  if (SDF_isGrammarBracket(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }

  ATabort("Grammar has no WsAfterParenOpen: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Grammar of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Grammar
 * \param[in] arg input SDF_Grammar
 * \param[in] Grammar new SDF_Grammar to set in #arg
 * \return A new SDF_Grammar with Grammar at the right place, or a core dump if #arg did not have a Grammar
 */
SDF_Grammar SDF_setGrammarGrammar(SDF_Grammar arg, SDF_Grammar Grammar) {
  if (SDF_isGrammarBracket(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Grammar), 2), 1);
  }

  ATabort("Grammar has no Grammar: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-Grammar of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-Grammar
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterGrammar new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterGrammar at the right place, or a core dump if #arg did not have a wsAfterGrammar
 */
SDF_Grammar SDF_setGrammarWsAfterGrammar(SDF_Grammar arg, SDF_OptLayout wsAfterGrammar) {
  if (SDF_isGrammarBracket(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterGrammar), 3), 1);
  }

  ATabort("Grammar has no WsAfterGrammar: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ImpSection of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ImpSection
 * \param[in] arg input SDF_Grammar
 * \param[in] ImpSection new SDF_ImpSection to set in #arg
 * \return A new SDF_Grammar with ImpSection at the right place, or a core dump if #arg did not have a ImpSection
 */
SDF_Grammar SDF_setGrammarImpSection(SDF_Grammar arg, SDF_ImpSection ImpSection) {
  if (SDF_isGrammarImpSection(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) ImpSection), 0), 1);
  }

  ATabort("Grammar has no ImpSection: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-priorities of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-priorities
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterPriorities new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterPriorities at the right place, or a core dump if #arg did not have a wsAfterPriorities
 */
SDF_Grammar SDF_setGrammarWsAfterPriorities(SDF_Grammar arg, SDF_OptLayout wsAfterPriorities) {
  if (SDF_isGrammarPriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterPriorities), 1), 1);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterPriorities), 3), 1);
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterPriorities), 3), 1);
  }

  ATabort("Grammar has no WsAfterPriorities: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Priorities of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Priorities
 * \param[in] arg input SDF_Grammar
 * \param[in] Priorities new SDF_Priorities to set in #arg
 * \return A new SDF_Grammar with Priorities at the right place, or a core dump if #arg did not have a Priorities
 */
SDF_Grammar SDF_setGrammarPriorities(SDF_Grammar arg, SDF_Priorities Priorities) {
  if (SDF_isGrammarPriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Priorities), 2), 1);
  }
  else if (SDF_isGrammarLexicalPriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Priorities), 4), 1);
  }
  else if (SDF_isGrammarContextFreePriorities(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Priorities), 4), 1);
  }

  ATabort("Grammar has no Priorities: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-restrictions of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-restrictions
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterRestrictions new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterRestrictions at the right place, or a core dump if #arg did not have a wsAfterRestrictions
 */
SDF_Grammar SDF_setGrammarWsAfterRestrictions(SDF_Grammar arg, SDF_OptLayout wsAfterRestrictions) {
  if (SDF_isGrammarRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterRestrictions), 1), 1);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterRestrictions), 3), 1);
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterRestrictions), 3), 1);
  }

  ATabort("Grammar has no WsAfterRestrictions: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Restrictions of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Restrictions
 * \param[in] arg input SDF_Grammar
 * \param[in] Restrictions new SDF_Restrictions to set in #arg
 * \return A new SDF_Grammar with Restrictions at the right place, or a core dump if #arg did not have a Restrictions
 */
SDF_Grammar SDF_setGrammarRestrictions(SDF_Grammar arg, SDF_Restrictions Restrictions) {
  if (SDF_isGrammarRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Restrictions), 2), 1);
  }
  else if (SDF_isGrammarLexicalRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Restrictions), 4), 1);
  }
  else if (SDF_isGrammarContextFreeRestrictions(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Restrictions), 4), 1);
  }

  ATabort("Grammar has no Restrictions: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-sorts of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-sorts
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterSorts new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterSorts at the right place, or a core dump if #arg did not have a wsAfterSorts
 */
SDF_Grammar SDF_setGrammarWsAfterSorts(SDF_Grammar arg, SDF_OptLayout wsAfterSorts) {
  if (SDF_isGrammarSorts(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSorts), 1), 1);
  }

  ATabort("Grammar has no WsAfterSorts: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the Symbols of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a Symbols
 * \param[in] arg input SDF_Grammar
 * \param[in] Symbols new SDF_Symbols to set in #arg
 * \return A new SDF_Grammar with Symbols at the right place, or a core dump if #arg did not have a Symbols
 */
SDF_Grammar SDF_setGrammarSymbols(SDF_Grammar arg, SDF_Symbols Symbols) {
  if (SDF_isGrammarSorts(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbols), 2), 1);
  }
  else if (SDF_isGrammarKernelStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbols), 2), 1);
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbols), 4), 1);
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbols), 4), 1);
  }

  ATabort("Grammar has no Symbols: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Set the ws-after-start-symbols of a SDF_Grammar. The precondition being that this SDF_Grammar actually has a ws-after-start-symbols
 * \param[in] arg input SDF_Grammar
 * \param[in] wsAfterStartSymbols new SDF_OptLayout to set in #arg
 * \return A new SDF_Grammar with wsAfterStartSymbols at the right place, or a core dump if #arg did not have a wsAfterStartSymbols
 */
SDF_Grammar SDF_setGrammarWsAfterStartSymbols(SDF_Grammar arg, SDF_OptLayout wsAfterStartSymbols) {
  if (SDF_isGrammarKernelStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterStartSymbols), 1), 1);
  }
  else if (SDF_isGrammarLexicalStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterStartSymbols), 3), 1);
  }
  else if (SDF_isGrammarContextFreeStartSymbols(arg)) {
    return (SDF_Grammar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterStartSymbols), 3), 1);
  }

  ATabort("Grammar has no WsAfterStartSymbols: %t\n", arg);
  return (SDF_Grammar)NULL;
}

/**
 * Assert whether a SDF_Alias is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Alias
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidAlias(SDF_Alias arg) {
  if (SDF_isAliasAlias(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Alias is a alias. Always returns ATtrue
 * \param[in] arg input SDF_Alias
 * \return ATtrue if #arg corresponds to the signature of a alias, or ATfalse otherwise
 */
inline ATbool SDF_isAliasAlias(SDF_Alias arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternAliasAlias, NULL, NULL, NULL, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_Alias has a Symbol. 
 * \param[in] arg input SDF_Alias
 * \return ATtrue if the SDF_Alias had a Symbol, or ATfalse otherwise
 */
ATbool SDF_hasAliasSymbol(SDF_Alias arg) {
  if (SDF_isAliasAlias(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Alias has a ws-after-Symbol. 
 * \param[in] arg input SDF_Alias
 * \return ATtrue if the SDF_Alias had a ws-after-Symbol, or ATfalse otherwise
 */
ATbool SDF_hasAliasWsAfterSymbol(SDF_Alias arg) {
  if (SDF_isAliasAlias(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Alias has a ws-after-arrow. 
 * \param[in] arg input SDF_Alias
 * \return ATtrue if the SDF_Alias had a ws-after-arrow, or ATfalse otherwise
 */
ATbool SDF_hasAliasWsAfterArrow(SDF_Alias arg) {
  if (SDF_isAliasAlias(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Alias has a alias. 
 * \param[in] arg input SDF_Alias
 * \return ATtrue if the SDF_Alias had a alias, or ATfalse otherwise
 */
ATbool SDF_hasAliasAlias(SDF_Alias arg) {
  if (SDF_isAliasAlias(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the Symbol SDF_Symbol of a SDF_Alias. Note that the precondition is that this SDF_Alias actually has a Symbol
 * \param[in] arg input SDF_Alias
 * \return the Symbol of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getAliasSymbol(SDF_Alias arg) {
  
    return (SDF_Symbol)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-Symbol SDF_OptLayout of a SDF_Alias. Note that the precondition is that this SDF_Alias actually has a ws-after-Symbol
 * \param[in] arg input SDF_Alias
 * \return the ws-after-Symbol of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getAliasWsAfterSymbol(SDF_Alias arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-arrow SDF_OptLayout of a SDF_Alias. Note that the precondition is that this SDF_Alias actually has a ws-after-arrow
 * \param[in] arg input SDF_Alias
 * \return the ws-after-arrow of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getAliasWsAfterArrow(SDF_Alias arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the alias SDF_Symbol of a SDF_Alias. Note that the precondition is that this SDF_Alias actually has a alias
 * \param[in] arg input SDF_Alias
 * \return the alias of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getAliasAlias(SDF_Alias arg) {
  
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Set the Symbol of a SDF_Alias. The precondition being that this SDF_Alias actually has a Symbol
 * \param[in] arg input SDF_Alias
 * \param[in] Symbol new SDF_Symbol to set in #arg
 * \return A new SDF_Alias with Symbol at the right place, or a core dump if #arg did not have a Symbol
 */
SDF_Alias SDF_setAliasSymbol(SDF_Alias arg, SDF_Symbol Symbol) {
  if (SDF_isAliasAlias(arg)) {
    return (SDF_Alias)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 0), 1);
  }

  ATabort("Alias has no Symbol: %t\n", arg);
  return (SDF_Alias)NULL;
}

/**
 * Set the ws-after-Symbol of a SDF_Alias. The precondition being that this SDF_Alias actually has a ws-after-Symbol
 * \param[in] arg input SDF_Alias
 * \param[in] wsAfterSymbol new SDF_OptLayout to set in #arg
 * \return A new SDF_Alias with wsAfterSymbol at the right place, or a core dump if #arg did not have a wsAfterSymbol
 */
SDF_Alias SDF_setAliasWsAfterSymbol(SDF_Alias arg, SDF_OptLayout wsAfterSymbol) {
  if (SDF_isAliasAlias(arg)) {
    return (SDF_Alias)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 1), 1);
  }

  ATabort("Alias has no WsAfterSymbol: %t\n", arg);
  return (SDF_Alias)NULL;
}

/**
 * Set the ws-after-arrow of a SDF_Alias. The precondition being that this SDF_Alias actually has a ws-after-arrow
 * \param[in] arg input SDF_Alias
 * \param[in] wsAfterArrow new SDF_OptLayout to set in #arg
 * \return A new SDF_Alias with wsAfterArrow at the right place, or a core dump if #arg did not have a wsAfterArrow
 */
SDF_Alias SDF_setAliasWsAfterArrow(SDF_Alias arg, SDF_OptLayout wsAfterArrow) {
  if (SDF_isAliasAlias(arg)) {
    return (SDF_Alias)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterArrow), 3), 1);
  }

  ATabort("Alias has no WsAfterArrow: %t\n", arg);
  return (SDF_Alias)NULL;
}

/**
 * Set the alias of a SDF_Alias. The precondition being that this SDF_Alias actually has a alias
 * \param[in] arg input SDF_Alias
 * \param[in] alias new SDF_Symbol to set in #arg
 * \return A new SDF_Alias with alias at the right place, or a core dump if #arg did not have a alias
 */
SDF_Alias SDF_setAliasAlias(SDF_Alias arg, SDF_Symbol alias) {
  if (SDF_isAliasAlias(arg)) {
    return (SDF_Alias)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) alias), 4), 1);
  }

  ATabort("Alias has no Alias: %t\n", arg);
  return (SDF_Alias)NULL;
}

/**
 * Assert whether a SDF_Aliases is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Aliases
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidAliases(SDF_Aliases arg) {
  if (SDF_isAliasesDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Aliases is a Default. Always returns ATtrue
 * \param[in] arg input SDF_Aliases
 * \return ATtrue if #arg corresponds to the signature of a Default, or ATfalse otherwise
 */
inline ATbool SDF_isAliasesDefault(SDF_Aliases arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternAliasesDefault, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_Aliases has a list. 
 * \param[in] arg input SDF_Aliases
 * \return ATtrue if the SDF_Aliases had a list, or ATfalse otherwise
 */
ATbool SDF_hasAliasesList(SDF_Aliases arg) {
  if (SDF_isAliasesDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the list SDF_AliasList of a SDF_Aliases. Note that the precondition is that this SDF_Aliases actually has a list
 * \param[in] arg input SDF_Aliases
 * \return the list of #arg, if it exist or an undefined value if it does not
 */
SDF_AliasList SDF_getAliasesList(SDF_Aliases arg) {
  
    return (SDF_AliasList)ATgetArgument((ATermAppl)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1)), 1);
}

/**
 * Set the list of a SDF_Aliases. The precondition being that this SDF_Aliases actually has a list
 * \param[in] arg input SDF_Aliases
 * \param[in] list new SDF_AliasList to set in #arg
 * \return A new SDF_Aliases with list at the right place, or a core dump if #arg did not have a list
 */
SDF_Aliases SDF_setAliasesList(SDF_Aliases arg, SDF_AliasList list) {
  if (SDF_isAliasesDefault(arg)) {
    return (SDF_Aliases)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1)), (ATerm)((ATerm) list), 1), 0), 1);
  }

  ATabort("Aliases has no List: %t\n", arg);
  return (SDF_Aliases)NULL;
}

/**
 * Assert whether a SDF_AliasList is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidAliasList(SDF_AliasList arg) {
  if (SDF_isAliasListEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isAliasListSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isAliasListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_AliasList is a empty. . May not be used to assert correctness of the SDF_AliasList
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isAliasListEmpty(SDF_AliasList arg) {
  if (!ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternAliasListEmpty));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_AliasList is a single. . May not be used to assert correctness of the SDF_AliasList
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if #arg corresponds to the signature of a single, or ATfalse otherwise
 */
inline ATbool SDF_isAliasListSingle(SDF_AliasList arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternAliasListSingle, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_AliasList is a many. . May not be used to assert correctness of the SDF_AliasList
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if #arg corresponds to the signature of a many, or ATfalse otherwise
 */
inline ATbool SDF_isAliasListMany(SDF_AliasList arg) {
  if (ATisEmpty((ATermList)arg)) {
    return ATfalse;
  }
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternAliasListMany, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_AliasList has a head. 
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if the SDF_AliasList had a head, or ATfalse otherwise
 */
ATbool SDF_hasAliasListHead(SDF_AliasList arg) {
  if (SDF_isAliasListSingle(arg)) {
    return ATtrue;
  }
  else if (SDF_isAliasListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_AliasList has a ws-after-head. 
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if the SDF_AliasList had a ws-after-head, or ATfalse otherwise
 */
ATbool SDF_hasAliasListWsAfterHead(SDF_AliasList arg) {
  if (SDF_isAliasListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_AliasList has a tail. 
 * \param[in] arg input SDF_AliasList
 * \return ATtrue if the SDF_AliasList had a tail, or ATfalse otherwise
 */
ATbool SDF_hasAliasListTail(SDF_AliasList arg) {
  if (SDF_isAliasListMany(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Returns a list of all but the first element of a SDF_AliasList. 
 * \param[in] arg input SDF_AliasList
 * \return A new SDF_AliasList, without the first element and the separator(s) just after it.)
 */
SDF_AliasList SDF_getAliasListTail(SDF_AliasList arg) {
  assert(!SDF_isAliasListEmpty(arg) && "getTail on an empty list");
  if (SDF_isAliasListSingle(arg)) {
    return (SDF_AliasList) SDF_makeAliasListEmpty();
  }
  else {
  
    return (SDF_AliasList)ATgetTail((ATermList)arg, 2);
  }
}

/**
 * Get the head SDF_Alias of a SDF_AliasList. Note that the precondition is that this SDF_AliasList actually has a head
 * \param[in] arg input SDF_AliasList
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_Alias SDF_getAliasListHead(SDF_AliasList arg) {
  if (SDF_isAliasListSingle(arg)) {
    return (SDF_Alias)ATgetFirst((ATermList)arg);
  }
  else 
    return (SDF_Alias)ATgetFirst((ATermList)arg);
}

/**
 * Get the ws-after-head SDF_OptLayout of a SDF_AliasList. Note that the precondition is that this SDF_AliasList actually has a ws-after-head
 * \param[in] arg input SDF_AliasList
 * \return the ws-after-head of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getAliasListWsAfterHead(SDF_AliasList arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)arg, 1);
}

/**
 * Set the head of a SDF_AliasList. The precondition being that this SDF_AliasList actually has a head
 * \param[in] arg input SDF_AliasList
 * \param[in] head new SDF_Alias to set in #arg
 * \return A new SDF_AliasList with head at the right place, or a core dump if #arg did not have a head
 */
SDF_AliasList SDF_setAliasListHead(SDF_AliasList arg, SDF_Alias head) {
  if (SDF_isAliasListSingle(arg)) {
    return (SDF_AliasList)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }
  else if (SDF_isAliasListMany(arg)) {
    return (SDF_AliasList)ATreplace((ATermList)arg, (ATerm)((ATerm) head), 0);
  }

  ATabort("AliasList has no Head: %t\n", arg);
  return (SDF_AliasList)NULL;
}

/**
 * Set the ws-after-head of a SDF_AliasList. The precondition being that this SDF_AliasList actually has a ws-after-head
 * \param[in] arg input SDF_AliasList
 * \param[in] wsAfterHead new SDF_OptLayout to set in #arg
 * \return A new SDF_AliasList with wsAfterHead at the right place, or a core dump if #arg did not have a wsAfterHead
 */
SDF_AliasList SDF_setAliasListWsAfterHead(SDF_AliasList arg, SDF_OptLayout wsAfterHead) {
  if (SDF_isAliasListMany(arg)) {
    return (SDF_AliasList)ATreplace((ATermList)arg, (ATerm)((ATerm) wsAfterHead), 1);
  }

  ATabort("AliasList has no WsAfterHead: %t\n", arg);
  return (SDF_AliasList)NULL;
}

/**
 * Set the tail of a SDF_AliasList. The precondition being that this SDF_AliasList actually has a tail
 * \param[in] arg input SDF_AliasList
 * \param[in] tail new SDF_AliasList to set in #arg
 * \return A new SDF_AliasList with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_AliasList SDF_setAliasListTail(SDF_AliasList arg, SDF_AliasList tail) {
  if (SDF_isAliasListMany(arg)) {
    return (SDF_AliasList)ATreplaceTail((ATermList)arg, (ATermList)((ATerm) tail), 2);
  }

  ATabort("AliasList has no Tail: %t\n", arg);
  return (SDF_AliasList)NULL;
}

/**
 * Assert whether a SDF_Symbol is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidSymbol(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLex(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLayout(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolCharClass(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLabel(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLifting(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLit(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolCiLit(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolOpt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIter(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolAlt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStart(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolFileStart(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolSort(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol is a cf. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a cf, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolCf(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolCf, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a lex. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a lex, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolLex(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolLex, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a varsym. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a varsym, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolVarsym(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolVarsym, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a layout. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a layout, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolLayout(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolLayout);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a char-class. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a char-class, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolCharClass(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolCharClass, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a label. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a label, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolLabel(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolLabel, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a lifting. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a lifting, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolLifting(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolLifting, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a lit. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a lit, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolLit(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolLit, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a ci-lit. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a ci-lit, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolCiLit(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolCiLit, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a empty. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a empty, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolEmpty(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolEmpty, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a seq. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a seq, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolSeq(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolSeq, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a opt. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a opt, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolOpt(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolOpt, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a iter. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a iter, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolIter(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolIter, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a iter-star. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a iter-star, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolIterStar(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolIterStar, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a iter-sep. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a iter-sep, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolIterSep(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolIterSep, NULL, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a iter-star-sep. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a iter-star-sep, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolIterStarSep(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolIterStarSep, NULL, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a tuple. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a tuple, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolTuple(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolTuple, NULL, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a func. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a func, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolFunc(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolFunc, NULL, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a alt. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a alt, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolAlt(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolAlt, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a strategy. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a strategy, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolStrategy(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolStrategy, NULL, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a start. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a start, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolStart(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolStart);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a file-start. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a file-start, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolFileStart(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolFileStart);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a sort. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a sort, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolSort(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolSort, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a parameterized-sort. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a parameterized-sort, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolParameterizedSort(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolParameterizedSort, NULL, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol is a Bracket. . May not be used to assert correctness of the SDF_Symbol
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if #arg corresponds to the signature of a Bracket, or ATfalse otherwise
 */
inline ATbool SDF_isSymbolBracket(SDF_Symbol arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternSymbolBracket, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_Symbol has a ws-after-<. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-<, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterLessThan(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLex(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a Symbol. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a Symbol, or ATfalse otherwise
 */
ATbool SDF_hasSymbolSymbol(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLex(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLabel(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLifting(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolOpt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIter(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-Symbol. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-Symbol, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterSymbol(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLex(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolLifting(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolOpt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIter(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after--CF. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after--CF, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterCF(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after--LEX. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after--LEX, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterLEX(SDF_Symbol arg) {
  if (SDF_isSymbolLex(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after--VAR. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after--VAR, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterVAR(SDF_Symbol arg) {
  if (SDF_isSymbolVarsym(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a CharClass. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a CharClass, or ATfalse otherwise
 */
ATbool SDF_hasSymbolCharClass(SDF_Symbol arg) {
  if (SDF_isSymbolCharClass(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a Label. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a Label, or ATfalse otherwise
 */
ATbool SDF_hasSymbolLabel(SDF_Symbol arg) {
  if (SDF_isSymbolLabel(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-Label. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-Label, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterLabel(SDF_Symbol arg) {
  if (SDF_isSymbolLabel(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-:. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-:, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterColon(SDF_Symbol arg) {
  if (SDF_isSymbolLabel(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-left-quote. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-left-quote, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterLeftQuote(SDF_Symbol arg) {
  if (SDF_isSymbolLifting(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a string. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a string, or ATfalse otherwise
 */
ATbool SDF_hasSymbolString(SDF_Symbol arg) {
  if (SDF_isSymbolLit(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ci-string. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ci-string, or ATfalse otherwise
 */
ATbool SDF_hasSymbolCiString(SDF_Symbol arg) {
  if (SDF_isSymbolCiLit(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-(. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-(, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterParenOpen(SDF_Symbol arg) {
  if (SDF_isSymbolEmpty(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a head. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a head, or ATfalse otherwise
 */
ATbool SDF_hasSymbolHead(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-head. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-head, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterHead(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a tail. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a tail, or ATfalse otherwise
 */
ATbool SDF_hasSymbolTail(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-tail. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-tail, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterTail(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-{. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-{, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterBraceOpen(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a sep. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a sep, or ATfalse otherwise
 */
ATbool SDF_hasSymbolSep(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-sep. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-sep, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterSep(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-}. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-}, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterBraceClose(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-,. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-,, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterComma(SDF_Symbol arg) {
  if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a rest. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a rest, or ATfalse otherwise
 */
ATbool SDF_hasSymbolRest(SDF_Symbol arg) {
  if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-rest. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-rest, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterRest(SDF_Symbol arg) {
  if (SDF_isSymbolTuple(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a arguments. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a arguments, or ATfalse otherwise
 */
ATbool SDF_hasSymbolArguments(SDF_Symbol arg) {
  if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-arguments. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-arguments, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterArguments(SDF_Symbol arg) {
  if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-=>. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-=>, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterEqualsGreaterThan(SDF_Symbol arg) {
  if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a results. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a results, or ATfalse otherwise
 */
ATbool SDF_hasSymbolResults(SDF_Symbol arg) {
  if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-results. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-results, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterResults(SDF_Symbol arg) {
  if (SDF_isSymbolFunc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a left. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a left, or ATfalse otherwise
 */
ATbool SDF_hasSymbolLeft(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-left. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-left, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterLeft(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-|. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-|, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterBar(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a right. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a right, or ATfalse otherwise
 */
ATbool SDF_hasSymbolRight(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-->. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-->, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterGreaterThan(SDF_Symbol arg) {
  if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-right. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-right, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterRight(SDF_Symbol arg) {
  if (SDF_isSymbolStrategy(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a Sort. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a Sort, or ATfalse otherwise
 */
ATbool SDF_hasSymbolSort(SDF_Symbol arg) {
  if (SDF_isSymbolSort(arg)) {
    return ATtrue;
  }
  else if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-Sort. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-Sort, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterSort(SDF_Symbol arg) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-[[. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-[[, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterBracketOpenBracketOpen(SDF_Symbol arg) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a parameters. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a parameters, or ATfalse otherwise
 */
ATbool SDF_hasSymbolParameters(SDF_Symbol arg) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_Symbol has a ws-after-parameters. 
 * \param[in] arg input SDF_Symbol
 * \return ATtrue if the SDF_Symbol had a ws-after-parameters, or ATfalse otherwise
 */
ATbool SDF_hasSymbolWsAfterParameters(SDF_Symbol arg) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-after-< SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-<
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-< of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterLessThan(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the Symbol SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a Symbol
 * \param[in] arg input SDF_Symbol
 * \return the Symbol of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolSymbol(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isSymbolLabel(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else if (SDF_isSymbolLifting(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isSymbolOpt(arg)) {
    return (SDF_Symbol)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isSymbolIter(arg)) {
    return (SDF_Symbol)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return (SDF_Symbol)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else 
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-Symbol SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-Symbol
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-Symbol of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterSymbol(SDF_Symbol arg) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isSymbolLifting(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isSymbolOpt(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolIter(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after--CF SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after--CF
 * \param[in] arg input SDF_Symbol
 * \return the ws-after--CF of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterCF(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after--LEX SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after--LEX
 * \param[in] arg input SDF_Symbol
 * \return the ws-after--LEX of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterLEX(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after--VAR SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after--VAR
 * \param[in] arg input SDF_Symbol
 * \return the ws-after--VAR of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterVAR(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the CharClass SDF_CharClass of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a CharClass
 * \param[in] arg input SDF_Symbol
 * \return the CharClass of #arg, if it exist or an undefined value if it does not
 */
SDF_CharClass SDF_getSymbolCharClass(SDF_Symbol arg) {
  
    return (SDF_CharClass)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the Label SDF_Label of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a Label
 * \param[in] arg input SDF_Symbol
 * \return the Label of #arg, if it exist or an undefined value if it does not
 */
SDF_Label SDF_getSymbolLabel(SDF_Symbol arg) {
  
    return (SDF_Label)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-Label SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-Label
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-Label of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterLabel(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-: SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-:
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-: of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterColon(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-left-quote SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-left-quote
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-left-quote of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterLeftQuote(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the string SDF_StrCon of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a string
 * \param[in] arg input SDF_Symbol
 * \return the string of #arg, if it exist or an undefined value if it does not
 */
SDF_StrCon SDF_getSymbolString(SDF_Symbol arg) {
  
    return (SDF_StrCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ci-string SDF_SingleQuotedStrCon of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ci-string
 * \param[in] arg input SDF_Symbol
 * \return the ci-string of #arg, if it exist or an undefined value if it does not
 */
SDF_SingleQuotedStrCon SDF_getSymbolCiString(SDF_Symbol arg) {
  
    return (SDF_SingleQuotedStrCon)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-( SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-(
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-( of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterParenOpen(SDF_Symbol arg) {
  if (SDF_isSymbolEmpty(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolSeq(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolFunc(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the head SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a head
 * \param[in] arg input SDF_Symbol
 * \return the head of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolHead(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else 
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-head SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-head
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-head of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterHead(SDF_Symbol arg) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the tail SDF_SymbolTail of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a tail
 * \param[in] arg input SDF_Symbol
 * \return the tail of #arg, if it exist or an undefined value if it does not
 */
SDF_SymbolTail SDF_getSymbolTail(SDF_Symbol arg) {
  
    return (SDF_SymbolTail)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), 1);
}

/**
 * Get the ws-after-tail SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-tail
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-tail of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterTail(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after-{ SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-{
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-{ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterBraceOpen(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the sep SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a sep
 * \param[in] arg input SDF_Symbol
 * \return the sep of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolSep(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-sep SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-sep
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-sep of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterSep(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after-} SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-}
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-} of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterBraceClose(SDF_Symbol arg) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 7);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 7);
}

/**
 * Get the ws-after-, SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-,
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-, of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterComma(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the rest SDF_SymbolRest of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a rest
 * \param[in] arg input SDF_Symbol
 * \return the rest of #arg, if it exist or an undefined value if it does not
 */
SDF_SymbolRest SDF_getSymbolRest(SDF_Symbol arg) {
  
    return (SDF_SymbolRest)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 6), 1);
}

/**
 * Get the ws-after-rest SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-rest
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-rest of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterRest(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 7);
}

/**
 * Get the arguments SDF_Symbols of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a arguments
 * \param[in] arg input SDF_Symbol
 * \return the arguments of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbols SDF_getSymbolArguments(SDF_Symbol arg) {
  
    return (SDF_Symbols)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-arguments SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-arguments
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-arguments of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterArguments(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-=> SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-=>
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-=> of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterEqualsGreaterThan(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the results SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a results
 * \param[in] arg input SDF_Symbol
 * \return the results of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolResults(SDF_Symbol arg) {
  
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 6);
}

/**
 * Get the ws-after-results SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-results
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-results of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterResults(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 7);
}

/**
 * Get the left SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a left
 * \param[in] arg input SDF_Symbol
 * \return the left of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolLeft(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else 
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-left SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-left
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-left of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterLeft(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-| SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-|
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-| of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterBar(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the right SDF_Symbol of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a right
 * \param[in] arg input SDF_Symbol
 * \return the right of #arg, if it exist or an undefined value if it does not
 */
SDF_Symbol SDF_getSymbolRight(SDF_Symbol arg) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_Symbol)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 6);
}

/**
 * Get the ws-after--> SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-->
 * \param[in] arg input SDF_Symbol
 * \return the ws-after--> of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterGreaterThan(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Get the ws-after-right SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-right
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-right of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterRight(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 7);
}

/**
 * Get the Sort SDF_Sort of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a Sort
 * \param[in] arg input SDF_Symbol
 * \return the Sort of #arg, if it exist or an undefined value if it does not
 */
SDF_Sort SDF_getSymbolSort(SDF_Symbol arg) {
  if (SDF_isSymbolSort(arg)) {
    return (SDF_Sort)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else 
    return (SDF_Sort)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-Sort SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-Sort
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-Sort of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterSort(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-[[ SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-[[
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-[[ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterBracketOpenBracketOpen(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the parameters SDF_SymbolParameters of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a parameters
 * \param[in] arg input SDF_Symbol
 * \return the parameters of #arg, if it exist or an undefined value if it does not
 */
SDF_SymbolParameters SDF_getSymbolParameters(SDF_Symbol arg) {
  
    return (SDF_SymbolParameters)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), 1);
}

/**
 * Get the ws-after-parameters SDF_OptLayout of a SDF_Symbol. Note that the precondition is that this SDF_Symbol actually has a ws-after-parameters
 * \param[in] arg input SDF_Symbol
 * \return the ws-after-parameters of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getSymbolWsAfterParameters(SDF_Symbol arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 5);
}

/**
 * Set the ws-after-< of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-<
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterLessThan new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterLessThan at the right place, or a core dump if #arg did not have a wsAfterLessThan
 */
SDF_Symbol SDF_setSymbolWsAfterLessThan(SDF_Symbol arg, SDF_OptLayout wsAfterLessThan) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLessThan), 1), 1);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLessThan), 1), 1);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLessThan), 1), 1);
  }
  else if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLessThan), 1), 1);
  }

  ATabort("Symbol has no WsAfterLessThan: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the Symbol of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a Symbol
 * \param[in] arg input SDF_Symbol
 * \param[in] Symbol new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with Symbol at the right place, or a core dump if #arg did not have a Symbol
 */
SDF_Symbol SDF_setSymbolSymbol(SDF_Symbol arg, SDF_Symbol Symbol) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolLabel(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 4), 1);
  }
  else if (SDF_isSymbolLifting(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolOpt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 0), 1);
  }
  else if (SDF_isSymbolIter(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 0), 1);
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 0), 1);
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }
  else if (SDF_isSymbolBracket(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Symbol), 2), 1);
  }

  ATabort("Symbol has no Symbol: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-Symbol of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-Symbol
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterSymbol new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterSymbol at the right place, or a core dump if #arg did not have a wsAfterSymbol
 */
SDF_Symbol SDF_setSymbolWsAfterSymbol(SDF_Symbol arg, SDF_OptLayout wsAfterSymbol) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolLex(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolVarsym(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolLifting(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolOpt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 1), 1);
  }
  else if (SDF_isSymbolIter(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 1), 1);
  }
  else if (SDF_isSymbolIterStar(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 1), 1);
  }
  else if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }
  else if (SDF_isSymbolBracket(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSymbol), 3), 1);
  }

  ATabort("Symbol has no WsAfterSymbol: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after--CF of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after--CF
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterCF new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterCF at the right place, or a core dump if #arg did not have a wsAfterCF
 */
SDF_Symbol SDF_setSymbolWsAfterCF(SDF_Symbol arg, SDF_OptLayout wsAfterCF) {
  if (SDF_isSymbolCf(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterCF), 5), 1);
  }

  ATabort("Symbol has no WsAfterCF: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after--LEX of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after--LEX
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterLEX new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterLEX at the right place, or a core dump if #arg did not have a wsAfterLEX
 */
SDF_Symbol SDF_setSymbolWsAfterLEX(SDF_Symbol arg, SDF_OptLayout wsAfterLEX) {
  if (SDF_isSymbolLex(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLEX), 5), 1);
  }

  ATabort("Symbol has no WsAfterLEX: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after--VAR of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after--VAR
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterVAR new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterVAR at the right place, or a core dump if #arg did not have a wsAfterVAR
 */
SDF_Symbol SDF_setSymbolWsAfterVAR(SDF_Symbol arg, SDF_OptLayout wsAfterVAR) {
  if (SDF_isSymbolVarsym(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterVAR), 5), 1);
  }

  ATabort("Symbol has no WsAfterVAR: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the CharClass of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a CharClass
 * \param[in] arg input SDF_Symbol
 * \param[in] CharClass new SDF_CharClass to set in #arg
 * \return A new SDF_Symbol with CharClass at the right place, or a core dump if #arg did not have a CharClass
 */
SDF_Symbol SDF_setSymbolCharClass(SDF_Symbol arg, SDF_CharClass CharClass) {
  if (SDF_isSymbolCharClass(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharClass), 0), 1);
  }

  ATabort("Symbol has no CharClass: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the Label of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a Label
 * \param[in] arg input SDF_Symbol
 * \param[in] Label new SDF_Label to set in #arg
 * \return A new SDF_Symbol with Label at the right place, or a core dump if #arg did not have a Label
 */
SDF_Symbol SDF_setSymbolLabel(SDF_Symbol arg, SDF_Label Label) {
  if (SDF_isSymbolLabel(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Label), 0), 1);
  }

  ATabort("Symbol has no Label: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-Label of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-Label
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterLabel new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterLabel at the right place, or a core dump if #arg did not have a wsAfterLabel
 */
SDF_Symbol SDF_setSymbolWsAfterLabel(SDF_Symbol arg, SDF_OptLayout wsAfterLabel) {
  if (SDF_isSymbolLabel(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLabel), 1), 1);
  }

  ATabort("Symbol has no WsAfterLabel: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-: of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-:
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterColon new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterColon at the right place, or a core dump if #arg did not have a wsAfterColon
 */
SDF_Symbol SDF_setSymbolWsAfterColon(SDF_Symbol arg, SDF_OptLayout wsAfterColon) {
  if (SDF_isSymbolLabel(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterColon), 3), 1);
  }

  ATabort("Symbol has no WsAfterColon: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-left-quote of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-left-quote
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterLeftQuote new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterLeftQuote at the right place, or a core dump if #arg did not have a wsAfterLeftQuote
 */
SDF_Symbol SDF_setSymbolWsAfterLeftQuote(SDF_Symbol arg, SDF_OptLayout wsAfterLeftQuote) {
  if (SDF_isSymbolLifting(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeftQuote), 1), 1);
  }

  ATabort("Symbol has no WsAfterLeftQuote: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the string of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a string
 * \param[in] arg input SDF_Symbol
 * \param[in] string new SDF_StrCon to set in #arg
 * \return A new SDF_Symbol with string at the right place, or a core dump if #arg did not have a string
 */
SDF_Symbol SDF_setSymbolString(SDF_Symbol arg, SDF_StrCon string) {
  if (SDF_isSymbolLit(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) string), 0), 1);
  }

  ATabort("Symbol has no String: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ci-string of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ci-string
 * \param[in] arg input SDF_Symbol
 * \param[in] ciString new SDF_SingleQuotedStrCon to set in #arg
 * \return A new SDF_Symbol with ciString at the right place, or a core dump if #arg did not have a ciString
 */
SDF_Symbol SDF_setSymbolCiString(SDF_Symbol arg, SDF_SingleQuotedStrCon ciString) {
  if (SDF_isSymbolCiLit(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) ciString), 0), 1);
  }

  ATabort("Symbol has no CiString: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-( of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-(
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterParenOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterParenOpen at the right place, or a core dump if #arg did not have a wsAfterParenOpen
 */
SDF_Symbol SDF_setSymbolWsAfterParenOpen(SDF_Symbol arg, SDF_OptLayout wsAfterParenOpen) {
  if (SDF_isSymbolEmpty(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }
  else if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }
  else if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }
  else if (SDF_isSymbolBracket(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }

  ATabort("Symbol has no WsAfterParenOpen: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the head of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a head
 * \param[in] arg input SDF_Symbol
 * \param[in] head new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with head at the right place, or a core dump if #arg did not have a head
 */
SDF_Symbol SDF_setSymbolHead(SDF_Symbol arg, SDF_Symbol head) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) head), 2), 1);
  }
  else if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) head), 2), 1);
  }

  ATabort("Symbol has no Head: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-head of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-head
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterHead new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterHead at the right place, or a core dump if #arg did not have a wsAfterHead
 */
SDF_Symbol SDF_setSymbolWsAfterHead(SDF_Symbol arg, SDF_OptLayout wsAfterHead) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterHead), 3), 1);
  }
  else if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterHead), 3), 1);
  }

  ATabort("Symbol has no WsAfterHead: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the tail of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a tail
 * \param[in] arg input SDF_Symbol
 * \param[in] tail new SDF_SymbolTail to set in #arg
 * \return A new SDF_Symbol with tail at the right place, or a core dump if #arg did not have a tail
 */
SDF_Symbol SDF_setSymbolTail(SDF_Symbol arg, SDF_SymbolTail tail) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), (ATerm)((ATerm) tail), 1), 4), 1);
  }

  ATabort("Symbol has no Tail: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-tail of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-tail
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterTail new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterTail at the right place, or a core dump if #arg did not have a wsAfterTail
 */
SDF_Symbol SDF_setSymbolWsAfterTail(SDF_Symbol arg, SDF_OptLayout wsAfterTail) {
  if (SDF_isSymbolSeq(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterTail), 5), 1);
  }

  ATabort("Symbol has no WsAfterTail: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-{ of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-{
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterBraceOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterBraceOpen at the right place, or a core dump if #arg did not have a wsAfterBraceOpen
 */
SDF_Symbol SDF_setSymbolWsAfterBraceOpen(SDF_Symbol arg, SDF_OptLayout wsAfterBraceOpen) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBraceOpen), 1), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBraceOpen), 1), 1);
  }

  ATabort("Symbol has no WsAfterBraceOpen: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the sep of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a sep
 * \param[in] arg input SDF_Symbol
 * \param[in] sep new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with sep at the right place, or a core dump if #arg did not have a sep
 */
SDF_Symbol SDF_setSymbolSep(SDF_Symbol arg, SDF_Symbol sep) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) sep), 4), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) sep), 4), 1);
  }

  ATabort("Symbol has no Sep: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-sep of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-sep
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterSep new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterSep at the right place, or a core dump if #arg did not have a wsAfterSep
 */
SDF_Symbol SDF_setSymbolWsAfterSep(SDF_Symbol arg, SDF_OptLayout wsAfterSep) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSep), 5), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSep), 5), 1);
  }

  ATabort("Symbol has no WsAfterSep: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-} of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-}
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterBraceClose new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterBraceClose at the right place, or a core dump if #arg did not have a wsAfterBraceClose
 */
SDF_Symbol SDF_setSymbolWsAfterBraceClose(SDF_Symbol arg, SDF_OptLayout wsAfterBraceClose) {
  if (SDF_isSymbolIterSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBraceClose), 7), 1);
  }
  else if (SDF_isSymbolIterStarSep(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBraceClose), 7), 1);
  }

  ATabort("Symbol has no WsAfterBraceClose: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-, of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-,
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterComma new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterComma at the right place, or a core dump if #arg did not have a wsAfterComma
 */
SDF_Symbol SDF_setSymbolWsAfterComma(SDF_Symbol arg, SDF_OptLayout wsAfterComma) {
  if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterComma), 5), 1);
  }

  ATabort("Symbol has no WsAfterComma: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the rest of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a rest
 * \param[in] arg input SDF_Symbol
 * \param[in] rest new SDF_SymbolRest to set in #arg
 * \return A new SDF_Symbol with rest at the right place, or a core dump if #arg did not have a rest
 */
SDF_Symbol SDF_setSymbolRest(SDF_Symbol arg, SDF_SymbolRest rest) {
  if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 6), (ATerm)((ATerm) rest), 1), 6), 1);
  }

  ATabort("Symbol has no Rest: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-rest of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-rest
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterRest new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterRest at the right place, or a core dump if #arg did not have a wsAfterRest
 */
SDF_Symbol SDF_setSymbolWsAfterRest(SDF_Symbol arg, SDF_OptLayout wsAfterRest) {
  if (SDF_isSymbolTuple(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterRest), 7), 1);
  }

  ATabort("Symbol has no WsAfterRest: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the arguments of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a arguments
 * \param[in] arg input SDF_Symbol
 * \param[in] arguments new SDF_Symbols to set in #arg
 * \return A new SDF_Symbol with arguments at the right place, or a core dump if #arg did not have a arguments
 */
SDF_Symbol SDF_setSymbolArguments(SDF_Symbol arg, SDF_Symbols arguments) {
  if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) arguments), 2), 1);
  }

  ATabort("Symbol has no Arguments: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-arguments of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-arguments
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterArguments new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterArguments at the right place, or a core dump if #arg did not have a wsAfterArguments
 */
SDF_Symbol SDF_setSymbolWsAfterArguments(SDF_Symbol arg, SDF_OptLayout wsAfterArguments) {
  if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterArguments), 3), 1);
  }

  ATabort("Symbol has no WsAfterArguments: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-=> of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-=>
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterEqualsGreaterThan new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterEqualsGreaterThan at the right place, or a core dump if #arg did not have a wsAfterEqualsGreaterThan
 */
SDF_Symbol SDF_setSymbolWsAfterEqualsGreaterThan(SDF_Symbol arg, SDF_OptLayout wsAfterEqualsGreaterThan) {
  if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterEqualsGreaterThan), 5), 1);
  }

  ATabort("Symbol has no WsAfterEqualsGreaterThan: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the results of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a results
 * \param[in] arg input SDF_Symbol
 * \param[in] results new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with results at the right place, or a core dump if #arg did not have a results
 */
SDF_Symbol SDF_setSymbolResults(SDF_Symbol arg, SDF_Symbol results) {
  if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) results), 6), 1);
  }

  ATabort("Symbol has no Results: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-results of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-results
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterResults new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterResults at the right place, or a core dump if #arg did not have a wsAfterResults
 */
SDF_Symbol SDF_setSymbolWsAfterResults(SDF_Symbol arg, SDF_OptLayout wsAfterResults) {
  if (SDF_isSymbolFunc(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterResults), 7), 1);
  }

  ATabort("Symbol has no WsAfterResults: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the left of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a left
 * \param[in] arg input SDF_Symbol
 * \param[in] left new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with left at the right place, or a core dump if #arg did not have a left
 */
SDF_Symbol SDF_setSymbolLeft(SDF_Symbol arg, SDF_Symbol left) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 2), 1);
  }

  ATabort("Symbol has no Left: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-left of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-left
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterLeft new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterLeft at the right place, or a core dump if #arg did not have a wsAfterLeft
 */
SDF_Symbol SDF_setSymbolWsAfterLeft(SDF_Symbol arg, SDF_OptLayout wsAfterLeft) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 3), 1);
  }

  ATabort("Symbol has no WsAfterLeft: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-| of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-|
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterBar new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterBar at the right place, or a core dump if #arg did not have a wsAfterBar
 */
SDF_Symbol SDF_setSymbolWsAfterBar(SDF_Symbol arg, SDF_OptLayout wsAfterBar) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBar), 3), 1);
  }

  ATabort("Symbol has no WsAfterBar: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the right of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a right
 * \param[in] arg input SDF_Symbol
 * \param[in] right new SDF_Symbol to set in #arg
 * \return A new SDF_Symbol with right at the right place, or a core dump if #arg did not have a right
 */
SDF_Symbol SDF_setSymbolRight(SDF_Symbol arg, SDF_Symbol right) {
  if (SDF_isSymbolAlt(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 4), 1);
  }
  else if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 6), 1);
  }

  ATabort("Symbol has no Right: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after--> of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-->
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterGreaterThan new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterGreaterThan at the right place, or a core dump if #arg did not have a wsAfterGreaterThan
 */
SDF_Symbol SDF_setSymbolWsAfterGreaterThan(SDF_Symbol arg, SDF_OptLayout wsAfterGreaterThan) {
  if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterGreaterThan), 5), 1);
  }

  ATabort("Symbol has no WsAfterGreaterThan: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-right of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-right
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterRight new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterRight at the right place, or a core dump if #arg did not have a wsAfterRight
 */
SDF_Symbol SDF_setSymbolWsAfterRight(SDF_Symbol arg, SDF_OptLayout wsAfterRight) {
  if (SDF_isSymbolStrategy(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterRight), 7), 1);
  }

  ATabort("Symbol has no WsAfterRight: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the Sort of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a Sort
 * \param[in] arg input SDF_Symbol
 * \param[in] Sort new SDF_Sort to set in #arg
 * \return A new SDF_Symbol with Sort at the right place, or a core dump if #arg did not have a Sort
 */
SDF_Symbol SDF_setSymbolSort(SDF_Symbol arg, SDF_Sort Sort) {
  if (SDF_isSymbolSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Sort), 0), 1);
  }
  else if (SDF_isSymbolParameterizedSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Sort), 0), 1);
  }

  ATabort("Symbol has no Sort: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-Sort of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-Sort
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterSort new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterSort at the right place, or a core dump if #arg did not have a wsAfterSort
 */
SDF_Symbol SDF_setSymbolWsAfterSort(SDF_Symbol arg, SDF_OptLayout wsAfterSort) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSort), 1), 1);
  }

  ATabort("Symbol has no WsAfterSort: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-[[ of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-[[
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterBracketOpenBracketOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterBracketOpenBracketOpen at the right place, or a core dump if #arg did not have a wsAfterBracketOpenBracketOpen
 */
SDF_Symbol SDF_setSymbolWsAfterBracketOpenBracketOpen(SDF_Symbol arg, SDF_OptLayout wsAfterBracketOpenBracketOpen) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBracketOpenBracketOpen), 3), 1);
  }

  ATabort("Symbol has no WsAfterBracketOpenBracketOpen: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the parameters of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a parameters
 * \param[in] arg input SDF_Symbol
 * \param[in] parameters new SDF_SymbolParameters to set in #arg
 * \return A new SDF_Symbol with parameters at the right place, or a core dump if #arg did not have a parameters
 */
SDF_Symbol SDF_setSymbolParameters(SDF_Symbol arg, SDF_SymbolParameters parameters) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4), (ATerm)((ATerm) parameters), 1), 4), 1);
  }

  ATabort("Symbol has no Parameters: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Set the ws-after-parameters of a SDF_Symbol. The precondition being that this SDF_Symbol actually has a ws-after-parameters
 * \param[in] arg input SDF_Symbol
 * \param[in] wsAfterParameters new SDF_OptLayout to set in #arg
 * \return A new SDF_Symbol with wsAfterParameters at the right place, or a core dump if #arg did not have a wsAfterParameters
 */
SDF_Symbol SDF_setSymbolWsAfterParameters(SDF_Symbol arg, SDF_OptLayout wsAfterParameters) {
  if (SDF_isSymbolParameterizedSort(arg)) {
    return (SDF_Symbol)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParameters), 5), 1);
  }

  ATabort("Symbol has no WsAfterParameters: %t\n", arg);
  return (SDF_Symbol)NULL;
}

/**
 * Assert whether a SDF_CharRange is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidCharRange(SDF_CharRange arg) {
  if (SDF_isCharRangeDefault(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharRangeRange(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRange is a Default. . May not be used to assert correctness of the SDF_CharRange
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if #arg corresponds to the signature of a Default, or ATfalse otherwise
 */
inline ATbool SDF_isCharRangeDefault(SDF_CharRange arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharRangeDefault, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharRange is a range. . May not be used to assert correctness of the SDF_CharRange
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if #arg corresponds to the signature of a range, or ATfalse otherwise
 */
inline ATbool SDF_isCharRangeRange(SDF_CharRange arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharRangeRange, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharRange has a Character. 
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if the SDF_CharRange had a Character, or ATfalse otherwise
 */
ATbool SDF_hasCharRangeCharacter(SDF_CharRange arg) {
  if (SDF_isCharRangeDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRange has a start. 
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if the SDF_CharRange had a start, or ATfalse otherwise
 */
ATbool SDF_hasCharRangeStart(SDF_CharRange arg) {
  if (SDF_isCharRangeRange(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRange has a ws-after-start. 
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if the SDF_CharRange had a ws-after-start, or ATfalse otherwise
 */
ATbool SDF_hasCharRangeWsAfterStart(SDF_CharRange arg) {
  if (SDF_isCharRangeRange(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRange has a ws-after--. 
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if the SDF_CharRange had a ws-after--, or ATfalse otherwise
 */
ATbool SDF_hasCharRangeWsAfter(SDF_CharRange arg) {
  if (SDF_isCharRangeRange(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRange has a end. 
 * \param[in] arg input SDF_CharRange
 * \return ATtrue if the SDF_CharRange had a end, or ATfalse otherwise
 */
ATbool SDF_hasCharRangeEnd(SDF_CharRange arg) {
  if (SDF_isCharRangeRange(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the Character SDF_Character of a SDF_CharRange. Note that the precondition is that this SDF_CharRange actually has a Character
 * \param[in] arg input SDF_CharRange
 * \return the Character of #arg, if it exist or an undefined value if it does not
 */
SDF_Character SDF_getCharRangeCharacter(SDF_CharRange arg) {
  
    return (SDF_Character)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the start SDF_Character of a SDF_CharRange. Note that the precondition is that this SDF_CharRange actually has a start
 * \param[in] arg input SDF_CharRange
 * \return the start of #arg, if it exist or an undefined value if it does not
 */
SDF_Character SDF_getCharRangeStart(SDF_CharRange arg) {
  
    return (SDF_Character)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-start SDF_OptLayout of a SDF_CharRange. Note that the precondition is that this SDF_CharRange actually has a ws-after-start
 * \param[in] arg input SDF_CharRange
 * \return the ws-after-start of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharRangeWsAfterStart(SDF_CharRange arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-- SDF_OptLayout of a SDF_CharRange. Note that the precondition is that this SDF_CharRange actually has a ws-after--
 * \param[in] arg input SDF_CharRange
 * \return the ws-after-- of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharRangeWsAfter(SDF_CharRange arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the end SDF_Character of a SDF_CharRange. Note that the precondition is that this SDF_CharRange actually has a end
 * \param[in] arg input SDF_CharRange
 * \return the end of #arg, if it exist or an undefined value if it does not
 */
SDF_Character SDF_getCharRangeEnd(SDF_CharRange arg) {
  
    return (SDF_Character)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Set the Character of a SDF_CharRange. The precondition being that this SDF_CharRange actually has a Character
 * \param[in] arg input SDF_CharRange
 * \param[in] Character new SDF_Character to set in #arg
 * \return A new SDF_CharRange with Character at the right place, or a core dump if #arg did not have a Character
 */
SDF_CharRange SDF_setCharRangeCharacter(SDF_CharRange arg, SDF_Character Character) {
  if (SDF_isCharRangeDefault(arg)) {
    return (SDF_CharRange)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) Character), 0), 1);
  }

  ATabort("CharRange has no Character: %t\n", arg);
  return (SDF_CharRange)NULL;
}

/**
 * Set the start of a SDF_CharRange. The precondition being that this SDF_CharRange actually has a start
 * \param[in] arg input SDF_CharRange
 * \param[in] start new SDF_Character to set in #arg
 * \return A new SDF_CharRange with start at the right place, or a core dump if #arg did not have a start
 */
SDF_CharRange SDF_setCharRangeStart(SDF_CharRange arg, SDF_Character start) {
  if (SDF_isCharRangeRange(arg)) {
    return (SDF_CharRange)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) start), 0), 1);
  }

  ATabort("CharRange has no Start: %t\n", arg);
  return (SDF_CharRange)NULL;
}

/**
 * Set the ws-after-start of a SDF_CharRange. The precondition being that this SDF_CharRange actually has a ws-after-start
 * \param[in] arg input SDF_CharRange
 * \param[in] wsAfterStart new SDF_OptLayout to set in #arg
 * \return A new SDF_CharRange with wsAfterStart at the right place, or a core dump if #arg did not have a wsAfterStart
 */
SDF_CharRange SDF_setCharRangeWsAfterStart(SDF_CharRange arg, SDF_OptLayout wsAfterStart) {
  if (SDF_isCharRangeRange(arg)) {
    return (SDF_CharRange)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterStart), 1), 1);
  }

  ATabort("CharRange has no WsAfterStart: %t\n", arg);
  return (SDF_CharRange)NULL;
}

/**
 * Set the ws-after-- of a SDF_CharRange. The precondition being that this SDF_CharRange actually has a ws-after--
 * \param[in] arg input SDF_CharRange
 * \param[in] wsAfter new SDF_OptLayout to set in #arg
 * \return A new SDF_CharRange with wsAfter at the right place, or a core dump if #arg did not have a wsAfter
 */
SDF_CharRange SDF_setCharRangeWsAfter(SDF_CharRange arg, SDF_OptLayout wsAfter) {
  if (SDF_isCharRangeRange(arg)) {
    return (SDF_CharRange)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfter), 3), 1);
  }

  ATabort("CharRange has no WsAfter: %t\n", arg);
  return (SDF_CharRange)NULL;
}

/**
 * Set the end of a SDF_CharRange. The precondition being that this SDF_CharRange actually has a end
 * \param[in] arg input SDF_CharRange
 * \param[in] end new SDF_Character to set in #arg
 * \return A new SDF_CharRange with end at the right place, or a core dump if #arg did not have a end
 */
SDF_CharRange SDF_setCharRangeEnd(SDF_CharRange arg, SDF_Character end) {
  if (SDF_isCharRangeRange(arg)) {
    return (SDF_CharRange)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) end), 4), 1);
  }

  ATabort("CharRange has no End: %t\n", arg);
  return (SDF_CharRange)NULL;
}

/**
 * Assert whether a SDF_CharRanges is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidCharRanges(SDF_CharRanges arg) {
  if (SDF_isCharRangesDefault(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharRangesConc(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharRangesBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges is a Default. . May not be used to assert correctness of the SDF_CharRanges
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if #arg corresponds to the signature of a Default, or ATfalse otherwise
 */
inline ATbool SDF_isCharRangesDefault(SDF_CharRanges arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharRangesDefault, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharRanges is a conc. . May not be used to assert correctness of the SDF_CharRanges
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if #arg corresponds to the signature of a conc, or ATfalse otherwise
 */
inline ATbool SDF_isCharRangesConc(SDF_CharRanges arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharRangesConc, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharRanges is a Bracket. . May not be used to assert correctness of the SDF_CharRanges
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if #arg corresponds to the signature of a Bracket, or ATfalse otherwise
 */
inline ATbool SDF_isCharRangesBracket(SDF_CharRanges arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharRangesBracket, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharRanges has a CharRange. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a CharRange, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesCharRange(SDF_CharRanges arg) {
  if (SDF_isCharRangesDefault(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a left. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a left, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesLeft(SDF_CharRanges arg) {
  if (SDF_isCharRangesConc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a ws-after-left. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a ws-after-left, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesWsAfterLeft(SDF_CharRanges arg) {
  if (SDF_isCharRangesConc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a right. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a right, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesRight(SDF_CharRanges arg) {
  if (SDF_isCharRangesConc(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a ws-after-(. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a ws-after-(, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesWsAfterParenOpen(SDF_CharRanges arg) {
  if (SDF_isCharRangesBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a CharRanges. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a CharRanges, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesCharRanges(SDF_CharRanges arg) {
  if (SDF_isCharRangesBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharRanges has a ws-after-CharRanges. 
 * \param[in] arg input SDF_CharRanges
 * \return ATtrue if the SDF_CharRanges had a ws-after-CharRanges, or ATfalse otherwise
 */
ATbool SDF_hasCharRangesWsAfterCharRanges(SDF_CharRanges arg) {
  if (SDF_isCharRangesBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the CharRange SDF_CharRange of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a CharRange
 * \param[in] arg input SDF_CharRanges
 * \return the CharRange of #arg, if it exist or an undefined value if it does not
 */
SDF_CharRange SDF_getCharRangesCharRange(SDF_CharRanges arg) {
  
    return (SDF_CharRange)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the left SDF_CharRanges of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a left
 * \param[in] arg input SDF_CharRanges
 * \return the left of #arg, if it exist or an undefined value if it does not
 */
SDF_CharRanges SDF_getCharRangesLeft(SDF_CharRanges arg) {
  
    return (SDF_CharRanges)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-left SDF_OptLayout of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a ws-after-left
 * \param[in] arg input SDF_CharRanges
 * \return the ws-after-left of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharRangesWsAfterLeft(SDF_CharRanges arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the right SDF_CharRanges of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a right
 * \param[in] arg input SDF_CharRanges
 * \return the right of #arg, if it exist or an undefined value if it does not
 */
SDF_CharRanges SDF_getCharRangesRight(SDF_CharRanges arg) {
  
    return (SDF_CharRanges)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-( SDF_OptLayout of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a ws-after-(
 * \param[in] arg input SDF_CharRanges
 * \return the ws-after-( of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharRangesWsAfterParenOpen(SDF_CharRanges arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the CharRanges SDF_CharRanges of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a CharRanges
 * \param[in] arg input SDF_CharRanges
 * \return the CharRanges of #arg, if it exist or an undefined value if it does not
 */
SDF_CharRanges SDF_getCharRangesCharRanges(SDF_CharRanges arg) {
  
    return (SDF_CharRanges)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-CharRanges SDF_OptLayout of a SDF_CharRanges. Note that the precondition is that this SDF_CharRanges actually has a ws-after-CharRanges
 * \param[in] arg input SDF_CharRanges
 * \return the ws-after-CharRanges of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharRangesWsAfterCharRanges(SDF_CharRanges arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Set the CharRange of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a CharRange
 * \param[in] arg input SDF_CharRanges
 * \param[in] CharRange new SDF_CharRange to set in #arg
 * \return A new SDF_CharRanges with CharRange at the right place, or a core dump if #arg did not have a CharRange
 */
SDF_CharRanges SDF_setCharRangesCharRange(SDF_CharRanges arg, SDF_CharRange CharRange) {
  if (SDF_isCharRangesDefault(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharRange), 0), 1);
  }

  ATabort("CharRanges has no CharRange: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the left of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a left
 * \param[in] arg input SDF_CharRanges
 * \param[in] left new SDF_CharRanges to set in #arg
 * \return A new SDF_CharRanges with left at the right place, or a core dump if #arg did not have a left
 */
SDF_CharRanges SDF_setCharRangesLeft(SDF_CharRanges arg, SDF_CharRanges left) {
  if (SDF_isCharRangesConc(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }

  ATabort("CharRanges has no Left: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the ws-after-left of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a ws-after-left
 * \param[in] arg input SDF_CharRanges
 * \param[in] wsAfterLeft new SDF_OptLayout to set in #arg
 * \return A new SDF_CharRanges with wsAfterLeft at the right place, or a core dump if #arg did not have a wsAfterLeft
 */
SDF_CharRanges SDF_setCharRangesWsAfterLeft(SDF_CharRanges arg, SDF_OptLayout wsAfterLeft) {
  if (SDF_isCharRangesConc(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }

  ATabort("CharRanges has no WsAfterLeft: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the right of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a right
 * \param[in] arg input SDF_CharRanges
 * \param[in] right new SDF_CharRanges to set in #arg
 * \return A new SDF_CharRanges with right at the right place, or a core dump if #arg did not have a right
 */
SDF_CharRanges SDF_setCharRangesRight(SDF_CharRanges arg, SDF_CharRanges right) {
  if (SDF_isCharRangesConc(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 2), 1);
  }

  ATabort("CharRanges has no Right: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the ws-after-( of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a ws-after-(
 * \param[in] arg input SDF_CharRanges
 * \param[in] wsAfterParenOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_CharRanges with wsAfterParenOpen at the right place, or a core dump if #arg did not have a wsAfterParenOpen
 */
SDF_CharRanges SDF_setCharRangesWsAfterParenOpen(SDF_CharRanges arg, SDF_OptLayout wsAfterParenOpen) {
  if (SDF_isCharRangesBracket(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }

  ATabort("CharRanges has no WsAfterParenOpen: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the CharRanges of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a CharRanges
 * \param[in] arg input SDF_CharRanges
 * \param[in] CharRanges new SDF_CharRanges to set in #arg
 * \return A new SDF_CharRanges with CharRanges at the right place, or a core dump if #arg did not have a CharRanges
 */
SDF_CharRanges SDF_setCharRangesCharRanges(SDF_CharRanges arg, SDF_CharRanges CharRanges) {
  if (SDF_isCharRangesBracket(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharRanges), 2), 1);
  }

  ATabort("CharRanges has no CharRanges: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Set the ws-after-CharRanges of a SDF_CharRanges. The precondition being that this SDF_CharRanges actually has a ws-after-CharRanges
 * \param[in] arg input SDF_CharRanges
 * \param[in] wsAfterCharRanges new SDF_OptLayout to set in #arg
 * \return A new SDF_CharRanges with wsAfterCharRanges at the right place, or a core dump if #arg did not have a wsAfterCharRanges
 */
SDF_CharRanges SDF_setCharRangesWsAfterCharRanges(SDF_CharRanges arg, SDF_OptLayout wsAfterCharRanges) {
  if (SDF_isCharRangesBracket(arg)) {
    return (SDF_CharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterCharRanges), 3), 1);
  }

  ATabort("CharRanges has no WsAfterCharRanges: %t\n", arg);
  return (SDF_CharRanges)NULL;
}

/**
 * Assert whether a SDF_OptCharRanges is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_OptCharRanges
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidOptCharRanges(SDF_OptCharRanges arg) {
  if (SDF_isOptCharRangesAbsent(arg)) {
    return ATtrue;
  }
  else if (SDF_isOptCharRangesPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_OptCharRanges is a absent. . May not be used to assert correctness of the SDF_OptCharRanges
 * \param[in] arg input SDF_OptCharRanges
 * \return ATtrue if #arg corresponds to the signature of a absent, or ATfalse otherwise
 */
inline ATbool SDF_isOptCharRangesAbsent(SDF_OptCharRanges arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptCharRangesAbsent);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptCharRanges is a present. . May not be used to assert correctness of the SDF_OptCharRanges
 * \param[in] arg input SDF_OptCharRanges
 * \return ATtrue if #arg corresponds to the signature of a present, or ATfalse otherwise
 */
inline ATbool SDF_isOptCharRangesPresent(SDF_OptCharRanges arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternOptCharRangesPresent, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_OptCharRanges has a CharRanges. 
 * \param[in] arg input SDF_OptCharRanges
 * \return ATtrue if the SDF_OptCharRanges had a CharRanges, or ATfalse otherwise
 */
ATbool SDF_hasOptCharRangesCharRanges(SDF_OptCharRanges arg) {
  if (SDF_isOptCharRangesPresent(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the CharRanges SDF_CharRanges of a SDF_OptCharRanges. Note that the precondition is that this SDF_OptCharRanges actually has a CharRanges
 * \param[in] arg input SDF_OptCharRanges
 * \return the CharRanges of #arg, if it exist or an undefined value if it does not
 */
SDF_CharRanges SDF_getOptCharRangesCharRanges(SDF_OptCharRanges arg) {
  
    return (SDF_CharRanges)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Set the CharRanges of a SDF_OptCharRanges. The precondition being that this SDF_OptCharRanges actually has a CharRanges
 * \param[in] arg input SDF_OptCharRanges
 * \param[in] CharRanges new SDF_CharRanges to set in #arg
 * \return A new SDF_OptCharRanges with CharRanges at the right place, or a core dump if #arg did not have a CharRanges
 */
SDF_OptCharRanges SDF_setOptCharRangesCharRanges(SDF_OptCharRanges arg, SDF_CharRanges CharRanges) {
  if (SDF_isOptCharRangesPresent(arg)) {
    return (SDF_OptCharRanges)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharRanges), 0), 1);
  }

  ATabort("OptCharRanges has no CharRanges: %t\n", arg);
  return (SDF_OptCharRanges)NULL;
}

/**
 * Assert whether a SDF_CharClass is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidCharClass(SDF_CharClass arg) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassComp(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassDiff(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassIsect(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassUnion(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass is a simple-charclass. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a simple-charclass, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassSimpleCharclass(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassSimpleCharclass, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass is a comp. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a comp, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassComp(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassComp, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass is a diff. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a diff, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassDiff(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassDiff, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass is a isect. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a isect, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassIsect(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassIsect, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass is a union. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a union, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassUnion(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassUnion, NULL, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass is a Bracket. . May not be used to assert correctness of the SDF_CharClass
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if #arg corresponds to the signature of a Bracket, or ATfalse otherwise
 */
inline ATbool SDF_isCharClassBracket(SDF_CharClass arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternCharClassBracket, NULL, NULL, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_CharClass has a ws-after-[. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-[, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterBracketOpen(SDF_CharClass arg) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a OptCharRanges. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a OptCharRanges, or ATfalse otherwise
 */
ATbool SDF_hasCharClassOptCharRanges(SDF_CharClass arg) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-OptCharRanges. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-OptCharRanges, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterOptCharRanges(SDF_CharClass arg) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-~. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-~, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterTilde(SDF_CharClass arg) {
  if (SDF_isCharClassComp(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a CharClass. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a CharClass, or ATfalse otherwise
 */
ATbool SDF_hasCharClassCharClass(SDF_CharClass arg) {
  if (SDF_isCharClassComp(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a left. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a left, or ATfalse otherwise
 */
ATbool SDF_hasCharClassLeft(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassIsect(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassUnion(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-left. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-left, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterLeft(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassIsect(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassUnion(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-/. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-/, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterSlash(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a right. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a right, or ATfalse otherwise
 */
ATbool SDF_hasCharClassRight(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassIsect(arg)) {
    return ATtrue;
  }
  else if (SDF_isCharClassUnion(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-/\. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-/\, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterSlashBackslash(SDF_CharClass arg) {
  if (SDF_isCharClassIsect(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-\/. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-\/, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterBackslashSlash(SDF_CharClass arg) {
  if (SDF_isCharClassUnion(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-(. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-(, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterParenOpen(SDF_CharClass arg) {
  if (SDF_isCharClassBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_CharClass has a ws-after-CharClass. 
 * \param[in] arg input SDF_CharClass
 * \return ATtrue if the SDF_CharClass had a ws-after-CharClass, or ATfalse otherwise
 */
ATbool SDF_hasCharClassWsAfterCharClass(SDF_CharClass arg) {
  if (SDF_isCharClassBracket(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the ws-after-[ SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-[
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-[ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterBracketOpen(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the OptCharRanges SDF_OptCharRanges of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a OptCharRanges
 * \param[in] arg input SDF_CharClass
 * \return the OptCharRanges of #arg, if it exist or an undefined value if it does not
 */
SDF_OptCharRanges SDF_getCharClassOptCharRanges(SDF_CharClass arg) {
  
    return (SDF_OptCharRanges)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the ws-after-OptCharRanges SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-OptCharRanges
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-OptCharRanges of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterOptCharRanges(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-~ SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-~
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-~ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterTilde(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the CharClass SDF_CharClass of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a CharClass
 * \param[in] arg input SDF_CharClass
 * \return the CharClass of #arg, if it exist or an undefined value if it does not
 */
SDF_CharClass SDF_getCharClassCharClass(SDF_CharClass arg) {
  if (SDF_isCharClassComp(arg)) {
    return (SDF_CharClass)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
  }
  else 
    return (SDF_CharClass)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 2);
}

/**
 * Get the left SDF_CharClass of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a left
 * \param[in] arg input SDF_CharClass
 * \return the left of #arg, if it exist or an undefined value if it does not
 */
SDF_CharClass SDF_getCharClassLeft(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
  }
  else 
    return (SDF_CharClass)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Get the ws-after-left SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-left
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-left of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterLeft(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
  }
  else 
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-/ SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-/
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-/ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterSlash(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the right SDF_CharClass of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a right
 * \param[in] arg input SDF_CharClass
 * \return the right of #arg, if it exist or an undefined value if it does not
 */
SDF_CharClass SDF_getCharClassRight(SDF_CharClass arg) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
  }
  else 
    return (SDF_CharClass)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 4);
}

/**
 * Get the ws-after-/\ SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-/\
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-/\ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterSlashBackslash(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-\/ SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-\/
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-\/ of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterBackslashSlash(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Get the ws-after-( SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-(
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-( of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterParenOpen(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1);
}

/**
 * Get the ws-after-CharClass SDF_OptLayout of a SDF_CharClass. Note that the precondition is that this SDF_CharClass actually has a ws-after-CharClass
 * \param[in] arg input SDF_CharClass
 * \return the ws-after-CharClass of #arg, if it exist or an undefined value if it does not
 */
SDF_OptLayout SDF_getCharClassWsAfterCharClass(SDF_CharClass arg) {
  
    return (SDF_OptLayout)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 3);
}

/**
 * Set the ws-after-[ of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-[
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterBracketOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterBracketOpen at the right place, or a core dump if #arg did not have a wsAfterBracketOpen
 */
SDF_CharClass SDF_setCharClassWsAfterBracketOpen(SDF_CharClass arg, SDF_OptLayout wsAfterBracketOpen) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBracketOpen), 1), 1);
  }

  ATabort("CharClass has no WsAfterBracketOpen: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the OptCharRanges of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a OptCharRanges
 * \param[in] arg input SDF_CharClass
 * \param[in] OptCharRanges new SDF_OptCharRanges to set in #arg
 * \return A new SDF_CharClass with OptCharRanges at the right place, or a core dump if #arg did not have a OptCharRanges
 */
SDF_CharClass SDF_setCharClassOptCharRanges(SDF_CharClass arg, SDF_OptCharRanges OptCharRanges) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) OptCharRanges), 2), 1);
  }

  ATabort("CharClass has no OptCharRanges: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-OptCharRanges of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-OptCharRanges
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterOptCharRanges new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterOptCharRanges at the right place, or a core dump if #arg did not have a wsAfterOptCharRanges
 */
SDF_CharClass SDF_setCharClassWsAfterOptCharRanges(SDF_CharClass arg, SDF_OptLayout wsAfterOptCharRanges) {
  if (SDF_isCharClassSimpleCharclass(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterOptCharRanges), 3), 1);
  }

  ATabort("CharClass has no WsAfterOptCharRanges: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-~ of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-~
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterTilde new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterTilde at the right place, or a core dump if #arg did not have a wsAfterTilde
 */
SDF_CharClass SDF_setCharClassWsAfterTilde(SDF_CharClass arg, SDF_OptLayout wsAfterTilde) {
  if (SDF_isCharClassComp(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterTilde), 1), 1);
  }

  ATabort("CharClass has no WsAfterTilde: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the CharClass of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a CharClass
 * \param[in] arg input SDF_CharClass
 * \param[in] CharClass new SDF_CharClass to set in #arg
 * \return A new SDF_CharClass with CharClass at the right place, or a core dump if #arg did not have a CharClass
 */
SDF_CharClass SDF_setCharClassCharClass(SDF_CharClass arg, SDF_CharClass CharClass) {
  if (SDF_isCharClassComp(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharClass), 2), 1);
  }
  else if (SDF_isCharClassBracket(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) CharClass), 2), 1);
  }

  ATabort("CharClass has no CharClass: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the left of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a left
 * \param[in] arg input SDF_CharClass
 * \param[in] left new SDF_CharClass to set in #arg
 * \return A new SDF_CharClass with left at the right place, or a core dump if #arg did not have a left
 */
SDF_CharClass SDF_setCharClassLeft(SDF_CharClass arg, SDF_CharClass left) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }
  else if (SDF_isCharClassUnion(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) left), 0), 1);
  }

  ATabort("CharClass has no Left: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-left of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-left
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterLeft new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterLeft at the right place, or a core dump if #arg did not have a wsAfterLeft
 */
SDF_CharClass SDF_setCharClassWsAfterLeft(SDF_CharClass arg, SDF_OptLayout wsAfterLeft) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }
  else if (SDF_isCharClassUnion(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterLeft), 1), 1);
  }

  ATabort("CharClass has no WsAfterLeft: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-/ of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-/
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterSlash new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterSlash at the right place, or a core dump if #arg did not have a wsAfterSlash
 */
SDF_CharClass SDF_setCharClassWsAfterSlash(SDF_CharClass arg, SDF_OptLayout wsAfterSlash) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSlash), 3), 1);
  }

  ATabort("CharClass has no WsAfterSlash: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the right of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a right
 * \param[in] arg input SDF_CharClass
 * \param[in] right new SDF_CharClass to set in #arg
 * \return A new SDF_CharClass with right at the right place, or a core dump if #arg did not have a right
 */
SDF_CharClass SDF_setCharClassRight(SDF_CharClass arg, SDF_CharClass right) {
  if (SDF_isCharClassDiff(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 4), 1);
  }
  else if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 4), 1);
  }
  else if (SDF_isCharClassUnion(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) right), 4), 1);
  }

  ATabort("CharClass has no Right: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-/\ of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-/\
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterSlashBackslash new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterSlashBackslash at the right place, or a core dump if #arg did not have a wsAfterSlashBackslash
 */
SDF_CharClass SDF_setCharClassWsAfterSlashBackslash(SDF_CharClass arg, SDF_OptLayout wsAfterSlashBackslash) {
  if (SDF_isCharClassIsect(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterSlashBackslash), 3), 1);
  }

  ATabort("CharClass has no WsAfterSlashBackslash: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-\/ of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-\/
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterBackslashSlash new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterBackslashSlash at the right place, or a core dump if #arg did not have a wsAfterBackslashSlash
 */
SDF_CharClass SDF_setCharClassWsAfterBackslashSlash(SDF_CharClass arg, SDF_OptLayout wsAfterBackslashSlash) {
  if (SDF_isCharClassUnion(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterBackslashSlash), 3), 1);
  }

  ATabort("CharClass has no WsAfterBackslashSlash: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-( of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-(
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterParenOpen new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterParenOpen at the right place, or a core dump if #arg did not have a wsAfterParenOpen
 */
SDF_CharClass SDF_setCharClassWsAfterParenOpen(SDF_CharClass arg, SDF_OptLayout wsAfterParenOpen) {
  if (SDF_isCharClassBracket(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterParenOpen), 1), 1);
  }

  ATabort("CharClass has no WsAfterParenOpen: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Set the ws-after-CharClass of a SDF_CharClass. The precondition being that this SDF_CharClass actually has a ws-after-CharClass
 * \param[in] arg input SDF_CharClass
 * \param[in] wsAfterCharClass new SDF_OptLayout to set in #arg
 * \return A new SDF_CharClass with wsAfterCharClass at the right place, or a core dump if #arg did not have a wsAfterCharClass
 */
SDF_CharClass SDF_setCharClassWsAfterCharClass(SDF_CharClass arg, SDF_OptLayout wsAfterCharClass) {
  if (SDF_isCharClassBracket(arg)) {
    return (SDF_CharClass)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) wsAfterCharClass), 3), 1);
  }

  ATabort("CharClass has no WsAfterCharClass: %t\n", arg);
  return (SDF_CharClass)NULL;
}

/**
 * Assert whether a SDF_LexNumChar is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_LexNumChar
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidLexNumChar(SDF_LexNumChar arg) {
  if (SDF_isLexNumCharDigits(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_LexNumChar is a digits. Always returns ATtrue
 * \param[in] arg input SDF_LexNumChar
 * \return ATtrue if #arg corresponds to the signature of a digits, or ATfalse otherwise
 */
inline ATbool SDF_isLexNumCharDigits(SDF_LexNumChar arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternLexNumCharDigits, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_LexNumChar has a number. 
 * \param[in] arg input SDF_LexNumChar
 * \return ATtrue if the SDF_LexNumChar had a number, or ATfalse otherwise
 */
ATbool SDF_hasLexNumCharNumber(SDF_LexNumChar arg) {
  if (SDF_isLexNumCharDigits(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the number char* of a SDF_LexNumChar. Note that the precondition is that this SDF_LexNumChar actually has a number
 * \param[in] arg input SDF_LexNumChar
 * \return the number of #arg, if it exist or an undefined value if it does not
 */
char* SDF_getLexNumCharNumber(SDF_LexNumChar arg) {
  
    return (char*)SDF_charsToString((ATerm)ATgetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1), 1));
}

/**
 * Set the number of a SDF_LexNumChar. The precondition being that this SDF_LexNumChar actually has a number
 * \param[in] arg input SDF_LexNumChar
 * \param[in] number new const char* to set in #arg
 * \return A new SDF_LexNumChar with number at the right place, or a core dump if #arg did not have a number
 */
SDF_LexNumChar SDF_setLexNumCharNumber(SDF_LexNumChar arg, const char* number) {
  if (SDF_isLexNumCharDigits(arg)) {
    return (SDF_LexNumChar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)ATsetArgument((ATermAppl)ATelementAt((ATermList)ATgetArgument((ATermAppl)arg, 1), 1), (ATerm)((ATerm) ((ATerm) SDF_stringToChars(number))), 1), 1), 1);
  }

  ATabort("LexNumChar has no Number: %t\n", arg);
  return (SDF_LexNumChar)NULL;
}

/**
 * Assert whether a SDF_NumChar is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_NumChar
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidNumChar(SDF_NumChar arg) {
  if (SDF_isNumCharLexToCf(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_NumChar is a Lex-to-cf. Always returns ATtrue
 * \param[in] arg input SDF_NumChar
 * \return ATtrue if #arg corresponds to the signature of a Lex-to-cf, or ATfalse otherwise
 */
inline ATbool SDF_isNumCharLexToCf(SDF_NumChar arg) {
#ifndef DISABLE_DYNAMIC_CHECKING
  assert(arg != NULL);
  assert(ATmatchTerm((ATerm)arg, SDF_patternNumCharLexToCf, NULL));
#endif
  return ATtrue;
}

/**
 * Assert whether a SDF_NumChar has a NumChar. 
 * \param[in] arg input SDF_NumChar
 * \return ATtrue if the SDF_NumChar had a NumChar, or ATfalse otherwise
 */
ATbool SDF_hasNumCharNumChar(SDF_NumChar arg) {
  if (SDF_isNumCharLexToCf(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Get the NumChar SDF_LexNumChar of a SDF_NumChar. Note that the precondition is that this SDF_NumChar actually has a NumChar
 * \param[in] arg input SDF_NumChar
 * \return the NumChar of #arg, if it exist or an undefined value if it does not
 */
SDF_LexNumChar SDF_getNumCharNumChar(SDF_NumChar arg) {
  
    return (SDF_LexNumChar)ATgetFirst((ATermList)ATgetArgument((ATermAppl)arg, 1));
}

/**
 * Set the NumChar of a SDF_NumChar. The precondition being that this SDF_NumChar actually has a NumChar
 * \param[in] arg input SDF_NumChar
 * \param[in] NumChar new SDF_LexNumChar to set in #arg
 * \return A new SDF_NumChar with NumChar at the right place, or a core dump if #arg did not have a NumChar
 */
SDF_NumChar SDF_setNumCharNumChar(SDF_NumChar arg, SDF_LexNumChar NumChar) {
  if (SDF_isNumCharLexToCf(arg)) {
    return (SDF_NumChar)ATsetArgument((ATermAppl)arg, (ATerm)ATreplace((ATermList)ATgetArgument((ATermAppl)arg, 1), (ATerm)((ATerm) NumChar), 0), 1);
  }

  ATabort("NumChar has no NumChar: %t\n", arg);
  return (SDF_NumChar)NULL;
}

/**
 * Assert whether a SDF_LexShortChar is any of the valid alternatives, or not. This analysis does not go any deeper than the top level
 * \param[in] arg input SDF_LexShortChar
 * \return ATtrue if #arg corresponds to the expected signature, or ATfalse otherwise
 */
ATbool SDF_isValidLexShortChar(SDF_LexShortChar arg) {
  if (SDF_isLexShortCharRegular(arg)) {
    return ATtrue;
  }
  else if (SDF_isLexShortCharEscaped(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_LexShortChar is a regular. . May not be used to assert correctness of the SDF_LexShortChar
 * \param[in] arg input SDF_LexShortChar
 * \return ATtrue if #arg corresponds to the signature of a regular, or ATfalse otherwise
 */
inline ATbool SDF_isLexShortCharRegular(SDF_LexShortChar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternLexShortCharRegular, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_LexShortChar is a escaped. . May not be used to assert correctness of the SDF_LexShortChar
 * \param[in] arg input SDF_LexShortChar
 * \return ATtrue if #arg corresponds to the signature of a escaped, or ATfalse otherwise
 */
inline ATbool SDF_isLexShortCharEscaped(SDF_LexShortChar arg) {
  {
    static ATerm last_arg = NULL;
    static int last_gc = -1;
    static ATbool last_result;

    assert(arg != NULL);

    if (last_gc != ATgetGCCount() || (ATerm)arg != last_arg) {
      last_arg = (ATerm)arg;
      last_result = ATmatchTerm((ATerm)arg, SDF_patternLexShortCharEscaped, NULL);
      last_gc = ATgetGCCount();
    }

    return last_result;
  }
}

/**
 * Assert whether a SDF_LexShortChar has a character. 
 * \param[in] arg input SDF_LexShortChar
 * \return ATtrue if the SDF_LexShortChar had a character, or ATfalse otherwise
 */
ATbool SDF_hasLexShortCharCharacter(SDF_LexShortChar arg) {
  if (SDF_isLexShortCharRegular(arg)) {
    return ATtrue;
  }
  return ATfalse;
}

/**
 * Assert whether a SDF_LexShortChar has a escape. 
 * \param[in] arg input SDF_LexShortChar
 * \return ATtrue if the SDF_LexShortChar had a escape, or ATfalse otherwise
 */
ATbool SDF_hasLexShortCharEscape(SDF_LexShortChar arg) {
  if (SDF_isLexShortCha